/**
 * This file is part of Nuun IO Kernel Specs.
 *
 * Nuun IO Kernel Specs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Nuun IO Kernel Specs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Nuun IO Kernel Specs.  If not, see <http://www.gnu.org/licenses/>.
 */
package io.nuun.kernel.api.di;

/**
 * This API element will give the opportunity to the kernel to assert UnitModule given by plugins.
 * <p>
 * The Module type to validate is Guice module.
 *
 * @author epo.jemba{@literal @}kametic.com
 */
public interface ModuleValidation
{

    /**
     * Verifies that the module validation can handle the given native module.
     *
     * @param nativeModuleType nativeModuleType
     * @return true if this validation object can handle this kind of class
     */
    boolean canHandle(Class<?> nativeModuleType);

    /**
     * Validates the given <code> dependencyInjectionDef </code>
     *
     * @param unitModule the unit module to validate
     */
    void validate(UnitModule unitModule);

}
