/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.api.config;

import io.nuun.kernel.api.config.ClasspathScanMode;
import io.nuun.kernel.api.config.DependencyInjectionMode;
import io.nuun.kernel.api.config.KernelOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KernelOptions {
    public static final KernelOption<List<String>> ROOT_PACKAGES = new KernelOption("root.packages");
    public static final KernelOption<Boolean> PRINT_SCAN_WARN = new KernelOption("scan.warn.disable");
    public static final KernelOption<Boolean> ENABLE_REFLECTION_LOGGER = new KernelOption("reflection.logger.disable");
    public static final KernelOption<Boolean> SCAN_PLUGIN = new KernelOption("plugin.scan.disable");
    public static final KernelOption<ClasspathScanMode> CLASSPATH_SCAN_MODE = new KernelOption("classpath.scan.mode");
    public static final KernelOption<DependencyInjectionMode> DEPENDENCY_INJECTION_MODE = new KernelOption("dependency.injection.mode");
    private final Map<String, Object> options = new HashMap<String, Object>();

    public KernelOptions() {
        this.set(ROOT_PACKAGES, new ArrayList());
        this.set(PRINT_SCAN_WARN, true);
        this.set(ENABLE_REFLECTION_LOGGER, false);
        this.set(SCAN_PLUGIN, true);
        this.set(CLASSPATH_SCAN_MODE, ClasspathScanMode.NOMINAL);
        this.set(DEPENDENCY_INJECTION_MODE, DependencyInjectionMode.PRODUCTION);
    }

    public <T> KernelOptions set(KernelOption<T> option, T value) {
        this.options.put(option.getName(), value);
        return this;
    }

    public <T> T get(KernelOption<T> option) {
        return (T)this.options.get(option.getName());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            stringBuilder.append(entry.getKey()).append(": ");
            if (entry.getValue() != null) {
                stringBuilder.append(entry.getValue().toString());
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

