/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.api.plugin.request;

import io.nuun.kernel.api.plugin.request.Builder;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequest;
import io.nuun.kernel.api.plugin.request.RequestType;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.kametic.specifications.Specification;

public class ClasspathScanRequestBuilder
implements Builder<Collection<ClasspathScanRequest>> {
    private Collection<ClasspathScanRequest> requests = new HashSet<ClasspathScanRequest>();

    public ClasspathScanRequestBuilder specification(Specification<Class<?>> specification) {
        this.requests.add(new ClasspathScanRequest(specification));
        return this;
    }

    public ClasspathScanRequestBuilder annotationType(Class<? extends Annotation> annotationTypeRequested) {
        this.requests.add(new ClasspathScanRequest(RequestType.ANNOTATION_TYPE, annotationTypeRequested));
        return this;
    }

    public ClasspathScanRequestBuilder annotationRegex(String annotationRegex) {
        this.requests.add(new ClasspathScanRequest(RequestType.ANNOTATION_REGEX_MATCH, annotationRegex));
        return this;
    }

    public ClasspathScanRequestBuilder subtypeOf(Class<?> parentTypeRequested) {
        this.requests.add(new ClasspathScanRequest(RequestType.SUBTYPE_OF_BY_CLASS, parentTypeRequested));
        return this;
    }

    public ClasspathScanRequestBuilder descendentTypeOf(Class<?> parentTypeRequested) {
        this.requests.add(new ClasspathScanRequest(RequestType.SUBTYPE_OF_BY_TYPE_DEEP, parentTypeRequested));
        return this;
    }

    public ClasspathScanRequestBuilder subtypeOfRegex(String parentTypeRegex) {
        this.requests.add(new ClasspathScanRequest(RequestType.SUBTYPE_OF_BY_REGEX_MATCH, parentTypeRegex));
        return this;
    }

    public ClasspathScanRequestBuilder typeOfRegex(String typeRegex) {
        this.requests.add(new ClasspathScanRequest(RequestType.TYPE_OF_BY_REGEX_MATCH, typeRegex));
        return this;
    }

    public ClasspathScanRequestBuilder resourcesRegex(String resourcesRegex) {
        this.requests.add(new ClasspathScanRequest(RequestType.RESOURCES_REGEX_MATCH, resourcesRegex));
        return this;
    }

    @Override
    public Collection<ClasspathScanRequest> build() {
        return Collections.unmodifiableCollection(this.requests);
    }

    @Override
    public void reset() {
        this.requests.clear();
    }
}

