/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.resource.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.opencensus.resource.Resource;
import java.util.LinkedHashMap;

public class ContainerResource {
    public static final String TYPE = "container";
    public static final String NAME_KEY = "container.name";
    public static final String IMAGE_NAME_KEY = "container.image.name";
    public static final String IMAGE_TAG_KEY = "container.image.tag";

    public static Resource create(String name, String imageName, String imageTag) {
        LinkedHashMap<String, Object> labels = new LinkedHashMap<String, Object>();
        labels.put(NAME_KEY, Preconditions.checkNotNull((Object)name, (Object)"name"));
        labels.put(IMAGE_NAME_KEY, Preconditions.checkNotNull((Object)imageName, (Object)"imageName"));
        labels.put(IMAGE_TAG_KEY, Preconditions.checkNotNull((Object)imageTag, (Object)"imageTag"));
        return Resource.create((String)TYPE, labels);
    }

    static Resource detect() {
        return ContainerResource.create((String)MoreObjects.firstNonNull((Object)System.getenv("CONTAINER_NAME"), (Object)""), "", "");
    }

    private ContainerResource() {
    }
}

