/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20InvalidGrantTypeException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20InvalidGrantTypeException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _grantType;

    public OAuth20InvalidGrantTypeException(String grantType) {
        super("unsupported_grant_type", "The grant_type parameter was invalid: " + grantType, null);
        this._grantType = grantType;
    }

    public OAuth20InvalidGrantTypeException(String msgKey, String grantType) {
        super("unsupported_grant_type", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{grantType}), null);
        this._msgKey = msgKey;
        this._grantType = grantType;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode((String)this._grantType, (Locale)locale, (String)encoding));
    }

    public String getGrantType() {
        return this._grantType;
    }
}

