/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20MismatchedClientAuthenticationException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20MismatchedClientAuthenticationException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _clientId;
    private String _authenticatedClient;

    public OAuth20MismatchedClientAuthenticationException(String clientId, String authenticatedClient) {
        super("invalid_request", "The client_id passed in the request to the token endpoint: " + clientId + " did not match the authenticated client provided in the API call: " + authenticatedClient, null);
        this._clientId = clientId;
        this._authenticatedClient = authenticatedClient;
    }

    public OAuth20MismatchedClientAuthenticationException(String msgKey, String clientId, String authenticatedClient) {
        super("invalid_request", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{clientId, authenticatedClient}), null);
        this._msgKey = msgKey;
        this._clientId = clientId;
        this._authenticatedClient = authenticatedClient;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode((String)this._clientId, (Locale)locale, (String)encoding), this._authenticatedClient);
    }

    public String getClientId() {
        return this._clientId;
    }

    public String getAuthenticatedClient() {
        return this._authenticatedClient;
    }
}

