/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.event.internal.TopicData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class Topic {
    private static final Pattern topicPattern;
    final String name;
    final AtomicReference<AtomicReference<TopicData>> topicDataReference = new AtomicReference(new AtomicReference());
    static final long serialVersionUID = 5535208957841352341L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Topic(String name) {
        this.validateTopic(name);
        this.name = name;
    }

    void validateTopic(String name) {
        if (name == null) {
            throw new NullPointerException("Topic name must not be null");
        }
        if (!topicPattern.matcher(name).matches()) {
            throw new IllegalArgumentException("\"" + name + "\" is not a valid topic name");
        }
    }

    public String getName() {
        return this.name;
    }

    public TopicData getTopicData() {
        return this.topicDataReference.get().get();
    }

    public void setTopicDataReference(AtomicReference<TopicData> topicDataReference) {
        this.topicDataReference.set(topicDataReference);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Topic) {
            Topic that = (Topic)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.event.Topic", Topic.class, (String)"EventEngine", null);
        topicPattern = Pattern.compile("[\\w\\-]+(/[\\w\\-]+)*");
    }
}

