/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver;

import com.ibm.ws.kernel.feature.internal.FeatureResolverImpl;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.repository.common.enums.InstallPolicy;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.resolver.FeatureTreeWalker;
import com.ibm.ws.repository.resolver.ProductRequirementInformation;
import com.ibm.ws.repository.resolver.RepositoryResolutionException;
import com.ibm.ws.repository.resolver.internal.ResolutionMode;
import com.ibm.ws.repository.resolver.internal.kernel.KernelResolverEsa;
import com.ibm.ws.repository.resolver.internal.kernel.KernelResolverRepository;
import com.ibm.ws.repository.resources.ApplicableToProduct;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class RepositoryResolver {
    KernelResolverRepository resolverRepository;
    Collection<ProvisioningFeatureDefinition> installedFeatures;
    Collection<ProvisioningFeatureDefinition> kernelFeatures;
    Map<String, SampleResource> sampleIndex;
    Collection<EsaResource> repoFeatures;
    Collection<SampleResource> repoSamples;
    RepositoryConnectionList repoConnections;
    Collection<ProductDefinition> installDefinition;
    Map<String, Collection<FeatureResolver.Chain>> featureConflicts;
    Set<String> featureNamesToResolve;
    Set<String> requestedFeatureNames;
    List<SampleResource> samplesToInstall;
    Map<String, ProvisioningFeatureDefinition> resolvedFeatures;
    List<ProvisioningFeatureDefinition> additionalInstallListRoots;
    List<String> featuresMissing;
    List<ApplicableToProduct> resourcesWrongProduct;
    Set<String> requirementsFoundForOtherProducts;
    List<String> missingTopLevelRequirements;
    List<RepositoryResolutionException.MissingRequirement> missingRequirements;
    private static final Integer IN_PROGRESS = -1;

    public RepositoryResolver(Collection<ProductDefinition> installDefinition, Collection<ProvisioningFeatureDefinition> installedFeatures, Collection<IFixInfo> installedIFixes, RepositoryConnectionList repoConnections) throws RepositoryException {
        this.repoConnections = repoConnections;
        this.installDefinition = installDefinition;
        this.fetchFromRepository(installDefinition);
        this.installedFeatures = installedFeatures;
        this.kernelFeatures = this.getKernelFeatures(installedFeatures);
        this.indexSamples();
    }

    RepositoryResolver(Collection<ProvisioningFeatureDefinition> installedFeatures, Collection<? extends EsaResource> repoFeatures, Collection<? extends SampleResource> repoSamples) {
        this.repoFeatures = new ArrayList<EsaResource>(repoFeatures);
        this.repoSamples = new ArrayList<SampleResource>(repoSamples);
        this.installedFeatures = installedFeatures;
        this.kernelFeatures = this.getKernelFeatures(installedFeatures);
        this.installDefinition = Collections.emptySet();
        this.indexSamples();
    }

    void fetchFromRepository(Collection<ProductDefinition> installDefinition) throws RepositoryException {
        Collection osiSamples;
        HashSet<ResourceType> interestingTypes = new HashSet<ResourceType>();
        interestingTypes.add(ResourceType.FEATURE);
        interestingTypes.add(ResourceType.OPENSOURCE);
        interestingTypes.add(ResourceType.PRODUCTSAMPLE);
        Map resources = this.repoConnections.getResources(installDefinition, interestingTypes, null);
        Collection<Object> features = (Collection<Object>)resources.get(ResourceType.FEATURE);
        this.repoFeatures = features != null ? features : Collections.emptySet();
        this.repoSamples = new ArrayList<SampleResource>();
        Collection samples = (Collection)resources.get(ResourceType.PRODUCTSAMPLE);
        if (samples != null) {
            this.repoSamples.addAll(samples);
        }
        if ((osiSamples = (Collection)resources.get(ResourceType.OPENSOURCE)) != null) {
            this.repoSamples.addAll(osiSamples);
        }
    }

    void initializeResolverRepository(Collection<ProductDefinition> installDefintion) {
        this.resolverRepository = new KernelResolverRepository(installDefintion, this.repoConnections);
        this.resolverRepository.addInstalledFeatures(this.installedFeatures);
        this.resolverRepository.addFeatures(this.repoFeatures);
    }

    Collection<ProvisioningFeatureDefinition> getKernelFeatures(Collection<ProvisioningFeatureDefinition> installedFeatures) {
        ArrayList<ProvisioningFeatureDefinition> kernelFeatures = new ArrayList<ProvisioningFeatureDefinition>();
        for (ProvisioningFeatureDefinition feature : installedFeatures) {
            if (!feature.isKernel()) continue;
            kernelFeatures.add(feature);
        }
        return kernelFeatures;
    }

    void indexSamples() {
        this.sampleIndex = new HashMap<String, SampleResource>();
        for (SampleResource sample : this.repoSamples) {
            if (sample.getShortName() == null) continue;
            this.sampleIndex.put(sample.getShortName().toLowerCase(), sample);
        }
    }

    public Collection<List<RepositoryResource>> resolve(Collection<String> toResolve) throws RepositoryResolutionException {
        return this.resolve(toResolve, ResolutionMode.IGNORE_CONFLICTS);
    }

    public Collection<List<RepositoryResource>> resolve(String toResolve) throws RepositoryResolutionException {
        return this.resolve(Collections.singleton(toResolve));
    }

    public Collection<List<RepositoryResource>> resolveAsSet(Collection<String> toResolve) throws RepositoryResolutionException {
        return this.resolve(toResolve, ResolutionMode.DETECT_CONFLICTS);
    }

    Collection<List<RepositoryResource>> resolve(Collection<String> toResolve, ResolutionMode resolutionMode) throws RepositoryResolutionException {
        this.initResolve();
        this.initializeResolverRepository(this.installDefinition);
        this.processNames(toResolve);
        if (resolutionMode == ResolutionMode.DETECT_CONFLICTS) {
            this.resolveFeaturesAsSet();
        } else {
            this.resolveFeaturesBasic();
            this.resolveAutoFeatures();
        }
        this.computeAdditionalInstallListRoots();
        List<List<RepositoryResource>> installLists = this.checkDependenciesAndCreateInstallLists();
        this.reportErrors();
        return installLists;
    }

    void initResolve() {
        this.featureNamesToResolve = new HashSet<String>();
        this.samplesToInstall = new ArrayList<SampleResource>();
        this.resolvedFeatures = new HashMap<String, ProvisioningFeatureDefinition>();
        this.requestedFeatureNames = new HashSet<String>();
        this.featuresMissing = new ArrayList<String>();
        this.resourcesWrongProduct = new ArrayList<ApplicableToProduct>();
        this.requirementsFoundForOtherProducts = new HashSet<String>();
        this.missingTopLevelRequirements = new ArrayList<String>();
        this.missingRequirements = new ArrayList<RepositoryResolutionException.MissingRequirement>();
        this.resolverRepository = null;
        this.featureConflicts = new HashMap<String, Collection<FeatureResolver.Chain>>();
    }

    void processNames(Collection<String> namesToResolve) {
        for (String name : namesToResolve) {
            SampleResource sample = this.sampleIndex.get(name.toLowerCase());
            if (sample != null) {
                this.samplesToInstall.add(sample);
                if (sample.getRequireFeature() == null) continue;
                this.featureNamesToResolve.addAll(sample.getRequireFeature());
                continue;
            }
            NameAndVersion nameAndVersion = this.splitRequestedNameAndVersion(name);
            if (nameAndVersion.version != null) {
                this.resolverRepository.setPreferredVersion(nameAndVersion.name, nameAndVersion.version);
            }
            this.featureNamesToResolve.add(nameAndVersion.name);
            this.requestedFeatureNames.add(nameAndVersion.name);
        }
    }

    private NameAndVersion splitRequestedNameAndVersion(String nameAndVersion) {
        String[] parts = nameAndVersion.split("/");
        if (parts.length > 2) {
            throw new IllegalArgumentException("Only one \"/\" symbol is allowed in the resourceString but it was " + nameAndVersion);
        }
        if (parts.length == 2) {
            return new NameAndVersion(parts[0], parts[1]);
        }
        return new NameAndVersion(nameAndVersion, null);
    }

    void resolveFeaturesAsSet() {
        FeatureResolverImpl resolver = new FeatureResolverImpl();
        FeatureResolver.Result result = resolver.resolve((FeatureResolver.Repository)this.resolverRepository, this.kernelFeatures, this.featureNamesToResolve, Collections.emptySet(), false, Collections.emptySet());
        this.featureConflicts.putAll(result.getConflicts());
        for (String name : result.getResolvedFeatures()) {
            ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(name);
            this.resolvedFeatures.put(feature.getSymbolicName(), feature);
        }
        for (String missingFeature : result.getMissing()) {
            this.recordMissingFeature(missingFeature);
        }
    }

    void resolveFeaturesBasic() {
        FeatureTreeWalker toResolveWalker = FeatureTreeWalker.walkOver(this.resolverRepository).forEach(f -> this.resolvedFeatures.put(f.getSymbolicName(), (ProvisioningFeatureDefinition)f)).onMissingDependency((f, dep) -> this.recordMissingFeature(dep.getSymbolicName())).walkEachFeatureOnlyOnce();
        for (String name : this.featureNamesToResolve) {
            ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(name);
            if (feature == null) {
                this.recordMissingFeature(name);
                continue;
            }
            toResolveWalker.walkDepthFirst(feature);
        }
        FeatureTreeWalker installedFeatureWalker = FeatureTreeWalker.walkOver(this.resolverRepository).forEach(f -> this.resolvedFeatures.put(f.getSymbolicName(), (ProvisioningFeatureDefinition)f)).onMissingDependency((f, dep) -> this.recordMissingFeature(dep.getSymbolicName())).useAutofeatureProvisionAsDependency(false).walkEachFeatureOnlyOnce();
        for (ProvisioningFeatureDefinition feature : this.installedFeatures) {
            installedFeatureWalker.walkDepthFirst(feature);
        }
    }

    void resolveAutoFeatures() {
        HashSet<ProvisioningFeatureDefinition> resolvedAndInstalled = new HashSet<ProvisioningFeatureDefinition>();
        resolvedAndInstalled.addAll(this.installedFeatures);
        resolvedAndInstalled.addAll(this.resolvedFeatures.values());
        FeatureTreeWalker autofeatureWalker = FeatureTreeWalker.walkOver(this.resolverRepository).forEach(f -> {
            this.resolvedFeatures.put(f.getSymbolicName(), (ProvisioningFeatureDefinition)f);
            resolvedAndInstalled.add((ProvisioningFeatureDefinition)f);
        }).onMissingDependency((f, dep) -> this.recordMissingFeature(dep.getSymbolicName())).useAutofeatureProvisionAsDependency(false).walkEachFeatureOnlyOnce();
        int oldSize = 0;
        while (resolvedAndInstalled.size() > oldSize) {
            oldSize = resolvedAndInstalled.size();
            for (ProvisioningFeatureDefinition feature : this.resolverRepository.getAutoFeatures()) {
                EsaResource esa = this.getResource(feature);
                if (esa == null || resolvedAndInstalled.contains(feature) || esa.getInstallPolicy() != InstallPolicy.WHEN_SATISFIED || !feature.isCapabilitySatisfied(resolvedAndInstalled)) continue;
                autofeatureWalker.walkDepthFirst(feature);
            }
        }
    }

    private void computeAdditionalInstallListRoots() {
        HashSet<ProvisioningFeatureDefinition> additionalRootCandidates = new HashSet<ProvisioningFeatureDefinition>();
        for (ProvisioningFeatureDefinition provisioningFeatureDefinition : this.resolvedFeatures.values()) {
            if (!(provisioningFeatureDefinition instanceof KernelResolverEsa)) continue;
            additionalRootCandidates.add(provisioningFeatureDefinition);
        }
        FeatureTreeWalker removeCandidateWalker = FeatureTreeWalker.walkOver(this.resolvedFeatures).forEach(additionalRootCandidates::remove).walkEachFeatureOnlyOnce();
        for (String name : this.featureNamesToResolve) {
            ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(name);
            if (feature == null) continue;
            removeCandidateWalker.walkDepthFirst(feature);
        }
        for (ProvisioningFeatureDefinition feature : this.resolvedFeatures.values()) {
            if (!feature.isAutoFeature() || !(feature instanceof KernelResolverEsa)) continue;
            removeCandidateWalker.walkDepthFirst(feature);
        }
        FeatureTreeWalker featureTreeWalker = FeatureTreeWalker.walkOver(this.resolvedFeatures).forEach(additionalRootCandidates::remove);
        for (ProvisioningFeatureDefinition feature : new ArrayList(additionalRootCandidates)) {
            if (!additionalRootCandidates.contains(feature)) continue;
            featureTreeWalker.walkDepthFirst(feature);
            additionalRootCandidates.add(feature);
        }
        this.additionalInstallListRoots = new ArrayList<ProvisioningFeatureDefinition>(additionalRootCandidates);
    }

    private void recordMissingFeature(String missingFeature) {
        Collection<ApplicableToProduct> featureOtherProducts = this.resolverRepository.getNonApplicableResourcesForName(missingFeature);
        if (featureOtherProducts.isEmpty()) {
            this.featuresMissing.add(missingFeature);
        } else {
            this.requirementsFoundForOtherProducts.add(missingFeature);
            for (ApplicableToProduct feature : featureOtherProducts) {
                this.resourcesWrongProduct.add(feature);
            }
        }
    }

    List<List<RepositoryResource>> checkDependenciesAndCreateInstallLists() {
        ArrayList<List<RepositoryResource>> installLists = new ArrayList<List<RepositoryResource>>();
        for (SampleResource sample : this.samplesToInstall) {
            installLists.add(this.checkDependenciesAndCreateInstallList(sample));
        }
        for (String featureName : this.requestedFeatureNames) {
            List<RepositoryResource> installList = this.checkDependenciesAndCreateInstallList(featureName);
            if (installList.isEmpty()) continue;
            installLists.add(installList);
        }
        for (ProvisioningFeatureDefinition feature : this.resolvedFeatures.values()) {
            if (!feature.isAutoFeature() || this.requestedFeatureNames.contains(feature.getSymbolicName()) || !(feature instanceof KernelResolverEsa)) continue;
            installLists.add(this.checkDependenciesAndCreateInstallList(feature.getSymbolicName()));
        }
        for (ProvisioningFeatureDefinition feature : this.additionalInstallListRoots) {
            installLists.add(this.checkDependenciesAndCreateInstallList(feature.getSymbolicName()));
        }
        return installLists;
    }

    List<RepositoryResource> checkDependenciesAndCreateInstallList(SampleResource resource) {
        ArrayList<RepositoryResolutionException.MissingRequirement> missingRequirements = new ArrayList<RepositoryResolutionException.MissingRequirement>();
        AtomicBoolean allDependenciesResolved = new AtomicBoolean(true);
        ArrayList<ProvisioningFeatureDefinition> rootFeatures = new ArrayList<ProvisioningFeatureDefinition>();
        if (resource.getRequireFeature() != null) {
            for (String featureName : resource.getRequireFeature()) {
                ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(featureName);
                if (feature == null) {
                    allDependenciesResolved.set(false);
                    if (!this.featuresMissing.contains(featureName)) continue;
                    missingRequirements.add(new RepositoryResolutionException.MissingRequirement(featureName, (RepositoryResource)resource));
                    continue;
                }
                rootFeatures.add(feature);
            }
            FeatureTreeWalker missingDepWalker = FeatureTreeWalker.walkOver(this.resolvedFeatures).onMissingDependency((f, dependency) -> {
                if (this.featuresMissing.contains(dependency.getSymbolicName())) {
                    missingRequirements.add(new RepositoryResolutionException.MissingRequirement(dependency.getSymbolicName(), (RepositoryResource)this.getResource((ProvisioningFeatureDefinition)f)));
                }
                allDependenciesResolved.set(false);
            }).walkEachFeatureOnlyOnce();
            for (ProvisioningFeatureDefinition feature : rootFeatures) {
                missingDepWalker.walkDepthFirst(feature);
            }
        }
        if (!allDependenciesResolved.get()) {
            this.missingTopLevelRequirements.add(resource.getShortName());
            this.missingRequirements.addAll(missingRequirements);
        }
        return this.createInstallList(rootFeatures, resource);
    }

    List<RepositoryResource> checkDependenciesAndCreateInstallList(String featureName) {
        ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(featureName);
        if (feature != null) {
            feature = this.resolvedFeatures.get(feature.getSymbolicName());
        }
        if (feature == null) {
            this.missingTopLevelRequirements.add(featureName);
            if (this.featuresMissing.contains(featureName)) {
                this.missingRequirements.add(new RepositoryResolutionException.MissingRequirement(featureName, null));
            }
            return Collections.emptyList();
        }
        ArrayList missingRequirements = new ArrayList();
        AtomicBoolean foundAll = new AtomicBoolean(true);
        FeatureTreeWalker.walkOver(this.resolvedFeatures).onMissingDependency((f, dependency) -> {
            if (this.featuresMissing.contains(dependency.getSymbolicName())) {
                missingRequirements.add(new RepositoryResolutionException.MissingRequirement(dependency.getSymbolicName(), (RepositoryResource)this.getResource((ProvisioningFeatureDefinition)f)));
            }
            foundAll.set(false);
        }).walkEachFeatureOnlyOnce().walkDepthFirst(feature);
        if (!foundAll.get()) {
            this.missingTopLevelRequirements.add(featureName);
            this.missingRequirements.addAll(missingRequirements);
        }
        return this.createInstallList(Collections.singletonList(feature), null);
    }

    private List<RepositoryResource> createInstallList(Collection<ProvisioningFeatureDefinition> featureRoots, SampleResource sampleRoot) {
        HashMap<ProvisioningFeatureDefinition, List<ProvisioningFeatureDefinition>> reverseDependencyMap = new HashMap<ProvisioningFeatureDefinition, List<ProvisioningFeatureDefinition>>();
        ArrayList dependentFeatures = new ArrayList();
        FeatureTreeWalker walker = FeatureTreeWalker.walkOver(this.resolvedFeatures).forEach(dependentFeatures::add).forEachLink((parent, feature) -> reverseDependencyMap.computeIfAbsent(feature, f -> new ArrayList()).add(parent)).walkEachFeatureOnlyOnce();
        for (ProvisioningFeatureDefinition provisioningFeatureDefinition : featureRoots) {
            walker.walkDepthFirst(provisioningFeatureDefinition);
        }
        LinkedHashMap<ProvisioningFeatureDefinition, Integer> distanceMap = new LinkedHashMap<ProvisioningFeatureDefinition, Integer>();
        for (ProvisioningFeatureDefinition feature3 : dependentFeatures) {
            this.computeDistance(feature3, reverseDependencyMap, distanceMap);
        }
        ArrayList<RepositoryResource> arrayList = new ArrayList<RepositoryResource>();
        distanceMap.entrySet().stream().sorted((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue())).map(Map.Entry::getKey).map(this::getResource).filter(Objects::nonNull).forEachOrdered(arrayList::add);
        if (sampleRoot != null) {
            arrayList.add((RepositoryResource)sampleRoot);
        }
        return arrayList;
    }

    private int computeDistance(ProvisioningFeatureDefinition feature, Map<ProvisioningFeatureDefinition, List<ProvisioningFeatureDefinition>> reverseDependencyMap, Map<ProvisioningFeatureDefinition, Integer> distanceMap) {
        Integer result = distanceMap.get(feature);
        if (result == IN_PROGRESS) {
            return 0;
        }
        if (result == null) {
            distanceMap.put(feature, IN_PROGRESS);
            int longest = 0;
            for (ProvisioningFeatureDefinition dependor : reverseDependencyMap.getOrDefault(feature, Collections.emptyList())) {
                int dependorDistance = this.computeDistance(dependor, reverseDependencyMap, distanceMap);
                if (dependorDistance <= longest) continue;
                longest = dependorDistance;
            }
            result = longest + 1;
            distanceMap.put(feature, result);
        }
        return result;
    }

    private EsaResource getResource(ProvisioningFeatureDefinition feature) {
        if (!(feature instanceof KernelResolverEsa)) {
            return null;
        }
        KernelResolverEsa esaFeature = (KernelResolverEsa)feature;
        return esaFeature.getResource();
    }

    private void reportErrors() throws RepositoryResolutionException {
        if (this.resourcesWrongProduct.isEmpty() && this.missingTopLevelRequirements.isEmpty() && this.missingRequirements.isEmpty() && this.featureConflicts.isEmpty()) {
            return;
        }
        HashSet<ProductRequirementInformation> missingProductInformation = new HashSet<ProductRequirementInformation>();
        for (ApplicableToProduct esa : this.resourcesWrongProduct) {
            this.missingRequirements.add(new RepositoryResolutionException.MissingRequirement(esa.getAppliesTo(), (RepositoryResource)esa));
            missingProductInformation.addAll(ProductRequirementInformation.createFromAppliesTo(esa.getAppliesTo()));
        }
        ArrayList<String> missingRequirementNames = new ArrayList<String>();
        for (RepositoryResolutionException.MissingRequirement req : this.missingRequirements) {
            missingRequirementNames.add(req.getRequirementName());
        }
        throw new RepositoryResolutionException(null, this.missingTopLevelRequirements, missingRequirementNames, missingProductInformation, this.missingRequirements, this.featureConflicts);
    }

    static class NameAndVersion {
        private final String name;
        private final String version;

        public NameAndVersion(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }
}

