/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.FeatureResolverBaseline;
import com.ibm.ws.kernel.feature.internal.FeatureResolverResultImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FeatureResolverImpl
implements FeatureResolver {
    private static final Object tc;
    private static final boolean isBeta;
    private static Map<String, String[]> parsedNAV;
    public static final String PREFERRED_PLATFORM_VERSIONS_ENV_VAR = "PREFERRED_PLATFORM_VERSIONS";
    private static String preferredPlatformVersions;
    private static final String EE_COMPATIBLE_FEATURE_NAME = "io.openliberty.internal.versionless.eeCompatible";
    private static final String MP_COMPATIBLE_FEATURE_NAME = "io.openliberty.internal.versionless.mpCompatible";
    static final long serialVersionUID = -1203292069559071826L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    protected static void trace(String message) {
        if (tc != null && TraceComponent.isAnyTracingEnabled() && ((TraceComponent)tc).isDebugEnabled()) {
            Tr.debug((TraceComponent)((TraceComponent)tc), (String)message, (Object[])new Object[0]);
        }
    }

    @Trivial
    protected static void error(String message, Object ... parms) {
        if (tc != null) {
            Tr.error((TraceComponent)((TraceComponent)tc), (String)message, (Object[])parms);
        }
    }

    @Trivial
    protected static void info(String message, Object ... parms) {
        if (tc != null) {
            Tr.info((TraceComponent)((TraceComponent)tc), (String)message, (Object[])parms);
        }
    }

    protected static StringBuilder append(StringBuilder builder, String value) {
        if (builder != null) {
            builder.append(',');
        } else {
            builder = new StringBuilder(1 + value.length() + 1);
        }
        builder.append('\"');
        builder.append(value);
        builder.append('\"');
        return builder;
    }

    public static String parseName(String feature) {
        return FeatureResolverImpl.parseNameAndVersion(feature)[0];
    }

    public static String parseVersion(String feature) {
        return FeatureResolverImpl.parseNameAndVersion(feature)[1];
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static String[] parseNameAndVersion(String feature) {
        String[] result = parsedNAV.get(feature);
        if (result != null) {
            return result;
        }
        String baseName = feature;
        String version = null;
        int lastDash = feature.lastIndexOf(45);
        if (lastDash >= 0) {
            version = feature.substring(lastDash + 1);
            try {
                Version.parseVersion((String)version);
                baseName = feature.substring(0, lastDash);
            }
            catch (IllegalArgumentException e) {
                version = null;
            }
        }
        result = new String[]{baseName, version};
        parsedNAV.put(feature, result);
        return result;
    }

    public static void setPreferredPlatforms(String preferredPlatformVersions) {
        FeatureResolverImpl.preferredPlatformVersions = preferredPlatformVersions;
    }

    private static Collection<String> collectPlatformCompatibilityFeatures(FeatureResolver.Repository repo, Collection<String> rootPlatforms) {
        if (rootPlatforms == null || rootPlatforms.isEmpty()) {
            return null;
        }
        HashSet<String> compatibilityFeatures = new HashSet<String>();
        for (String plat : rootPlatforms) {
            String compatibilityFeature;
            plat = plat.trim();
            String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(plat);
            String platBase = nameAndVersion[0];
            String platVersion = nameAndVersion[1];
            if (platVersion == null) {
                FeatureResolverImpl.trace("Platform element [ " + plat + " ] does not contain a valid version.");
                continue;
            }
            if (platBase.startsWith("jakartaee") || platBase.startsWith("javaee")) {
                compatibilityFeature = "com.ibm.websphere.appserver.eeCompatible-" + platVersion;
            } else if (platBase.startsWith("microprofile")) {
                compatibilityFeature = "io.openliberty.internal.mpVersion-" + platVersion;
            } else {
                FeatureResolverImpl.trace("Platform element [ " + plat + " ] is not a known platform.");
                continue;
            }
            if (repo.getFeature(compatibilityFeature) != null) {
                compatibilityFeatures.add(compatibilityFeature);
                continue;
            }
            FeatureResolverImpl.trace("Platform element [ " + plat + " ] is not a known platform version.");
        }
        return compatibilityFeatures;
    }

    private static void updateTolerates(FeatureResolver.Repository repo, String featureName, Collection<String> updatedTolerates) {
        Collection<FeatureResource> includedResources = repo.getFeature(featureName).getConstituents(SubsystemContentType.FEATURE_TYPE);
        for (FeatureResource includedResource : includedResources) {
            List<String> tolerates = includedResource.getTolerates();
            tolerates.clear();
            tolerates.addAll(updatedTolerates);
        }
    }

    private static Set<String> collectPlatformCompatibilityFeatures(FeatureResolver.Repository repo) {
        if (preferredPlatformVersions == null) {
            return null;
        }
        String[] preferredPlatforms = preferredPlatformVersions.split(",");
        ArrayList<String> eeCompatibleVersions = new ArrayList<String>();
        ArrayList<String> mpCompatibleVersions = new ArrayList<String>();
        HashSet<String> compatibilityFeatures = new HashSet<String>();
        for (String plat : preferredPlatforms) {
            plat = plat.trim().toLowerCase();
            String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(plat);
            String platBase = nameAndVersion[0];
            String platVersion = nameAndVersion[1];
            if (platVersion == null) {
                FeatureResolverImpl.trace("Platform environment variable [ PREFERRED_PLATFORM_VERSIONS ] platform value [ " + plat + " ] does not contain a valid version.");
                continue;
            }
            if (platBase.startsWith("jakartaee") || platBase.startsWith("javaee")) {
                eeCompatibleVersions.add(platVersion);
                continue;
            }
            if (plat.startsWith("microprofile")) {
                mpCompatibleVersions.add(platVersion);
                continue;
            }
            FeatureResolverImpl.trace("Platform environment variable [ PREFERRED_PLATFORM_VERSIONS ] platform value [ " + plat + " ] is not a valid platform.");
        }
        if (!eeCompatibleVersions.isEmpty()) {
            FeatureResolverImpl.updateTolerates(repo, EE_COMPATIBLE_FEATURE_NAME, eeCompatibleVersions);
            compatibilityFeatures.add(EE_COMPATIBLE_FEATURE_NAME);
        }
        if (!mpCompatibleVersions.isEmpty()) {
            FeatureResolverImpl.updateTolerates(repo, MP_COMPATIBLE_FEATURE_NAME, mpCompatibleVersions);
            compatibilityFeatures.add(MP_COMPATIBLE_FEATURE_NAME);
        }
        return compatibilityFeatures;
    }

    @Override
    @Deprecated
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions) {
        return this.resolve(repository, Collections.emptySet(), rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, EnumSet.allOf(ProcessType.class), null);
    }

    @Override
    @Deprecated
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, EnumSet.allOf(ProcessType.class), null);
    }

    @Override
    @Deprecated
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions, EnumSet<ProcessType> supportedProcessTypes) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, supportedProcessTypes, null);
    }

    @Override
    @Deprecated
    public FeatureResolver.Result resolveFeatures(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, Set<String> allowedMultipleVersions, EnumSet<ProcessType> supportedProcessTypes) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowedMultipleVersions, supportedProcessTypes, null);
    }

    @Override
    public FeatureResolver.Result resolve(FeatureResolver.Repository repository, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions, Collection<String> rootPlatforms) {
        return this.resolve(repository, Collections.emptySet(), rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, EnumSet.allOf(ProcessType.class), rootPlatforms);
    }

    @Override
    public FeatureResolver.Result resolve(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions, Collection<String> rootPlatforms) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, EnumSet.allOf(ProcessType.class), rootPlatforms);
    }

    @Override
    public FeatureResolver.Result resolve(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, boolean allowMultipleVersions, EnumSet<ProcessType> supportedProcessTypes, Collection<String> rootPlatforms) {
        return this.resolve(repository, kernelFeatures, rootFeatures, preResolved, allowMultipleVersions ? Collections.emptySet() : null, supportedProcessTypes, rootPlatforms);
    }

    @Override
    public FeatureResolver.Result resolve(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, Set<String> allowedMultiple, EnumSet<ProcessType> supportedProcessTypes, Collection<String> rootPlatforms) {
        FeatureResolverBaseline.generate(this, repository, allowedMultiple, kernelFeatures);
        return this.doResolve(repository, kernelFeatures, rootFeatures, preResolved, allowedMultiple, supportedProcessTypes, rootPlatforms);
    }

    public FeatureResolver.Result doResolve(FeatureResolver.Repository repository, Collection<ProvisioningFeatureDefinition> kernelFeatures, Collection<String> rootFeatures, Set<String> preResolved, Set<String> allowedMultipleVersions, EnumSet<ProcessType> supportedProcessTypes, Collection<String> rootPlatforms) {
        if (isBeta) {
            Collection<String> serverPlatforms = FeatureResolverImpl.collectPlatformCompatibilityFeatures(repository, rootPlatforms);
            rootPlatforms = serverPlatforms != null ? serverPlatforms : FeatureResolverImpl.collectPlatformCompatibilityFeatures(repository);
        }
        SelectionContext selectionContext = new SelectionContext(repository, allowedMultipleVersions, supportedProcessTypes);
        preResolved = this.checkPreResolvedExistAndSetFullName(preResolved, selectionContext);
        rootFeatures = this.checkRootsAreAccessibleAndSetFullName(new ArrayList<String>(rootFeatures), selectionContext, preResolved);
        Collection<String> rootFeaturesList = new ArrayList<String>(rootFeatures);
        if (isBeta && rootPlatforms != null) {
            rootFeaturesList.addAll(rootPlatforms);
        }
        selectionContext.primeSelected(preResolved);
        selectionContext.primeSelected(rootFeaturesList);
        Set<String> autoFeaturesToInstall = Collections.emptySet();
        HashSet<String> seenAutoFeatures = new HashSet<String>();
        Set<String> resolved = Collections.emptySet();
        do {
            if (autoFeaturesToInstall.isEmpty()) continue;
            rootFeaturesList = autoFeaturesToInstall;
            selectionContext.primeSelected(autoFeaturesToInstall);
            preResolved = resolved;
            selectionContext.saveCurrentPreResolvedConflicts();
        } while (!(autoFeaturesToInstall = this.processAutoFeatures(kernelFeatures, resolved = this.doResolveFeatures(rootFeaturesList, preResolved, selectionContext), seenAutoFeatures, selectionContext)).isEmpty());
        return selectionContext.getResult();
    }

    private List<String> checkRootsAreAccessibleAndSetFullName(List<String> rootFeatures, SelectionContext selectionContext, Set<String> preResolved) {
        ListIterator<String> iRootFeatures = rootFeatures.listIterator();
        while (iRootFeatures.hasNext()) {
            String rootFeatureName = iRootFeatures.next();
            ProvisioningFeatureDefinition rootFeatureDef = selectionContext.getRepository().getFeature(rootFeatureName);
            if (rootFeatureDef == null) {
                selectionContext.getResult().addMissingRoot(rootFeatureName);
                iRootFeatures.remove();
                continue;
            }
            String symbolicName = rootFeatureDef.getSymbolicName();
            if (rootFeatureDef.getVisibility() != Visibility.PUBLIC) {
                selectionContext.getResult().addNonPublicRoot(rootFeatureName);
                iRootFeatures.remove();
                continue;
            }
            if (!FeatureResolverImpl.supportedProcessType(selectionContext._supportedProcessTypes, rootFeatureDef)) {
                selectionContext.getResult().addWrongRootFeatureType(symbolicName);
                iRootFeatures.remove();
                continue;
            }
            if (preResolved.contains(symbolicName)) {
                iRootFeatures.remove();
                continue;
            }
            iRootFeatures.set(symbolicName);
        }
        return rootFeatures;
    }

    static final boolean supportedProcessType(EnumSet<ProcessType> supportedTypes, ProvisioningFeatureDefinition fd) {
        for (ProcessType processType : fd.getProcessTypes()) {
            if (!supportedTypes.contains((Object)processType)) continue;
            return true;
        }
        return false;
    }

    private Set<String> checkPreResolvedExistAndSetFullName(Set<String> preResolved, SelectionContext selectionContext) {
        LinkedHashSet<String> preResolvedSymbolicNames = new LinkedHashSet<String>(preResolved.size());
        for (String preResolvedFeatureName : preResolved) {
            ProvisioningFeatureDefinition preResolvedDef = selectionContext.getRepository().getFeature(preResolvedFeatureName);
            if (preResolvedDef == null) {
                return Collections.emptySet();
            }
            preResolvedSymbolicNames.add(preResolvedDef.getSymbolicName());
        }
        return preResolvedSymbolicNames;
    }

    private Set<String> doResolveFeatures(Collection<String> rootFeatures, Set<String> preResolved, SelectionContext selectionContext) {
        selectionContext.resetInitialBlockedCount();
        Set<String> result = this.processCurrentPermutation(rootFeatures, preResolved, selectionContext);
        if (selectionContext.getResult().getConflicts().isEmpty()) {
            selectionContext.selectCurrentPermutation();
            return result;
        }
        while (selectionContext.currentHasMoreThanInitialBlockedCount() && selectionContext.popPermutation()) {
            result = this.processCurrentPermutation(rootFeatures, preResolved, selectionContext);
        }
        selectionContext.restoreBestSolution();
        Set<String> resolvedFeatures = selectionContext.getResult().getResolvedFeatures();
        return new LinkedHashSet<String>(resolvedFeatures);
    }

    Set<String> processCurrentPermutation(Collection<String> rootFeatures, Set<String> preResolved, SelectionContext selectionContext) {
        Set<String> result;
        int numBlocked;
        do {
            selectionContext.processPostponed();
            numBlocked = selectionContext.getBlockedCount();
            result = this.processRoots(rootFeatures, preResolved, selectionContext);
        } while (selectionContext.hasPostponed() || numBlocked != selectionContext.getBlockedCount() || selectionContext.hasTriedVersionlessResolution());
        ((SelectionContext)selectionContext)._current._result.setResolvedFeatures(result);
        selectionContext.checkForBestSolution();
        return result;
    }

    private Set<String> processRoots(Collection<String> rootFeatures, Set<String> preResolved, SelectionContext selectionContext) {
        ArrayDeque<String> chain = new ArrayDeque<String>();
        LinkedHashSet<String> result = new LinkedHashSet<String>(preResolved.size());
        for (String featureSymbolicName : preResolved) {
            ProvisioningFeatureDefinition featureDef = selectionContext._repository.getFeature(featureSymbolicName);
            result.add(featureDef.getFeatureName());
        }
        for (String rootFeatureName : rootFeatures) {
            ProvisioningFeatureDefinition rootFeatureDef = selectionContext.getRepository().getFeature(rootFeatureName);
            if (rootFeatureDef == null) {
                selectionContext.getResult().addMissingReference(rootFeatureName);
                continue;
            }
            this.processSelected(rootFeatureDef, null, chain, result, selectionContext);
        }
        selectionContext.setInitialRootBlockedCount();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSelected(ProvisioningFeatureDefinition selectedFeature, Set<String> allowedTolerations, Deque<String> chain, Set<String> result, SelectionContext selectionContext) {
        if (selectedFeature == null) {
            return;
        }
        String featureName = selectedFeature.getSymbolicName();
        String baseFeatureName = FeatureResolverImpl.parseNameAndVersion(featureName)[0];
        if (selectionContext.isBlocked(baseFeatureName)) {
            return;
        }
        if (selectedFeature.isSingleton() && !selectionContext.allowMultipleVersions(baseFeatureName)) {
            String selectedFeatureName;
            FeatureResolver.Chain existingSelection = selectionContext.getSelected(baseFeatureName);
            String string = selectedFeatureName = existingSelection == null ? null : existingSelection.getCandidates().get(0);
            if (existingSelection == null || !featureName.equals(selectedFeatureName)) {
                throw new IllegalStateException("Expected feature \"" + featureName + "\" to be selected instead feature of \"" + selectedFeatureName);
            }
        }
        if (chain.contains(featureName)) {
            return;
        }
        chain.addLast(featureName);
        try {
            Collection<FeatureResource> includes = selectedFeature.getConstituents(SubsystemContentType.FEATURE_TYPE);
            boolean isRoot = chain.size() == 1;
            HashSet<String> includedBaseFeatureNames = new HashSet<String>();
            for (FeatureResource included : includes) {
                String symbolicName = included.getSymbolicName();
                if (symbolicName == null) continue;
                String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(included.getSymbolicName());
                String baseName = nameAndVersion[0];
                includedBaseFeatureNames.add(baseName);
            }
            if (allowedTolerations == null) {
                if (!isRoot) {
                    throw new IllegalStateException("A null allowTolerations is only valid for root features.");
                }
            } else {
                includedBaseFeatureNames.retainAll(allowedTolerations);
            }
            allowedTolerations = includedBaseFeatureNames;
            for (FeatureResource included : includes) {
                this.processIncluded(selectedFeature, included, allowedTolerations, chain, result, selectionContext);
            }
        }
        finally {
            chain.removeLast();
            String name = selectedFeature.getFeatureName();
            result.add(name);
        }
    }

    private void processIncluded(ProvisioningFeatureDefinition includingFeature, FeatureResource included, Set<String> allowedTolerations, Deque<String> chain, Set<String> result, SelectionContext selectionContext) {
        String symbolicName = included.getSymbolicName();
        if (symbolicName == null) {
            if (!chain.isEmpty()) {
                selectionContext.getResult().addUnlabelledResource(included, chain);
            }
            return;
        }
        String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(symbolicName);
        String baseSymbolicName = nameAndVersion[0];
        String preferredVersion = nameAndVersion[1];
        boolean isSingleton = false;
        if (selectionContext.isBlocked(baseSymbolicName)) {
            return;
        }
        List<String> tolerates = included.getTolerates();
        List<String> overrideTolerates = selectionContext.getRepository().getConfiguredTolerates(baseSymbolicName);
        if (!overrideTolerates.isEmpty()) {
            tolerates = tolerates == null ? new ArrayList<String>() : new ArrayList<String>(tolerates);
            tolerates.addAll(overrideTolerates);
        }
        ArrayList<String> candidateNames = new ArrayList<String>(1 + (tolerates == null ? 0 : tolerates.size()));
        ProvisioningFeatureDefinition preferredCandidateDef = selectionContext.getRepository().getFeature(symbolicName);
        if (preferredCandidateDef != null && this.isAccessible(includingFeature, preferredCandidateDef)) {
            this.checkForFullSymbolicName(preferredCandidateDef, symbolicName, chain.getLast());
            isSingleton = preferredCandidateDef.isSingleton();
            candidateNames.add(symbolicName);
        }
        if (tolerates != null && (candidateNames.isEmpty() || isSingleton)) {
            for (String tolerate : tolerates) {
                if (selectionContext.allowMultipleVersions(baseSymbolicName) && !candidateNames.isEmpty()) break;
                String toleratedSymbolicName = baseSymbolicName + '-' + tolerate;
                ProvisioningFeatureDefinition toleratedCandidateDef = selectionContext.getRepository().getFeature(toleratedSymbolicName);
                if (toleratedCandidateDef == null || candidateNames.contains(toleratedCandidateDef.getSymbolicName()) || !this.isAccessible(includingFeature, toleratedCandidateDef)) continue;
                this.checkForFullSymbolicName(toleratedCandidateDef, toleratedSymbolicName, chain.getLast());
                isSingleton |= toleratedCandidateDef.isSingleton();
                if (!this.isAllowedToleration(selectionContext, toleratedCandidateDef, allowedTolerations, overrideTolerates, baseSymbolicName, tolerate, chain)) continue;
                candidateNames.add(toleratedCandidateDef.getSymbolicName());
            }
        }
        if (!isSingleton && candidateNames.size() > 1) {
            candidateNames.retainAll(Collections.singleton((String)candidateNames.get(0)));
        }
        selectionContext.processCandidates(chain, candidateNames, symbolicName, baseSymbolicName, preferredVersion, isSingleton);
        if (candidateNames.size() == 1 && (!baseSymbolicName.startsWith("io.openliberty.internal.versionless.") || baseSymbolicName.startsWith("io.openliberty.internal.versionless.") && selectionContext.getSelected(baseSymbolicName) != null)) {
            String selectedName = (String)candidateNames.get(0);
            this.processSelected(selectionContext.getRepository().getFeature(selectedName), allowedTolerations, chain, result, selectionContext);
        }
    }

    private boolean isAccessible(ProvisioningFeatureDefinition includingFeature, ProvisioningFeatureDefinition candidateDef) {
        return !candidateDef.getFeatureName().startsWith("io.openliberty.versionless.") && (candidateDef.getVisibility() != Visibility.PRIVATE || includingFeature.getBundleRepositoryType().equals(candidateDef.getBundleRepositoryType()));
    }

    private boolean isAllowedToleration(SelectionContext selectionContext, ProvisioningFeatureDefinition toleratedCandidateDef, Set<String> allowedTolerations, List<String> overrideTolerates, String baseSymbolicName, String tolerate, Deque<String> chain) {
        if (selectionContext.allowMultipleVersions(baseSymbolicName)) {
            return true;
        }
        if (Visibility.PRIVATE == toleratedCandidateDef.getVisibility()) {
            return true;
        }
        if (allowedTolerations.contains(baseSymbolicName)) {
            return true;
        }
        if (overrideTolerates.contains(tolerate)) {
            return true;
        }
        return isBeta && chain.peekFirst().startsWith("io.openliberty.versionless.");
    }

    private void checkForFullSymbolicName(ProvisioningFeatureDefinition candidateDef, String symbolicName, String includingFeature) {
        if (!symbolicName.equals(candidateDef.getSymbolicName())) {
            throw new IllegalArgumentException("A feature is not allowed to use short feature names when including other features. Detected short name \"" + symbolicName + "\" being used instead of \"" + candidateDef.getSymbolicName() + "\" by feature \"" + includingFeature + "\".");
        }
    }

    private Set<String> processAutoFeatures(Collection<ProvisioningFeatureDefinition> kernelFeatures, Set<String> result, Set<String> seenAutoFeatures, SelectionContext selectionContext) {
        HashSet<String> autoFeaturesToProcess = new HashSet<String>();
        HashSet<ProvisioningFeatureDefinition> filteredFeatureDefs = new HashSet<ProvisioningFeatureDefinition>(kernelFeatures);
        for (String feature : result) {
            filteredFeatureDefs.add(selectionContext.getRepository().getFeature(feature));
        }
        for (ProvisioningFeatureDefinition autoFeatureDef : selectionContext.getRepository().getAutoFeatures()) {
            String featureSymbolicName = autoFeatureDef.getSymbolicName();
            if (seenAutoFeatures.contains(featureSymbolicName) || !autoFeatureDef.isCapabilitySatisfied(filteredFeatureDefs)) continue;
            seenAutoFeatures.add(featureSymbolicName);
            if (!FeatureResolverImpl.supportedProcessType(selectionContext._supportedProcessTypes, autoFeatureDef)) continue;
            autoFeaturesToProcess.add(featureSymbolicName);
        }
        return autoFeaturesToProcess;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl", FeatureResolverImpl.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        TraceComponent temp = null;
        try {
            temp = Tr.register(FeatureResolverImpl.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl", (String)"79", null, (Object[])new Object[0]);
        }
        tc = temp;
        isBeta = Boolean.valueOf(System.getProperty("com.ibm.ws.beta.edition"));
        parsedNAV = new HashMap<String, String[]>();
        preferredPlatformVersions = System.getenv(PREFERRED_PLATFORM_VERSIONS_ENV_VAR);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class SelectionContext {
        private final FeatureResolver.Repository _repository;
        private final Deque<Permutation> _permutations = new ArrayDeque<Permutation>(Arrays.asList(new Permutation()));
        private final Set<String> _allowedMultipleVersions;
        private final EnumSet<ProcessType> _supportedProcessTypes;
        private final AtomicInteger _initialBlockedCount = new AtomicInteger(-1);
        private final Map<String, Collection<FeatureResolver.Chain>> _preResolveConflicts = new HashMap<String, Collection<FeatureResolver.Chain>>();
        private Permutation _current = this._permutations.getFirst();
        private final Map<String, List<String>> versionless = new HashMap<String, List<String>>();
        private boolean triedVersionless = false;
        private static final String COMPATIBILITY_EE = "com.ibm.websphere.appserver.eeCompatible";
        private static final String COMPATIBILITY_MP = "io.openliberty.internal.mpVersion";
        private static final String VERSIONLESS_PREFIX = "io.openliberty.internal.versionless.";
        private static final String VERSIONLESS_PREFIX_MP = "io.openliberty.internal.versionless.mp";
        static final long serialVersionUID = -1220827277748483158L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SelectionContext(FeatureResolver.Repository repository, Set<String> allowedMultipleVersions, EnumSet<ProcessType> supportedProcessTypes) {
            this._repository = repository;
            this._allowedMultipleVersions = allowedMultipleVersions;
            this._supportedProcessTypes = supportedProcessTypes;
        }

        void saveCurrentPreResolvedConflicts() {
            this._preResolveConflicts.clear();
            this._preResolveConflicts.putAll(this._current._result.getConflicts());
        }

        void resetInitialBlockedCount() {
            this._initialBlockedCount.set(-1);
        }

        boolean currentHasMoreThanInitialBlockedCount() {
            return this.getBlockedCount() > this._initialBlockedCount.get();
        }

        void setInitialRootBlockedCount() {
            this._initialBlockedCount.compareAndSet(-1, this.getBlockedCount());
        }

        void restoreBestSolution() {
            while (this.popPermutation()) {
            }
            this._current = this._permutations.getFirst();
        }

        void selectCurrentPermutation() {
            this._permutations.clear();
            this._permutations.addFirst(this._current);
        }

        void checkForBestSolution() {
            if (this._permutations.getLast()._result.getConflicts().size() > this._current._result.getConflicts().size()) {
                this._permutations.pollLast();
                this._permutations.addLast(this._current);
            }
        }

        boolean popPermutation() {
            Permutation popped;
            Permutation permutation = popped = this._permutations.size() > 1 ? this._permutations.pollFirst() : null;
            if (popped != null) {
                this.triedVersionless = false;
                this._current = popped;
                return true;
            }
            return false;
        }

        @FFDCIgnore(value={DeadEndChain.class})
        void pushPermutation() {
            if (this._initialBlockedCount.get() == this.getBlockedCount()) {
                try {
                    this._permutations.addFirst(this._current.copy(this._preResolveConflicts));
                }
                catch (DeadEndChain deadEndChain) {
                    // empty catch block
                }
            }
        }

        FeatureResolver.Repository getRepository() {
            return this._repository;
        }

        boolean isBlocked(String baseSymbolicName) {
            return this._current._blockedFeatures.contains(baseSymbolicName);
        }

        boolean allowMultipleVersions(String baseSymbolicName) {
            return this._allowedMultipleVersions != null && (this._allowedMultipleVersions.size() == 0 || this._allowedMultipleVersions.contains(baseSymbolicName));
        }

        int getBlockedCount() {
            return this._current._blockedFeatures.size();
        }

        FeatureResolverResultImpl getResult() {
            return this._current._result;
        }

        boolean isVersionless(String baseSymbolicName) {
            return baseSymbolicName.startsWith(VERSIONLESS_PREFIX);
        }

        boolean isVersionlessMP(String baseSymbolicName) {
            return baseSymbolicName.startsWith(VERSIONLESS_PREFIX_MP);
        }

        boolean isVersionlessEE(String baseSymbolicName) {
            return this.isVersionless(baseSymbolicName) && !this.isVersionlessMP(baseSymbolicName);
        }

        void processCandidates(Collection<String> chain, List<String> candidateNames, String symbolicName, String baseSymbolicName, String preferredVersion, boolean isSingleton) {
            if (this.isVersionlessEE(baseSymbolicName) && this.getSelected(COMPATIBILITY_EE) == null || this.isVersionlessMP(baseSymbolicName) && this.getSelected(COMPATIBILITY_MP) == null) {
                this.addPostponed(baseSymbolicName, new FeatureResolver.Chain(chain, candidateNames, preferredVersion, symbolicName));
                return;
            }
            ArrayList<String> origCandidateNames = new ArrayList<String>(candidateNames);
            Iterator<String> iCandidateNames = candidateNames.iterator();
            while (iCandidateNames.hasNext()) {
                ProvisioningFeatureDefinition fd = this._repository.getFeature(iCandidateNames.next());
                if (FeatureResolverImpl.supportedProcessType(this._supportedProcessTypes, fd)) continue;
                FeatureResolver.Chain c = new FeatureResolver.Chain(chain, candidateNames, preferredVersion, symbolicName);
                this._current._result.addWrongResolvedFeatureType(symbolicName, c);
                iCandidateNames.remove();
            }
            if (candidateNames.isEmpty()) {
                this._current._result.addIncomplete(symbolicName, origCandidateNames, chain);
                return;
            }
            if (!isSingleton || this.allowMultipleVersions(baseSymbolicName)) {
                return;
            }
            ArrayList<String> copyCandidates = new ArrayList<String>(candidateNames);
            FeatureResolver.Chain selectedChain = this.getSelected(baseSymbolicName);
            if (selectedChain != null) {
                candidateNames.retainAll(selectedChain.getCandidates());
                if (candidateNames.isEmpty()) {
                    this.addConflict(baseSymbolicName, this.asList(selectedChain, new FeatureResolver.Chain(chain, copyCandidates, preferredVersion, symbolicName)));
                    return;
                }
            }
            if (candidateNames.size() > 1) {
                this.addPostponed(baseSymbolicName, new FeatureResolver.Chain(chain, candidateNames, preferredVersion, symbolicName));
                return;
            }
            String selectedName = candidateNames.get(0);
            FeatureResolver.Chain conflict = this.getPostponedConflict(baseSymbolicName, selectedName);
            if (conflict != null) {
                this.addConflict(baseSymbolicName, this.asList(conflict, new FeatureResolver.Chain(chain, copyCandidates, preferredVersion, symbolicName)));
            }
            if (selectedChain == null) {
                this._current._selected.put(baseSymbolicName, new FeatureResolver.Chain(chain, Collections.singletonList(selectedName), preferredVersion, symbolicName));
            }
            this._current._postponed.remove(baseSymbolicName);
        }

        List<FeatureResolver.Chain> asList(FeatureResolver.Chain chain1, FeatureResolver.Chain chain2) {
            ArrayList<FeatureResolver.Chain> result = new ArrayList<FeatureResolver.Chain>(2);
            result.add(chain1);
            result.add(chain2);
            return result;
        }

        FeatureResolver.Chain getSelected(String baseName) {
            return this._current._selected.get(baseName);
        }

        boolean hasPostponed() {
            return !this._current._postponed.isEmpty();
        }

        boolean hasTriedVersionlessResolution() {
            if (!this.triedVersionless) {
                this.triedVersionless = true;
                return !this._current._postponedVersionless.isEmpty();
            }
            return false;
        }

        void processPostponed() {
            if (this._current._postponed.isEmpty() && this._current._postponedVersionless.isEmpty()) {
                return;
            }
            if (isBeta && !this._current._postponedVersionless.isEmpty() && (this.getSelected(COMPATIBILITY_MP) != null || this.getSelected(COMPATIBILITY_EE) != null)) {
                Set<String> entries = this._current._postponedVersionless.keySet();
                Iterator<Map.Entry<String, Chains>> postponedVersionlessIterator = this._current._postponedVersionless.entrySet().iterator();
                Map.Entry<String, Chains> firstPostponedVersionless = null;
                while (postponedVersionlessIterator.hasNext() && !((firstPostponedVersionless = postponedVersionlessIterator.next()).getKey().substring(36, 38).equals("mp") ? this.getSelected(COMPATIBILITY_MP) != null : this.getSelected(COMPATIBILITY_EE) != null)) {
                    firstPostponedVersionless = null;
                }
                if (firstPostponedVersionless != null) {
                    FeatureResolver.Chain selected = firstPostponedVersionless.getValue().select(firstPostponedVersionless.getKey(), this);
                    if (selected != null) {
                        this._current._selected.put(firstPostponedVersionless.getKey(), selected);
                    }
                    this._current._postponed.clear();
                    this._current._postponedVersionless.clear();
                    return;
                }
            }
            if (!this._current._postponed.isEmpty()) {
                Map.Entry<String, Chains> firstPostponed = this._current._postponed.entrySet().iterator().next();
                FeatureResolver.Chain selected = firstPostponed.getValue().select(firstPostponed.getKey(), this);
                if (selected != null) {
                    this._current._selected.put(firstPostponed.getKey(), selected);
                }
                this._current._postponed.clear();
                this._current._postponedVersionless.clear();
            }
        }

        void primeSelected(Collection<String> features) {
            if (this._allowedMultipleVersions != null && this._allowedMultipleVersions.size() == 0) {
                return;
            }
            HashMap<String, String> conflicts = new HashMap<String, String>();
            Iterator<String> iFeatures = features.iterator();
            while (iFeatures.hasNext()) {
                String featureName = iFeatures.next();
                ProvisioningFeatureDefinition featureDef = this._repository.getFeature(featureName);
                if (featureDef == null || !featureDef.isSingleton()) continue;
                String featureSymbolicName = featureDef.getSymbolicName();
                String[] nameAndVersion = FeatureResolverImpl.parseNameAndVersion(featureSymbolicName);
                String base = nameAndVersion[0];
                String preferredVersion = nameAndVersion[1];
                if (this.allowMultipleVersions(base)) continue;
                FeatureResolver.Chain selectedChain = this._current._selected.get(base);
                if (selectedChain != null) {
                    iFeatures.remove();
                    String selectedFeature = selectedChain.getCandidates().get(0);
                    if (!features.contains(selectedFeature)) continue;
                    FeatureResolver.Chain conflictedFeatureChain = new FeatureResolver.Chain(featureSymbolicName, preferredVersion, featureSymbolicName);
                    this.addConflict(base, this.asList(selectedChain, conflictedFeatureChain));
                    conflicts.put(selectedFeature, base);
                    continue;
                }
                this._current._selected.put(base, new FeatureResolver.Chain(featureSymbolicName, preferredVersion, featureSymbolicName));
            }
            for (Map.Entry conflict : conflicts.entrySet()) {
                features.remove(conflict.getKey());
                this._current._selected.remove(conflict.getValue());
            }
        }

        void addPostponed(String baseName, FeatureResolver.Chain chain) {
            Map<String, Chains> usePostponed = baseName.startsWith(VERSIONLESS_PREFIX) ? this._current._postponedVersionless : this._current._postponed;
            Chains existing = usePostponed.get(baseName);
            if (existing == null) {
                existing = new Chains();
                usePostponed.put(baseName, existing);
            }
            existing.add(chain);
        }

        FeatureResolver.Chain getPostponedConflict(String baseName, String selectedName) {
            Chains postponedChains = this._current._postponed.get(baseName);
            return postponedChains == null ? null : postponedChains.findConflict(selectedName);
        }

        void addConflict(String baseFeatureName, List<FeatureResolver.Chain> conflicts) {
            this._current._blockedFeatures.add(baseFeatureName);
            this._current._result.addConflict(baseFeatureName, conflicts);
        }

        void putVersionless(String feature, List<String> tolerates) {
            this.versionless.put(feature, tolerates);
        }

        List<String> copyVersionless(String feature) {
            List<String> raw = this.versionless.get(feature);
            return raw == null ? null : new ArrayList<String>(raw);
        }

        Permutation getCurrent() {
            try {
                return this._current.copy(this._preResolveConflicts);
            }
            catch (DeadEndChain deadEndChain) {
                FFDCFilter.processException((Throwable)deadEndChain, (String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$SelectionContext", (String)"1421", (Object)this, (Object[])new Object[0]);
                return null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$SelectionContext", SelectionContext.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        @TraceOptions
        static class Permutation {
            final Map<String, FeatureResolver.Chain> _selected = new HashMap<String, FeatureResolver.Chain>();
            final Map<String, Chains> _postponed = new LinkedHashMap<String, Chains>();
            final Map<String, Chains> _postponedVersionless = new LinkedHashMap<String, Chains>();
            final Set<String> _blockedFeatures = new HashSet<String>();
            final FeatureResolverResultImpl _result = new FeatureResolverResultImpl();
            static final long serialVersionUID = 772908001055481558L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            Permutation() {
            }

            Permutation copy(Map<String, Collection<FeatureResolver.Chain>> preResolveConflicts) throws DeadEndChain {
                Permutation copy = new Permutation();
                copy._selected.putAll(this._selected);
                copy._result._conflicts.putAll(preResolveConflicts);
                copy._result._missing.addAll(this._result.getMissing());
                copy._result._nonPublicRoots.addAll(this._result.getNonPublicRoots());
                for (Map.Entry<String, Chains> chainsEntry : this._postponed.entrySet()) {
                    copy._postponed.put(chainsEntry.getKey(), chainsEntry.getValue().copy());
                }
                for (Map.Entry<String, Chains> chainsEntry : this._postponedVersionless.entrySet()) {
                    copy._postponedVersionless.put(chainsEntry.getKey(), chainsEntry.getValue().copy());
                }
                return copy;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$SelectionContext$Permutation", Permutation.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class Chains
    implements Comparator<FeatureResolver.Chain> {
        private final Set<String> _attempted = new HashSet<String>();
        private final List<FeatureResolver.Chain> _chains = new ArrayList<FeatureResolver.Chain>();
        static final long serialVersionUID = 6852425761403058862L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Chains() {
        }

        void add(FeatureResolver.Chain chain) {
            int insertion = Collections.binarySearch(this._chains, chain, this);
            if (insertion < 0) {
                insertion = -insertion - 1;
            } else {
                FeatureResolver.Chain existing;
                while (insertion < this._chains.size() && (existing = this._chains.get(insertion)) != null && this.compare(existing, chain) == 0) {
                    ++insertion;
                }
            }
            this._chains.add(insertion, chain);
        }

        public Chains copy() throws DeadEndChain {
            if (this.noMoreCandidatesToTry()) {
                throw new DeadEndChain();
            }
            Chains copy = new Chains();
            copy._chains.addAll(this._chains);
            copy._attempted.addAll(this._attempted);
            return copy;
        }

        private boolean noMoreCandidatesToTry() {
            for (FeatureResolver.Chain chain : this._chains) {
                boolean allAttempted = true;
                for (String candidate : chain.getCandidates()) {
                    if (!(allAttempted &= this._attempted.contains(candidate))) break;
                }
                if (!allAttempted) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compare(FeatureResolver.Chain o1, FeatureResolver.Chain o2) {
            return o1.getPreferredVersion().compareTo(o2.getPreferredVersion());
        }

        FeatureResolver.Chain select(String baseFeatureName, SelectionContext selectionContext) {
            for (FeatureResolver.Chain selectedChain : this._chains) {
                FeatureResolver.Chain match;
                String preferredCandidate = selectedChain.getCandidates().get(0);
                if (!this._attempted.add(preferredCandidate) || (match = this.match(preferredCandidate, selectedChain, selectionContext)) == null) continue;
                return match;
            }
            for (FeatureResolver.Chain selectedChain : this._chains) {
                for (String candidate : selectedChain.getCandidates()) {
                    FeatureResolver.Chain match;
                    if (!this._attempted.add(candidate) || (match = this.match(candidate, selectedChain, selectionContext)) == null) continue;
                    return match;
                }
            }
            selectionContext.addConflict(baseFeatureName, this._chains);
            return null;
        }

        private FeatureResolver.Chain match(String candidate, FeatureResolver.Chain selectedChain, SelectionContext selectionContext) {
            for (FeatureResolver.Chain checkChain : this._chains) {
                if (selectedChain == checkChain || checkChain.getCandidates().contains(candidate)) continue;
                return null;
            }
            selectionContext.pushPermutation();
            return new FeatureResolver.Chain(selectedChain.getChain(), Collections.singletonList(candidate), selectedChain.getPreferredVersion().toString(), selectedChain.getFeatureRequirement());
        }

        List<FeatureResolver.Chain> getChains() {
            return this._chains;
        }

        FeatureResolver.Chain findConflict(String candidate) {
            for (FeatureResolver.Chain chain : this._chains) {
                if (chain.getCandidates().contains(candidate)) continue;
                return chain;
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$Chains", Chains.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class DeadEndChain
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DeadEndChain() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.FeatureResolverImpl$DeadEndChain", DeadEndChain.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

