/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.feature.internal.util.LazySupplier;
import com.ibm.ws.kernel.feature.internal.util.VerifyDelta;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class VerifyData {
    public final List<VerifyCase> cases;
    static final long serialVersionUID = 6987499234993157534L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public VerifyData add(VerifyData other) {
        Map<String, VerifyCase> mappedCases = this.mapCases();
        Map<String, VerifyCase> otherMappedCases = other.mapCases();
        mappedCases.putAll(otherMappedCases);
        return new VerifyData(mappedCases.values());
    }

    public VerifyData() {
        this.cases = new ArrayList<VerifyCase>();
    }

    public VerifyData(Collection<? extends LazySupplier<VerifyCase>> cases) {
        this.cases = new ArrayList<VerifyCase>(cases.size());
        for (LazySupplier<VerifyCase> lazySupplier : cases) {
            this.cases.add(lazySupplier.supply());
        }
    }

    public List<? extends VerifyCase> getCases() {
        return this.cases;
    }

    public Map<String, VerifyCase> mapCases() {
        LinkedHashMap<String, VerifyCase> mappedCases = new LinkedHashMap<String, VerifyCase>(this.cases.size());
        StringBuilder keyBuilder = new StringBuilder();
        for (VerifyCase verifyCase : this.cases) {
            String caseKey = verifyCase.asKey(keyBuilder);
            VerifyCase priorCase = mappedCases.put(caseKey, verifyCase);
            if (priorCase == null) continue;
            System.out.println("ERROR: Key duplication [ " + caseKey + " ]");
        }
        return mappedCases;
    }

    private static void append(StringBuilder builder, String text, char sep) {
        if (builder.length() != 0) {
            builder.append(sep);
        }
        builder.append(text);
    }

    public VerifyCase addCase() {
        VerifyCase verifyCase = new VerifyCase();
        this.cases.add(verifyCase);
        return verifyCase;
    }

    public void addCase(VerifyCase verifyCase) {
        this.cases.add(verifyCase);
    }

    public static long getTimeNs() {
        return System.nanoTime();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyData", VerifyData.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VerifyCase
    implements LazySupplier<VerifyCase> {
        public String name;
        public String description;
        public long durationNs;
        public final VerifyInput input = new VerifyInput();
        public final VerifyOutput output = new VerifyOutput();
        static final long serialVersionUID = -2502283756428780725L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public VerifyCase() {
        }

        public VerifyCase(VerifyCase inputCase, List<String> resolved, long durationNs) {
            this.name = inputCase.name;
            this.description = inputCase.description;
            this.durationNs = durationNs;
            if (inputCase.input.isMultiple) {
                this.input.setMultiple();
            }
            if (inputCase.input.isClient) {
                this.input.setClient();
            } else if (inputCase.input.isServer) {
                this.input.setServer();
            }
            for (String kernelName : inputCase.input.kernel) {
                this.input.addKernel(kernelName);
            }
            for (String rootName : inputCase.input.roots) {
                this.input.addRoot(rootName);
            }
            for (String featureName : resolved) {
                this.output.addResolved(featureName);
            }
        }

        public void setDuration(long startNs) {
            this.durationNs = VerifyData.getTimeNs() - startNs;
        }

        public String asKey(StringBuilder keyBuilder) {
            char spaceSep = ' ';
            char colonSep = ':';
            if (this.input.isMultiple) {
                VerifyData.append(keyBuilder, "Multiple", spaceSep);
            }
            VerifyData.append(keyBuilder, "Process", spaceSep);
            if (this.input.isClient) {
                VerifyData.append(keyBuilder, "Client", colonSep);
            }
            if (this.input.isServer) {
                VerifyData.append(keyBuilder, "Server", colonSep);
            }
            VerifyData.append(keyBuilder, "Kernel", spaceSep);
            for (String kernelName : this.input.kernel) {
                VerifyData.append(keyBuilder, kernelName, colonSep);
            }
            VerifyData.append(keyBuilder, "Roots", spaceSep);
            for (String rootName : this.input.roots) {
                VerifyData.append(keyBuilder, rootName, colonSep);
            }
            String key = keyBuilder.toString();
            keyBuilder.setLength(0);
            return key;
        }

        public void kernelAdjust(boolean usedKernel, Set<String> altResolved, boolean altUsedKernel) {
            VerifyDelta.kernelAdjust(this, usedKernel, altResolved, altUsedKernel);
        }

        @Override
        public VerifyCase produce() {
            return this;
        }

        @Override
        public VerifyCase supply() {
            return this;
        }

        @Override
        public VerifyCase getSupplied() {
            return this;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyData$VerifyCase", VerifyCase.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VerifyOutput {
        public final List<String> resolved = new ArrayList<String>();
        public final List<String> kernelOnly = new ArrayList<String>();
        public final List<String> kernelBlocked = new ArrayList<String>();
        static final long serialVersionUID = -7517589158679018696L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void addResolved(String feature) {
            this.resolved.add(feature);
        }

        public void addKernelOnly(String feature) {
            this.kernelOnly.add(feature);
        }

        public void addKernelBlocked(String feature) {
            this.kernelBlocked.add(feature);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyData$VerifyOutput", VerifyOutput.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VerifyInput {
        public boolean isMultiple;
        public boolean isClient;
        public boolean isServer;
        public final List<String> kernel = new ArrayList<String>();
        public final List<String> roots = new ArrayList<String>();
        static final long serialVersionUID = 2084701130515013359L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void setMultiple() {
            this.isMultiple = true;
        }

        public void setClient() {
            this.isClient = true;
        }

        public void setServer() {
            this.isServer = true;
        }

        public void addKernel(String feature) {
            this.kernel.add(feature);
        }

        public void addRoot(String name) {
            this.roots.add(name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyData$VerifyInput", VerifyInput.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

