/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.feature.internal.util.VerifyData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class VerifyDelta {
    private final Map<String, List<String>> errors = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<String>> warnings = new LinkedHashMap<String, List<String>>();
    public static final String GLOBAL_CASE_KEY = "global results";
    public static final boolean USED_KERNEL = true;
    public static final boolean ORIGINAL_USED_KERNEL = true;
    public static final boolean UPDATED_USED_KERNEL = true;
    static final long serialVersionUID = -4168524114873735486L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Map<String, List<String>> compare(VerifyData expectedCases, VerifyData actualCases, boolean actualUsedKernel) {
        VerifyDelta delta = new VerifyDelta();
        delta.doCompare(expectedCases, actualCases, actualUsedKernel);
        return delta.getErrors();
    }

    public void clear() {
        this.clearErrors();
        this.clearWarnings();
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public int size() {
        return this.errors.size();
    }

    public int totalSize() {
        int total = 0;
        for (List<String> caseErrors : this.errors.values()) {
            total += caseErrors.size();
        }
        return total;
    }

    public Map<String, List<String>> getErrors() {
        return this.errors;
    }

    private void setErrors(String name, List<String> caseErrors) {
        this.errors.put(name, caseErrors);
    }

    private void addError(String name, String error) {
        List<String> caseErrors = this.errors.get(name);
        if (caseErrors == null) {
            caseErrors = new ArrayList<String>();
            this.errors.put(name, caseErrors);
        }
        caseErrors.add(error);
    }

    private static List<String> addError(List<String> errors, String error) {
        if (errors == null) {
            errors = new ArrayList<String>();
        }
        errors.add(error);
        return errors;
    }

    public void clearWarnings() {
        this.warnings.clear();
    }

    public int getWarningCount() {
        return this.warnings.size();
    }

    public int totalWarningCount() {
        int total = 0;
        for (List<String> caseWarnings : this.warnings.values()) {
            total += caseWarnings.size();
        }
        return total;
    }

    public Map<String, List<String>> getWarnings() {
        return this.warnings;
    }

    private void setWarnings(String name, List<String> caseWarnings) {
        this.warnings.put(name, caseWarnings);
    }

    public void doCompare(VerifyData expectedCases, VerifyData actualCases, boolean actualUsedKernel) {
        String caseKey;
        int expectedSize;
        int actualSize = actualCases.cases.size();
        if (actualSize != (expectedSize = expectedCases.cases.size())) {
            this.addError(GLOBAL_CASE_KEY, "Incorrect case count; expected [ " + expectedSize + " ] actual [ " + actualSize + " ]");
        }
        Map<String, VerifyData.VerifyCase> actual = actualCases.mapCases();
        Map<String, VerifyData.VerifyCase> expected = expectedCases.mapCases();
        for (Map.Entry<String, VerifyData.VerifyCase> caseEntry : actual.entrySet()) {
            caseKey = caseEntry.getKey();
            if (expected.containsKey(caseKey)) continue;
            this.addError(GLOBAL_CASE_KEY, "Extra case [ " + caseKey + " ]");
        }
        for (Map.Entry<String, VerifyData.VerifyCase> caseEntry : expected.entrySet()) {
            caseKey = caseEntry.getKey();
            if (actual.containsKey(caseKey)) continue;
            this.addError(GLOBAL_CASE_KEY, "Missing case [ " + caseKey + " ]");
        }
        for (Map.Entry<String, VerifyData.VerifyCase> caseEntry : actual.entrySet()) {
            caseKey = caseEntry.getKey();
            VerifyData.VerifyCase actualCase = caseEntry.getValue();
            VerifyData.VerifyCase expectedCase = expected.get(caseKey);
            if (expectedCase == null) {
                return;
            }
            ArrayList<String> caseWarnings = new ArrayList<String>(0);
            List<String> caseErrors = VerifyDelta.compare(null, caseWarnings, expectedCase, actualCase, actualUsedKernel, null, null);
            if (caseErrors != null) {
                this.setErrors(caseKey, caseErrors);
            }
            if (caseWarnings.isEmpty()) continue;
            this.setWarnings(caseKey, caseWarnings);
        }
    }

    public static List<String> compare(List<String> caseErrors, List<String> caseWarnings, VerifyData.VerifyCase expectedCase, VerifyData.VerifyCase actualCase, boolean actualUsedKernel, List<String> extra, List<String> missing) {
        return VerifyDelta.compare(null, caseErrors, caseWarnings, expectedCase.output.resolved, expectedCase.output.kernelOnly, expectedCase.output.kernelBlocked, actualCase.output.resolved, actualUsedKernel, extra, missing);
    }

    public static List<String> compare(VisibilitySupplier repo, List<String> caseErrors, List<String> caseWarnings, VerifyData.VerifyCase expectedCase, VerifyData.VerifyCase actualCase, boolean actualUsedKernel, List<String> extra, List<String> missing) {
        return VerifyDelta.compare(repo, caseErrors, caseWarnings, expectedCase.output.resolved, expectedCase.output.kernelOnly, expectedCase.output.kernelBlocked, actualCase.output.resolved, actualUsedKernel, extra, missing);
    }

    protected static String getType(VisibilitySupplier repo, String featureName) {
        return repo.getVisibility(featureName);
    }

    protected static String addType(VisibilitySupplier repo, String featureName) {
        if (repo == null) {
            return featureName;
        }
        return featureName + " " + VerifyDelta.getType(repo, featureName);
    }

    public static List<String> compare(VisibilitySupplier repo, List<String> caseErrors, List<String> caseWarnings, List<String> expected, List<String> expectedKernelOnly, List<String> expectedKernelBlocked, List<String> actual, boolean actualUsedKernel, List<String> extra, List<String> missing) {
        int actualSize = actual.size();
        int expectedSize = expected.size();
        if (actualSize != (expectedSize += actualUsedKernel ? expectedKernelOnly.size() : expectedKernelBlocked.size())) {
            caseErrors = VerifyDelta.addError(caseErrors, "Incorrect count: expected [ " + expectedSize + " ] actual [ " + actualSize + " ]");
        }
        HashSet<String> actualSet = new HashSet<String>(actual);
        HashSet<String> expectedSet = new HashSet<String>(expected);
        HashSet<String> expectedExtraSet = new HashSet<String>(actualUsedKernel ? expectedKernelOnly : expectedKernelBlocked);
        for (String string : expectedSet) {
            if (actualSet.contains(string)) continue;
            if (missing != null) {
                missing.add(string);
            }
            caseErrors = VerifyDelta.addError(caseErrors, "Missing [ " + VerifyDelta.addType(repo, string) + " ]");
        }
        String usedKernelTag = actualUsedKernel ? "Kernel Only" : "Kernel Blocked";
        for (String expectedElement : expectedExtraSet) {
            if (actualSet.contains(expectedElement)) continue;
            if (missing != null) {
                missing.add(expectedElement);
            }
            caseErrors = VerifyDelta.addError(caseErrors, "Missing [ " + VerifyDelta.addType(repo, expectedElement) + " ]" + usedKernelTag);
        }
        for (String actualElement : actualSet) {
            String extraTag = expectedSet.contains(actualElement) ? null : (expectedKernelOnly.contains(actualElement) ? (actualUsedKernel ? null : "Extra kernel only") : (expectedKernelBlocked.contains(actualElement) ? (actualUsedKernel ? "Extra kernel blocked" : null) : "Extra"));
            if (extraTag == null) continue;
            if (extra != null) {
                extra.add(actualElement);
            }
            caseErrors = VerifyDelta.addError(caseErrors, extraTag + " [ " + VerifyDelta.addType(repo, actualElement) + " ]");
        }
        if (caseErrors == null) {
            int n = actualSize > expectedSize ? expectedSize : actualSize;
            String orderError = null;
            int expectedNo = 0;
            for (int actualNo = 0; orderError == null && actualNo < n; ++actualNo) {
                String actualAt = actual.get(actualNo);
                if (expectedExtraSet.contains(actualAt)) continue;
                String expectedAt = expected.get(expectedNo);
                ++expectedNo;
                if (expectedAt.contentEquals(actualAt)) continue;
                orderError = "Order error at [ " + (actualNo - 1) + " ]: Expected [ " + expectedAt + " ] Actual [ " + actualAt + " ]";
            }
            if (orderError != null) {
                if (caseWarnings != null) {
                    caseWarnings.add(orderError);
                } else {
                    caseErrors = VerifyDelta.addError(caseErrors, orderError);
                }
            }
        }
        return caseErrors;
    }

    public static void kernelAdjust(VerifyData.VerifyCase original, boolean originalUsedKernel, Set<String> updatedResolved, boolean updatedUsedKernel) {
        List<String> removed;
        List<String> added;
        if (originalUsedKernel == updatedUsedKernel) {
            return;
        }
        if (originalUsedKernel) {
            added = original.output.kernelBlocked;
            removed = original.output.kernelOnly;
        } else {
            added = original.output.kernelBlocked;
            removed = original.output.kernelOnly;
        }
        VerifyDelta.moveDifference(original.output.resolved, updatedResolved, added, removed);
    }

    protected static void moveDifference(List<String> original, Set<String> updated, List<String> added, List<String> removed) {
        int numOriginal = original.size();
        for (int originalNo = 0; originalNo < numOriginal; ++originalNo) {
            String originalElement = original.get(originalNo);
            if (updated.contains(originalElement)) continue;
            removed.add(originalElement);
            original.remove(originalNo);
            --numOriginal;
        }
        HashSet<String> originalSet = new HashSet<String>(original);
        for (String updatedElement : updated) {
            if (originalSet.contains(updatedElement)) continue;
            added.add(updatedElement);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyDelta", VerifyDelta.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    }

    public static interface VisibilitySupplier {
        public String getVisibility(String var1);
    }
}

