/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.internal.util.BaseXML;
import com.ibm.ws.kernel.feature.internal.util.LazySupplierImpl;
import com.ibm.ws.kernel.feature.internal.util.VerifyData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class VerifyXML
extends BaseXML {
    static final long serialVersionUID = -5636974326735215176L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void writeDurations(File file, List<LazySupplierImpl<VerifyData.VerifyCase>> cases) throws Exception {
        FileWriter fW = new FileWriter(file, false);
        try {
            PrintWriter pW = new PrintWriter(fW);
            try {
                VerifyXML.writeDurations(pW, cases);
                pW.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", (String)"43", null, (Object[])new Object[]{file, cases});
                try {
                    pW.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", (String)"43", null, (Object[])new Object[]{file, cases});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", (String)"43", null, (Object[])new Object[]{file, cases});
            try {
                fW.close();
            }
            catch (Throwable throwable3) {
                FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", (String)"43", null, (Object[])new Object[]{file, cases});
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        fW.close();
    }

    public static void writeDurations(PrintWriter output, List<LazySupplierImpl<VerifyData.VerifyCase>> cases) throws Exception {
        StringBuilder lineBuilder = new StringBuilder();
        for (LazySupplierImpl<VerifyData.VerifyCase> caseSupplier : cases) {
            VerifyData.VerifyCase verifyCase = caseSupplier.getSupplied();
            if (verifyCase == null) continue;
            long durationNs = verifyCase.durationNs;
            long ns = durationNs % 1000000000L;
            long s = (durationNs - ns) / 1000000000L;
            String nsText = Long.toString(ns);
            String sText = Long.toString(s);
            lineBuilder.append(verifyCase.name);
            lineBuilder.append(' ');
            lineBuilder.append(sText);
            lineBuilder.append('.');
            lineBuilder.append(BaseXML.gap(ns));
            lineBuilder.append(nsText);
            lineBuilder.append(' ');
            lineBuilder.append('s');
            output.println(lineBuilder);
            lineBuilder.setLength(0);
        }
    }

    public static void writeCases(PrintStream output, final List<? extends VerifyData.VerifyCase> cases) throws Exception {
        VerifyXML.write(output, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = -2731492888116545358L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                VerifyXMLWriter xW = new VerifyXMLWriter(pW);
                try {
                    xW.writeCases(cases);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public static void write(File file, final List<LazySupplierImpl<VerifyData.VerifyCase>> cases) throws Exception {
        VerifyXML.write(file, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = 5791046774806887097L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                VerifyXMLWriter xW = new VerifyXMLWriter(pW);
                try {
                    xW.write(cases);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$2", 2.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public static void write(PrintStream output, final VerifyData verifyData) throws Exception {
        VerifyXML.write(output, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = -847742271455214804L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                VerifyXMLWriter xW = new VerifyXMLWriter(pW);
                try {
                    xW.write(verifyData);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$3", 3.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public static void write(File file, final VerifyData verifyData) throws Exception {
        VerifyXML.write(file, new BaseXML.FailableConsumer<PrintWriter, Exception>(){
            static final long serialVersionUID = -2992174917993917946L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(PrintWriter pW) throws Exception {
                VerifyXMLWriter xW = new VerifyXMLWriter(pW);
                try {
                    xW.write(verifyData);
                }
                finally {
                    xW.flush();
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$4", 4.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        });
    }

    public static VerifyData read(File file) throws Exception {
        VerifyContentHandler contentHandler = new VerifyContentHandler();
        VerifyErrorHandler errorHandler = new VerifyErrorHandler(System.out);
        BaseXML.read(file, contentHandler, errorHandler);
        return contentHandler.verifyData;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML", VerifyXML.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VerifyContentHandler
    extends BaseXML.BaseContentHandler {
        private VerifyData verifyData;
        private VerifyData.VerifyCase verifyCase;
        static final long serialVersionUID = -1655975981726484688L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private void startData() {
            this.verifyData = new VerifyData();
        }

        private void endData() {
        }

        private void startCase() {
            this.verifyCase = this.verifyData.addCase();
        }

        private void endCase() {
            this.verifyCase = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            boolean whitespaceOnly = false;
            if (this.pushElement(qName, "cases", null)) {
                this.startData();
                whitespaceOnly = true;
            } else if (this.pushElement(qName, "case", "cases")) {
                this.startCase();
                whitespaceOnly = true;
            } else if (!(this.pushElement(qName, "name", "case") || this.pushElement(qName, "description", "case") || this.pushElement(qName, "duration", "case"))) {
                if (this.pushElement(qName, "input", "case")) {
                    whitespaceOnly = true;
                } else if (!(this.pushElement(qName, "multiple", "input") || this.pushElement(qName, "client", "input") || this.pushElement(qName, "server", "input") || this.pushElement(qName, "kernel", "input") || this.pushElement(qName, "root", "input"))) {
                    if (this.pushElement(qName, "output", "case")) {
                        whitespaceOnly = true;
                    } else if (!this.pushElement(qName, "resolved", "output")) {
                        super.startElement(uri, localName, qName, atts);
                    }
                }
            }
            this.pushBuilder(whitespaceOnly);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String elementText = this.popBuilder();
            String oldLast = this.popElement();
            if (oldLast.equals("cases")) {
                this.endData();
            } else if (oldLast.equals("case")) {
                this.endCase();
            } else if (oldLast.equals("name")) {
                this.verifyCase.name = elementText;
            } else if (oldLast.equals("description")) {
                this.verifyCase.description = elementText;
            } else if (oldLast.equals("duration")) {
                this.verifyCase.durationNs = this.parseSAsNS(elementText);
            } else if (!oldLast.equals("input")) {
                if (oldLast.contentEquals("multiple")) {
                    this.verifyCase.input.setMultiple();
                } else if (oldLast.contentEquals("client")) {
                    this.verifyCase.input.setClient();
                } else if (oldLast.contentEquals("server")) {
                    this.verifyCase.input.setServer();
                } else if (oldLast.equals("kernel")) {
                    this.verifyCase.input.addKernel(elementText);
                } else if (oldLast.equals("root")) {
                    this.verifyCase.input.addRoot(elementText);
                } else if (!oldLast.equals("output")) {
                    if (oldLast.equals("resolved")) {
                        this.verifyCase.output.addResolved(elementText);
                    } else {
                        super.endElement(uri, localName, qName);
                    }
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$VerifyContentHandler", VerifyContentHandler.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VerifyErrorHandler
    extends BaseXML.BaseErrorHandler {
        static final long serialVersionUID = -6449634859531195176L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public VerifyErrorHandler(PrintStream printer) {
            super(printer);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$VerifyErrorHandler", VerifyErrorHandler.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VerifyXMLWriter
    extends BaseXML.BaseXMLWriter {
        static final long serialVersionUID = 5040704455366592136L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public VerifyXMLWriter(PrintWriter pW) {
            super(pW);
        }

        public void write(VerifyData verifyData) {
            this.openElement("cases");
            this.upIndent();
            for (VerifyData.VerifyCase verifyCase : verifyData.cases) {
                this.write(verifyCase);
            }
            this.downIndent();
            this.closeElement("cases");
        }

        public void writeCases(List<? extends VerifyData.VerifyCase> cases) throws Exception {
            this.openElement("cases");
            this.upIndent();
            for (VerifyData.VerifyCase verifyCase : cases) {
                this.write(verifyCase);
            }
            this.downIndent();
            this.closeElement("cases");
        }

        public void write(List<LazySupplierImpl<VerifyData.VerifyCase>> cases) throws Exception {
            this.openElement("cases");
            this.upIndent();
            for (LazySupplierImpl<VerifyData.VerifyCase> verifyCase : cases) {
                this.write(verifyCase.supply());
            }
            this.downIndent();
            this.closeElement("cases");
        }

        public void write(VerifyData.VerifyCase verifyCase) {
            this.openElement("case");
            this.upIndent();
            this.printElement("name", verifyCase.name);
            this.printElement("description", verifyCase.description);
            this.write(verifyCase.input);
            this.write(verifyCase.output);
            this.downIndent();
            this.closeElement("case");
        }

        public void write(VerifyData.VerifyInput verifyInput) {
            this.openElement("input");
            this.upIndent();
            if (verifyInput.isMultiple) {
                this.printElement("multiple");
            }
            if (verifyInput.isClient) {
                this.printElement("client");
            }
            if (verifyInput.isServer) {
                this.printElement("server");
            }
            for (String kernelFeature : verifyInput.kernel) {
                this.printElement("kernel", kernelFeature);
            }
            for (String root : verifyInput.roots) {
                this.printElement("root", root);
            }
            this.downIndent();
            this.closeElement("input");
        }

        public void write(VerifyData.VerifyOutput verifyOutput) {
            this.openElement("output");
            this.upIndent();
            for (String feature : verifyOutput.kernelOnly) {
                this.printElement("kernelOnly", feature);
            }
            for (String feature : verifyOutput.kernelBlocked) {
                this.printElement("kernelBlocked", feature);
            }
            for (String resolved : verifyOutput.resolved) {
                this.printElement("resolved", resolved);
            }
            this.downIndent();
            this.closeElement("output");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.util.VerifyXML$VerifyXMLWriter", VerifyXMLWriter.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

