/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.context.SubjectManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JsonWebTokenBean
implements Bean<JsonWebToken>,
PassivationCapable {
    private static final TraceComponent tc = Tr.register(JsonWebTokenBean.class);
    private final String name;
    private final String id;
    private final Class<? extends Annotation> scope = RequestScoped.class;
    private final HashSet<Annotation> qualifiers = new HashSet();
    private final Type type;
    private final Set<Type> types;
    private final Set<InjectionPoint> injectionPoints;
    static final long serialVersionUID = -4352835306817879286L;

    public JsonWebTokenBean(BeanManager beanManager) {
        this.qualifiers.add((Annotation)new AnnotationLiteral<Default>(){
            static final long serialVersionUID = -6571283887830503236L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        this.type = new TypeLiteral<JsonWebToken>(){
            static final long serialVersionUID = -2599312945295196859L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        }.getType();
        this.types = Collections.singleton(this.type);
        this.injectionPoints = Collections.emptySet();
        this.name = this.getClass().getName() + "[" + this.type + "]";
        this.id = beanManager.hashCode() + "#" + this.name;
    }

    @ManualTrace
    public JsonWebToken create(CreationalContext<JsonWebToken> creationalContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"create", (Object[])new Object[]{creationalContext});
        }
        JsonWebToken jsonWebToken = null;
        Subject subject = new SubjectManager().getCallerSubject();
        Set<JsonWebToken> jsonWebTokenPrincipal = subject.getPrincipals(JsonWebToken.class);
        if (!jsonWebTokenPrincipal.isEmpty()) {
            jsonWebToken = jsonWebTokenPrincipal.iterator().next();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"create", (Object)jsonWebToken);
        }
        return jsonWebToken;
    }

    public void destroy(JsonWebToken arg0, CreationalContext<JsonWebToken> creationalContext) {
        creationalContext.release();
    }

    public String getName() {
        return this.name;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<?> getBeanClass() {
        return JsonWebToken.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public boolean isNullable() {
        return false;
    }

    public String getId() {
        return this.id;
    }
}

