/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JavaInfo {
    private static JavaInfo instance;
    private final int MAJOR;
    private final int MINOR;
    private final Vendor VENDOR;
    static final long serialVersionUID = -8493232880270469008L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private JavaInfo() {
        String version = PrivHelper.getProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        this.MAJOR = Integer.valueOf(versionElements[i++]);
        this.MINOR = i < versionElements.length ? Integer.valueOf(versionElements[i]) : 0;
        String vendor = PrivHelper.getProperty("java.vendor").toLowerCase();
        this.VENDOR = vendor.contains("ibm") ? Vendor.IBM : (vendor.contains("oracle") ? Vendor.ORACLE : Vendor.UNKNOWN);
    }

    private static JavaInfo instance() {
        if (instance == null) {
            instance = new JavaInfo();
        }
        return instance;
    }

    public static int majorVersion() {
        return JavaInfo.instance().MAJOR;
    }

    public static int minorVersion() {
        return JavaInfo.instance().MINOR;
    }

    public static Vendor vendor() {
        return JavaInfo.instance().VENDOR;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JavaInfo.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class Vendor
    extends Enum<Vendor> {
        public static final /* enum */ Vendor IBM;
        public static final /* enum */ Vendor ORACLE;
        public static final /* enum */ Vendor UNKNOWN;
        private static final /* synthetic */ Vendor[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static Vendor[] values() {
            return (Vendor[])$VALUES.clone();
        }

        public static Vendor valueOf(String name) {
            return Enum.valueOf(Vendor.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Vendor.class);
            IBM = new Vendor();
            ORACLE = new Vendor();
            UNKNOWN = new Vendor();
            $VALUES = new Vendor[]{IBM, ORACLE, UNKNOWN};
        }
    }
}

