/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.webcontainer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.jaxws.endpoint.EndpointPublisher;
import com.ibm.ws.jaxws.endpoint.EndpointPublisherManager;
import com.ibm.ws.jaxws.endpoint.JaxWsPublisherContext;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.jaxws.support.JaxWsInstanceManager;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.jaxws.webcontainer.JaxWsExtensionProcessor;
import com.ibm.ws.jaxws.webcontainer.JaxWsWebAppConfigurator;
import com.ibm.ws.jaxws.webcontainer.WebAppInjectionInstanceInterceptor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxWsExtensionFactory
implements ExtensionFactory {
    private static final TraceComponent tc = Tr.register(JaxWsExtensionFactory.class);
    private final AtomicServiceReference<EndpointPublisherManager> endpointPublisherManagerRef = new AtomicServiceReference("endpointPublisherManager");
    private final Set<JaxWsWebAppConfigurator> jaxWsWebAppConfigurators = new CopyOnWriteArraySet<JaxWsWebAppConfigurator>();
    static final long serialVersionUID = -5666713866464728236L;

    public void setJaxWsWebAppConfigurator(JaxWsWebAppConfigurator configurator) {
        this.jaxWsWebAppConfigurators.add(configurator);
    }

    public void unsetJaxWsWebAppConfigurator(JaxWsWebAppConfigurator configurator) {
        this.jaxWsWebAppConfigurators.remove(configurator);
    }

    public void setEndpointPublisherManager(ServiceReference<EndpointPublisherManager> ref) {
        this.endpointPublisherManagerRef.setReference(ref);
    }

    public void unsetEndpointPublisherManager(ServiceReference<EndpointPublisherManager> ref) {
        this.endpointPublisherManagerRef.setReference(null);
    }

    protected void activate(ComponentContext cc) {
        this.endpointPublisherManagerRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.endpointPublisherManagerRef.deactivate(cc);
    }

    public ExtensionProcessor createExtensionProcessor(IServletContext servletContext) throws Exception {
        WebModuleMetaData moduleMetaData = ((WebAppConfigExtended)servletContext.getWebAppConfig()).getMetaData();
        JaxWsModuleMetaData jaxWsModuleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)moduleMetaData);
        if (jaxWsModuleMetaData == null) {
            return null;
        }
        jaxWsModuleMetaData.getJaxWsInstanceManager().addInterceptor((JaxWsInstanceManager.InstanceInterceptor)new WebAppInjectionInstanceInterceptor(servletContext));
        JaxWsModuleInfo jaxWsModuleInfo = (JaxWsModuleInfo)servletContext.getModuleContainer().adapt(JaxWsModuleInfo.class);
        if (jaxWsModuleInfo == null || jaxWsModuleInfo.endpointInfoSize() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No web service implementation bean is found in the web module, will not create web service processor", (Object[])new Object[0]);
            }
            return null;
        }
        Container publisherModuleContainer = servletContext.getModuleContainer();
        JaxWsPublisherContext publisherContext = new JaxWsPublisherContext(jaxWsModuleMetaData, publisherModuleContainer, (ModuleInfo)JaxWsUtils.getWebModuleInfo((Container)publisherModuleContainer));
        publisherContext.setAttribute("SERVLET_CONTEXT", (Object)servletContext);
        WebApp webApp = (WebApp)servletContext;
        publisherContext.setAttribute("NAMESPACE_COLLABORATOR", (Object)webApp.getCollaboratorHelper().getWebAppNameSpaceCollaborator());
        publisherContext.setAttribute("ENDPOINT_INFO_BUILDER_CONTEXT", (Object)new EndpointInfoBuilderContext(((WebAnnotations)servletContext.getModuleContainer().adapt(WebAnnotations.class)).getInfoStore(), servletContext.getModuleContainer()));
        EndpointPublisher endpointPublisher = ((EndpointPublisherManager)this.endpointPublisherManagerRef.getServiceWithException()).getEndpointPublisher("WEB");
        for (EndpointInfo endpointInfo : jaxWsModuleInfo.getEndpointInfos()) {
            endpointPublisher.publish(endpointInfo, publisherContext);
        }
        for (JaxWsWebAppConfigurator jaxWsWebAppConfigurator : this.jaxWsWebAppConfigurators) {
            jaxWsWebAppConfigurator.configure(jaxWsModuleInfo, servletContext.getWebAppConfig());
        }
        return new JaxWsExtensionProcessor(servletContext);
    }

    public List getPatternList() {
        return Collections.emptyList();
    }
}

