/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.security.ManagementRole;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authorization.AuthorizationTableService;
import com.ibm.ws.security.authorization.RoleSet;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ManagementSecurityAuthorizationTable
implements AuthorizationTableService,
UserRegistryChangeListener {
    private static final TraceComponent tc = Tr.register(ManagementSecurityAuthorizationTable.class);
    static final String KEY_SECURITY_SERVICE = "securityService";
    static final String KEY_MANAGEMENT_ROLE = "managementRole";
    static final String KEY_LDAP_REGISTRY = "(service.factoryPid=com.ibm.ws.security.registry.ldap.config)";
    static final String KEY_IGNORE_CASE = "ignoreCase";
    private final RoleSet ADMIN_ROLE_SET;
    private final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    private final ConcurrentServiceReferenceSet<ManagementRole> managementRoles = new ConcurrentServiceReferenceSet("managementRole");
    static final String KEY_CONFIG_ADMIN = "configurationAdmin";
    protected final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configurationAdmin");
    private final Map<String, RoleSet> accessIdToRoles = new HashMap<String, RoleSet>();
    private final Map<String, String> userToAccessId = new HashMap<String, String>();
    private final Map<String, String> groupToAccessId = new HashMap<String, String>();
    private final Map<String, RoleSet> userToRoles = new HashMap<String, RoleSet>();
    private final Map<String, RoleSet> groupToRoles = new HashMap<String, RoleSet>();
    private static HashSet<String> ALL_AUTHENTICATED_USERS_SET = new HashSet();
    private static final RoleSet ALL_AUTHENTICATED_USERS_ROLESET;
    private boolean isIgnoreCaseSet = false;
    private boolean isIgnoreCase = false;
    static final long serialVersionUID = -6998435307221982735L;

    public ManagementSecurityAuthorizationTable() {
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("Administrator");
        this.ADMIN_ROLE_SET = new RoleSet(adminRoles);
    }

    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    protected synchronized void setManagementRole(ServiceReference<ManagementRole> reference) {
        this.managementRoles.addReference(reference);
        this.populateInitialAuthorizationTable();
    }

    protected synchronized void updatedManagementRole(ServiceReference<ManagementRole> reference) {
        this.populateInitialAuthorizationTable();
    }

    protected synchronized void unsetManagementRole(ServiceReference<ManagementRole> reference) {
        this.managementRoles.removeReference(reference);
        this.populateInitialAuthorizationTable();
    }

    protected void setConfigurationAdmin(ServiceReference<ConfigurationAdmin> reference) {
        this.configAdminRef.setReference(reference);
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> reference) {
        this.configAdminRef.unsetReference(reference);
    }

    protected synchronized void activate(ComponentContext cc) {
        this.securityServiceRef.activate(cc);
        this.managementRoles.activate(cc);
        this.configAdminRef.activate(cc);
        this.populateInitialAuthorizationTable();
    }

    protected synchronized void deactivate(ComponentContext cc) {
        this.clearAuthorizationTable();
        this.configAdminRef.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
        this.managementRoles.deactivate(cc);
    }

    public RoleSet getRolesForSpecialSubject(String resName, String specialSubject) {
        if ("com.ibm.ws.management.security.resource".equals(resName)) {
            if (specialSubject.equals("ALL_AUTHENTICATED_USERS")) {
                return ALL_AUTHENTICATED_USERS_ROLESET;
            }
            return RoleSet.EMPTY_ROLESET;
        }
        return null;
    }

    public RoleSet getRolesForAccessId(String resName, String accessId) {
        if ("com.ibm.ws.management.security.resource".equals(resName)) {
            return this.rolesForAccessId(accessId);
        }
        return null;
    }

    private void clearAuthorizationTable() {
        this.accessIdToRoles.clear();
        this.userToAccessId.clear();
        this.groupToAccessId.clear();
        this.userToRoles.clear();
        this.groupToRoles.clear();
    }

    private void populateInitialAuthorizationTable() {
        this.clearAuthorizationTable();
        HashMap userToRoleName = new HashMap();
        HashMap groupToRoleName = new HashMap();
        Iterator itr = this.managementRoles.getServices();
        while (itr.hasNext()) {
            Set<String> assignedRoles;
            ManagementRole role = (ManagementRole)itr.next();
            String roleName = role.getRoleName();
            for (String user : role.getUsers()) {
                assignedRoles = (HashSet<String>)userToRoleName.get(user);
                if (assignedRoles == null) {
                    assignedRoles = new HashSet<String>();
                    userToRoleName.put(user, assignedRoles);
                }
                assignedRoles.add(roleName);
            }
            for (String group : role.getGroups()) {
                assignedRoles = (Set)groupToRoleName.get(group);
                if (assignedRoles == null) {
                    assignedRoles = new HashSet();
                    groupToRoleName.put(group, assignedRoles);
                }
                assignedRoles.add(roleName);
            }
        }
        for (Map.Entry entry : userToRoleName.entrySet()) {
            this.userToRoles.put((String)entry.getKey(), new RoleSet((Set)entry.getValue()));
        }
        for (Map.Entry entry : groupToRoleName.entrySet()) {
            this.groupToRoles.put((String)entry.getKey(), new RoleSet((Set)entry.getValue()));
        }
    }

    private RoleSet rolesForAccessId(String accessId) {
        if (AccessIdUtil.isServerAccessId((String)accessId)) {
            return this.ADMIN_ROLE_SET;
        }
        RoleSet roles = this.accessIdToRoles.get(accessId);
        if (roles == null) {
            return this.findRolesForAccessId(accessId);
        }
        return roles;
    }

    private RoleSet findRolesForAccessId(String accessId) {
        if (!AccessIdUtil.isAccessId((String)accessId)) {
            throw new IllegalArgumentException("Invalid accessId");
        }
        if (AccessIdUtil.isUserAccessId((String)accessId)) {
            for (String user : this.userToRoles.keySet()) {
                String userAccessId = this.userToAccessId.get(user);
                if (userAccessId == null) {
                    userAccessId = this.getUserAccessId(user);
                    if (userAccessId == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Unable to determine accessId of user " + user), (Object[])new Object[0]);
                        continue;
                    }
                    this.userToAccessId.put(user, userAccessId);
                }
                if (this.accessIdToRoles.get(userAccessId) == null) {
                    this.accessIdToRoles.put(userAccessId, this.userToRoles.get(user));
                }
                if (!this.isMatch(accessId, userAccessId)) continue;
                return this.accessIdToRoles.get(userAccessId);
            }
        } else if (AccessIdUtil.isGroupAccessId((String)accessId)) {
            for (String group : this.groupToRoles.keySet()) {
                String groupAccessId = this.groupToAccessId.get(group);
                if (groupAccessId == null) {
                    groupAccessId = this.getGroupAccessId(group);
                    if (groupAccessId == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Unable to determine accessId of group " + group), (Object[])new Object[0]);
                        continue;
                    }
                    this.groupToAccessId.put(group, groupAccessId);
                }
                if (this.accessIdToRoles.get(groupAccessId) == null) {
                    this.accessIdToRoles.put(groupAccessId, this.groupToRoles.get(group));
                }
                if (!this.isMatch(accessId, groupAccessId)) continue;
                return this.accessIdToRoles.get(groupAccessId);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unknown accessId", (Object[])new Object[0]);
            }
            return RoleSet.EMPTY_ROLESET;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No roles mapped to accessId", (Object[])new Object[]{accessId});
        }
        return RoleSet.EMPTY_ROLESET;
    }

    /*
     * WARNING - void declaration
     */
    private String getUserAccessId(String userName) {
        block4: {
            try {
                SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                UserRegistryService userRegistryService = securityService.getUserRegistryService();
                UserRegistry userRegistry = userRegistryService.getUserRegistry();
                String realm = userRegistry.getRealm();
                String uniqueId = userRegistry.getUniqueUserId(userName);
                return AccessIdUtil.createAccessId((String)"user", (String)realm, (String)uniqueId);
            }
            catch (EntryNotFoundException securityService) {
                FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.management.security.internal.ManagementSecurityAuthorizationTable", (String)"332", (Object)this, (Object[])new Object[]{userName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + userName + ": " + e), (Object[])new Object[0]);
                }
            }
            catch (RegistryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.security.internal.ManagementSecurityAuthorizationTable", (String)"337", (Object)this, (Object[])new Object[]{userName});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + userName + ": " + (Object)((Object)e)), (Object[])new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getGroupAccessId(String groupName) {
        block4: {
            try {
                SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                UserRegistryService userRegistryService = securityService.getUserRegistryService();
                UserRegistry userRegistry = userRegistryService.getUserRegistry();
                String realm = userRegistry.getRealm();
                String groupUniqueId = userRegistry.getUniqueGroupId(groupName);
                return AccessIdUtil.createAccessId((String)"group", (String)realm, (String)groupUniqueId);
            }
            catch (EntryNotFoundException securityService) {
                FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.management.security.internal.ManagementSecurityAuthorizationTable", (String)"361", (Object)this, (Object[])new Object[]{groupName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + groupName + ": " + e), (Object[])new Object[0]);
                }
            }
            catch (RegistryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.security.internal.ManagementSecurityAuthorizationTable", (String)"366", (Object)this, (Object[])new Object[]{groupName});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + groupName + ": " + (Object)((Object)e)), (Object[])new Object[0]);
            }
        }
        return null;
    }

    public void notifyOfUserRegistryChange() {
        this.isIgnoreCaseSet = false;
        this.accessIdToRoles.clear();
        this.userToAccessId.clear();
        this.groupToAccessId.clear();
    }

    protected boolean isIgnoreCase() {
        if (!this.isIgnoreCaseSet) {
            this.isIgnoreCase = this.getIgnoreCase();
            this.isIgnoreCaseSet = true;
        }
        return this.isIgnoreCase;
    }

    protected boolean isMatch(String a, String b) {
        boolean match = false;
        match = this.isIgnoreCase() ? a.equalsIgnoreCase(b) : a.equals(b);
        return match;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean getIgnoreCase() {
        boolean value;
        block13: {
            value = false;
            if (this.securityServiceRef != null && this.configAdminRef != null) {
                try {
                    String type;
                    UserRegistryService userRegistryService;
                    SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                    if (securityService == null || (userRegistryService = securityService.getUserRegistryService()) == null || !userRegistryService.isUserRegistryConfigured() || !"LDAP".equalsIgnoreCase(type = userRegistryService.getUserRegistryType()) && !"WIM".equalsIgnoreCase(type)) break block13;
                    value = true;
                    ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
                    if (configAdmin != null) {
                        Configuration[] ldapRegistryConfigs = configAdmin.listConfigurations(KEY_LDAP_REGISTRY);
                        if (ldapRegistryConfigs != null) {
                            for (int i = 0; i < ldapRegistryConfigs.length; ++i) {
                                Object ignoreCaseObject;
                                Dictionary props = ldapRegistryConfigs[i].getProperties();
                                if (props != null && (ignoreCaseObject = props.get(KEY_IGNORE_CASE)) != null) {
                                    if (ignoreCaseObject instanceof Boolean) {
                                        value = (Boolean)ignoreCaseObject;
                                    } else if (ignoreCaseObject instanceof String && "false".equalsIgnoreCase((String)ignoreCaseObject)) {
                                        value = false;
                                    }
                                }
                                if (value) {
                                    continue;
                                }
                                break block13;
                            }
                            break block13;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"The Ldap Configuration object is null, use the default value which is true.", (Object[])new Object[0]);
                        }
                        break block13;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The ConfigurationAdmin object is null, use the default value which is true.", (Object[])new Object[0]);
                    }
                }
                catch (Exception securityService) {
                    void e;
                    FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.management.security.internal.ManagementSecurityAuthorizationTable", (String)"456", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)("Exception is caught while accessing the user registry configuration information. The default value " + value + " is used."), (Object[])new Object[]{e});
                }
            }
        }
        return value;
    }

    public boolean isAuthzInfoAvailableForApp(String appName) {
        return "com.ibm.ws.management.security.resource".equals(appName);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ALL_AUTHENTICATED_USERS_SET.add("allAuthenticatedUsers");
        ALL_AUTHENTICATED_USERS_ROLESET = new RoleSet(ALL_AUTHENTICATED_USERS_SET);
    }
}

