/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.clientcontainer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.LifecycleCallback;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LifecycleCallbackHelper {
    private static final TraceComponent tc = Tr.register(LifecycleCallbackHelper.class, (String)"clientContainer", (String)"com.ibm.ws.clientcontainer.resources.Messages");
    private String mainClassName = "";
    private boolean metadataComplete = false;
    static final long serialVersionUID = -4686510193955641388L;

    public LifecycleCallbackHelper(boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    public void doPostConstruct(Class clazz, List<LifecycleCallback> postConstructs) throws InjectionException {
        this.mainClassName = clazz.getName();
        this.doPostConstruct(clazz, postConstructs, null);
    }

    public void doPostConstruct(Object instance, List<LifecycleCallback> postConstructs) throws InjectionException {
        this.doPostConstruct(instance.getClass(), postConstructs, instance);
    }

    public void doPreDestroy(Object instance, List<LifecycleCallback> preDestroy) throws InjectionException {
        this.doPreDestroy(instance.getClass(), preDestroy, instance);
    }

    private void doPostConstruct(Class clazz, List<LifecycleCallback> postConstructs, Object instance) throws InjectionException {
        Method method;
        String classname;
        String methodName;
        if (!this.metadataComplete && clazz.getSuperclass() != null) {
            this.doPostConstruct(clazz.getSuperclass(), postConstructs, instance);
        }
        if ((methodName = this.getMethodNameFromDD(postConstructs, classname = clazz.getName())) != null) {
            this.invokeMethod(clazz, methodName, instance);
        } else if (!this.metadataComplete && (method = this.getAnnotatedPostConstructMethod(clazz)) != null) {
            this.invokeMethod(clazz, method.getName(), instance);
        }
    }

    private void doPreDestroy(Class clazz, List<LifecycleCallback> preDestroy, Object instance) throws InjectionException {
        Method method;
        String classname;
        String methodName;
        if (!this.metadataComplete && clazz.getSuperclass() != null) {
            this.doPostConstruct(clazz.getSuperclass(), preDestroy, instance);
        }
        if ((methodName = this.getMethodNameFromDD(preDestroy, classname = clazz.getName())) != null) {
            this.invokeMethod(clazz, methodName, instance);
        } else if (!this.metadataComplete && (method = this.getAnnotatedPreDestroyMethod(clazz)) != null) {
            this.invokeMethod(clazz, method.getName(), instance);
        }
    }

    public Method getAnnotatedPostConstructMethod(Class clazz) {
        return this.getAnnotatedMethod(clazz, PostConstruct.class);
    }

    public Method getAnnotatedPreDestroyMethod(Class clazz) {
        return this.getAnnotatedMethod(clazz, PreDestroy.class);
    }

    public Method getAnnotatedMethod(Class clazz, Class<? extends Annotation> annotationClass) {
        Method m = null;
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Annotation[] a = methods[i].getAnnotations();
            if (a == null) continue;
            for (int j = 0; j < a.length; ++j) {
                if (a[j].annotationType() != annotationClass) continue;
                if (m == null) {
                    m = methods[i];
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"DUPLICATE_CALLBACK_METHOD_CWWKC2454W", (Object[])new Object[]{methods[i].getName(), clazz.getName()});
            }
        }
        return m;
    }

    public void invokeMethod(final Class clazz, final String methodName, final Object instance) {
        AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = -3114508368893110255L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            public Object run() {
                try {
                    Method m = clazz.getDeclaredMethod(methodName, new Class[0]);
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                        m.invoke(instance, new Object[0]);
                        m.setAccessible(false);
                        return m;
                    }
                    m.invoke(instance, new Object[0]);
                    return m;
                }
                catch (Exception m) {
                    FFDCFilter.processException((Throwable)m, (String)"com.ibm.ws.clientcontainer.internal.LifecycleCallbackHelper$1", (String)"203", (Object)this, (Object[])new Object[0]);
                    if (tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    public String getMethodNameFromDD(List<LifecycleCallback> callbacks, String classname) {
        String methodName = null;
        for (LifecycleCallback callback : callbacks) {
            String callbackClassName = callback.getClassName();
            if (callbackClassName == null) {
                callbackClassName = this.mainClassName;
            }
            if (!callbackClassName.equals(classname)) continue;
            if (methodName == null) {
                methodName = callback.getMethodName();
                continue;
            }
            Tr.warning((TraceComponent)tc, (String)"DUPLICATE_CALLBACK_METHOD_CWWKC2454W", (Object[])new Object[]{methodName, classname});
        }
        return methodName;
    }
}

