/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.security.MessagingSecurityException;
import com.ibm.ws.messaging.security.MessagingSecurityService;
import com.ibm.ws.messaging.security.RuntimeSecurityService;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationService;
import com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl;
import com.ibm.ws.messaging.security.authorization.MessagingAuthorizationService;
import com.ibm.ws.messaging.security.authorization.internal.MessagingAuthorizationServiceImpl;
import com.ibm.ws.messaging.security.beans.Permission;
import com.ibm.ws.messaging.security.beans.QueuePermission;
import com.ibm.ws.messaging.security.beans.TemporaryDestinationPermission;
import com.ibm.ws.messaging.security.beans.TopicPermission;
import com.ibm.ws.messaging.security.utility.MessagingSecurityUtility;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.ibm.ws.messaging.security"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class MessagingSecurityServiceImpl
implements MessagingSecurityService,
ConfigurationListener {
    private static final TraceComponent tc = SibTr.register(MessagingSecurityServiceImpl.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpl";
    private SecurityService securityService = null;
    private MessagingAuthenticationService sibAuthenticationService = null;
    private MessagingAuthorizationService sibAuthorizationService = null;
    private ConfigurationAdmin configAdmin = null;
    private Map<String, Object> properties;
    private final Set<String> pids = new HashSet<String>();
    private Map<String, QueuePermission> queuePermissions;
    private Map<String, TemporaryDestinationPermission> temporaryDestinationPermissions;
    private Map<String, TopicPermission> topicPermissions;
    private final RuntimeSecurityService runtimeSecurityService = RuntimeSecurityService.SINGLETON_INSTANCE;
    private String bundleLocation;

    @Activate
    protected void activate(BundleContext ctx, Map<String, Object> properties) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplactivate", properties);
        this.properties = properties;
        this.bundleLocation = ctx.getBundle().getLocation();
        this.populateDestinationPermissions();
        this.runtimeSecurityService.modifyMessagingServices((MessagingSecurityService)this);
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplactivate");
    }

    @Modified
    protected void modify(ComponentContext cc, Map<String, Object> properties) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplmodify", properties);
        this.properties = properties;
        this.populateDestinationPermissions();
        this.runtimeSecurityService.modifyMessagingServices((MessagingSecurityService)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplmodify");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpldeactivate", (Object)context);
        this.runtimeSecurityService.modifyMessagingServices(null);
        this.queuePermissions = null;
        this.topicPermissions = null;
        this.temporaryDestinationPermissions = null;
        this.sibAuthenticationService = null;
        this.sibAuthorizationService = null;
        this.bundleLocation = null;
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpldeactivate");
    }

    @Reference
    protected void setSecurityService(SecurityService securityService) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplsetSecurityService", (Object)securityService);
        this.securityService = securityService;
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplsetSecurityService");
    }

    protected void unsetSecurityService(SecurityService securityService) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplunsetSecurityService", (Object)securityService);
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplunsetSecurityService");
    }

    @Reference
    protected void setConfigAdmin(ConfigurationAdmin configAdmin) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplsetConfigAdmin", (Object)configAdmin);
        this.configAdmin = configAdmin;
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplsetConfigAdmin");
    }

    protected void unsetConfigAdmin(ConfigurationAdmin configAdmin) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplunsetConfigAdmin", (Object)configAdmin);
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplunsetConfigAdmin");
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public MessagingAuthenticationService getMessagingAuthenticationService() {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplgetMessagingAuthenticationService");
        if (this.sibAuthenticationService == null) {
            this.sibAuthenticationService = new MessagingAuthenticationServiceImpl(this);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplgetMessagingAuthenticationService", (Object)this.sibAuthenticationService);
        return this.sibAuthenticationService;
    }

    public MessagingAuthorizationService getMessagingAuthorizationService() {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplgetMessagingAuthorizationService");
        if (this.sibAuthorizationService == null) {
            this.sibAuthorizationService = new MessagingAuthorizationServiceImpl(this);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplgetMessagingAuthorizationService", (Object)this.sibAuthorizationService);
        return this.sibAuthorizationService;
    }

    public String getUniqueUserName(Subject subject) throws MessagingSecurityException {
        return MessagingSecurityUtility.getUniqueUserName(subject);
    }

    public boolean isUnauthenticated(Subject subject) throws Exception {
        String uniqueUserName = this.getUniqueUserName(subject);
        this.getUserRegistry().getUserSecurityName(uniqueUserName);
        return MessagingSecurityUtility.isUnauthenticated(subject);
    }

    public UserRegistry getUserRegistry() {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplgetUserRegistry");
        UserRegistry userRegistry = null;
        if (this.getSecurityService() != null) {
            UserRegistryService userRegistryService = this.securityService.getUserRegistryService();
            try {
                if (userRegistryService.isUserRegistryConfigured()) {
                    userRegistry = userRegistryService.getUserRegistry();
                } else {
                    MessagingSecurityException mse = new MessagingSecurityException();
                    FFDCFilter.processException((Throwable)mse, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpl.getUserRegistry", (String)"1005", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)mse));
                    SibTr.error((TraceComponent)tc, (String)"USER_REGISTRY_NOT_CONFIGURED_MSE1005");
                }
            }
            catch (RegistryException re) {
                MessagingSecurityException mse = new MessagingSecurityException((Throwable)re);
                FFDCFilter.processException((Throwable)mse, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpl.getUserRegistry", (String)"1006", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)mse));
                SibTr.error((TraceComponent)tc, (String)"USER_REGISTRY_EXCEPTION_MSE1006");
            }
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplgetUserRegistry", userRegistry);
        return userRegistry;
    }

    public Map<String, QueuePermission> getQueuePermissions() {
        return this.queuePermissions;
    }

    public Map<String, TemporaryDestinationPermission> getTemporaryDestinationPermissions() {
        return this.temporaryDestinationPermissions;
    }

    public Map<String, TopicPermission> getTopicPermissions() {
        return this.topicPermissions;
    }

    private void populateDestinationPermissions() {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplpopulateDestinationPermissions", this.properties);
        this.pids.clear();
        String[] roles = (String[])this.properties.get("role");
        this.initializeMaps();
        if (roles != null) {
            this.checkIfRolesAreUnique(roles);
            for (String role : roles) {
                Dictionary<String, Object> roleProperties = this.getDictionaryObject(role);
                Set<String> users = null;
                Set<String> groups = null;
                users = this.createUserOrGroupSet(roleProperties, "user");
                groups = this.createUserOrGroupSet(roleProperties, "group");
                if (roleProperties == null) continue;
                this.populateQueuePermissions(roleProperties, users, groups);
                this.populateTemporarayDestinationPermissions(roleProperties, users, groups);
                this.populateTopicPermissions(roleProperties, users, groups);
            }
        }
        if (tc.isDebugEnabled()) {
            this.printDestinationPermissions(this.queuePermissions);
            this.printDestinationPermissions(this.topicPermissions);
            this.printDestinationPermissions(this.temporaryDestinationPermissions);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplpopulateDestinationPermissions");
    }

    private void initializeMaps() {
        if (this.queuePermissions != null) {
            this.queuePermissions.clear();
        } else {
            this.queuePermissions = new ConcurrentHashMap<String, QueuePermission>();
        }
        if (this.topicPermissions != null) {
            this.topicPermissions.clear();
        } else {
            this.topicPermissions = new ConcurrentHashMap<String, TopicPermission>();
        }
        if (this.temporaryDestinationPermissions != null) {
            this.temporaryDestinationPermissions.clear();
        } else {
            this.temporaryDestinationPermissions = new ConcurrentHashMap<String, TemporaryDestinationPermission>();
        }
    }

    private void populateQueuePermissions(Dictionary<String, Object> roleProperties, Set<String> users, Set<String> groups) {
        String[] tempPermissions = (String[])roleProperties.get("queuePermission");
        if (tempPermissions != null) {
            for (String tempPermission : tempPermissions) {
                QueuePermission permission = this.createQueuePermission(tempPermission, users, groups);
                if (permission == null) continue;
                this.queuePermissions.put(permission.getQueueReference(), permission);
            }
        }
    }

    private QueuePermission createQueuePermission(String tempPermission, Set<String> users, Set<String> groups) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcreateQueuePermission", (Object)new Object[]{tempPermission, users, groups});
        QueuePermission permission = null;
        String queueRef = null;
        Dictionary<String, Object> permissionProperties = this.getDictionaryObject(tempPermission);
        if (permissionProperties != null) {
            queueRef = (String)permissionProperties.get("queueRef");
            String[] actionArray = (String[])permissionProperties.get("action");
            permission = this.queuePermissions.get(queueRef);
            if (permission == null) {
                permission = new QueuePermission();
                permission.setQueueReference(queueRef);
            }
            permission.addUserAndGroupsToRole(actionArray, users, groups);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcreateQueuePermission", permission);
        return permission;
    }

    private void populateTopicPermissions(Dictionary<String, Object> roleProperties, Set<String> users, Set<String> groups) {
        String[] tempPermissions = (String[])roleProperties.get("topicPermission");
        if (tempPermissions != null) {
            for (String tempPermission : tempPermissions) {
                TopicPermission permission = this.createTopicPermission(tempPermission, users, groups);
                if (permission == null) continue;
                String topicSpace = permission.getTopicSpaceName();
                String topicName = permission.getTopicName();
                String key = this.getTopicPermissionKey(topicSpace, topicName);
                this.topicPermissions.put(key, permission);
            }
        }
    }

    private TopicPermission createTopicPermission(String tempPermission, Set<String> users, Set<String> groups) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcreateTopicPermission", (Object)new Object[]{tempPermission, users, groups});
        TopicPermission permission = null;
        String topicSpace = null;
        String topic = null;
        Dictionary<String, Object> permissionProperties = this.getDictionaryObject(tempPermission);
        if (permissionProperties != null) {
            topic = (String)permissionProperties.get("topicName");
            topicSpace = (String)permissionProperties.get("topicSpaceRef");
            String[] actionArray = (String[])permissionProperties.get("action");
            String key = this.getTopicPermissionKey(topicSpace, topic);
            permission = this.topicPermissions.get(key);
            if (permission == null) {
                permission = new TopicPermission();
                permission.setTopicName(topic);
                permission.setTopicSpaceName(topicSpace);
            }
            permission.addUserAndGroupsToRole(actionArray, users, groups);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcreateTopicPermission", permission);
        return permission;
    }

    private void populateTemporarayDestinationPermissions(Dictionary<String, Object> roleProperties, Set<String> users, Set<String> groups) {
        String[] tempPermissions = (String[])roleProperties.get("tempDestinationPermission");
        if (tempPermissions != null) {
            for (String tempPermission : tempPermissions) {
                TemporaryDestinationPermission permission = this.createTemporaryDestinationPermission(tempPermission, users, groups);
                if (permission == null) continue;
                this.temporaryDestinationPermissions.put(permission.getPrefix(), permission);
            }
        }
    }

    private TemporaryDestinationPermission createTemporaryDestinationPermission(String tempPermission, Set<String> users, Set<String> groups) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcreateTemporaryDestinationPermission", (Object)new Object[]{tempPermission, users, groups});
        TemporaryDestinationPermission permission = null;
        String prefix = null;
        Dictionary<String, Object> permissionProperties = this.getDictionaryObject(tempPermission);
        if (permissionProperties != null) {
            prefix = (String)permissionProperties.get("prefix");
            if (prefix.length() > 12) {
                prefix = prefix.substring(0, 12);
            }
            String[] actionArray = (String[])permissionProperties.get("action");
            permission = this.temporaryDestinationPermissions.get(prefix);
            if (permission == null) {
                permission = new TemporaryDestinationPermission();
                permission.setPrefix(prefix);
            }
            permission.addUserAndGroupsToRole(actionArray, users, groups);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcreateTemporaryDestinationPermission", permission);
        return permission;
    }

    private String getTopicPermissionKey(String topicSpace, String topic) {
        String key = null;
        key = topic == null || topic.isEmpty() ? topicSpace : topicSpace + "/" + topic;
        return key;
    }

    private void checkIfRolesAreUnique(String[] roles) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcheckIfRolesAreUnique");
        ArrayList<String> tempList = new ArrayList<String>();
        for (String role : roles) {
            Dictionary<String, Object> roleProperties = this.getDictionaryObject(role);
            if (roleProperties == null) continue;
            String roleName = (String)roleProperties.get("name");
            if (tempList.contains(roleName)) {
                SibTr.warning((TraceComponent)tc, (String)"DUPLICATE_ROLE_NAME_EXISTS_MSE1012", (Object)new Object[]{roleName});
            }
            tempList.add(roleName);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcheckIfRolesAreUnique");
    }

    private Set<String> createUserOrGroupSet(Dictionary<String, Object> properties, String type) {
        String[] tempUsersOrGroups;
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcreateUserOrGroupSet", (Object)new Object[]{properties, type});
        HashSet<String> userOrGroupSet = new HashSet<String>();
        if (properties != null && (tempUsersOrGroups = (String[])properties.get(type)) != null) {
            for (String tempUserOrGroup : tempUsersOrGroups) {
                Dictionary<String, Object> userOrGroupProperties = this.getDictionaryObject(tempUserOrGroup);
                if (userOrGroupProperties == null) continue;
                String userOrGroup = (String)userOrGroupProperties.get("name");
                userOrGroupSet.add(userOrGroup.trim());
            }
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplcreateUserOrGroupSet", userOrGroupSet);
        return userOrGroupSet;
    }

    private Dictionary<String, Object> getDictionaryObject(String input) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplgetDictionaryObject", (Object)input);
        Dictionary dictionary = null;
        Configuration config = null;
        try {
            this.pids.add(input);
            config = this.configAdmin.getConfiguration(input, this.bundleLocation);
        }
        catch (IOException e) {
            MessagingSecurityException mse = new MessagingSecurityException((Throwable)e);
            FFDCFilter.processException((Throwable)mse, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpl.getDictionaryObject", (String)"1008", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)mse));
            SibTr.error((TraceComponent)tc, (String)"IO_EXCEPTION_READING_CONFIGURATION_MSE1008");
            return new Hashtable<String, Object>();
        }
        dictionary = config.getProperties();
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImplgetDictionaryObject", (Object)dictionary);
        return dictionary;
    }

    private void printDestinationPermissions(Map<String, ?> destinationPermissions) {
        Set<String> destinations = destinationPermissions.keySet();
        for (String destination : destinations) {
            SibTr.debug((TraceComponent)tc, (String)("Destination: " + destination));
            Permission permission = (Permission)destinationPermissions.get(destination);
            SibTr.debug((TraceComponent)tc, (String)"  Users having permissions!!!");
            Map userRoles = permission.getRoleToUserMap();
            Set uRoles = userRoles.keySet();
            for (String role : uRoles) {
                SibTr.debug((TraceComponent)tc, (String)("    " + role + ": " + userRoles.get(role)));
            }
            SibTr.debug((TraceComponent)tc, (String)"  Groups having permissions!!!");
            Map groupRoles = permission.getRoleToGroupMap();
            Set gRoles = groupRoles.keySet();
            for (String role : gRoles) {
                SibTr.debug((TraceComponent)tc, (String)("    " + role + ": " + groupRoles.get(role)));
            }
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1 && this.pids.contains(event.getPid())) {
            this.populateDestinationPermissions();
            this.runtimeSecurityService.modifyMessagingServices((MessagingSecurityService)this);
        }
    }
}

