/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class PluginManager {
    private final PluginTracker pluginTracker;
    static final long serialVersionUID = -8398978898050816134L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PluginManager(BundleContext context) {
        this.pluginTracker = new PluginTracker(context);
    }

    public void start() {
        this.pluginTracker.open();
    }

    public void stop() {
        this.pluginTracker.close();
    }

    public void modifyConfiguration(ServiceReference<?> managedReference, Dictionary<String, Object> properties) {
        if (properties == null) {
            return;
        }
        ServiceReference<ConfigurationPlugin>[] references = this.pluginTracker.getServiceReferences();
        for (int i = 0; i < references.length; ++i) {
            ConfigurationPlugin plugin;
            String[] pids = (String[])references[i].getProperty("cm.target");
            if (pids != null) {
                String pid = (String)properties.get("service.pid");
                if (!Arrays.asList(pids).contains(pid)) continue;
            }
            if ((plugin = (ConfigurationPlugin)this.pluginTracker.getService(references[i])) == null) continue;
            plugin.modifyConfiguration(managedReference, properties);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PluginManager.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class PluginTracker
    extends ServiceTracker<ConfigurationPlugin, ConfigurationPlugin> {
        final Integer ZERO = 0;
        private final TreeSet<ServiceReference<ConfigurationPlugin>> serviceReferences = new TreeSet(new Comparator<ServiceReference<?>>(){
            static final long serialVersionUID = -4231597367838676265L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(ServiceReference<?> o1, ServiceReference<?> o2) {
                return this.getRank(o1).compareTo(this.getRank(o2));
            }

            private Integer getRank(ServiceReference<?> ref) {
                Object ranking = ref.getProperty("service.cmRanking");
                if (ranking == null || !(ranking instanceof Integer)) {
                    return PluginTracker.this.ZERO;
                }
                return (Integer)ranking;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        static final long serialVersionUID = -7376493731690248385L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PluginTracker(BundleContext context) {
            super(context, ConfigurationPlugin.class.getName(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceReference<ConfigurationPlugin>[] getServiceReferences() {
            TreeSet<ServiceReference<ConfigurationPlugin>> treeSet = this.serviceReferences;
            synchronized (treeSet) {
                ServiceReference[] result = new ServiceReference[]{};
                return this.serviceReferences.toArray(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConfigurationPlugin addingService(ServiceReference<ConfigurationPlugin> reference) {
            TreeSet<ServiceReference<ConfigurationPlugin>> treeSet = this.serviceReferences;
            synchronized (treeSet) {
                this.serviceReferences.add(reference);
            }
            return (ConfigurationPlugin)this.context.getService(reference);
        }

        public void modifiedService(ServiceReference<ConfigurationPlugin> reference, ConfigurationPlugin service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ConfigurationPlugin> reference, ConfigurationPlugin service) {
            TreeSet<ServiceReference<ConfigurationPlugin>> treeSet = this.serviceReferences;
            synchronized (treeSet) {
                this.serviceReferences.remove(reference);
            }
            this.context.ungetService(reference);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PluginTracker.class);
        }
    }
}

