/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ErrorHandler;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinitionImpl;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinitionImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class MetaTypeRegistry {
    private static final TraceComponent tc = Tr.register(MetaTypeRegistry.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    public static final String MTP_REMOVED_TOPIC = "internal_mtp_removed";
    public static final String MTP_ADDED_TOPIC = "internal_mtp_added";
    public static final String UPDATED_PIDS = "internal_mtp_updated_pids";
    public static final String BUNDLE = "internal_mtp_bundle";
    public static final String MTP_INFO = "internal_mtp_info";
    private final Map<String, RegistryEntry> entryMap = new ConcurrentHashMap<String, RegistryEntry>();
    private final Map<String, RegistryEntry> aliasMap = new ConcurrentHashMap<String, RegistryEntry>();
    private final Map<String, Collection<RegistryEntry>> invalidEntryMap = new ConcurrentHashMap<String, Collection<RegistryEntry>>();
    private final Map<String, Map<String, RegistryEntry>> childAliasMap = new ConcurrentHashMap<String, Map<String, RegistryEntry>>();
    private final Map<String, Map<String, RegistryEntry>> childPidMap = new ConcurrentHashMap<String, Map<String, RegistryEntry>>();
    private final Map<String, List<RegistryEntry>> serviceToObjectClassMap = new ConcurrentHashMap<String, List<RegistryEntry>>();
    private final Map<String, List<RegistryEntry>> serviceToServicesMap = new ConcurrentHashMap<String, List<RegistryEntry>>();
    private final ConcurrentHashMap<Bundle, MetaTypeInformation> bundleMap = new ConcurrentHashMap();
    private ServiceTracker<MetaTypeService, MetaTypeService> metaTypeTracker = null;
    private ServiceTracker<MetaTypeProvider, MetaTypeProvider> mtpTracker = null;
    static final long serialVersionUID = -7127920695312189277L;

    MetaTypeRegistry() {
    }

    void start(BundleContext bc) {
        this.metaTypeTracker = new ServiceTracker(bc, MetaTypeService.class.getName(), null);
        this.metaTypeTracker.open();
        this.mtpTracker = new MTPTracker(bc, this);
        this.mtpTracker.open();
    }

    void stop(BundleContext context) {
        if (null != this.metaTypeTracker) {
            this.metaTypeTracker.close();
            this.metaTypeTracker = null;
        }
        if (null != this.mtpTracker) {
            this.mtpTracker.close();
            this.mtpTracker = null;
        }
    }

    Set<RegistryEntry> addMetaType(Bundle bundle) {
        MetaTypeInformation metaTypeInformation;
        MetaTypeService metaTypeService = (MetaTypeService)this.metaTypeTracker.getService();
        if (metaTypeService != null && (metaTypeInformation = metaTypeService.getMetaTypeInformation(bundle)) != null) {
            return this.addMetaType(metaTypeInformation);
        }
        return Collections.emptySet();
    }

    RegistryEntry getRegistryEntry(String pid) {
        if (pid == null) {
            return null;
        }
        return this.entryMap.get(pid);
    }

    RegistryEntry getRegistryEntryByAlias(String pid) {
        return this.aliasMap.get(pid);
    }

    RegistryEntry getRegistryEntryByPidOrAlias(String id) {
        if (id == null) {
            return null;
        }
        RegistryEntry re = this.entryMap.get(id);
        if (re == null) {
            re = this.aliasMap.get(id);
        }
        return re;
    }

    Collection<String> getRegistryEntryPids() {
        return this.entryMap.keySet();
    }

    Collection<RegistryEntry> getAllRegistryEntries() {
        return this.entryMap.values();
    }

    MetaTypeInformation getMetaTypeInformation(Bundle bundle) {
        return this.bundleMap.get(bundle);
    }

    synchronized Set<RegistryEntry> addMetaType(MetaTypeInformation information) {
        MetaTypeInformation existingInfo;
        HashSet<RegistryEntry> updatedRegistryEntries = new HashSet<RegistryEntry>();
        boolean newEntries = this.addMetaTypeDefinition(information, information.getPids(), false, updatedRegistryEntries);
        if ((newEntries |= this.addMetaTypeDefinition(information, information.getFactoryPids(), true, updatedRegistryEntries)) && (existingInfo = this.bundleMap.putIfAbsent(information.getBundle(), information)) != null && existingInfo != information) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"addMetaType: bundleMap.putIfAbsent", (Object[])new Object[]{information, existingInfo});
            }
            throw new IllegalStateException("addMetaType");
        }
        return updatedRegistryEntries;
    }

    ExtendedMetaTypeInformation getExtendedMetaTypeInformation(Bundle bundle) {
        ExtendedMetaTypeInformation newInformation;
        MetaTypeInformation information = this.bundleMap.get(bundle);
        if (information == null && (information = this.bundleMap.putIfAbsent(bundle, newInformation = new ExtendedMetaTypeInformation(bundle))) == null) {
            information = newInformation;
        }
        if (!(information instanceof ExtendedMetaTypeInformation)) {
            return null;
        }
        return (ExtendedMetaTypeInformation)information;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMetaTypeDefinition(MetaTypeInformation info, String pid, boolean isFactory, Set<RegistryEntry> updatedRegistryEntries) {
        RegistryEntry pidEntry = this.entryMap.get(pid);
        if (pidEntry == null) {
            ExtendedObjectClassDefinitionImpl ocd = ExtendedObjectClassDefinitionImpl.newExtendedObjectClassDefinition(info.getObjectClassDefinition(pid, null), info.getBundle().getLocation());
            ocd.setPid(pid);
            boolean invalid = false;
            if (isFactory) {
                if (ocd.getExtends() == null && ocd.getExtendsAlias() != null) {
                    Tr.error((TraceComponent)tc, (String)"error.ExtendsAliasMustExtend", (Object[])new Object[]{pid, ocd.getExtendsAlias()});
                    invalid = true;
                }
            } else {
                if (ocd.getExtends() != null) {
                    Tr.error((TraceComponent)tc, (String)"error.factoryOnly", (Object[])new Object[]{pid, ocd.getExtends()});
                    invalid = true;
                }
                if (ocd.getExtendsAlias() != null) {
                    Tr.error((TraceComponent)tc, (String)"error.factoryOnly.extendsAlias", (Object[])new Object[]{pid, ocd.getExtendsAlias()});
                    invalid = true;
                }
            }
            if (ocd.getParentPID() != null && ocd.getChildAlias() == null) {
                Tr.error((TraceComponent)tc, (String)"error.parentpid.and.childalias", (Object[])new Object[]{pid, "ibm:parentPid", ocd.getParentPID(), "ibm:childAlias"});
            } else if (ocd.getParentPID() == null && ocd.getChildAlias() != null) {
                Tr.error((TraceComponent)tc, (String)"error.parentpid.and.childalias", (Object[])new Object[]{pid, "ibm:childAlias", ocd.getChildAlias(), "ibm:parentPid"});
            }
            if (invalid) {
                return true;
            }
            pidEntry = new RegistryEntry(pid, isFactory, info.getBundle(), ocd, this);
            Map<String, Collection<RegistryEntry>> map = this.invalidEntryMap;
            synchronized (map) {
                if (pidEntry.isValid()) {
                    updatedRegistryEntries.add(pidEntry);
                    this.addValidRegistryEntry(pidEntry, updatedRegistryEntries);
                } else {
                    String extendsPid = pidEntry.getExtends();
                    if (extendsPid == null) {
                        throw new IllegalStateException("invalid RegistryEntry that does not extend " + pid);
                    }
                    Collection<RegistryEntry> invalids = this.invalidEntryMap.get(extendsPid);
                    if (invalids == null) {
                        invalids = new ArrayList<RegistryEntry>();
                        this.invalidEntryMap.put(extendsPid, invalids);
                    }
                    invalids.add(pidEntry);
                }
            }
            return true;
        }
        if (info.getBundle().getBundleId() != pidEntry.getBundleId()) {
            this.warnCollision(pid, null, pidEntry, info.getBundle().getBundleId(), info.getObjectClassDefinition(pid, null).getID());
        }
        return false;
    }

    private void addValidRegistryEntry(RegistryEntry pidEntry, Set<RegistryEntry> updatedRegistryEntries) {
        List<String> objectClass;
        String childAlias;
        updatedRegistryEntries.add(pidEntry);
        this.entryMap.put(pidEntry.getPid(), pidEntry);
        Collection<RegistryEntry> invalids = this.invalidEntryMap.remove(pidEntry.getPid());
        if (invalids != null) {
            for (RegistryEntry invalid : invalids) {
                invalid.complete(pidEntry, this);
                if (!invalid.isValid()) continue;
                this.addValidRegistryEntry(invalid, updatedRegistryEntries);
            }
        }
        this.processReferencedTypes(pidEntry);
        String alias = pidEntry.getAlias();
        if (alias != null) {
            RegistryEntry aliasEntry = this.aliasMap.get(alias);
            if (aliasEntry == null) {
                this.aliasMap.put(alias, pidEntry);
            } else if (pidEntry != aliasEntry) {
                this.warnCollision(pidEntry.getPid(), alias, pidEntry, aliasEntry.getBundleId(), aliasEntry.getObjectClassDefinition().getID());
            }
        }
        if ((childAlias = pidEntry.getChildAlias()) != null) {
            String parentPid;
            Map<String, RegistryEntry> parentMap = this.childAliasMap.get(childAlias);
            if (parentMap == null) {
                parentMap = new HashMap<String, RegistryEntry>();
                this.childAliasMap.put(childAlias, parentMap);
            }
            if ((parentPid = pidEntry.getObjectClassDefinition().getParentPID()) == null) {
                Tr.error((TraceComponent)tc, (String)"error.specify.parentpid", (Object[])new Object[]{pidEntry.getPid()});
            } else {
                RegistryEntry parentEntry = parentMap.get(parentPid);
                if (parentEntry == null) {
                    parentMap.put(parentPid, pidEntry);
                    this.childPidMap.put(pidEntry.getPid(), parentMap);
                } else {
                    this.warnCollision(pidEntry.getPid(), childAlias, pidEntry, parentEntry.getBundleId(), parentEntry.getObjectClassDefinition().getID());
                }
            }
        }
        if ((objectClass = pidEntry.getObjectClassDefinition().getObjectClass()) != null) {
            for (String service : objectClass) {
                List<RegistryEntry> exposers = this.serviceToObjectClassMap.get(service);
                if (exposers == null) {
                    exposers = new CopyOnWriteArrayList<RegistryEntry>();
                    this.serviceToObjectClassMap.put(service, exposers);
                }
                exposers.add(pidEntry);
            }
        }
    }

    private boolean addMetaTypeDefinition(MetaTypeInformation information, String[] pids, boolean isFactory, Set<RegistryEntry> updatedRegistryEntries) {
        boolean newEntries = false;
        if (pids != null) {
            for (String pid : pids) {
                if (pid == null) continue;
                newEntries |= this.addMetaTypeDefinition(information, pid, isFactory, updatedRegistryEntries);
            }
        }
        return newEntries;
    }

    private void processReferencedTypes(RegistryEntry pidEntry) {
        RegistryEntry other;
        for (ExtendedAttributeDefinition ad : pidEntry.getAttributeMap().values()) {
            if (ad.getType() != 1001) continue;
            if (ad.getReferencePid() != null) {
                RegistryEntry other2 = this.getRegistryEntry(ad.getReferencePid());
                if (other2 == null) continue;
                PidReference ref = new PidReference(other2, pidEntry, ad.getID(), true);
                other2.addReferencingEntry(ref);
                pidEntry.addReferencedEntry(ref);
                continue;
            }
            if (ad.getService() == null) continue;
            this.addServiceUse(ad.getService(), pidEntry);
        }
        if (pidEntry.getObjectClassDefinition().getParentPID() != null && (other = this.getRegistryEntry(pidEntry.getObjectClassDefinition().getParentPID())) != null) {
            pidEntry.addReferencingEntry(new PidReference(pidEntry, other, pidEntry.getChildAlias(), false));
        }
        for (RegistryEntry other3 : this.entryMap.values()) {
            if (pidEntry.getPid().equals(other3.getObjectClassDefinition().getParentPID())) {
                other3.addReferencingEntry(new PidReference(other3, pidEntry, other3.getChildAlias(), false));
            }
            for (ExtendedAttributeDefinition ad : other3.getAttributeMap().values()) {
                if (ad.getType() != 1001 || !pidEntry.getPid().equals(ad.getReferencePid())) continue;
                pidEntry.addReferencingEntry(new PidReference(pidEntry, other3, ad.getID(), true));
            }
        }
    }

    private void addServiceUse(String service, RegistryEntry entry) {
        List<RegistryEntry> serviceUsers = this.serviceToServicesMap.get(service);
        if (serviceUsers == null) {
            serviceUsers = new CopyOnWriteArrayList<RegistryEntry>();
            this.serviceToServicesMap.put(service, serviceUsers);
        }
        serviceUsers.add(entry);
    }

    private void removeServiceUse(String service, RegistryEntry entry) {
        List<RegistryEntry> serviceUsers = this.serviceToServicesMap.get(service);
        if (serviceUsers != null) {
            serviceUsers.remove(entry);
        }
    }

    List<RegistryEntry> getEntriesExposingService(String service) {
        return this.serviceToObjectClassMap.get(service);
    }

    List<RegistryEntry> getEntriesUsingService(RegistryEntry entry) {
        List<String> objectClass = entry.getObjectClassDefinition().getObjectClass();
        if (objectClass != null) {
            ArrayList<RegistryEntry> references = new ArrayList<RegistryEntry>();
            for (String service : objectClass) {
                List<RegistryEntry> users = this.serviceToServicesMap.get(service);
                if (users == null) continue;
                references.addAll(users);
            }
            return references;
        }
        return Collections.emptyList();
    }

    public Collection<RegistryEntry> getReferencedEntries(ExtendedAttributeDefinition attrDef) {
        if (attrDef == null) {
            throw new NullPointerException("attrDef");
        }
        if (attrDef.getType() != 1001) {
            throw new IllegalArgumentException("Must be pid type, not " + attrDef.getType());
        }
        if (attrDef.getReferencePid() != null) {
            RegistryEntry entry = this.getRegistryEntry(attrDef.getReferencePid());
            if (entry == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(entry);
        }
        return this.serviceToObjectClassMap.get(attrDef.getService());
    }

    private void warnCollision(String pid, String alias, RegistryEntry entry1, long bundleId2, String ocdId2) {
        Object pidAlias = pid;
        if (alias != null) {
            pidAlias = Arrays.asList(pid, alias);
        }
        List<String> ids = Arrays.asList(entry1.getBundleId() + ":" + entry1.getObjectClassDefinition().getID(), bundleId2 + ":" + ocdId2);
        Tr.error((TraceComponent)tc, (String)"error.alias.collision", (Object[])new Object[]{pidAlias, ids});
    }

    MetaTypeInformation removeMetaType(Bundle bundle) {
        MetaTypeInformation information = this.bundleMap.remove(bundle);
        if (information != null) {
            Set<RegistryEntry> removed = this.removeMetaTypeDefinitions(information, information.getPids());
            removed.addAll(this.removeMetaTypeDefinitions(information, information.getFactoryPids()));
            for (RegistryEntry entry : removed) {
                for (PidReference ref : entry.getReferencedEntries()) {
                    RegistryEntry other = ref.getReferencedEntry();
                    if (other == null) continue;
                    other.removeReferencingEntry(ref);
                }
                entry.removeAllReferences();
            }
        }
        return information;
    }

    synchronized Set<RegistryEntry> removeMetaTypeDefinitions(MetaTypeInformation information, String[] pids) {
        HashSet<RegistryEntry> removedRegistryEntries = new HashSet<RegistryEntry>();
        if (pids != null) {
            for (String pid : pids) {
                RegistryEntry aliasEntry;
                RegistryEntry pidEntry = this.entryMap.remove(pid);
                if (pidEntry == null) {
                    block1: for (Map.Entry<String, Collection<RegistryEntry>> entry : this.invalidEntryMap.entrySet()) {
                        for (RegistryEntry test : entry.getValue()) {
                            if (!test.getPid().equals(pid)) continue;
                            pidEntry = test;
                            entry.getValue().remove(test);
                            if (!entry.getValue().isEmpty()) continue block1;
                            this.invalidEntryMap.remove(entry.getKey());
                            continue block1;
                        }
                    }
                }
                if (pidEntry == null) continue;
                removedRegistryEntries.add(pidEntry);
                if (pidEntry.getAlias() != null && (aliasEntry = this.aliasMap.get(pidEntry.getAlias())) == pidEntry) {
                    this.aliasMap.remove(pidEntry.getAlias());
                }
                if (pidEntry.getChildAlias() != null) {
                    Map<String, RegistryEntry> parentMap = this.childAliasMap.get(pidEntry.getChildAlias());
                    String parentPid = pidEntry.getObjectClassDefinition().getParentPID();
                    if (parentPid != null) {
                        parentMap.remove(parentPid);
                    }
                    this.childPidMap.remove(pidEntry.getPid());
                }
                if (pidEntry.getObjectClassDefinition().getObjectClass() != null) {
                    for (String service : pidEntry.getObjectClassDefinition().getObjectClass()) {
                        List<RegistryEntry> exposers = this.serviceToObjectClassMap.get(service);
                        if (exposers == null) continue;
                        exposers.remove(pidEntry);
                        if (!exposers.isEmpty()) continue;
                        this.serviceToObjectClassMap.remove(service);
                    }
                }
                for (ExtendedAttributeDefinition ad : pidEntry.getObjectClassDefinition().getAttributeMap().values()) {
                    List<RegistryEntry> uses;
                    if (ad.getService() == null || (uses = this.serviceToServicesMap.get(ad.getService())) == null) continue;
                    uses.remove(pidEntry);
                    if (!uses.isEmpty()) continue;
                    this.serviceToServicesMap.remove(ad.getService());
                }
                pidEntry.unextend(this);
                this.invalidEntryMap.remove(pid);
            }
        }
        return removedRegistryEntries;
    }

    RegistryEntry getRegistryEntry(RegistryEntry parentEntry, String childNodeName) {
        Map<String, RegistryEntry> parentMap = this.childAliasMap.get(childNodeName);
        if (parentMap == null) {
            parentMap = this.childPidMap.get(childNodeName);
        }
        if (parentMap == null) {
            return null;
        }
        while (parentEntry != null) {
            RegistryEntry childEntry = parentMap.get(parentEntry.getPid());
            if (childEntry != null) {
                return childEntry;
            }
            parentEntry = this.getRegistryEntry(parentEntry.getExtends());
        }
        return null;
    }

    RegistryEntry getRegistryEntry(ConfigElement element) {
        if (element.getParent() == null || element.childAttributeName == null) {
            return this.getRegistryEntryByPidOrAlias(element.getNodeName());
        }
        Map<String, RegistryEntry> parentMap = this.childAliasMap.get(element.childAttributeName);
        if (parentMap == null) {
            return null;
        }
        return parentMap.get(element.getParent().getNodeName());
    }

    Map<String, ExtendedAttributeDefinition> getHierarchyCompleteAttributeMap(String factoryPid) {
        RegistryEntry entry = this.getRegistryEntry(factoryPid);
        if (entry != null) {
            return entry.getAttributeMap();
        }
        return null;
    }

    String getAttributeName(String pid, String attributeID) {
        Map<String, ExtendedAttributeDefinition> attributeMap;
        RegistryEntry ent = this.getRegistryEntryByPidOrAlias(pid);
        if (ent != null && (attributeMap = ent.getAttributeMap()) != null && attributeMap.containsKey(attributeID)) {
            return attributeMap.get(attributeID).getName();
        }
        return null;
    }

    String getElementName(String pid) {
        ExtendedObjectClassDefinition ocd;
        RegistryEntry ent = this.getRegistryEntryByPidOrAlias(pid);
        if (ent != null && (ocd = ent.getObjectClassDefinition()) != null) {
            return ocd.getName();
        }
        return null;
    }

    List<AttributeDefinition> getRequiredAttributesForHierarchy(String factoryPid) {
        RegistryEntry entry = this.getRegistryEntry(factoryPid);
        if (entry != null) {
            ArrayList<AttributeDefinition> ads = new ArrayList<AttributeDefinition>();
            Map<String, ExtendedAttributeDefinition> attributeMap = entry.getAttributeMap();
            for (String name : entry.getRequiredAttributeNames()) {
                ads.add(attributeMap.get(name));
            }
            return ads;
        }
        return null;
    }

    RegistryEntry getRegistryEntry(String parentPid, String childNodeName) {
        Map<String, RegistryEntry> parentMap = this.childAliasMap.get(childNodeName);
        if (parentMap == null) {
            return null;
        }
        return parentMap.get(parentPid);
    }

    void missingPid(String pid) throws ConfigUpdateException {
        block0: for (Collection<RegistryEntry> entries : this.invalidEntryMap.values()) {
            for (RegistryEntry entry : entries) {
                if (!entry.getPid().equals(pid)) continue;
                String superPid = entry.getExtends();
                if (this.getRegistryEntry(superPid) != null) continue block0;
                Tr.error((TraceComponent)tc, (String)"error.missingSuper", (Object[])new Object[]{pid, superPid});
                if (!ErrorHandler.INSTANCE.fail()) continue block0;
                throw new ConfigUpdateException(Tr.formatMessage((TraceComponent)tc, (String)"error.missingSuper", (Object[])new Object[]{pid, superPid}));
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class MTPTracker
    extends ServiceTracker<MetaTypeProvider, MetaTypeProvider> {
        private final MetaTypeRegistry registry;
        private ServiceTracker<EventAdmin, EventAdmin> eventTracker = null;
        static final long serialVersionUID = -6180965171787297116L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MTPTracker(BundleContext bc, MetaTypeRegistry registry) {
            super(bc, MetaTypeProvider.class.getName(), null);
            this.registry = registry;
            this.eventTracker = new ServiceTracker(bc, EventAdmin.class.getName(), null);
            this.eventTracker.open();
        }

        public void close() {
            if (null != this.eventTracker) {
                this.eventTracker.close();
                this.eventTracker = null;
            }
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetaTypeProvider addingService(ServiceReference<MetaTypeProvider> reference) {
            Bundle bundle;
            MetaTypeProvider provider = (MetaTypeProvider)super.addingService(reference);
            if (FrameworkState.isStopping()) {
                return provider;
            }
            Bundle bundle2 = bundle = reference.getBundle();
            synchronized (bundle2) {
                Set<RegistryEntry> updatedRegistryEntries;
                ExtendedMetaTypeInformation information = this.registry.getExtendedMetaTypeInformation(bundle);
                if (information == null) {
                    return provider;
                }
                ExtendedMetaTypeInformation wrapper = information;
                wrapper.addMetaTypeProvider(provider, this.getPids(reference, "metatype.pid"), false);
                wrapper.addMetaTypeProvider(provider, this.getPids(reference, "metatype.factory.pid"), true);
                if (provider instanceof ManagedService) {
                    wrapper.addMetaTypeProvider(provider, this.getPids(reference, "service.pid"), false);
                }
                if (provider instanceof ManagedServiceFactory) {
                    wrapper.addMetaTypeProvider(provider, this.getPids(reference, "service.pid"), true);
                }
                if (!(updatedRegistryEntries = this.registry.addMetaType(information)).isEmpty()) {
                    EventAdmin eventAdmin = (EventAdmin)this.eventTracker.getService();
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put(MetaTypeRegistry.BUNDLE, bundle);
                    properties.put(MetaTypeRegistry.UPDATED_PIDS, updatedRegistryEntries);
                    Event event = new Event(MetaTypeRegistry.MTP_ADDED_TOPIC, properties);
                    eventAdmin.postEvent(event);
                }
            }
            return provider;
        }

        public void modifiedService(ServiceReference<MetaTypeProvider> reference, MetaTypeProvider service) {
            super.modifiedService(reference, (Object)service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<MetaTypeProvider> reference, MetaTypeProvider service) {
            Bundle bundle;
            if (FrameworkState.isStopping()) {
                return;
            }
            Bundle bundle2 = bundle = reference.getBundle();
            synchronized (bundle2) {
                MetaTypeInformation information = this.registry.getMetaTypeInformation(bundle);
                if (information == null || !(information instanceof ExtendedMetaTypeInformation)) {
                    return;
                }
                ExtendedMetaTypeInformation wrapper = (ExtendedMetaTypeInformation)information;
                String pid = (String)reference.getProperty("service.pid");
                PIDCollection removedPids = wrapper.removeMetaTypeProvider(service);
                if (service instanceof ManagedService) {
                    wrapper.removePid(pid, false);
                }
                if (service instanceof ManagedServiceFactory) {
                    wrapper.removePid(pid, true);
                }
                Collection pids = removedPids.getPids();
                Collection factoryPids = removedPids.getFactoryPids();
                Set<RegistryEntry> updatedPids = this.registry.removeMetaTypeDefinitions(information, pids.toArray(new String[pids.size()]));
                updatedPids.addAll(this.registry.removeMetaTypeDefinitions(information, factoryPids.toArray(new String[factoryPids.size()])));
                EventAdmin eventAdmin = (EventAdmin)this.eventTracker.getService();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put(MetaTypeRegistry.MTP_INFO, information);
                properties.put(MetaTypeRegistry.UPDATED_PIDS, updatedPids);
                Event event = new Event(MetaTypeRegistry.MTP_REMOVED_TOPIC, properties);
                eventAdmin.postEvent(event);
            }
            super.removedService(reference, (Object)service);
        }

        private Collection<String> getPids(ServiceReference<MetaTypeProvider> ref, String pid) {
            Object property = ref.getProperty(pid);
            if (property == null) {
                return Collections.emptyList();
            }
            if (property instanceof String) {
                return Collections.singletonList((String)property);
            }
            if (property instanceof String[]) {
                ArrayList<String> retVal = new ArrayList<String>();
                for (String value : (String[])property) {
                    retVal.add(value);
                }
                return retVal;
            }
            if (property instanceof Collection) {
                return (Collection)property;
            }
            return Collections.emptyList();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MTPTracker.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class PIDCollection {
        private Collection<String> factoryPids;
        private Collection<String> pids;
        static final long serialVersionUID = -3333229236362522739L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PIDCollection() {
        }

        private Collection<String> getFactoryPids() {
            return this.factoryPids;
        }

        private void setPids(Collection<String> providerPids) {
            this.pids = providerPids;
        }

        private void setFactoryPids(Collection<String> providerPids) {
            this.factoryPids = providerPids;
        }

        private Collection<String> getPids() {
            return this.pids;
        }

        private Collection<String> getAllPids() {
            ArrayList<String> allPids = new ArrayList<String>();
            if (this.factoryPids != null) {
                allPids.addAll(this.factoryPids);
            }
            if (this.pids != null) {
                allPids.addAll(this.pids);
            }
            return allPids;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String pid : this.getAllPids()) {
                sb.append(pid);
                sb.append(",");
            }
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PIDCollection.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class ExtendedMetaTypeInformation
    implements MetaTypeInformation {
        private final Map<String, MetaTypeProvider> pidToProviders = new HashMap<String, MetaTypeProvider>();
        private final Map<MetaTypeProvider, PIDCollection> providerToPids = new HashMap<MetaTypeProvider, PIDCollection>();
        private final Bundle bundle;
        private final List<String> pids = new ArrayList<String>();
        private final List<String> factoryPids = new ArrayList<String>();
        private final ReentrantLock lock = new ReentrantLock();
        static final long serialVersionUID = 3848948025968966008L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ExtendedMetaTypeInformation(Bundle bundle) {
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getLocales() {
            this.lock.lock();
            try {
                ArrayList<String> locales = new ArrayList<String>();
                for (MetaTypeProvider provider : this.getMetaTypeProviders()) {
                    if (provider.getLocales() == null) continue;
                    for (String locale : provider.getLocales()) {
                        if (locales.contains(locale)) continue;
                        locales.add(locale);
                    }
                }
                String[] stringArray = locales.toArray(new String[locales.size()]);
                return stringArray;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<MetaTypeProvider> getMetaTypeProviders() {
            this.lock.lock();
            try {
                HashSet<MetaTypeProvider> retVal = new HashSet<MetaTypeProvider>();
                for (Map.Entry<String, MetaTypeProvider> entry : this.pidToProviders.entrySet()) {
                    retVal.add(entry.getValue());
                }
                HashSet<MetaTypeProvider> hashSet = retVal;
                return hashSet;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectClassDefinition getObjectClassDefinition(String pid, String arg1) {
            this.lock.lock();
            try {
                Bundle bundle = this.bundle;
                synchronized (bundle) {
                    MetaTypeProvider provider = this.pidToProviders.get(pid);
                    ObjectClassDefinition objectClassDefinition = provider == null ? null : provider.getObjectClassDefinition(pid, arg1);
                    return objectClassDefinition;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public Bundle getBundle() {
            this.lock.lock();
            try {
                Bundle bundle = this.bundle;
                return bundle;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getFactoryPids() {
            this.lock.lock();
            try {
                Bundle bundle = this.bundle;
                synchronized (bundle) {
                    String[] stringArray = this.factoryPids.toArray(new String[this.factoryPids.size()]);
                    return stringArray;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getPids() {
            this.lock.lock();
            try {
                Bundle bundle = this.bundle;
                synchronized (bundle) {
                    String[] stringArray = this.pids.toArray(new String[this.pids.size()]);
                    return stringArray;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMetaTypeProvider(MetaTypeProvider provider, Collection<String> providerPids, boolean isFactory) {
            this.lock.lock();
            try {
                PIDCollection pidCollection = this.providerToPids.get(provider);
                if (pidCollection == null) {
                    pidCollection = new PIDCollection();
                    this.providerToPids.put(provider, pidCollection);
                }
                if (isFactory) {
                    pidCollection.setFactoryPids(providerPids);
                    this.factoryPids.addAll(providerPids);
                } else {
                    pidCollection.setPids(providerPids);
                    this.pids.addAll(providerPids);
                }
                for (String pid : providerPids) {
                    this.pidToProviders.put(pid, provider);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PIDCollection removeMetaTypeProvider(MetaTypeProvider provider) {
            this.lock.lock();
            try {
                PIDCollection pidCollection = this.providerToPids.remove(provider);
                for (String pid : pidCollection.getFactoryPids()) {
                    this.factoryPids.remove(pid);
                    this.pidToProviders.remove(pid);
                }
                for (String pid : pidCollection.getPids()) {
                    this.pids.remove(pid);
                    this.pidToProviders.remove(pid);
                }
                PIDCollection pIDCollection = pidCollection;
                return pIDCollection;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void removePid(String pid, boolean isFactory) {
            this.lock.lock();
            try {
                if (isFactory) {
                    this.factoryPids.remove(pid);
                } else {
                    this.pids.remove(pid);
                }
                this.pidToProviders.remove(pid);
            }
            finally {
                this.lock.unlock();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ExtendedMetaTypeInformation.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class RegistryEntry {
        private final String pid;
        private String rootPid;
        private final boolean factory;
        private final ExtendedObjectClassDefinition ocd;
        private final long bundleId;
        private final String bundleName;
        private boolean valid;
        private final Map<String, ExtendedAttributeDefinition> effectiveAttributes = new LinkedHashMap<String, ExtendedAttributeDefinition>();
        private final Set<String> requiredAttributeNames = new HashSet<String>();
        private List<RegistryEntry> extenders;
        private List<PidReference> referencingPids;
        private List<PidReference> referencedPids;
        private RegistryEntry extendedRegistryEntry;
        static final long serialVersionUID = 8337314792633918935L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RegistryEntry(String pid, boolean isFactory, Bundle bundle, ExtendedObjectClassDefinition ocd, MetaTypeRegistry metatypeRegistry) {
            if (pid == null) {
                throw new NullPointerException("pid");
            }
            if (bundle == null) {
                throw new NullPointerException("bundle");
            }
            if (ocd == null) {
                throw new NullPointerException("ocd");
            }
            this.bundleId = bundle.getBundleId();
            this.bundleName = bundle.getSymbolicName();
            this.pid = pid;
            this.factory = isFactory;
            this.ocd = ocd;
            if (this.ocd.getExtends() != null) {
                RegistryEntry extendedEntry = metatypeRegistry.getRegistryEntry(this.ocd.getExtends());
                if (extendedEntry != null) {
                    this.complete(extendedEntry, metatypeRegistry);
                }
            } else {
                this.valid = true;
                this.rootPid = pid;
                this.computeEffectiveAttributes(this.ocd, this.effectiveAttributes, this.requiredAttributeNames, metatypeRegistry);
            }
        }

        public void complete(RegistryEntry extendedEntry, MetaTypeRegistry metatypeRegistry) {
            if (!extendedEntry.isFactory()) {
                Tr.error((TraceComponent)tc, (String)"error.superFactoryOnly", (Object[])new Object[]{extendedEntry.getPid(), this.getPid()});
                return;
            }
            this.rootPid = extendedEntry.getRootPid();
            this.extendedRegistryEntry = extendedEntry;
            this.effectiveAttributes.putAll(extendedEntry.effectiveAttributes);
            this.requiredAttributeNames.addAll(extendedEntry.requiredAttributeNames);
            this.valid = this.computeEffectiveAttributes(this.ocd, this.effectiveAttributes, this.requiredAttributeNames, metatypeRegistry);
            if (this.valid) {
                this.valid = extendedEntry.addExtender(this, metatypeRegistry);
            }
        }

        private boolean addExtender(RegistryEntry extender, MetaTypeRegistry metatypeRegistry) {
            if (this.top().check(extender)) {
                if (this.extenders == null) {
                    this.extenders = new ArrayList<RegistryEntry>();
                }
                this.extenders.add(extender);
                return true;
            }
            return false;
        }

        private RegistryEntry top() {
            if (this.extendedRegistryEntry == null) {
                return this;
            }
            return this.extendedRegistryEntry.top();
        }

        private boolean check(RegistryEntry extender) {
            if (extender.getExtendsAlias() == null) {
                return true;
            }
            if (extender.getExtendsAlias().equals(this.getExtendsAlias())) {
                Tr.error((TraceComponent)tc, (String)"error.extendsAlias.collision", (Object[])new Object[]{extender.getPid(), this.getPid(), this.getExtendsAlias()});
                return false;
            }
            if (this.extenders != null) {
                for (RegistryEntry existing : this.extenders) {
                    if (existing.check(extender)) continue;
                    return false;
                }
            }
            return true;
        }

        private void unextend(final MetaTypeRegistry metatypeRegistry) {
            RegistryEntry extended;
            String extendsPid = this.getExtends();
            if (extendsPid != null && (extended = metatypeRegistry.getRegistryEntry(extendsPid)) != null) {
                extended.removeExtender(metatypeRegistry, this);
            }
            this.traverseHierarchyWithRoot(new EntryAction<Void>(){
                static final long serialVersionUID = -4302582588174459544L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public boolean entry(RegistryEntry registryEntry) {
                    registryEntry.effectiveAttributes.clear();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"List of effective attributes cleared for {0}", (Object[])new Object[]{registryEntry});
                    }
                    if (registryEntry.extenders != null) {
                        if (!metatypeRegistry.invalidEntryMap.containsKey(registryEntry.getPid())) {
                            metatypeRegistry.invalidEntryMap.put(registryEntry.getPid(), registryEntry.extenders);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Setting extenders to null for registry entry {0}", (Object[])new Object[]{registryEntry});
                        }
                        registryEntry.extenders = null;
                    }
                    return true;
                }

                @Override
                public Void getResult() {
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }

        private void removeExtender(MetaTypeRegistry metatypeRegistry, RegistryEntry extender) {
            Collection<RegistryEntry> extendersToCleanup = this.extenders;
            if (this.extenders == null) {
                extendersToCleanup = (Collection)metatypeRegistry.invalidEntryMap.get(this.getPid());
            }
            extendersToCleanup.remove(extender);
            if (extendersToCleanup.isEmpty()) {
                if (this.extenders == null) {
                    metatypeRegistry.invalidEntryMap.remove(this.getPid());
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting extenders to null for extender {0}", (Object[])new Object[]{extender});
                    }
                    this.extenders = null;
                }
            }
        }

        private synchronized void addReferencingEntry(PidReference ref) {
            if (ref.getReferencingEntry() == this) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Circular RegistryEntry reference detected: ", (Object[])new Object[]{this});
                }
                return;
            }
            if (this.referencingPids == null) {
                this.referencingPids = new CopyOnWriteArrayList<PidReference>();
            }
            if (!this.referencingPids.contains(ref)) {
                this.referencingPids.add(ref);
            }
        }

        public void addReferencedEntry(PidReference ref) {
            if (this.referencedPids == null) {
                this.referencedPids = new CopyOnWriteArrayList<PidReference>();
            }
            if (!this.referencedPids.contains(ref)) {
                this.referencedPids.add(ref);
            }
        }

        private synchronized void removeReferencingEntry(PidReference ref) {
            if (this.referencingPids != null) {
                this.referencingPids.remove(ref);
            }
        }

        synchronized List<PidReference> getReferencingEntries() {
            if (this.referencingPids == null) {
                return Collections.emptyList();
            }
            return this.referencingPids;
        }

        synchronized List<PidReference> getReferencedEntries() {
            if (this.referencedPids == null) {
                return Collections.emptyList();
            }
            return this.referencedPids;
        }

        private synchronized void removeAllReferences() {
            if (this.referencedPids != null) {
                this.referencedPids.clear();
            }
            if (this.referencingPids != null) {
                this.referencingPids.clear();
            }
        }

        public <T> T traverseHierarchyPreOrder(EntryAction<T> action) {
            this.traverseHierarchy(action, false, true);
            return action.getResult();
        }

        public <T> T traverseHierarchyWithRootPreOrder(EntryAction<T> action) {
            this.traverseHierarchy(action, true, true);
            return action.getResult();
        }

        public <T> T traverseHierarchy(EntryAction<T> action) {
            this.traverseHierarchy(action, false, false);
            return action.getResult();
        }

        public <T> T traverseHierarchyWithRoot(EntryAction<T> action) {
            this.traverseHierarchy(action, true, false);
            return action.getResult();
        }

        private <T> boolean traverseHierarchy(EntryAction<T> action, boolean includeRoot, boolean pre) {
            if (pre && includeRoot && !action.entry(this)) {
                return false;
            }
            if (this.extenders != null) {
                for (RegistryEntry extender : this.extenders) {
                    if (extender.traverseHierarchy(action, true, pre)) continue;
                    return false;
                }
            }
            if (!pre && includeRoot) {
                return action.entry(this);
            }
            return true;
        }

        private boolean computeEffectiveAttributes(ExtendedObjectClassDefinition ocd, Map<String, ExtendedAttributeDefinition> map, Set<String> requiredAttributeNames, MetaTypeRegistry metatypeRegistry) {
            HashSet<String> alreadyRenamed = new HashSet<String>();
            boolean valid = this.processAttributes(ocd.getAttributeDefinitions(1), true, map, requiredAttributeNames, alreadyRenamed, metatypeRegistry);
            return valid &= this.processAttributes(ocd.getAttributeDefinitions(2), false, map, requiredAttributeNames, alreadyRenamed, metatypeRegistry);
        }

        private boolean processAttributes(AttributeDefinition[] attrDefs, boolean required, Map<String, ExtendedAttributeDefinition> map, Set<String> requiredAttributeNames, Set<String> alreadyRenamed, MetaTypeRegistry metatypeRegistry) {
            boolean valid = true;
            if (attrDefs != null) {
                for (AttributeDefinition attrDef : attrDefs) {
                    ExtendedAttributeDefinitionImpl extendedAttrDef = new ExtendedAttributeDefinitionImpl(attrDef);
                    String key = extendedAttrDef.getID();
                    String rename = extendedAttrDef.getRename();
                    ExtendedAttributeDefinition existing = null;
                    if (rename != null) {
                        existing = map.remove(rename);
                        if (existing == null) {
                            if (alreadyRenamed.contains(rename)) {
                                Tr.error((TraceComponent)tc, (String)"error.conflicting.rename.attribute", (Object[])new Object[]{extendedAttrDef.getID(), rename, this.ocd.getID()});
                            } else {
                                Tr.error((TraceComponent)tc, (String)"error.rename.attribute.missing", (Object[])new Object[]{this.ocd.getID(), rename, extendedAttrDef.getID()});
                            }
                            valid = false;
                            continue;
                        }
                        alreadyRenamed.add(rename);
                        requiredAttributeNames.remove(rename);
                    } else {
                        existing = map.get(extendedAttrDef.getID());
                    }
                    if (existing != null) {
                        if (existing.isFinal()) {
                            RegistryEntry re = this;
                            boolean found = false;
                            block1: while (!found) {
                                AttributeDefinition[] ads;
                                if (re.getExtends() == null) {
                                    throw new IllegalStateException("should not happen: " + re.toString());
                                }
                                re = metatypeRegistry.getRegistryEntry(re.getExtends());
                                for (AttributeDefinition ad : ads = re.getObjectClassDefinition().getAttributeDefinitions(-1)) {
                                    if (!ad.getID().equals(existing.getID())) continue;
                                    found = true;
                                    continue block1;
                                }
                            }
                            Tr.error((TraceComponent)tc, (String)"error.final.override", (Object[])new Object[]{extendedAttrDef.getID(), this.pid, re.getPid()});
                            valid = false;
                            continue;
                        }
                        requiredAttributeNames.remove(existing.getID());
                    }
                    map.put(key, extendedAttrDef);
                    if (!required) continue;
                    requiredAttributeNames.add(key);
                }
            }
            return valid;
        }

        public Map<String, ExtendedAttributeDefinition> getAttributeMap() {
            return this.effectiveAttributes;
        }

        public Collection<String> getRequiredAttributeNames() {
            return this.requiredAttributeNames;
        }

        public String getDefaultId() {
            ExtendedAttributeDefinition id = this.getAttributeMap().get("id");
            if (id != null) {
                String[] values = id.getDefaultValue();
                if (values == null) {
                    return null;
                }
                if (values.length > 1) {
                    throw new IllegalStateException("The id attribute can not have multiple values");
                }
                return values[0];
            }
            return null;
        }

        @Trivial
        public String getPid() {
            return this.pid;
        }

        public String getRootPid() {
            return this.rootPid;
        }

        public String getAlias() {
            return this.ocd.getAlias();
        }

        public String getChildAlias() {
            return this.ocd.getChildAlias();
        }

        public String getExtendsAlias() {
            return this.ocd.getExtendsAlias();
        }

        public String getEffectiveAD(String ad) {
            String extendsAlias = this.getExtendsAlias();
            if (extendsAlias == null) {
                return null;
            }
            if (extendsAlias.length() == 0) {
                return ad;
            }
            if (extendsAlias.startsWith("!")) {
                return extendsAlias.substring(1);
            }
            return MessageFormat.format("{0}.{1}", ad, extendsAlias);
        }

        public ExtendedObjectClassDefinition getObjectClassDefinition() {
            return this.ocd;
        }

        public boolean isFactory() {
            return this.factory;
        }

        public boolean isSingleton() {
            return !this.factory;
        }

        long getBundleId() {
            return this.bundleId;
        }

        String getBundleName() {
            return this.bundleName;
        }

        public String getExtends() {
            return this.ocd.getExtends();
        }

        public RegistryEntry getExtendedRegistryEntry() {
            return this.extendedRegistryEntry;
        }

        public boolean supportsExtensions() {
            return this.ocd.supportsExtensions() || this.extendedRegistryEntry != null && this.extendedRegistryEntry.supportsExtensions();
        }

        boolean supportsHiddenExtensions() {
            return this.ocd.supportsHiddenExtensions();
        }

        boolean isValid() {
            return this.valid;
        }

        @Trivial
        public String toString() {
            return super.toString() + "[" + this.pid + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RegistryEntry.class);
        }
    }

    public static interface EntryAction<T> {
        public boolean entry(RegistryEntry var1);

        public T getResult();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class ServiceUse {
        private final String service;
        private final RegistryEntry registryEntry;
        private final String attribute;
        static final long serialVersionUID = -758609386963391937L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ServiceUse(String service, RegistryEntry registryEntry, String attribute) {
            this.service = service;
            this.registryEntry = registryEntry;
            this.attribute = attribute;
        }

        public String getService() {
            return this.service;
        }

        public RegistryEntry getRegistryEntry() {
            return this.registryEntry;
        }

        public String getAttribute() {
            return this.attribute;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ServiceUse.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class PidReference {
        private final RegistryEntry referencingEntry;
        private final String baseAccessor;
        private final RegistryEntry referencedEntry;
        private final boolean isParentFirst;
        static final long serialVersionUID = 4794636731061385482L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PidReference(RegistryEntry referencedEntry, RegistryEntry referencingEntry, String ad, boolean isParentFirst) {
            this.referencedEntry = referencedEntry;
            this.referencingEntry = referencingEntry;
            this.baseAccessor = ad;
            this.isParentFirst = isParentFirst;
        }

        public String getAccessor() {
            return this.baseAccessor;
        }

        public RegistryEntry getReferencedEntry() {
            return this.referencedEntry;
        }

        public RegistryEntry getReferencingEntry() {
            return this.referencingEntry;
        }

        public boolean isParentFirst() {
            return this.isParentFirst;
        }

        @Trivial
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseAccessor == null ? 0 : this.baseAccessor.hashCode());
            result = 31 * result + (this.referencedEntry == null ? 0 : this.referencedEntry.getPid().hashCode());
            result = 31 * result + (this.referencingEntry == null ? 0 : this.referencingEntry.getPid().hashCode());
            return result;
        }

        @Trivial
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PidReference other = (PidReference)obj;
            if (this.baseAccessor == null ? other.baseAccessor != null : !this.baseAccessor.equals(other.baseAccessor)) {
                return false;
            }
            if (this.referencedEntry == null ? other.referencedEntry != null : !this.referencedEntry.getPid().equals(other.referencedEntry.getPid())) {
                return false;
            }
            return !(this.referencingEntry == null ? other.referencingEntry != null : !this.referencingEntry.getPid().equals(other.referencingEntry.getPid()));
        }

        @Trivial
        public String toString() {
            return super.toString() + "[parent: " + this.referencingEntry.getPid() + ", child: " + this.referencedEntry.getPid() + ", accessed by: " + this.getAccessor() + (this.isParentFirst ? ", parent-first" : ", child-first") + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PidReference.class);
        }
    }
}

