/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jaxrs20.providers.api.JaxRsProviderRegister;
import com.ibm.ws.opentracing.OpentracingClientFilter;
import com.ibm.ws.opentracing.OpentracingContainerFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, service={JaxRsProviderRegister.class})
public class OpentracingJaxRsProviderRegister
implements JaxRsProviderRegister {
    private static final TraceComponent tc = Tr.register(OpentracingJaxRsProviderRegister.class);
    private OpentracingContainerFilter containerFilter;
    private OpentracingClientFilter clientFilter;
    static final long serialVersionUID = 3022965106462747282L;

    protected void activate(ComponentContext context) {
        this.setContainerFilter();
        this.setClientFilter();
    }

    protected void deactivate(ComponentContext context) {
        this.clearContainerFilter();
        this.clearClientFilter();
    }

    @Trivial
    protected void setContainerFilter() {
        this.containerFilter = new OpentracingContainerFilter();
    }

    @Trivial
    protected void clearContainerFilter() {
        this.containerFilter = null;
    }

    @Trivial
    protected OpentracingContainerFilter getContainerFilter() {
        return this.containerFilter;
    }

    @Trivial
    protected void setClientFilter() {
        this.clientFilter = new OpentracingClientFilter();
    }

    @Trivial
    protected void clearClientFilter() {
        this.clientFilter = null;
    }

    @Trivial
    protected OpentracingClientFilter getClientFilter() {
        return this.clientFilter;
    }

    @Trivial
    public void installProvider(boolean clientSide, List<Object> providers, Set<String> features) {
        String methodName = "installProvider";
        if (clientSide) {
            OpentracingClientFilter useClientFilter = this.getClientFilter();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Client Filter", useClientFilter});
            }
            if (useClientFilter != null) {
                providers.add(useClientFilter);
            }
        } else {
            OpentracingContainerFilter useContainerFilter = this.getContainerFilter();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Container Filter", useContainerFilter});
            }
            if (useContainerFilter != null) {
                providers.add(useContainerFilter);
            }
        }
    }
}

