/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.opentracing.filters.SpanFilter;
import com.ibm.ws.opentracing.filters.SpanFilterType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.opentracing"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"service.vendor=IBM"})
public class OpentracingService {
    private static final TraceComponent tc = Tr.register(OpentracingService.class);
    private static volatile SpanFilter[] allFilters = new SpanFilter[0];
    static final long serialVersionUID = 2360906552776178823L;

    @Activate
    protected void activate(Map<String, Object> map) {
        this.modified(map);
    }

    @Modified
    protected void modified(Map<String, Object> map) {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference configurationAdminReference = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)bundleContext.getService(configurationAdminReference);
        ArrayList filters = new ArrayList();
        SpanFilter[] finalFilters = new SpanFilter[filters.size()];
        filters.toArray(finalFilters);
        allFilters = finalFilters;
    }

    /*
     * WARNING - void declaration
     */
    private void processFilters(List<SpanFilter> filters, Map<String, Object> map, ConfigurationAdmin configAdmin, String childNames, Class<? extends SpanFilter> impl) {
        String methodName = "processFilters";
        String[] children = (String[])map.get(childNames);
        if (children != null) {
            for (String child : children) {
                try {
                    Configuration config = configAdmin.getConfiguration(child, null);
                    Dictionary childProperties = config.getProperties();
                    String pattern = (String)childProperties.get("pattern");
                    SpanFilterType type = SpanFilterType.valueOf(((String)childProperties.get("type")).trim());
                    boolean ignoreCase = (Boolean)childProperties.get("ignoreCase");
                    boolean regex = (Boolean)childProperties.get("regex");
                    SpanFilter filter = (SpanFilter)Class.forName(impl.getName()).getConstructor(String.class, SpanFilterType.class, Boolean.TYPE, Boolean.TYPE).newInstance(new Object[]{pattern, type, ignoreCase, regex});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processFilters", (Object[])new Object[]{"filter " + filter});
                    }
                    filters.add(filter);
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException config) {
                    void e;
                    FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.opentracing.OpentracingService", (String)"124", (Object)this, (Object[])new Object[]{filters, map, configAdmin, childNames, impl});
                    throw new IllegalStateException((Throwable)e);
                }
            }
        }
    }

    public static boolean process(URI uri, SpanFilterType type) {
        String methodName = "process";
        boolean result = true;
        SpanFilter[] filters = allFilters;
        for (int i = 0; i < filters.length; ++i) {
            result = filters[i].process(result, uri, type);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"process", (Object[])new Object[]{"filter " + filters[i] + " set result to " + result});
        }
        return result;
    }
}

