/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.MatchSpace;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.MatchTarget;
import com.ibm.ws.sib.matchspace.MatchingException;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.impl.BooleanMatcher;
import com.ibm.ws.sib.matchspace.impl.CacheingSearchResults;
import com.ibm.ws.sib.matchspace.impl.ContentMatcher;
import com.ibm.ws.sib.matchspace.impl.EqualityMatcher;
import com.ibm.ws.sib.matchspace.impl.Factory;
import com.ibm.ws.sib.matchspace.impl.InternTable;
import com.ibm.ws.sib.matchspace.impl.MatchCache;
import com.ibm.ws.sib.matchspace.impl.NumericMatcher;
import com.ibm.ws.sib.matchspace.impl.SetValEvaluationContext;
import com.ibm.ws.sib.matchspace.impl.StringMatcher;
import com.ibm.ws.sib.matchspace.selector.impl.OrdinalPosition;
import com.ibm.ws.sib.matchspace.utils.FFDC;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceComponent;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.io.PrintWriter;

public class MatchSpaceImpl
implements MatchSpace,
MatchCache.RehashFilter {
    private static final Class cclass = MatchSpaceImpl.class;
    private static Trace tc = TraceUtils.getTrace(MatchSpaceImpl.class, (String)"SIBMatchSpace");
    private static final int MATCH_CACHE_INITIAL_CAPACITY = 10000;
    private MatchCache matchCache;
    private volatile long matchTreeGeneration = 0L;
    private ContentMatcher matchTree;
    Identifier rootId;
    InternTable subExpr = new InternTable();
    private int exactPuts;
    private int wildPuts;
    private int resultCacheHitGets;
    private int wildCacheHitGets;
    private int wildCacheMissGets;
    private int exactMatches;
    private int resultsCached;
    private int removals;
    private int cacheCreates;
    private int cacheRemoves;
    private int optimisticGets;
    private int pessimisticGets;
    private int puntsDueToCache;

    public MatchSpaceImpl(Identifier rootId, boolean enableCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "MatchSpaceImpl", new Object[]{rootId, new Boolean(enableCache)});
        }
        this.initialise(rootId, enableCache);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "MatchSpaceImpl", (Object)this);
        }
    }

    public void initialise(Identifier rootId, boolean enableCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "initialise", new Object[]{rootId, new Boolean(enableCache)});
        }
        switch (rootId.getType()) {
            case -7: 
            case 0: {
                this.matchTree = new EqualityMatcher(rootId);
                break;
            }
            case -5: 
            case 3: {
                this.matchTree = new StringMatcher(rootId);
                break;
            }
            case -6: {
                this.matchTree = new BooleanMatcher(rootId);
                break;
            }
            default: {
                this.matchTree = new NumericMatcher(rootId);
            }
        }
        if (enableCache) {
            this.rootId = rootId;
            this.matchCache = new MatchCache(10000);
            this.matchCache.setRehashFilter(this);
            ((EqualityMatcher)this.matchTree).setCacheing(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "MatchSpaceImpl", (Object)this);
        }
    }

    public synchronized void addTarget(Conjunction conjunction, MatchTarget object) throws MatchingException {
        OrdinalPosition rootOrd;
        SimpleTest test;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "addTarget", new Object[]{conjunction, object});
        }
        if (this.rootId != null && (test = Factory.findTest(rootOrd = new OrdinalPosition(0, 0), conjunction)) != null && test.getKind() == 2) {
            CacheEntry e = this.getCacheEntry(test.getValue(), true);
            ++e.exactGeneration;
            ContentMatcher exact = e.exactMatcher;
            e.exactMatcher = exact = Factory.createMatcher(rootOrd, conjunction, exact);
            e.cachedResults = null;
            try {
                exact.put(conjunction, object, this.subExpr);
                e.noResultCache |= exact.hasTests();
            }
            catch (RuntimeException exc) {
                FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.addTarget", (Throwable)exc, (String)"1:303:1.44");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit((Object)this, cclass, "addTarget", (Object)e);
                }
                throw new MatchingException((Exception)exc);
            }
            finally {
                ++e.exactGeneration;
            }
            ++this.exactPuts;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "addTarget");
            }
            return;
        }
        ++this.matchTreeGeneration;
        try {
            this.matchTree.put(conjunction, object, this.subExpr);
        }
        catch (RuntimeException e) {
            FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.addTarget", (Throwable)e, (String)"1:333:1.44");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "addTarget", (Object)e);
            }
            throw new MatchingException((Exception)e);
        }
        finally {
            ++this.matchTreeGeneration;
        }
        ++this.wildPuts;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "addTarget");
        }
    }

    private CacheEntry getCacheEntry(Object value, boolean create) {
        CacheEntry e;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "getCacheEntry", new Object[]{value, new Boolean(create), this.matchCache});
        }
        if ((e = (CacheEntry)this.matchCache.get(value)) == null && create) {
            e = new CacheEntry();
            this.matchCache.put(value, e);
            ++this.cacheCreates;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "getCacheEntry", (Object)e);
        }
        return e;
    }

    @Override
    public boolean shouldRetain(Object key, Object val) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "shouldRetain", new Object[]{key, val});
        }
        CacheEntry e = (CacheEntry)val;
        if (e.exactMatcher != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "shouldRetain", (Object)Boolean.TRUE);
            }
            return true;
        }
        ++this.cacheRemoves;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "shouldRetain", (Object)Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(Object rootValue, MatchSpaceKey msg, EvalCache cache, SearchResults result) throws MatchingException, BadMessageFormatMatchingException {
        long exactG;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "search", new Object[]{rootValue, msg, cache, result});
        }
        if (rootValue == null && this.rootId != null) {
            rootValue = msg.getIdentifierValue(this.rootId, false, null, false);
        }
        SetValEvaluationContext evalContext = new SetValEvaluationContext();
        CacheEntry e = null;
        if (this.rootId != null && (e = this.getCacheEntry(rootValue, false)) == null) {
            ++this.puntsDueToCache;
            this.pessimisticGet(rootValue, msg, cache, evalContext, result);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "search");
            }
            return;
        }
        long wildG = this.matchTreeGeneration;
        long l = exactG = e == null ? 0L : e.exactGeneration;
        if ((wildG & 1L) == 1L || (exactG & 1L) == 1L) {
            if (e == null) {
                MatchSpaceImpl matchSpaceImpl = this;
                synchronized (matchSpaceImpl) {
                    this.matchTree.get(rootValue, msg, cache, evalContext, result);
                }
            } else {
                this.pessimisticGet(rootValue, msg, cache, evalContext, result);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "search");
            }
            return;
        }
        if (e != null && (wildG != e.matchTreeGeneration || !e.noResultCache && e.cachedResults == null)) {
            ++this.puntsDueToCache;
            this.pessimisticGet(rootValue, msg, cache, evalContext, result);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "search");
            }
            return;
        }
        SearchResults searchResults = result;
        synchronized (searchResults) {
        }
        Throwable oops = null;
        try {
            if (e != null && e.cachedResults != null && result.acceptCacheable(e.cachedResults)) {
                ++this.resultCacheHitGets;
            } else {
                cache.prepareCache(this.subExpr.evalCacheSize());
                if (e == null) {
                    this.matchTree.get(rootValue, msg, cache, evalContext, result);
                } else {
                    if (e.otherMatchers != null) {
                        for (int i = 0; i < e.otherMatchers.length; ++i) {
                            e.otherMatchers[i].get(null, msg, cache, evalContext, result);
                        }
                        ++this.wildCacheHitGets;
                    }
                    if (e.exactMatcher != null) {
                        e.exactMatcher.get(null, msg, cache, evalContext, result);
                        ++this.exactMatches;
                    }
                }
            }
        }
        catch (RuntimeException exc) {
            oops = exc;
        }
        catch (Error exc) {
            oops = exc;
        }
        if (wildG != this.matchTreeGeneration || e != null && exactG != e.exactGeneration) {
            result.reset();
            if (e == null) {
                MatchSpaceImpl matchSpaceImpl = this;
                synchronized (matchSpaceImpl) {
                    this.matchTree.get(rootValue, msg, cache, evalContext, result);
                }
            } else {
                this.pessimisticGet(rootValue, msg, cache, evalContext, result);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "search");
            }
            return;
        }
        if (oops != null) {
            FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.search", (Throwable)oops, (String)"1:604:1.44");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "search", (Object)oops);
            }
            throw new MatchingException(oops.toString());
        }
        ++this.optimisticGets;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "search");
        }
    }

    private synchronized void pessimisticGet(Object key, MatchSpaceKey msg, EvalCache cache, Object rootContext, SearchResults result) throws MatchingException, BadMessageFormatMatchingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "pessimisticGet", new Object[]{key, msg, cache, result});
        }
        CacheEntry e = this.getCacheEntry(key, true);
        if (e.matchTreeGeneration != this.matchTreeGeneration) {
            e.cachedResults = null;
            e.otherMatchers = null;
        }
        if (e.cachedResults != null && result.acceptCacheable(e.cachedResults)) {
            ++this.resultCacheHitGets;
            ++this.pessimisticGets;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "pessimisticGet");
            }
            return;
        }
        cache.prepareCache(this.subExpr.evalCacheSize());
        if (e.otherMatchers != null) {
            for (int i = 0; i < e.otherMatchers.length; ++i) {
                try {
                    e.otherMatchers[i].get(null, msg, cache, rootContext, result);
                    continue;
                }
                catch (RuntimeException exc) {
                    FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.pessimisticGet", (Throwable)exc, (String)"1:677:1.44");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        tc.exit((Object)this, cclass, "pessimisticGet", (Object)exc);
                    }
                    throw new MatchingException((Exception)exc);
                }
            }
            ++this.wildCacheHitGets;
        } else if (this.matchTree != null) {
            CacheingSearchResults csr = new CacheingSearchResults(result);
            try {
                this.matchTree.get(key, msg, cache, rootContext, csr);
            }
            catch (RuntimeException exc) {
                FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.pessimisticGet", (Throwable)exc, (String)"1:704:1.44");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit((Object)this, cclass, "pessimisticGet", (Object)exc);
                }
                throw new MatchingException((Exception)exc);
            }
            e.otherMatchers = csr.getMatchers();
            e.matchTreeGeneration = this.matchTreeGeneration;
            e.noResultCache |= csr.hasContent;
            ++this.wildCacheMissGets;
        }
        if (e.exactMatcher != null) {
            try {
                e.exactMatcher.get(null, msg, cache, rootContext, result);
            }
            catch (RuntimeException exc) {
                FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.pessimisticGet", (Throwable)exc, (String)"1:731:1.44");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit((Object)this, cclass, "pessimisticGet", (Object)exc);
                }
                throw new MatchingException((Exception)exc);
            }
            ++this.exactMatches;
        }
        if (!e.noResultCache) {
            e.cachedResults = result.provideCacheable(key);
            if (e.cachedResults != null) {
                ++this.resultsCached;
            }
        }
        ++this.pessimisticGets;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "pessimisticGet");
        }
    }

    public synchronized void removeTarget(Conjunction conjunction, MatchTarget target) throws MatchingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "removeTarget", new Object[]{conjunction, target, this.matchCache});
        }
        OrdinalPosition rootOrd = new OrdinalPosition(0, 0);
        SimpleTest test = Factory.findTest(rootOrd, conjunction);
        if (this.rootId == null || test == null || test.getKind() != 2) {
            if (this.matchTree == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit((Object)this, cclass, "removeTarget", (Object)"matchTree == null");
                }
                throw new MatchingException();
            }
            ++this.matchTreeGeneration;
            try {
                this.matchTree.remove(conjunction, target, this.subExpr, rootOrd);
            }
            catch (RuntimeException e) {
                FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.removeTarget", (Throwable)e, (String)"1:798:1.44");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit((Object)this, cclass, "removeTarget", (Object)e);
                }
                throw new MatchingException((Exception)e);
            }
            finally {
                ++this.matchTreeGeneration;
            }
        }
        CacheEntry e = (CacheEntry)this.matchCache.get(test.getValue());
        if (e == null || e.exactMatcher == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "removeTarget", (Object)"MatchingException");
            }
            throw new MatchingException();
        }
        ++e.exactGeneration;
        try {
            e.exactMatcher = e.exactMatcher.remove(conjunction, target, this.subExpr, rootOrd);
        }
        catch (RuntimeException exc) {
            FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl.removeTarget", (Throwable)exc, (String)"1:835:1.44");
            ++e.exactGeneration;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "removeTarget", (Object)"MatchingException");
            }
            throw new MatchingException((Exception)exc);
        }
        if (e.exactMatcher == null && (e.otherMatchers == null || e.matchTreeGeneration != this.matchTreeGeneration || e.otherMatchers.length == 0)) {
            this.matchCache.remove(test.getValue());
            ++this.cacheRemoves;
        }
        e.cachedResults = null;
        ++e.exactGeneration;
        ++this.removals;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "removeTarget");
        }
    }

    public void statistics(PrintWriter wtr) {
        int truePessimisticGets = this.pessimisticGets - this.puntsDueToCache;
        wtr.println("Exact puts: " + this.exactPuts + ", Wildcard generation: " + this.matchTreeGeneration + ", Wildcard puts: " + this.wildPuts + ", Wildcard-Cache-hit gets: " + this.wildCacheHitGets + ", Wildcard-Cache-miss gets: " + this.wildCacheMissGets + ", Result-Cache-hit gets: " + this.resultCacheHitGets + ", Exact matches: " + this.exactMatches + ", Results cached: " + this.resultsCached + ", Removals:" + this.removals + ", Cache entries created:" + this.cacheCreates + ", Cache entries removed:" + this.cacheRemoves + ", Optimistic gets:" + this.optimisticGets + ", True Pessimistic gets:" + truePessimisticGets + ", Mutating gets:" + this.puntsDueToCache);
    }

    public synchronized void clear(Identifier rootId, boolean enableCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "clear");
        }
        this.matchTree = null;
        this.matchTreeGeneration = 0L;
        this.subExpr.clear();
        this.initialise(rootId, enableCache);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "clear");
        }
    }

    private class CacheEntry {
        ContentMatcher exactMatcher;
        volatile long exactGeneration;
        ContentMatcher[] otherMatchers;
        long matchTreeGeneration;
        Object cachedResults;
        boolean noResultCache;

        private CacheEntry() {
        }
    }
}

