/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.ExtendedBoolean;
import com.ibm.ws.sib.admin.QualifiedDestinationName;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.impl.AbstractAliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.Alias;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AliasDestinationHandler
extends AbstractAliasDestinationHandler {
    private static final TraceComponent tc = SibTr.register(AliasDestinationHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private DestinationAliasDefinition _definition;
    private List<JsDestinationAddress> _forwardRoutingPath = null;
    SIDestinationAddress[] _defaultFrp = null;
    JsDestinationAddress _replyDest = null;
    private boolean _isReceiveAllowed;
    private JsDestinationAddress _aliasDestinationAddr = null;
    private JsDestinationAddress _targetDestinationAddr = null;
    private boolean _hasScopedMessagePoints = false;
    private SIBUuid8 _singleScopedQueuePointME = null;
    private HashSet<SIBUuid8> _scopedQueuePointMEs = null;

    public AliasDestinationHandler(DestinationAliasDefinition aliasDefinition, MessageProcessor messageProcessor, SIMPItemStream parentItemStream, DestinationHandler resolvedDestinationHandler, String busName) {
        super(messageProcessor, resolvedDestinationHandler, busName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AliasDestinationHandler", (Object)new Object[]{aliasDefinition, messageProcessor, parentItemStream, resolvedDestinationHandler, busName});
        }
        this.processDefinition(aliasDefinition);
        this.createControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AliasDestinationHandler", (Object)new Object[]{this, this._aliasDestinationAddr, this._targetDestinationAddr});
        }
    }

    private void processDefinition(DestinationAliasDefinition definition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processDefinition", (Object)definition);
        }
        this._definition = definition;
        this._forwardRoutingPath = null;
        this._defaultFrp = null;
        this._replyDest = null;
        this._aliasDestinationAddr = null;
        this._targetDestinationAddr = null;
        this._hasScopedMessagePoints = false;
        this._singleScopedQueuePointME = null;
        this._scopedQueuePointMEs = null;
        if (this._definition != null) {
            SIBUuid8[] queuePoints;
            QualifiedDestinationName replyName;
            QualifiedDestinationName[] names;
            this._aliasDestinationAddr = SIMPUtils.createJsDestinationAddress(this._definition.getName(), null, this.getBus());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Alias destination address: " + this._aliasDestinationAddr));
            }
            this._targetDestinationAddr = SIMPUtils.createJsDestinationAddress(this.getTargetName(), null, this.getTargetBus());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Target destination address: " + this._targetDestinationAddr));
            }
            if ((names = this._definition.getForwardRoutingPath()) != null) {
                this._forwardRoutingPath = new ArrayList<JsDestinationAddress>(names.length);
                this._defaultFrp = new SIDestinationAddress[names.length];
                for (int name = 0; name < names.length; ++name) {
                    JsDestinationAddress address = SIMPUtils.createJsDestinationAddress(names[name].getDestination(), null, names[name].getBus());
                    this._forwardRoutingPath.add(address);
                    this._defaultFrp[name] = address;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)("Forward routing path [" + name + "]: " + address));
                }
            }
            if ((replyName = this._definition.getReplyDestination()) != null) {
                this._replyDest = SIMPUtils.createJsDestinationAddress(replyName.getDestination(), this.messageProcessor.getMessagingEngineUuid(), replyName.getBus());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Reply destination: " + this._replyDest));
                }
            }
            if ((queuePoints = this._definition.getScopedQueuePointMEs()) != null && queuePoints.length > 0) {
                this._hasScopedMessagePoints = true;
                if (queuePoints.length == 1) {
                    this._singleScopedQueuePointME = queuePoints[0];
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Single scoped Queue Point: " + queuePoints[0]));
                    }
                } else {
                    this._scopedQueuePointMEs = new HashSet();
                    for (int i = 0; i < queuePoints.length; ++i) {
                        this._scopedQueuePointMEs.add(queuePoints[i]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)("Scoped Queue Point: " + queuePoints[i]));
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No scoped Queue Point");
            }
            this.setReceiveAllowed(this._definition);
        } else {
            this._isReceiveAllowed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processDefinition");
        }
    }

    @Override
    public Object getContextValue(String keyName) {
        Map context;
        Object property;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getContextValue", (Object)keyName);
        }
        if (null == (property = (context = this._definition.getDestinationContext()).get(keyName))) {
            property = this.getTarget().getContextValue(keyName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getContextValue", property);
        }
        return property;
    }

    @Override
    public int getDefaultPriority() {
        int pri;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultPriority");
        }
        if ((pri = this._definition.getDefaultPriority()) == -1) {
            pri = this.getTarget().getDefaultPriority();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultPriority", (Object)pri);
        }
        return pri;
    }

    @Override
    public Reliability getDefaultReliability() {
        Reliability rel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultReliability");
        }
        if ((rel = this._definition.getDefaultReliability()).equals(Reliability.NONE)) {
            rel = this.getTarget().getDefaultReliability();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultReliability", (Object)rel);
        }
        return rel;
    }

    @Override
    public String getDescription() {
        String desc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDescription");
        }
        if (null == (desc = this._definition.getDescription())) {
            desc = this.getTarget().getDescription();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDescription", (Object)desc);
        }
        return desc;
    }

    @Override
    public DestinationType getDestinationType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationType");
        }
        DestinationType dt = this.getTarget().getDestinationType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationType", (Object)dt);
        }
        return dt;
    }

    @Override
    public Reliability getMaxReliability() {
        Reliability rel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaxReliability");
        }
        if ((rel = this._definition.getMaxReliability()).equals(Reliability.NONE)) {
            rel = this.getTarget().getMaxReliability();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaxReliability", (Object)rel);
        }
        return rel;
    }

    @Override
    public boolean isOverrideOfQOSByProducerAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed");
        }
        ExtendedBoolean aliasIsProducerQOSOverrideEnabled = this._definition.isOverrideOfQOSByProducerAllowed();
        boolean isProducerQOSOverrideEnabled = false;
        isProducerQOSOverrideEnabled = aliasIsProducerQOSOverrideEnabled.equals(ExtendedBoolean.NONE) ? this.getTarget().isOverrideOfQOSByProducerAllowed() : !aliasIsProducerQOSOverrideEnabled.equals(ExtendedBoolean.FALSE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed", (Object)isProducerQOSOverrideEnabled);
        }
        return isProducerQOSOverrideEnabled;
    }

    @Override
    public boolean isAlias() {
        return true;
    }

    @Override
    public boolean isForeign() {
        return false;
    }

    @Override
    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean isSendAllowed = true;
        DestinationHandler target = this.getTarget();
        if (this._sendAllowedOnTargetForeignBus != null) {
            isSendAllowed = this._sendAllowedOnTargetForeignBus;
        }
        ExtendedBoolean aliasIsSendAllowed = this._definition.isSendAllowed();
        if (isSendAllowed) {
            isSendAllowed = aliasIsSendAllowed.equals(ExtendedBoolean.NONE) ? target.isSendAllowed() : !aliasIsSendAllowed.equals(ExtendedBoolean.FALSE);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)isSendAllowed);
        }
        return isSendAllowed;
    }

    @Override
    public synchronized boolean isReceiveAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveAllowed");
            SibTr.exit((TraceComponent)tc, (String)"isReceiveAllowed", (Object)this._isReceiveAllowed);
        }
        return this._isReceiveAllowed;
    }

    private synchronized void setReceiveAllowed(DestinationAliasDefinition aliasDefinition) {
        ExtendedBoolean aliasIsReceiveAllowed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReceiveAllowed", (Object)aliasDefinition);
        }
        this._isReceiveAllowed = (aliasIsReceiveAllowed = aliasDefinition.isReceiveAllowed()).equals(ExtendedBoolean.NONE) ? this.getTarget().isReceiveAllowed() : !aliasIsReceiveAllowed.equals(ExtendedBoolean.FALSE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReceiveAllowed", (Object)this._isReceiveAllowed);
        }
    }

    @Override
    public BaseDestinationDefinition getDefinition() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefinition");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefinition", (Object)this._definition);
        }
        return this._definition;
    }

    @Override
    public void updateDefinition(BaseDestinationDefinition destinationDefinition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateDefinition", (Object)destinationDefinition);
        }
        DestinationAliasDefinition oldDefinition = this._definition;
        this.processDefinition((DestinationAliasDefinition)destinationDefinition);
        if (oldDefinition == null || oldDefinition.isReceiveAllowed() != this._definition.isReceiveAllowed()) {
            if (this.isPubSub()) {
                SubscriptionTypeFilter filter = new SubscriptionTypeFilter();
                filter.LOCAL = Boolean.TRUE;
                SIMPIterator itr = this.getSubscriptionIndex().iterator(filter);
                while (itr.hasNext()) {
                    ControllableSubscription subscription = (ControllableSubscription)itr.next();
                    ConsumerDispatcher cd = (ConsumerDispatcher)subscription.getOutputHandler();
                    if (cd == null || !cd.getConsumerDispatcherState().getTopicSpaceUuid().equals((Object)this.getUuid())) continue;
                    cd.notifyReceiveAllowed(this);
                }
                itr.finished();
            } else {
                ConsumerDispatcher cm = (ConsumerDispatcher)this.getLocalPtoPConsumerManager();
                if (cm != null) {
                    cm.notifyReceiveAllowed(this);
                }
            }
            this.notifyReceiveAllowedRCD(this);
            this.notifyTargettingAliasesReceiveAllowed();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateDefinition");
        }
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = new Alias(this.messageProcessor, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter", (Object)this.controlAdapter);
        }
    }

    @Override
    public ControlAdapter getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public String getTargetName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetName");
            SibTr.exit((TraceComponent)tc, (String)"getTargetName", (Object)this._definition.getTargetName());
        }
        return this._definition.getTargetName();
    }

    @Override
    public String getTargetBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetBus");
            SibTr.exit((TraceComponent)tc, (String)"getTargetBus", (Object)this._definition.getTargetBus());
        }
        return this._definition.getTargetBus();
    }

    @Override
    public JsDestinationAddress getRoutingDestinationAddr(JsDestinationAddress inAddress, boolean fixedMessagePoint) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRoutingDestinationAddr", (Object)new Object[]{this, inAddress, fixedMessagePoint});
        }
        JsDestinationAddress outAddress = null;
        DestinationHandler target = this.getTarget();
        outAddress = target.getRoutingDestinationAddr(this._targetDestinationAddr, fixedMessagePoint);
        if (outAddress == null && this._hasScopedMessagePoints && (this._singleScopedQueuePointME != null || this._scopedQueuePointMEs != null)) {
            outAddress = this._aliasDestinationAddr;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRoutingDestinationAddr", (Object)outAddress);
        }
        return outAddress;
    }

    @Override
    public OutputHandler choosePtoPOutputHandler(SIBUuid8 fixedMEUuid, SIBUuid8 preferredMEUuid, boolean localMessage, boolean forcePut, HashSet<SIBUuid8> scopedMEs) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)new Object[]{fixedMEUuid, preferredMEUuid, localMessage, forcePut, scopedMEs});
        }
        OutputHandler result = null;
        boolean error = false;
        if (scopedMEs != null) {
            SIMPErrorException e = new SIMPErrorException("Alias called with scoped ME set");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            e.setExceptionReason(901);
            e.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:750:1.71.2.6", SIMPUtils.getStackTrace((Throwable)e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandlers", (Object)e);
            }
            throw e;
        }
        SIBUuid8 singleScopedME = null;
        HashSet<SIBUuid8> definedScopedMEs = null;
        if (this._hasScopedMessagePoints) {
            if (this._singleScopedQueuePointME != null) {
                singleScopedME = this._singleScopedQueuePointME;
            } else {
                definedScopedMEs = this._scopedQueuePointMEs;
            }
            if (fixedMEUuid != null) {
                if (singleScopedME != null && !fixedMEUuid.equals((Object)singleScopedME)) {
                    error = true;
                } else if (definedScopedMEs != null && !definedScopedMEs.contains(fixedMEUuid)) {
                    error = true;
                }
            }
            if (singleScopedME != null) {
                fixedMEUuid = singleScopedME;
            }
        }
        if (!error) {
            result = this._targetDestinationHandler.choosePtoPOutputHandler(fixedMEUuid, preferredMEUuid, localMessage, forcePut, definedScopedMEs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)result);
        }
        return result;
    }

    @Override
    public ConsumerManager chooseConsumerManager(SIBUuid12 gatheringTargetUuid, SIBUuid8 fixedMEUuid, HashSet<SIBUuid8> scopedMEs) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"chooseConsumerManager", (Object)new Object[]{gatheringTargetUuid, fixedMEUuid, scopedMEs});
        }
        if (scopedMEs != null) {
            SIMPErrorException e = new SIMPErrorException("Alias called with scoped ME set");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            e.setExceptionReason(901);
            e.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:837:1.71.2.6", SIMPUtils.getStackTrace((Throwable)e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"chooseConsumerManager", (Object)e);
            }
            throw e;
        }
        boolean error = false;
        ConsumerManager consumerManager = null;
        if (fixedMEUuid != null) {
            if (this._singleScopedQueuePointME != null && !fixedMEUuid.equals((Object)this._singleScopedQueuePointME)) {
                error = true;
            } else if (this._scopedQueuePointMEs != null && !this._scopedQueuePointMEs.contains(fixedMEUuid)) {
                error = true;
            }
        }
        if (!error) {
            if (this._singleScopedQueuePointME != null) {
                fixedMEUuid = this._singleScopedQueuePointME;
            }
            if (gatheringTargetUuid != null) {
                gatheringTargetUuid = this._definition.getUUID();
            }
            consumerManager = this._targetDestinationHandler.chooseConsumerManager(gatheringTargetUuid, fixedMEUuid, this._scopedQueuePointMEs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chooseConsumerManager", consumerManager);
        }
        return consumerManager;
    }

    public List getForwardRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardRoutingPath");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForwardRoutingPath", this._forwardRoutingPath);
        }
        return this._forwardRoutingPath;
    }

    @Override
    public SIDestinationAddress[] getDefaultForwardRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultForwardRoutingPath");
            SibTr.exit((TraceComponent)tc, (String)"getDefaultForwardRoutingPath", (Object)this._defaultFrp);
        }
        return this._defaultFrp;
    }

    @Override
    public JsDestinationAddress getReplyDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReplyDestination");
            SibTr.exit((TraceComponent)tc, (String)"getReplyDestination", (Object)this._replyDest);
        }
        return this._replyDest;
    }

    @Override
    public boolean checkDestinationAccess(SecurityContext secContext, OperationType operation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{secContext, operation});
        }
        boolean allow = false;
        if (this._definition.getDelegateAuthorizationCheckToTarget()) {
            if (this.getTarget().checkDestinationAccess(secContext, operation)) {
                allow = true;
            }
        } else if (this.accessChecker.checkDestinationAccess(secContext, this.getBus(), this.getDefinition().getName(), operation)) {
            allow = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)allow);
        }
        return allow;
    }

    @Override
    public boolean isTopicAccessCheckRequired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTopicAccessCheckRequired");
        }
        boolean ret = this.getTarget().isTopicAccessCheckRequired();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTopicAccessCheckRequired", (Object)ret);
        }
        return ret;
    }

    @Override
    public boolean checkDiscriminatorAccess(SecurityContext secContext, OperationType operation) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)new Object[]{secContext, operation});
        }
        boolean allow = true;
        if (this.isTopicAccessCheckRequired() && !this.getTarget().checkDiscriminatorAccess(secContext, operation)) {
            allow = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)allow);
        }
        return allow;
    }

    @Override
    public int checkPtoPOutputHandlers(SIBUuid8 fixedMEUuid, HashSet<SIBUuid8> scopedMEs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPtoPOutputHandlers", (Object)new Object[]{fixedMEUuid, scopedMEs});
        }
        int result = -1;
        if (scopedMEs != null) {
            SIMPErrorException e = new SIMPErrorException("Alias called with scoped ME set");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            e.setExceptionReason(901);
            e.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1044:1.71.2.6", SIMPUtils.getStackTrace((Throwable)e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkPtoPOutputHandlers", (Object)e);
            }
            throw e;
        }
        SIBUuid8 singleScopedME = null;
        HashSet<SIBUuid8> definedScopedMEs = null;
        if (this._hasScopedMessagePoints) {
            if (this._singleScopedQueuePointME != null) {
                singleScopedME = this._singleScopedQueuePointME;
            } else {
                definedScopedMEs = this._scopedQueuePointMEs;
            }
            if (fixedMEUuid != null) {
                if (singleScopedME != null && !fixedMEUuid.equals((Object)singleScopedME)) {
                    result = 0;
                } else if (definedScopedMEs != null && !definedScopedMEs.contains(fixedMEUuid)) {
                    result = 0;
                }
            }
            if (singleScopedME != null) {
                fixedMEUuid = singleScopedME;
            }
        }
        if (result == -1) {
            result = this._targetDestinationHandler.checkPtoPOutputHandlers(fixedMEUuid, definedScopedMEs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPtoPOutputHandlers", (Object)new Integer(result));
        }
        return result;
    }

    @Override
    public void notifyReceiveAllowed(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{destinationHandler});
        }
        if (this._definition.isReceiveAllowed() == ExtendedBoolean.NONE) {
            this.getTarget().notifyReceiveAllowed(destinationHandler);
            this.notifyTargettingAliasesReceiveAllowed();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    @Override
    public boolean isOrdered() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isOrdered");
        }
        boolean returnValue = this.getTarget().isOrdered();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isOrdered", (Object)returnValue);
        }
        return returnValue;
    }

    @Override
    public boolean hasLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasLocal");
        }
        boolean hasLocal = false;
        if (this._hasScopedMessagePoints) {
            if (this._singleScopedQueuePointME != null) {
                if (this._singleScopedQueuePointME.equals((Object)this.getMessageProcessor().getMessagingEngineUuid())) {
                    hasLocal = true;
                }
            } else if (this._scopedQueuePointMEs != null && this._scopedQueuePointMEs.contains(this.getMessageProcessor().getMessagingEngineUuid())) {
                hasLocal = true;
            }
        }
        if (hasLocal || !this._hasScopedMessagePoints) {
            hasLocal = this._targetDestinationHandler.hasLocal();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasLocal", (Object)hasLocal);
        }
        return hasLocal;
    }

    @Override
    public long getQHighMsgDepth() {
        return -1L;
    }
}

