/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.AbstractConsumerKey;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.JSConsumerClassifications;
import com.ibm.ws.sib.processor.impl.JSConsumerSet;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyFilter;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;

public class LocalQPConsumerKey
extends AbstractConsumerKey
implements DispatchableKey,
Filter {
    private static final TraceComponent tc = SibTr.register(LocalQPConsumerKey.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected boolean ready;
    protected boolean detached;
    protected final DispatchableConsumerPoint consumerPoint;
    protected long version;
    private Reliability unrecoverability = null;
    private final JSConsumerManager consumerDispatcher;
    private final SIBUuid12 connectionUuid;
    private boolean forwardScanning;
    private boolean started = false;
    private final ItemStream itemStream;
    private String selectorString = null;
    private Selector selectorTree;
    private Selector discriminatorTree;
    private boolean specific;
    private LocalQPConsumerKeyFilter[] consumerKeyFilter = null;
    private boolean pendingFlowReset = false;

    LocalQPConsumerKey(DispatchableConsumerPoint consumerPoint, JSConsumerManager consumerDispatcher, SelectionCriteria criteria, SIBUuid12 connectionUuid, boolean forwardScanning, JSConsumerSet consumerSet) throws SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LocalQPConsumerKey", (Object)new Object[]{consumerPoint, consumerDispatcher, criteria, connectionUuid, forwardScanning, consumerSet});
        }
        this.consumerDispatcher = consumerDispatcher;
        this.consumerPoint = consumerPoint;
        this.connectionUuid = connectionUuid;
        this.detached = false;
        this.ready = false;
        this.forwardScanning = forwardScanning;
        this.keyGroup = null;
        this.consumerSet = consumerSet;
        if (consumerSet != null) {
            this.classifyingMessages = true;
        }
        try {
            this.itemStream = ((ConsumerDispatcher)consumerDispatcher).getItemStream();
            LockingCursor cursor = null;
            if (this.itemStream != null) {
                this.createNewFiltersAndCursors(this.itemStream);
            } else {
                this.consumerKeyFilter = new LocalQPConsumerKeyFilter[1];
                this.consumerKeyFilter[0] = new LocalQPConsumerKeyFilter(this, 0, null);
                cursor = ((ConsumerDispatcher)consumerDispatcher).getReferenceStream().newLockingCursor(null, !forwardScanning);
                this.consumerKeyFilter[0].setLockingCursor(cursor);
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.LocalQPConsumerKey.LocalQPConsumerKey", (String)"1:198:1.23", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SIResourceException newE = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKey", "1:208:1.23", e}, null), (Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LocalQPConsumerKey", (Object)((Object)newE));
            }
            throw newE;
        }
        try {
            this.specific = false;
            if (criteria != null) {
                if (criteria.getSelectorString() != null && !criteria.getSelectorString().equals("")) {
                    this.selectorString = criteria.getSelectorString();
                    this.selectorTree = consumerDispatcher.getMessageProcessor().getMessageProcessorMatching().parseSelector(criteria.getSelectorString(), criteria.getSelectorDomain());
                    this.specific = true;
                }
                if (criteria.getDiscriminator() != null && !criteria.getDiscriminator().equals("")) {
                    this.discriminatorTree = consumerDispatcher.getMessageProcessor().getMessageProcessorMatching().parseDiscriminator(criteria.getDiscriminator());
                    this.specific = true;
                }
            }
        }
        catch (SISelectorSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.LocalQPConsumerKey.LocalQPConsumerKey", (String)"1:251:1.23", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LocalQPConsumerKey", (Object)((Object)e));
            }
            throw e;
        }
        catch (SIDiscriminatorSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.LocalQPConsumerKey.LocalQPConsumerKey", (String)"1:265:1.23", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LocalQPConsumerKey", (Object)((Object)e));
            }
            throw e;
        }
        if (this.classifyingMessages) {
            consumerSet.addConsumer(consumerPoint);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LocalQPConsumerKey", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ready(Reliability unrecoverability) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ready", (Object)unrecoverability);
        }
        if (this.closedReason == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ready", (Object)"SINotPossibleInCurrentConfigurationException - deleted");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_DELETED_ERROR_CWSIP00221", new Object[]{this.consumerDispatcher.getDestination().getName(), this.consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
        }
        if (this.closedReason == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ready", (Object)"SINotPossibleInCurrentConfigurationException - receive Exclusive");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_EXCLUSIVE_ERROR_CWSIP00222", new Object[]{this.consumerDispatcher.getDestination().getName(), this.consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
        }
        if (this.closedReason == 3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ready", (Object)"SINotPossibleInCurrentConfigurationException - localisation unreachable");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_UNREACHABLE_ERROR_CWSIP00223", new Object[]{this.consumerDispatcher.getDestination().getName(), this.consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
        }
        Object object = this.consumerDispatcher.getDestination().getReadyConsumerPointLock();
        synchronized (object) {
            this.unrecoverability = unrecoverability;
            if (this.keyGroup == null) {
                if (!this.ready) {
                    this.version = this.consumerDispatcher.newReadyConsumer(this, this.specific);
                }
            } else {
                this.keyGroup.ready(null);
            }
            this.ready = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ready", (Object)this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notReady");
        }
        Object object = this.consumerDispatcher.getDestination().getReadyConsumerPointLock();
        synchronized (object) {
            if (this.keyGroup == null) {
                if (this.ready) {
                    this.consumerDispatcher.removeReadyConsumer(this, this.specific);
                }
            } else {
                this.keyGroup.notReady();
            }
            this.ready = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notReady");
        }
    }

    @Override
    public long waiting(long timeout, boolean modifyTimeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waiting");
            SibTr.exit((TraceComponent)tc, (String)"waiting", (Object)timeout);
        }
        return timeout;
    }

    public LockingCursor getDefaultGetCursor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultGetCursor");
        }
        LockingCursor cursor = this.consumerKeyFilter[0].getGetCursor();
        if (this.keyGroup != null) {
            cursor = this.keyGroup.getDefaultGetCursor();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultGetCursor", (Object)cursor);
        }
        return cursor;
    }

    @Override
    public LockingCursor getGetCursor(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getGetCursor", (Object)msg);
        }
        int classification = 0;
        LockingCursor cursor = null;
        if (this.classifyingMessages) {
            this.consumerSet.takeClassificationReadLock();
            if (this.pendingFlowReset) {
                this.pendingFlowReset = false;
                this.resetFlowProperties();
            }
            classification = this.consumerSet.getGetCursorIndex(msg);
            cursor = this.consumerKeyFilter[classification].getGetCursor();
            if (this.keyGroup != null) {
                cursor = this.keyGroup.getGetCursor(classification);
            }
            this.consumerSet.freeClassificationReadLock();
        } else {
            cursor = this.consumerKeyFilter[0].getGetCursor();
            if (this.keyGroup != null) {
                cursor = this.keyGroup.getGetCursor(0);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getGetCursor", (Object)cursor);
        }
        return cursor;
    }

    protected LockingCursor getGetCursor(int classification) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getGetCursor", (Object)classification);
        }
        LockingCursor cursor = this.consumerKeyFilter[classification].getGetCursor();
        if (this.keyGroup != null) {
            cursor = this.keyGroup.getGetCursor(classification);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getGetCursor", (Object)cursor);
        }
        return cursor;
    }

    private int chooseGetCursorIndex(int classification) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"chooseGetCursorIndex");
        }
        int classIndex = 0;
        if (this.classifyingMessages) {
            classIndex = this.consumerSet.chooseGetCursorIndex(classification);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chooseGetCursorIndex", (Object)classIndex);
        }
        return classIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detach");
        }
        this.notReady();
        if (this.keyGroup != null) {
            this.keyGroup.removeMember(this);
        }
        this.consumerDispatcher.detachConsumerPoint(this);
        if (this.classifyingMessages) {
            this.consumerSet.takeClassificationReadLock();
            int numFilters = this.consumerKeyFilter.length;
            for (int i = 0; i < numFilters; ++i) {
                this.consumerKeyFilter[i].detach();
            }
            this.consumerSet.freeClassificationReadLock();
        } else {
            this.consumerKeyFilter[0].detach();
        }
        LocalQPConsumerKey localQPConsumerKey = this;
        synchronized (localQPConsumerKey) {
            this.detached = true;
        }
        if (this.classifyingMessages) {
            this.consumerSet.removeConsumer(this.consumerPoint);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detach");
        }
    }

    @Override
    public SIBUuid12 getConnectionUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnectionUuid");
            SibTr.exit((TraceComponent)tc, (String)"getConnectionUuid", (Object)this.connectionUuid);
        }
        return this.connectionUuid;
    }

    @Override
    public boolean getForwardScanning() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardScanning");
            SibTr.exit((TraceComponent)tc, (String)"getForwardScanning", (Object)this.forwardScanning);
        }
        return this.forwardScanning;
    }

    @Override
    public boolean requiresRecovery(SIMPMessage msg) {
        Reliability msgReliability;
        boolean recoverable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requiresRecovery", (Object)new Object[]{msg});
        }
        boolean bl = recoverable = (msgReliability = msg.getReliability()).compareTo((Object)this.unrecoverability) > 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requiresRecovery", (Object)recoverable);
        }
        return recoverable;
    }

    @Override
    public JSConsumerManager getConsumerManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerManager");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerManager", (Object)this.consumerDispatcher);
        }
        return this.consumerDispatcher;
    }

    @Override
    public boolean close(int closedReason, SIBUuid8 qpoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close", (Object)new Object[]{closedReason, qpoint});
        }
        this.closedReason = closedReason;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close", (Object)true);
        }
        return true;
    }

    @Override
    public void notifyConsumerPointAboutException(SIException e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyConsumerPointAboutException", (Object)((Object)e));
        }
        this.consumerPoint.notifyException(e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyConsumerPointAboutException");
        }
    }

    @Override
    public void notifyReceiveAllowed(boolean isAllowed, DestinationHandler destinationBeingModified) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)isAllowed);
        }
        if (this.consumerPoint.destinationMatches(destinationBeingModified, this.consumerDispatcher)) {
            this.consumerPoint.notifyReceiveAllowed(isAllowed);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    @Override
    public boolean isKeyReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isKeyReady");
        }
        boolean returnValue = false;
        returnValue = this.keyGroup == null ? this.ready : this.keyGroup.isKeyReady();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isKeyReady", (Object)returnValue);
        }
        return returnValue;
    }

    @Override
    public void markNotReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markNotReady");
        }
        this.ready = false;
        if (this.keyGroup != null) {
            this.keyGroup.markNotReady();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markNotReady");
        }
    }

    @Override
    public long getVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getVersion");
            SibTr.exit((TraceComponent)tc, (String)"getVersion", (Object)this.version);
        }
        return this.version;
    }

    @Override
    public DispatchableConsumerPoint getConsumerPoint() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerPoint");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerPoint", (Object)this.consumerPoint);
        }
        return this.consumerPoint;
    }

    @Override
    public boolean isSpecific() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSpecific");
            SibTr.exit((TraceComponent)tc, (String)"isSpecific", (Object)this.specific);
        }
        return this.specific;
    }

    @Override
    public DispatchableKey resolvedKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolvedKey");
            SibTr.exit((TraceComponent)tc, (String)"resolvedKey", (Object)this);
        }
        return this;
    }

    public boolean filterMatches(AbstractItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"filterMatches", (Object)item);
        }
        boolean result = true;
        if (this.selectorTree != null || this.discriminatorTree != null) {
            JsMessage msg = ((SIMPMessage)item).getMessageIfAvailable();
            if (msg == null) {
                result = false;
            } else {
                int redelCount = ((SIMPMessage)item).guessRedeliveredCount();
                if (redelCount > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Set deliverycount into message: " + redelCount));
                    }
                    msg.setDeliveryCount(redelCount);
                }
                result = this.consumerDispatcher.getMessageProcessor().getMessageProcessorMatching().evaluateMessage(this.selectorTree, this.discriminatorTree, (SIBusMessage)msg);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)result);
        }
        return result;
    }

    @Override
    public JSConsumerKey getParent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getParent");
        }
        JSConsumerKey key = this;
        if (this.keyGroup != null) {
            key = this.keyGroup;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getParent", (Object)key);
        }
        return key;
    }

    @Override
    public void start() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        if (!this.started) {
            this.started = true;
            if (this.keyGroup != null) {
                this.keyGroup.startMember();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    @Override
    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (this.started) {
            this.started = false;
            if (this.keyGroup != null) {
                this.keyGroup.stopMember();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public String toString() {
        String returnStr = super.toString();
        if (this.consumerDispatcher != null) {
            returnStr = this.consumerDispatcher.toString() + returnStr + ", " + this.selectorString;
        }
        return returnStr;
    }

    @Override
    public Selector getSelector() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelector");
            SibTr.exit((TraceComponent)tc, (String)"getSelector", (Object)this.selectorTree);
        }
        return this.selectorTree;
    }

    @Override
    public SIMPMessage getMessageLocked() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageLocked");
        }
        SIMPMessage msg = null;
        if (this.classifyingMessages) {
            this.consumerSet.takeClassificationReadLock();
            if (this.pendingFlowReset) {
                this.pendingFlowReset = false;
                this.resetFlowProperties();
            }
            int classIndex = -1;
            while (classIndex != 0) {
                msg = this.getMessageLocked(classIndex = this.chooseGetCursorIndex(classIndex));
                if (msg == null) continue;
                classIndex = 0;
            }
            this.consumerSet.freeClassificationReadLock();
        } else {
            msg = this.getMessageLocked(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageLocked", (Object)msg);
        }
        return msg;
    }

    protected SIMPMessage getMessageLocked(int classification) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageLocked", (Object)classification);
        }
        SIMPMessage msg = null;
        msg = !this.classifyingMessages ? (SIMPMessage)this.getDefaultGetCursor().next() : (SIMPMessage)this.getGetCursor(classification).next();
        if (msg != null) {
            msg.setLocalisingME(this.consumerDispatcher.getMessageProcessor().getMessagingEngineUuid());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageLocked", (Object)msg);
        }
        return msg;
    }

    public String getSelectorString() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelectorString");
            SibTr.exit((TraceComponent)tc, (String)"getSelectorString", (Object)this.selectorString);
        }
        return this.selectorString;
    }

    private void createNewFiltersAndCursors(ItemStream itemStream) throws SIResourceException, MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNewFiltersAndCursors", (Object)itemStream);
        }
        LockingCursor cursor = null;
        if (this.classifyingMessages) {
            JSConsumerClassifications classifications = this.consumerSet.getClassifications();
            int numClasses = classifications.getNumberOfClasses();
            this.consumerKeyFilter = new LocalQPConsumerKeyFilter[numClasses + 1];
            for (int i = 0; i < numClasses + 1; ++i) {
                String classificationName = null;
                if (i > 0) {
                    classificationName = classifications.getClassification(i);
                }
                this.consumerKeyFilter[i] = new LocalQPConsumerKeyFilter(this, i, classificationName);
                cursor = itemStream.newLockingItemCursor((Filter)this.consumerKeyFilter[i], !this.forwardScanning);
                this.consumerKeyFilter[i].setLockingCursor(cursor);
            }
        } else {
            this.consumerKeyFilter = new LocalQPConsumerKeyFilter[1];
            this.consumerKeyFilter[0] = new LocalQPConsumerKeyFilter(this, 0, null);
            cursor = itemStream.newLockingItemCursor((Filter)this.consumerKeyFilter[0], !this.forwardScanning);
            this.consumerKeyFilter[0].setLockingCursor(cursor);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNewFiltersAndCursors");
        }
    }

    public void notifyResetFlowProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyResetFlowProperties");
        }
        this.pendingFlowReset = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyResetFlowProperties");
        }
    }

    private void resetFlowProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetFlowProperties");
        }
        int numFilters = this.consumerKeyFilter.length;
        for (int i = 0; i < numFilters; ++i) {
            this.consumerKeyFilter[i].discard();
        }
        try {
            ItemStream itemStream = ((ConsumerDispatcher)this.consumerDispatcher).getItemStream();
            this.createNewFiltersAndCursors(itemStream);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.sib.processor.impl.LocalQPConsumerKey.resetFlowProperties", (String)"1:1101:1.23", (Object)this);
            SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKey", "1:1108:1.23", ex}, null), (Throwable)ex);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKey", "1:1114:1.23", SIMPUtils.getStackTrace(ex)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"resetFlowProperties", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetFlowProperties");
        }
    }

    public void refillQueuePoint(boolean gathering) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"refillQueuePoint");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"refillQueuePoint");
        }
    }

    public void initiateRefill() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initiateRefill", (Object)this);
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initiateRefill");
        }
    }

    public boolean isRefillAllowed() {
        return false;
    }
}

