/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.JSConsumerSet;
import com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.RemoteQPConsumerKey;
import com.ibm.ws.sib.processor.impl.RemoteQPConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.JSKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.RefillKey;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.AIMessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.matching.MatchingConsumerPoint;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class RemoteConsumerDispatcher
extends ConsumerDispatcher {
    private static final TraceComponent tc = SibTr.register(RemoteConsumerDispatcher.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final String _destName;
    private final AnycastInputHandler _aih;
    private boolean _cardinalityOne;
    private boolean _cardinalityChange;
    private boolean _forceFlushInProgress;
    private final SIMPTransactionManager _tranManager;
    private boolean _currentReachability;
    private long lockID;
    private boolean _pendingDelete = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteConsumerDispatcher(BaseDestinationHandler destination, String destName, PtoPMessageItemStream itemStream, ConsumerDispatcherState dispatcherState, AnycastInputHandler aih, SIMPTransactionManager tranManager, boolean card) {
        super(destination, itemStream, dispatcherState);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteConsumerDispatcher", (Object)new Object[]{destination, destName, itemStream, dispatcherState, aih, tranManager, card});
        }
        this._destName = destName;
        this._aih = aih;
        this._tranManager = tranManager;
        this._currentReachability = true;
        try {
            this.lockID = this._messageProcessor.getMessageStore().getUniqueLockID(1);
        }
        catch (PersistenceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            this._forceFlushInProgress = false;
            this._cardinalityOne = card;
            this._cardinalityChange = false;
            if (this._cardinalityOne) {
                aih.rejectAll();
            }
        }
        aih.initRCD(this);
        if (aih.getAIProtocolStream() != null && aih.getAIProtocolStream().isUnableToOrder()) {
            destination.setIsUnableToOrder(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteConsumerDispatcher", (Object)this);
        }
    }

    public final String getDestName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestName");
            SibTr.exit((TraceComponent)tc, (String)"getDestName", (Object)this._destName);
        }
        return this._destName;
    }

    public final SIBUuid8 getLocalisationUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalisationUuid");
        }
        SIBUuid8 uuid = this._aih.getLocalisationUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalisationUuid", (Object)uuid);
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyReceiveExclusiveChange(boolean newValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveExclusiveChange", (Object)new Boolean(newValue));
        }
        boolean notifyConsumers = true;
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            this._cardinalityOne = newValue;
            this._cardinalityChange = true;
            if (this.consumerPoints.size() == 0) {
                notifyConsumers = false;
            }
        }
        if (notifyConsumers) {
            super.closeAllConsumersForReceiveExclusive();
        } else {
            try {
                this.cardinalityChangeConsumersDetached();
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.notifyReceiveExclusiveChange", (String)"1:203:1.75", (Object)this);
                SIErrorException e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.notifyReceiveExclusiveChange", "1:211:1.75", e}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.notifyReceiveExclusiveChange", "1:219:1.75", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"notifyReceiveExclusiveChange", (Object)((Object)e2));
                }
                throw e2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveExclusiveChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerKey attachConsumerPoint(ConsumerPoint consumerPoint, SelectionCriteria criteria, SIBUuid12 connectionUuid, boolean readAhead, boolean forwardScanning, JSConsumerSet consumerSet) throws SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"attachConsumerPoint", (Object)new Object[]{consumerPoint, criteria, connectionUuid, new Boolean(readAhead), new Boolean(forwardScanning), consumerSet});
        }
        ConsumerKey returnKey = null;
        int chances = 5;
        boolean repeat = true;
        while (repeat) {
            repeat = false;
            LinkedList linkedList = this.consumerPoints;
            synchronized (linkedList) {
                if (!this._currentReachability) {
                    SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0471", new Object[]{this.getDestName(), SIMPUtils.getMENameFromUuid(this.getLocalisationUuid().toString())}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)((Object)e));
                    }
                    throw e;
                }
                if (this._cardinalityOne) {
                    if (this.consumerPoints.size() != 0) {
                        SIResourceException e = new SIResourceException(nls.getFormattedMessage("CONSUMERCARDINALITY_LIMIT_REACHED_CWSIP0472", new Object[]{this.getDestName(), this.getLocalisationUuid().toString()}, null));
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)((Object)e));
                        }
                        throw e;
                    }
                } else if (this._cardinalityChange || this._forceFlushInProgress) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Unable to attach at this point " + this._cardinalityChange + ":" + this._forceFlushInProgress));
                    }
                    repeat = true;
                }
                long responseTimeout = 0L;
                responseTimeout = consumerPoint.isGatheringConsumer() ? 10000L : 300000L;
                if (this._aih.consumerAttaching(responseTimeout)) {
                    returnKey = super.attachConsumerPoint(consumerPoint, criteria, connectionUuid, readAhead, forwardScanning, consumerSet);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Unable to attach at this point, flush work in progress");
                    }
                    repeat = true;
                }
                if (repeat) {
                    if (chances > 0) {
                        try {
                            this.consumerPoints.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        --chances;
                    } else {
                        SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_NOT_FLUSHED_CWSIP0512", new Object[]{this._messageProcessor.getMessagingEngineName(), this._destName}, null));
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.attachConsumerPoint", (String)"1:445:1.97.2.21", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)((Object)e));
                        }
                        throw e;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", returnKey);
        }
        return returnKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachConsumerPoint(ConsumerKey consumerKey) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        AnycastInputHandler.FlushWorkItem flushWork;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"detachConsumerPoint", (Object)consumerKey);
        }
        SIErrorException e2 = null;
        boolean cardinalityOneFlush = false;
        boolean cardinalityChangeDone = false;
        boolean forceFlushDone = false;
        try {
            LinkedList linkedList = this.consumerPoints;
            synchronized (linkedList) {
                if (this._cardinalityOne && !this._cardinalityChange) {
                    cardinalityOneFlush = true;
                }
            }
            if (cardinalityOneFlush) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"cardinalityOneFlush");
                }
                flushWork = new AnycastInputHandler.FlushWorkItem(){

                    @Override
                    public void performWorkItem() {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.entry((TraceComponent)tc, (String)"performWorkItem");
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"cardinalityOneFlush");
                        }
                        RemoteConsumerDispatcher.this._aih.rejectAll();
                        try {
                            RemoteConsumerDispatcher.this.removeAllMessagesItemStream();
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.performWorkItem", (String)"1:516:1.97.2.21", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)e);
                            throw new SIErrorException((Throwable)e);
                        }
                    }
                };
                this._aih.performFlushWork(flushWork, false);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.detachConsumerPoint", (String)"1:532:1.97.2.21", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            e2 = new SIErrorException((Throwable)e);
        }
        super.detachConsumerPoint(consumerKey);
        LinkedList e = this.consumerPoints;
        synchronized (e) {
            boolean nomoreCPs;
            boolean bl = nomoreCPs = this.consumerPoints.size() == 0;
            if (nomoreCPs) {
                if (!(this._cardinalityOne || this._cardinalityChange || this._forceFlushInProgress)) {
                    this._aih.lastCardNConsumerDetached();
                }
                if (this._cardinalityChange) {
                    cardinalityChangeDone = true;
                }
                if (this._forceFlushInProgress) {
                    forceFlushDone = true;
                }
            }
        }
        if (cardinalityChangeDone) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"cardinalityChangeDone");
            }
            flushWork = new AnycastInputHandler.FlushWorkItem(){

                @Override
                public void performWorkItem() {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"performWorkItem");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"cardinalityChangeDone");
                    }
                    try {
                        RemoteConsumerDispatcher.this.cardinalityChangeConsumersDetached();
                    }
                    catch (SIResourceException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.performWorkItem", (String)"1:594:1.97.2.21", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"performWorkItem", (Object)"SIErrorException");
                        }
                        throw new SIErrorException((Throwable)e);
                    }
                }
            };
            this._aih.performFlushWork(flushWork, false);
        }
        if (forceFlushDone) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"forceFlushDone");
            }
            flushWork = new AnycastInputHandler.FlushWorkItem(){

                @Override
                public void performWorkItem() {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"performWorkItem");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"forceFlushDone");
                    }
                    try {
                        RemoteConsumerDispatcher.this.forceFlushConsumersDetached();
                    }
                    catch (SIResourceException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.performWorkItem", (String)"1:634:1.97.2.21", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"performWorkItem", (Object)"SIErrorException");
                        }
                        throw new SIErrorException((Throwable)e);
                    }
                }
            };
            this._aih.performFlushWork(flushWork, false);
        }
        if (e2 != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"detachConsumerPoint", (Object)((Object)e2));
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachConsumerPoint");
        }
    }

    @Override
    public BrowseCursor getBrowseCursor(SelectionCriteria criteria) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrowseCursor", (Object)criteria);
            SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor");
        }
        return this._aih.newBrowseCursor(criteria);
    }

    public void put(List undeliveredMessages, boolean isRestoring) throws SIResourceException {
        AIMessageItem msg;
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)undeliveredMessages);
        }
        int length = undeliveredMessages.size();
        RemoteQPConsumerKey[] rcks = new RemoteQPConsumerKey[length];
        LocalTransaction tran = null;
        try {
            tran = this._tranManager.createLocalTransaction(true);
            for (i = 0; i < length; ++i) {
                msg = (AIMessageItem)undeliveredMessages.get(i);
                RemoteDispatchableKey dkey = msg.getAIStreamKey().getRemoteDispatchableKey();
                if (dkey instanceof RemoteQPConsumerKey) {
                    rcks[i] = (RemoteQPConsumerKey)dkey;
                }
                this.itemStream.addItem(msg, (Transaction)tran);
                this.registerForEvents(msg);
                msg.setLocalisingME(this.getLocalisationUuid());
            }
            tran.commit();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.put", (String)"1:708:1.97.2.21", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (tran != null) {
                try {
                    tran.rollback();
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.put", (String)"1:721:1.97.2.21", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e2);
                }
            }
            if (!isRestoring) {
                SIIncorrectCallException e3 = new SIIncorrectCallException(nls.getFormattedMessage("PUTEXCEPTION_DISCONNECT_CONSUMER_CWSIP0473", new Object[]{this.getDestName(), this.getLocalisationUuid().toString(), e}, null));
                this.dispatchExceptionToConsumers(e3);
                for (int i2 = 0; i2 < length; ++i2) {
                    AIMessageItem msg2 = (AIMessageItem)undeliveredMessages.get(i2);
                    AIStreamKey key = msg2.getAIStreamKey();
                    this._aih.reject(key);
                    this.resolve(key);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"put", (Object)e);
            }
            return;
        }
        for (i = 0; i < length; ++i) {
            msg = (AIMessageItem)undeliveredMessages.get(i);
            if (msg.isReserved()) {
                msg.restoreAOData(this.lockID);
            }
            if (msg.isReserved()) continue;
            if (rcks[i] != null) {
                rcks[i].messageReceived(msg.getAIStreamKey());
            }
            this.dispatchInternalAndHandleException(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchExceptionToConsumers(SIIncorrectCallException e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dispatchExceptionToConsumers", (Object)((Object)e));
        }
        Object[] clonedConsumerPoints = null;
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            clonedConsumerPoints = this.consumerPoints.toArray();
        }
        if (clonedConsumerPoints != null) {
            for (int i = 0; i < clonedConsumerPoints.length; ++i) {
                DispatchableKey ck = (DispatchableKey)clonedConsumerPoints[i];
                ck.notifyConsumerPointAboutException((SIException)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dispatchExceptionToConsumers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(AIStreamKey key) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolve", (Object)key);
        }
        RemoteQPConsumerKey ck = (RemoteQPConsumerKey)key.getRemoteDispatchableKey();
        ConsumableKey senderKey = ck.getConsumerPoint().getConsumerKey();
        boolean stillReady = false;
        boolean rckClosed = false;
        Object object = this._baseDestHandler.getReadyConsumerPointLock();
        synchronized (object) {
            if (ck.isKeyReady()) {
                stillReady = true;
            } else if (senderKey.isKeyReady()) {
                rckClosed = true;
                stillReady = true;
            } else {
                ck.completedReceivedNoPrefetch(key, false);
            }
        }
        if (!stillReady) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"resolve");
            }
            return;
        }
        if (!rckClosed) {
            ck.completedReceived(key, true);
        } else {
            ck.completedReceived(key, false);
            if (key.getOriginalTimeout() == -1L) {
                senderKey.waiting(key.getOriginalTimeout(), false);
            } else {
                long timeoutTime;
                long currTime = System.currentTimeMillis();
                long expectedResponseTime = currTime + this._aih.getRoundTripTime();
                if (expectedResponseTime < (timeoutTime = key.getIssueTime() + key.getOriginalTimeout())) {
                    senderKey.waiting(timeoutTime - currTime, false);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resolve");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reachabilityChange(boolean reachable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reachabilityChange", (Object)reachable);
        }
        Object[] clonedConsumerPoints = null;
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            if (this._currentReachability && !reachable) {
                clonedConsumerPoints = this.consumerPoints.toArray();
            }
            this._currentReachability = reachable;
        }
        if (clonedConsumerPoints != null) {
            SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0471", new Object[]{this.getDestName(), SIMPUtils.getMENameFromUuid(this.getLocalisationUuid().toString())}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            for (int i = 0; i < clonedConsumerPoints.length; ++i) {
                DispatchableKey ck = (DispatchableKey)clonedConsumerPoints[i];
                ck.getConsumerPoint().implicitClose(null, (SIException)((Object)e), this._aih.getLocalisationUuid());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reachabilityChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectCardOneConsumer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"disconnectCardOneConsumer");
        }
        Object[] clonedConsumerPoints = null;
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            clonedConsumerPoints = this.consumerPoints.toArray();
        }
        SILimitExceededException e = new SILimitExceededException(nls.getFormattedMessage("CONSUMERCARDINALITY_LIMIT_REACHED_CWSIP0472", new Object[]{this.getDestName(), this.getLocalisationUuid().toString()}, null));
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.disconnectCardOneConsumer", (String)"1:945:1.97.2.21", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)e);
        for (int i = 0; i < clonedConsumerPoints.length; ++i) {
            DispatchableKey ck = (DispatchableKey)clonedConsumerPoints[i];
            ck.notifyConsumerPointAboutException((SIException)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"disconnectCardOneConsumer");
        }
    }

    @Override
    protected DispatchableKey createConsumerKey(DispatchableConsumerPoint consumerPoint, SelectionCriteria criteria, SIBUuid12 connectionUuid, boolean readAhead, boolean forwardScanning, JSConsumerSet consumerSet) throws SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerKey", (Object)new Object[]{consumerPoint, criteria, connectionUuid, new Boolean(readAhead), new Boolean(forwardScanning), consumerSet});
        }
        RemoteQPConsumerKey consKey = new RemoteQPConsumerKey(consumerPoint, this, criteria, connectionUuid, readAhead, forwardScanning);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerKey", (Object)consKey);
        }
        return consKey;
    }

    @Override
    protected JSKeyGroup createConsumerKeyGroup(JSConsumerSet consumerSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerKeyGroup", (Object)consumerSet);
        }
        RemoteQPConsumerKeyGroup ckg = new RemoteQPConsumerKeyGroup(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerKeyGroup", (Object)ckg);
        }
        return ckg;
    }

    public RemoteConsumerDispatcher getResolvedDurableCD(RemoteConsumerDispatcher rcd) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getResolvedDurableCD", (Object)rcd);
        }
        RemoteConsumerDispatcher returnedRCD = this._aih.getResolvedDurableCD(rcd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getResolvedDurableCD", (Object)returnedRCD);
        }
        return returnedRCD;
    }

    @Override
    protected void eventPostCommitAdd(SIMPMessage msg, TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)new Object[]{msg, transaction});
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    @Override
    protected void eventUnlocked(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventUnlocked", (Object)msg);
        }
        AIMessageItem message = (AIMessageItem)msg;
        this.dispatchInternalAndHandleException(message);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    @Override
    protected void eventPreUnlocked(SIMPMessage msg, TransactionCommon tran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPreUnlocked", (Object)new Object[]{msg, tran});
        }
        if (msg.guessRedeliveredCount() + 1 >= this._baseDestHandler.getMaxFailedDeliveries()) {
            boolean tranCreated = false;
            if (tran == null) {
                tran = this._tranManager.createLocalTransaction(false);
                tranCreated = true;
            }
            ((AIMessageItem)msg).setRejectTransactionID(tran.getPersistentTranId());
            this._aih.incrementUnlockCount(msg.getMessage().getGuaranteedRemoteGetValueTick());
            try {
                if (msg.isInStore()) {
                    Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(tran);
                    msg.remove(msTran, msg.getLockID());
                }
                if (tranCreated) {
                    ((LocalTransaction)tran).commit();
                }
                msg.setRedeliveryCountReached();
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.eventPreUnlocked", (String)"1:1090:1.97.2.21", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.eventPreUnlocked", (String)"1:1102:1.97.2.21", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPreUnlocked");
        }
    }

    private final void dispatchInternalAndHandleException(AIMessageItem msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dispatchInternalAndHandleException", (Object)msg);
        }
        try {
            this.dispatchInternal(msg);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.dispatchInternalAndHandleException", (String)"1:1126:1.97.2.21", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.dispatchInternalAndHandleException", (String)"1:1135:1.97.2.21", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dispatchInternalAndHandleException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchInternal(AIMessageItem msg) throws SIException, MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dispatchInternal", (Object)msg);
        }
        RemoteDispatchableKey dkey = msg.getAIStreamKey().getRemoteDispatchableKey();
        RemoteQPConsumerKey readyConsumer = null;
        if (dkey instanceof RemoteQPConsumerKey) {
            readyConsumer = (RemoteQPConsumerKey)dkey;
        }
        if (readyConsumer != null) {
            Object object = this._baseDestHandler.getReadyConsumerPointLock();
            synchronized (object) {
                if (!readyConsumer.isKeyReady()) {
                    readyConsumer = null;
                } else {
                    readyConsumer.markNotReady();
                    dkey = (RemoteDispatchableKey)readyConsumer.getParent();
                    this.removeReadyConsumer(dkey, !dkey.hasNonSpecificConsumers());
                }
            }
        }
        boolean accepted = false;
        if (readyConsumer != null) {
            if (this.dispatcherState.isNoLocal() && readyConsumer.getConnectionUuid().equals((Object)msg.getProducerConnectionUuid())) {
                accepted = true;
                if (msg.lockItemIfAvailable(this.lockID)) {
                    LocalTransaction tran = null;
                    tran = this._tranManager.createLocalTransaction(true);
                    msg.remove((Transaction)tran, this.lockID);
                    tran.commit();
                }
                ((JSLocalConsumerPoint)readyConsumer.consumerPoint).waitingNotify();
            } else {
                readyConsumer.updateLastNotReadyTime();
                accepted = readyConsumer.consumerPoint.put(msg, true);
            }
        }
        if (!accepted) {
            readyConsumer = null;
            boolean continueSearch = true;
            boolean newMatchRequired = false;
            MatchingConsumerPoint[] matchResults = null;
            int index = 0;
            int startPoint = 0;
            boolean grabCurrentReadyVersion = true;
            long newestReadyVersion = 0L;
            while (continueSearch) {
                if (newMatchRequired) {
                    MessageProcessorSearchResults searchResults = (MessageProcessorSearchResults)this._messageProcessor.getSearchResultsObjectPool().remove();
                    JsMessage searchMsg = msg.getMessage();
                    int redelCount = msg.guessRedeliveredCount();
                    if (redelCount > 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Set deliverycount into message: " + redelCount));
                        }
                        searchMsg.setDeliveryCount(redelCount);
                    }
                    this._messageProcessor.getMessageProcessorMatching().retrieveMatchingConsumerPoints(this._baseDestHandler.getUuid(), this.getUuid(), searchMsg, searchResults);
                    Object[] allResults = searchResults.getResults(this._baseDestHandler.getName());
                    Set matchSet = (Set)allResults[2];
                    matchResults = matchSet.toArray(new MatchingConsumerPoint[0]);
                    int resultSize = matchResults.length;
                    if (resultSize <= 0) break;
                    index = startPoint = msg.getProducerSeed() % resultSize;
                    newMatchRequired = false;
                }
                Object object = this._baseDestHandler.getReadyConsumerPointLock();
                synchronized (object) {
                    if (grabCurrentReadyVersion) {
                        newestReadyVersion = this.readyConsumerVersion;
                        grabCurrentReadyVersion = false;
                    }
                    if (matchResults == null) {
                        dkey = (RemoteDispatchableKey)((Object)this.nonSpecificReadyCPs.getFirst());
                        readyConsumer = null;
                        if (dkey != null && dkey.getVersion() > newestReadyVersion) {
                            dkey = null;
                        }
                        if (dkey == null) {
                            newMatchRequired = true;
                        } else {
                            readyConsumer = (RemoteQPConsumerKey)dkey.resolvedKey();
                        }
                    } else {
                        readyConsumer = null;
                        while (readyConsumer == null) {
                            DispatchableKey ck = matchResults[index].getConsumerPointData();
                            if (ck.isKeyReady() && ck.getVersion() <= newestReadyVersion && ck instanceof RemoteDispatchableKey) {
                                readyConsumer = (RemoteQPConsumerKey)ck;
                                continue;
                            }
                            if ((index = (index + 1) % matchResults.length) != startPoint) continue;
                            break;
                        }
                        if (readyConsumer == null) {
                            continueSearch = false;
                        }
                    }
                    if (readyConsumer != null) {
                        readyConsumer.markNotReady();
                        dkey = (RemoteDispatchableKey)readyConsumer.getParent();
                        this.removeReadyConsumer(dkey, !dkey.hasNonSpecificConsumers());
                    }
                }
                if (readyConsumer == null) continue;
                readyConsumer.updateLastNotReadyTime();
                accepted = readyConsumer.consumerPoint.put(msg, true);
                continueSearch = !accepted;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dispatchInternal");
        }
    }

    public final long getRoundTripTime() {
        return this._aih.getRoundTripTime();
    }

    public final AIStreamKey issueGet(SelectionCriteria[] criterias, long timeout, RemoteDispatchableKey ck, RefillKey refillCallback) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"issueGet", (Object)new Object[]{criterias, timeout, ck});
        }
        AIStreamKey key = this._aih.issueGet(criterias, timeout, ck, null, refillCallback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueGet");
        }
        return key;
    }

    public final AIStreamKey[] issueGet(SelectionCriteria[] criterias, int count, RemoteDispatchableKey ck) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"issueGet", (Object)new Object[]{criterias, count, ck});
        }
        AIStreamKey[] aikeys = this._aih.issueGet(criterias, count, ck);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)aikeys);
        }
        return aikeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRejectTimeout() {
        boolean localCardinalityOne;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRejectTimeout");
        }
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            localCardinalityOne = this._cardinalityOne;
        }
        if (localCardinalityOne) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRejectTimeout", (Object)new Long(-2L));
            }
            return -2L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRejectTimeout", (Object)new Long(this._messageProcessor.getCustomProperties().get_unlocked_reject_interval()));
        }
        return this._messageProcessor.getCustomProperties().get_unlocked_reject_interval();
    }

    public AnycastInputHandler getAnycastInputHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastInputHandler");
            SibTr.exit((TraceComponent)tc, (String)"getAnycastInputHandler", (Object)new Object[]{this._aih});
        }
        return this._aih;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cardinalityChangeConsumersDetached() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cardinalityChangeConsumersDetached");
        }
        this._aih.rejectAll();
        this.removeAllMessagesItemStream();
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            this._cardinalityChange = false;
            this._aih.changeReceiveExclusive(this._cardinalityOne);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cardinalityChangeConsumersDetached");
        }
    }

    private void removeAllMessagesItemStream() throws SIResourceException {
        block15: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"removeAllMessagesItemStream");
            }
            try {
                LocalTransaction tran = this._tranManager.createLocalTransaction(true);
                LockingCursor cursor = this.itemStream.newLockingItemCursor(null);
                AbstractItem item = null;
                PersistentTranId tranId = tran.getPersistentTranId();
                while ((item = cursor.next()) != null) {
                    ((AIMessageItem)item).setRejectTransactionID(tranId);
                    item.remove((Transaction)tran, item.getLockID());
                }
                tran.commit();
                cursor.finished();
                Statistics stats = this.itemStream.getStatistics();
                long expiringItems = stats.getExpiringItemCount();
                long items = stats.getTotalItemCount();
                if (items == 0L) break block15;
                for (int count = 0; expiringItems > 0L && count < 20; ++count) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    expiringItems = stats.getExpiringItemCount();
                }
                if (expiringItems > 0L || stats.getTotalItemCount() > 0L) {
                    String statTxt = stats.getTotalItemCount() + ":" + stats.getAddingItemCount() + ":" + stats.getAvailableItemCount() + ":" + stats.getExpiringItemCount() + ":" + stats.getLockedItemCount() + ":" + stats.getRemovingItemCount() + ":" + stats.getUnavailableItemCount() + ":" + stats.getUnavailableItemCount();
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.removeAllMessagesItemStream", "1:1525:1.97.2.21", statTxt}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.removeAllMessagesItemStream", (String)"1:1531:1.97.2.21", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SIResourceException e2 = new SIResourceException((Throwable)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"removeAllMessagesItemStream", (Object)((Object)e2));
                    }
                    throw e2;
                }
            }
            catch (MessageStoreException e) {
                SIResourceException e2 = new SIResourceException((Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeAllMessagesItemStream", (Object)((Object)e2));
                }
                throw e2;
            }
            catch (SIIncorrectCallException e) {
                SIResourceException e2 = new SIResourceException((Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeAllMessagesItemStream", (Object)((Object)e2));
                }
                throw e2;
            }
            catch (SIConnectionLostException e) {
                SIResourceException e2 = new SIResourceException((Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeAllMessagesItemStream", (Object)((Object)e2));
                }
                throw e2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAllMessagesItemStream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConsumersForFlush() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeAllConsumersForFlush");
        }
        boolean notifyConsumers = true;
        Object[] clonedConsumerPoints = null;
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            this._forceFlushInProgress = true;
            if (this.consumerPoints.size() == 0) {
                notifyConsumers = false;
            } else {
                clonedConsumerPoints = this.consumerPoints.toArray();
            }
        }
        if (notifyConsumers) {
            SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0471", new Object[]{this.getDestName(), SIMPUtils.getMENameFromUuid(this.getLocalisationUuid().toString())}, null));
            for (int i = 0; i < clonedConsumerPoints.length; ++i) {
                DispatchableKey ck = (DispatchableKey)clonedConsumerPoints[i];
                ck.getConsumerPoint().implicitClose(null, (SIException)((Object)e), this._aih.getLocalisationUuid());
            }
        } else {
            try {
                this.forceFlushConsumersDetached();
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.closeAllConsumersForFlush", (String)"1:1630:1.97.2.21", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SIErrorException e2 = new SIErrorException((Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForFlush", (Object)((Object)e2));
                }
                throw e2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceFlushConsumersDetached() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushConsumersDetached");
        }
        this._aih.rejectAll();
        this.removeAllMessagesItemStream();
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            this._forceFlushInProgress = false;
        }
        this._aih.closeAllConsumersForFlushDone();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushConsumersDetached");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNewTransactionAllowed(TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isNewTransactionAllowed", (Object)transaction);
        }
        boolean allowed = true;
        Object object = this.orderLock;
        synchronized (object) {
            if (this.streamHasInDoubtRemoves) {
                if (this._aih.getAIProtocolStream() != null) {
                    this.currentTran = this._aih.getAIProtocolStream().getOrderedActiveTran();
                }
                if (this.currentTran == null) {
                    this.streamHasInDoubtRemoves = false;
                }
            }
            if (!(this.currentTran == null || transaction != null && this.currentTran.equals((Object)transaction.getPersistentTranId()))) {
                allowed = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isNewTransactionAllowed", (Object)new Boolean(allowed));
        }
        return allowed;
    }

    public synchronized void setPendingDelete(boolean delete) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPendingDelete", (Object)delete);
        }
        this._pendingDelete = delete;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setPendingDelete");
        }
    }

    public synchronized boolean getPendingDelete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPendingDelete");
            SibTr.exit((TraceComponent)tc, (String)"getPendingDelete", (Object)this._pendingDelete);
        }
        return this._pendingDelete;
    }
}

