/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.DeliveryDelayDeleteFilter;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MessageReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class SubscriptionItemStream
extends MessageReferenceStream
implements MessageEventListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int BATCH_DELETE_SIZE = 10;
    private static final TraceComponent tc = SibTr.register(SubscriptionItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ConsumerDispatcher consumerDispatcher = null;
    private boolean unableToOrder = false;
    private PersistentTranId currentTranId = null;
    protected boolean toBeDeleted = false;
    private DestinationHandler destinationHandler = null;
    private boolean removingAvailableReferences = false;
    private final LockManager _subscriptionLockManager = new LockManager();
    private volatile boolean _blocked = false;

    public SubscriptionItemStream() {
    }

    public SubscriptionItemStream(PubSubMessageItemStream parentItemStream, SIMPTransactionManager txManager) throws OutOfCacheSpace, MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SubscriptionItemStream", (Object)new Object[]{parentItemStream, txManager});
        }
        this.setStorageStrategy(2);
        ExternalAutoCommitTransaction transaction = txManager.createAutoCommitTransaction();
        parentItemStream.addReferenceStream(this, (Transaction)transaction);
        parentItemStream.incrementReferenceStreamCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SubscriptionItemStream", (Object)this);
        }
    }

    public void setConsumerDispatcher(ConsumerDispatcher consumerDispatcher) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setConsumerDispatcher", (Object)consumerDispatcher);
        }
        this.consumerDispatcher = consumerDispatcher;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setConsumerDispatcher");
        }
    }

    public ConsumerDispatcher getConsumerDispatcher() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerDispatcher");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerDispatcher", (Object)this.consumerDispatcher);
        }
        return this.consumerDispatcher;
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        if (this.consumerDispatcher != null) {
            writer.newLine();
            writer.taggedValue("consumerDispatcher", (Object)this.consumerDispatcher.toString());
        }
    }

    @Override
    public void registerForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents");
        }
        msg.registerMessageEventListener(3, this);
        msg.registerMessageEventListener(5, this);
        msg.registerMessageEventListener(2, this);
        msg.registerMessageEventListener(4, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    @Override
    public void messageEventOccurred(int event, SIMPMessage msg, TransactionCommon tran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(event), msg, tran});
        }
        switch (event) {
            case 3: 
            case 5: 
            case 6: {
                if (this.currentTranId != null) {
                    this.currentTranId = null;
                    break;
                }
            }
            case 2: 
            case 4: {
                this.deleteIfPossible(true);
                break;
            }
            default: {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:241:1.54"}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.messageEventOccurred", (String)"1:247:1.54", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:254:1.54"});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIfPossible(boolean startAsynchThread) {
        block34: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteIfPossible", (Object)new Boolean(startAsynchThread));
            }
            this._subscriptionLockManager.lockExclusive();
            try {
                if (this.destinationHandler == null) {
                    PubSubMessageItemStream mis = (PubSubMessageItemStream)this.getItemStream();
                    this.destinationHandler = (DestinationHandler)mis.getItemStream();
                }
                if (!this.toBeDeleted && !this.destinationHandler.isToBeDeleted()) break block34;
                SIMPTransactionManager txManager = this.destinationHandler.getTxManager();
                boolean complete = false;
                try {
                    long countOfTotalItems;
                    Statistics statistics = null;
                    try {
                        statistics = this.getStatistics();
                    }
                    catch (NotInMessageStore e) {
                        complete = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"deleteIfPossible", (Object)"Subscription already deleted");
                        }
                        if (!complete) {
                            this.destinationHandler.getDestinationManager().addSubscriptionToDelete(this);
                            if (startAsynchThread) {
                                this.destinationHandler.getDestinationManager().startAsynchDeletion();
                            }
                        }
                        this._subscriptionLockManager.unlockExclusive();
                        return;
                    }
                    long countOfAvailableItems = statistics.getAvailableItemCount();
                    long countOfLockedMessages = statistics.getLockedItemCount();
                    if (countOfAvailableItems > 0L || countOfLockedMessages > 0L) {
                        try {
                            this.removeAllAvailableReferences();
                        }
                        catch (SIResourceException e1) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"deleteIfPossible", (Object)((Object)e1));
                            }
                            if (!complete) {
                                this.destinationHandler.getDestinationManager().addSubscriptionToDelete(this);
                                if (startAsynchThread) {
                                    this.destinationHandler.getDestinationManager().startAsynchDeletion();
                                }
                            }
                            this._subscriptionLockManager.unlockExclusive();
                            return;
                        }
                    }
                    if ((countOfTotalItems = (statistics = this.getStatistics()).getTotalItemCount()) == 0L) {
                        if (this.destinationHandler.isToBeDeleted()) {
                            this.destinationHandler.getDestinationManager().markDestinationAsCleanUpPending(this.destinationHandler);
                        }
                        try {
                            PubSubMessageItemStream parentItemStream = (PubSubMessageItemStream)this.getItemStream();
                            this.remove((Transaction)txManager.createAutoCommitTransaction(), -2L);
                            parentItemStream.decrementReferenceStreamCount();
                            complete = true;
                        }
                        catch (MessageStoreException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.deleteIfPossible", (String)"1:364:1.54", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:371:1.54", e});
                        }
                    }
                }
                catch (Exception e) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
                finally {
                    if (!complete) {
                        this.destinationHandler.getDestinationManager().addSubscriptionToDelete(this);
                        if (startAsynchThread) {
                            this.destinationHandler.getDestinationManager().startAsynchDeletion();
                        }
                    }
                }
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.deleteIfPossible", (String)"1:400:1.54", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:407:1.54", e});
            }
            finally {
                this._subscriptionLockManager.unlockExclusive();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteIfPossible");
        }
    }

    public boolean isToBeDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isToBeDeleted");
            SibTr.exit((TraceComponent)tc, (String)"isToBeDeleted", (Object)this.toBeDeleted);
        }
        return this.toBeDeleted;
    }

    public void markAsToBeDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markAsToBeDeleted");
        }
        this.toBeDeleted = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markAsToBeDeleted");
        }
    }

    public void removeAllAvailableReferences() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAllAvailableReferences");
        }
        LocalTransaction transaction = null;
        ItemReference itemReference = null;
        try {
            PubSubMessageItemStream mis = (PubSubMessageItemStream)this.getItemStream();
            DestinationHandler dh = (DestinationHandler)mis.getItemStream();
            SIMPTransactionManager txManager = dh.getTxManager();
            this.removingAvailableReferences = true;
            if (txManager != null) {
                transaction = txManager.createLocalTransaction(true);
                int countOfItems = 0;
                while (true) {
                    if ((itemReference = this.removeFirstMatching((Filter)new DeliveryDelayDeleteFilter(), (Transaction)transaction)) != null) {
                        ++countOfItems;
                    }
                    if (itemReference != null && countOfItems < 10) continue;
                    if (countOfItems > 0) {
                        transaction.commit();
                        if (itemReference != null) {
                            transaction = txManager.createLocalTransaction(true);
                        }
                        countOfItems = 0;
                    }
                    if (itemReference == null) break;
                }
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.removeAllAvailableReferences", (String)"1:509:1.54", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:516:1.54", e});
            if (transaction != null) {
                this.handleRollback(transaction);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeAllAvailableReferences");
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:530:1.54", e}, null), (Throwable)e);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.removeAllAvailableReferences", (String)"1:540:1.54", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:547:1.54", e});
            if (transaction != null) {
                this.handleRollback(transaction);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeAllAvailableReferences");
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:561:1.54", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAllAvailableReferences");
        }
    }

    private void handleRollback(LocalTransaction transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)transaction);
        }
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.handleRollback", (String)"1:594:1.54", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    @Override
    public void registerListeners(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerListeners", (Object)msg);
        }
        if (!this.removingAvailableReferences) {
            this.consumerDispatcher.registerForEvents(msg);
            this.registerForEvents(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerListeners");
        }
    }

    public void registerForEventsPostAddItem(SIMPMessage msg) {
    }

    public LockManager getSubscriptionLockManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionLockManager");
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionLockManager", (Object)this._subscriptionLockManager);
        }
        return this._subscriptionLockManager;
    }

    @Override
    public void setCurrentTransaction(SIMPMessage msg, boolean isInDoubtOnRemoteConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCurrentTransaction", (Object)new Object[]{msg, isInDoubtOnRemoteConsumer});
        }
        if (this.currentTranId != null && !msg.getTransactionId().equals((Object)this.currentTranId)) {
            this.unableToOrder = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unable to order. Transaction: " + msg.getTransactionId() + " Current:" + this.currentTranId));
            }
        } else {
            this.currentTranId = msg.getTransactionId();
        }
        if (isInDoubtOnRemoteConsumer) {
            msg.registerMessageEventListener(6, this);
            msg.registerMessageEventListener(3, this);
        } else {
            msg.registerMessageEventListener(3, this);
            msg.registerMessageEventListener(5, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCurrentTransaction");
        }
    }

    public PersistentTranId getOrderedActiveTran() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOrderedActiveTran");
            SibTr.exit((TraceComponent)tc, (String)"getOrderedActiveTran", (Object)this.currentTranId);
        }
        return this.currentTranId;
    }

    public boolean isUnableToOrder() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isUnableToOrder");
            SibTr.exit((TraceComponent)tc, (String)"isUnableToOrder", (Object)this.unableToOrder);
        }
        return this.unableToOrder;
    }

    public void setBlocked(boolean blocked) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBlocked", (Object)new Object[]{blocked, this._blocked});
        }
        this._blocked = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBlocked");
        }
    }

    public boolean isBlocked() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isBlocked");
            SibTr.exit((TraceComponent)tc, (String)"isBlocked", (Object)this._blocked);
        }
        return this._blocked;
    }
}

