/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.io;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAccept;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlDecisionExpected;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlReject;
import com.ibm.ws.sib.mfp.control.ControlRequest;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.DurableInputHandler;
import com.ibm.ws.sib.processor.impl.DurableOutputHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.statemodel.State;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.io.MPIO;
import com.ibm.ws.sib.processor.io.MPIOMsgDebug;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;

public final class RemoteMessageReceiver {
    private static final TraceComponent tc = SibTr.register(RemoteMessageReceiver.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private MessageProcessor _messageProcessor;
    private DestinationManager _destinationManager;
    private SIMPTransactionManager _txManager;
    private SIBUuid8 _localMEUuid;
    private SIBUuid8 _localBus;
    private String _localBusName;
    private MPIO _mpio;

    RemoteMessageReceiver(MessageProcessor messageProcessor, MPIO mpio) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteMessageReceiver", (Object)new Object[]{messageProcessor, mpio});
        }
        this._messageProcessor = messageProcessor;
        this._mpio = mpio;
        this.init();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteMessageReceiver", (Object)this);
        }
    }

    protected void init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"init");
        }
        this._destinationManager = this._messageProcessor.getDestinationManager();
        this._txManager = this._messageProcessor.getTXManager();
        this._localMEUuid = this._messageProcessor.getMessagingEngineUuid();
        this._localBus = this._messageProcessor.getMessagingEngineBusUuid();
        this._localBusName = this._messageProcessor.getMessagingEngineBus();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"init");
        }
    }

    void receiveMessage(AbstractMessage aMessage) {
        block40: {
            SIBUuid8 targetMEUuid;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"receiveMessage", (Object)new Object[]{aMessage});
            }
            if ((targetMEUuid = aMessage.getGuaranteedTargetMessagingEngineUUID()) == null) {
                targetMEUuid = this._localMEUuid;
            }
            SIBUuid8 sourceMEUuid = aMessage.getGuaranteedSourceMessagingEngineUUID();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("localMEUuid     : " + this._localMEUuid));
                SibTr.debug((TraceComponent)tc, (String)("localBus         : " + this._localBus));
                MPIOMsgDebug.debug(tc, aMessage, -1);
            }
            if (targetMEUuid.equals((Object)this._localMEUuid)) {
                DestinationHandler dest = null;
                String destId = null;
                SIBUuid8 sourceBusUUID = aMessage.getGuaranteedCrossBusSourceBusUUID();
                if (sourceBusUUID != null && !sourceBusUUID.equals((Object)this._localBus)) {
                    dest = this._destinationManager.getLink(aMessage.getGuaranteedCrossBusLinkName());
                    if (dest == null) {
                        SibTr.error((TraceComponent)tc, (String)"LINK_NOT_FOUND_ERROR_CWSIP0041", (Object)new Object[]{aMessage.getGuaranteedCrossBusLinkName(), this._messageProcessor.getMessagingEngineName()});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"receiveMessage");
                        }
                        return;
                    }
                } else {
                    try {
                        JsDestinationAddress routingDestination = aMessage.getRoutingDestination();
                        if (routingDestination != null && (this._localBusName.equals(routingDestination.getBusName()) || routingDestination.getBusName() == null)) {
                            destId = routingDestination.getDestinationName();
                            if (destId.startsWith("_T") || destId.startsWith("_Q")) {
                                dest = this._destinationManager.getDestination(this._messageProcessor.getTDReceiverAddr(), false);
                            } else if (destId.startsWith("_P")) {
                                dest = this._destinationManager.getDestination(destId, false);
                            } else {
                                SIBUuid12 destID = aMessage.getGuaranteedTargetDestinationDefinitionUUID();
                                if (destID != null) {
                                    destId = destID.toString();
                                }
                                dest = this._destinationManager.getDestinationInternal(destID, true);
                            }
                        } else {
                            SIBUuid12 destID = aMessage.getGuaranteedTargetDestinationDefinitionUUID();
                            if (destID != null) {
                                destId = destID.toString();
                            }
                            if (aMessage.isControlMessage()) {
                                ProtocolType msgType = aMessage.getGuaranteedProtocolType();
                                if (msgType == ProtocolType.DURABLEINPUT) {
                                    DurableInputHandler.staticHandleControlMessage((ControlMessage)aMessage);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        SibTr.exit((TraceComponent)tc, (String)"receiveMessage");
                                    }
                                    return;
                                }
                                if (msgType == ProtocolType.DURABLEOUTPUT) {
                                    DurableOutputHandler.staticHandleControlMessage((ControlMessage)aMessage, this._destinationManager, this._messageProcessor);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        SibTr.exit((TraceComponent)tc, (String)"receiveMessage");
                                    }
                                    return;
                                }
                            }
                            dest = this._destinationManager.getDestinationInternal(destID, true);
                        }
                    }
                    catch (SINotPossibleInCurrentConfigurationException e) {
                        dest = null;
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.io.RemoteMessageReceiver.receiveMessage", (String)"1:296:1.120", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.io.RemoteMessageReceiver.receiveMessage", "1:305:1.120"});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"receiveMessage");
                        }
                        return;
                    }
                    if (!aMessage.isControlMessage()) {
                        this.traceApiMessage((JsMessage)aMessage, dest);
                    }
                    if (dest == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Message received for unknown destination");
                        }
                        if (aMessage.isControlMessage()) {
                            this.processUnknownControlMessage((ControlMessage)aMessage);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"receiveMessage");
                        }
                        return;
                    }
                }
                try {
                    State state = dest.isLink() ? this._destinationManager.getLinkIndex().getState(dest) : this._destinationManager.getDestinationIndex().getState(dest);
                    if (state == null || !state.isCreateInProgress()) {
                        if (aMessage.isControlMessage()) {
                            this.processControlMessage((ControlMessage)aMessage, sourceMEUuid, targetMEUuid, dest, state);
                        } else {
                            this.processJsMessage((JsMessage)aMessage, sourceMEUuid, targetMEUuid, dest, state);
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Message received for destination or link currently being created", (Object)dest);
                    }
                    break block40;
                }
                catch (SIException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    break block40;
                }
            }
            this.forwardMessage(aMessage, targetMEUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"receiveMessage");
        }
    }

    private void traceApiMessage(JsMessage msg, DestinationHandler dest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"traceApiMessage", (Object)new Object[]{msg, dest});
        }
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled() && msg.isApiMessage()) {
            String destName = null;
            String text = "INBOUND_MESSAGE_RECEIVED_CWSJU0020";
            if (dest != null && ((destName = dest.getName()).startsWith("_Q") || destName.startsWith("_T"))) {
                text = "INBOUND_MESSAGE_RECEIVED_TEMP_CWSJU0120";
            }
            String apiMsgId = null;
            String correlationId = null;
            if (msg instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)msg).getApiMessageId();
                correlationId = ((JsApiMessage)msg).getCorrelationId();
            } else {
                if (msg.getApiMessageIdAsBytes() != null) {
                    apiMsgId = new String(msg.getApiMessageIdAsBytes());
                }
                if (msg.getCorrelationIdAsBytes() != null) {
                    correlationId = new String(msg.getCorrelationIdAsBytes());
                }
            }
            SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage(text, new Object[]{apiMsgId, msg.getSystemMessageId(), correlationId, msg.getSystemMessageSourceUuid(), destName}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"traceApiMessage");
        }
    }

    private void processUnknownControlMessage(ControlMessage ctlMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processUnknownControlMessage", (Object)new Object[]{ctlMsg});
        }
        if (ctlMsg.getGuaranteedProtocolType().equals(ProtocolType.ANYCASTINPUT) && ctlMsg instanceof ControlDecisionExpected) {
            ControlDecisionExpected cde = (ControlDecisionExpected)ctlMsg;
            SIBUuid8 remoteUuid = cde.getGuaranteedSourceMessagingEngineUUID();
            String meName = JsAdminUtils.getMENameByUuid((String)remoteUuid.toString());
            if (meName == null) {
                meName = remoteUuid.toString();
            }
            SibTr.warning((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"UNEXPECTED_MESSAGE_RECEIVED_CWSIP0784", (Object)new Object[]{cde.getGuaranteedGatheringTargetUUID(), meName, cde.getTick(), this._messageProcessor.getMessagingEngineName()});
        }
        if (ctlMsg instanceof ControlAreYouFlushed || ctlMsg instanceof ControlAccept || ctlMsg instanceof ControlReject || ctlMsg instanceof ControlRequest) {
            ProtocolType pt = ctlMsg.getGuaranteedProtocolType();
            ControlFlushed flushedMsg = null;
            if (pt.equals(ProtocolType.ANYCASTOUTPUT)) {
                pt = ProtocolType.ANYCASTINPUT;
            } else if (pt.equals(ProtocolType.UNICASTOUTPUT)) {
                pt = ProtocolType.UNICASTINPUT;
            } else if (pt.equals(ProtocolType.PUBSUBOUTPUT)) {
                pt = ProtocolType.PUBSUBINPUT;
            }
            try {
                flushedMsg = MessageProcessor.getControlMessageFactory().createNewControlFlushed();
            }
            catch (MessageCreateFailedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.io.RemoteMessageReceiver.processUnknownControlMessage", (String)"1:520:1.120", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.exit((TraceComponent)tc, (String)"processUnknownControlMessage", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.io.RemoteMessageReceiver", "1:534:1.120", e});
            }
            SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)flushedMsg, this._messageProcessor.getMessagingEngineUuid(), ctlMsg.getGuaranteedSourceMessagingEngineUUID(), ctlMsg.getGuaranteedStreamUUID(), null, ctlMsg.getGuaranteedTargetDestinationDefinitionUUID(), pt, GDConfig.PROTOCOL_VERSION);
            flushedMsg.setPriority(11);
            flushedMsg.setReliability(ctlMsg.getReliability());
            flushedMsg.setMediated(ctlMsg.isMediated());
            SIBUuid8 targetUuid = ctlMsg.getGuaranteedSourceMessagingEngineUUID();
            this._mpio.sendToMe(targetUuid, 11, (AbstractMessage)flushedMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processUnknownControlMessage");
        }
    }

    private void processControlMessage(ControlMessage ctlMsg, SIBUuid8 sourceMEUuid, SIBUuid8 targetMEUuid, DestinationHandler dest, State state) throws SIConnectionLostException, SIRollbackException, SIIncorrectCallException, SIResourceException {
        ControlHandler controlHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processControlMessage", (Object)new Object[]{ctlMsg, sourceMEUuid, targetMEUuid, dest, state});
        }
        if ((controlHandler = dest.getControlHandler(ctlMsg.getGuaranteedProtocolType(), sourceMEUuid, ctlMsg)) != null) {
            controlHandler.handleControlMessage(sourceMEUuid, ctlMsg);
        } else if (ctlMsg.getGuaranteedProtocolType() == ProtocolType.ANYCASTINPUT) {
            if (ctlMsg instanceof ControlDecisionExpected) {
                ControlDecisionExpected cde = (ControlDecisionExpected)ctlMsg;
                String meName = JsAdminUtils.getMENameByUuid((String)sourceMEUuid.toString());
                if (meName == null) {
                    meName = sourceMEUuid.toString();
                }
                SibTr.warning((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"UNEXPECTED_MESSAGE_RECEIVED_CWSIP0784", (Object)new Object[]{dest.getName(), meName, cde.getTick(), this._messageProcessor.getMessagingEngineName()});
            }
        } else if (dest.isToBeDeleted()) {
            this.processUnknownControlMessage(ctlMsg);
        } else {
            SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0008", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.RemoteMessageReceiver.processControlMessage", "1:636:1.120", dest.getName(), sourceMEUuid + ", " + ctlMsg.getControlMessageType() + ", " + state});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processControlMessage");
        }
    }

    private void processJsMessage(JsMessage jsMsg, SIBUuid8 sourceMEUuid, SIBUuid8 targetMEUuid, DestinationHandler dest, State state) throws SIConnectionLostException, SIRollbackException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        InputHandler handler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processJsMessage", (Object)new Object[]{jsMsg, sourceMEUuid, targetMEUuid, dest, state});
        }
        if ((handler = dest.getInputHandler(jsMsg.getGuaranteedProtocolType(), sourceMEUuid, jsMsg)) == null) {
            SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0008", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.RemoteMessageReceiver.processJsMessage", "1:712:1.120", dest.getName(), sourceMEUuid + ", " + state});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processJsMessage");
        }
    }

    private void forwardMessage(AbstractMessage aMessage, SIBUuid8 targetMEUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forwardMessage", (Object)new Object[]{aMessage, targetMEUuid});
        }
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled() && !aMessage.isControlMessage()) {
            JsMessage jsMsg = (JsMessage)aMessage;
            JsDestinationAddress routingDestination = jsMsg.getRoutingDestination();
            if (routingDestination != null) {
                String destId = routingDestination.getDestinationName();
                boolean temporary = false;
                if (destId.startsWith("_T")) {
                    temporary = true;
                }
                UserTrace.forwardJSMessage(jsMsg, targetMEUuid, destId, temporary);
            } else {
                DestinationHandler dest = this._destinationManager.getDestinationInternal(aMessage.getGuaranteedTargetDestinationDefinitionUUID(), false);
                if (dest != null) {
                    UserTrace.forwardJSMessage(jsMsg, targetMEUuid, dest.getName(), dest.isTemporary());
                } else {
                    UserTrace.forwardJSMessage(jsMsg, targetMEUuid, jsMsg.getGuaranteedTargetDestinationDefinitionUUID().toString(), false);
                }
            }
        }
        this._mpio.sendToMe(targetMEUuid, aMessage.getPriority(), aMessage);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forwardMessage");
        }
    }
}

