/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.gd.InternalOutputStreamManager;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPPubSubOutboundTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AttachedRemoteSubscriberIterator;
import com.ibm.ws.sib.processor.runtime.impl.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class RemoteTopicSpaceControl
extends AbstractRegisteredControlAdapter
implements SIMPRemoteTopicSpaceControllable {
    private static final TraceComponent tc = SibTr.register(RemoteTopicSpaceControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected PubSubOutputHandler _outputHandler;
    private AnycastInputHandler _anycastInputHandler;
    private MessageProcessor _messageProcessor;

    public RemoteTopicSpaceControl(PubSubOutputHandler outputHandler, AnycastInputHandler anycastIH, MessageProcessor messageProcessor) {
        super(messageProcessor, ControllableType.REMOTE_PUBLICATION_POINT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteTopicSpaceControl", (Object)new Object[]{outputHandler, anycastIH, messageProcessor});
        }
        this._messageProcessor = messageProcessor;
        this._outputHandler = outputHandler;
        this._anycastInputHandler = anycastIH;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteTopicSpaceControl", (Object)this);
        }
    }

    public void setAnycastInputHandler(AnycastInputHandler anycastIH) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAnycastInputHandler", (Object)anycastIH);
            SibTr.exit((TraceComponent)tc, (String)"setAnycastInputHandler");
        }
        this._anycastInputHandler = anycastIH;
    }

    public SIMPTopicSpaceControllable getTopicSpace() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpace");
        }
        String topicSpaceUuidString = this.getUuid();
        SIBUuid12 topicSpaceUuid = new SIBUuid12(topicSpaceUuidString);
        SIMPTopicSpaceControllable tsControl = (SIMPTopicSpaceControllable)this._messageProcessor.getDestinationManager().getDestinationInternal(topicSpaceUuid, false).getControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpace", (Object)tsControl);
        }
        return tsControl;
    }

    public SIMPIterator getPubSubOutboundTransmitIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubOutboundTransmitIterator");
        }
        BasicSIMPIterator iterator = null;
        if (this._outputHandler != null) {
            InternalOutputStreamManager streamManager = this._outputHandler.getInternalOutputStreamManager();
            iterator = new BasicSIMPIterator((Iterator)streamManager.getStreamSetControlIterator(this));
        }
        if (iterator == null) {
            iterator = new BasicSIMPIterator(new ArrayList().iterator());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubOutboundTransmitIterator", (Object)iterator);
        }
        return iterator;
    }

    public SIMPIterator getTopicNameIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicNameIterator");
        }
        BasicSIMPIterator itr = null;
        if (this._outputHandler != null && this._outputHandler.getTopics() != null) {
            itr = new BasicSIMPIterator(Arrays.asList(this._outputHandler.getTopics()).iterator());
        }
        if (itr == null) {
            itr = new BasicSIMPIterator(new ArrayList().iterator());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicNameIterator", (Object)itr);
        }
        return itr;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String id = this.getUuid();
        id = id + this.getRemoteEngineUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)id);
        }
        return id;
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String name = null;
        name = this._outputHandler != null ? this._outputHandler.getDestinationName() : this._anycastInputHandler.getDestName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)name);
        }
        return name;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._outputHandler == null && this._anycastInputHandler == null) {
            SIMPControllableNotFoundException e = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"RemoteTopicSpaceControl.assertValidControllable", "1:274:1.34"}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._outputHandler = null;
        this._messageProcessor = null;
        this._anycastInputHandler = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public synchronized void registerControlAdapterAsMBean() {
        super.registerControlAdapterAsMBean();
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    public String getMessagingEngineName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineName");
        }
        String meUuid = this.getRemoteEngineUuid();
        String meName = JsAdminUtils.getMENameByUuid((String)meUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineName", (Object)meName);
        }
        return meName;
    }

    @Override
    public String getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
        }
        String uuid = null;
        uuid = this._outputHandler != null ? this._outputHandler.getTopicSpaceUuid().toString() : this._anycastInputHandler.getBaseDestinationHandler().getUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)uuid);
        }
        return uuid;
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String remoteME = null;
        remoteME = this._outputHandler != null ? this._outputHandler.getTargetMEUuid().toString() : this._anycastInputHandler.getLocalisationUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)remoteME);
        }
        return remoteME;
    }

    public SIMPPubSubOutboundTransmitControllable getPubSubOutboundTransmitControllable() {
        SIMPIterator iterator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubOutboundTransmitControllable");
        }
        SIMPPubSubOutboundTransmitControllable outbound = null;
        if (this._outputHandler != null && (iterator = this.getPubSubOutboundTransmitIterator()).hasNext()) {
            outbound = (SIMPPubSubOutboundTransmitControllable)iterator.next();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubOutboundTransmitControllable", outbound);
        }
        return outbound;
    }

    public void clearTopics() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearTopics");
        }
        if (this._outputHandler != null) {
            if (this._outputHandler.getTopics() != null) {
                Iterator<String> topics = Arrays.asList(this._outputHandler.getTopics()).iterator();
                LinkedList<String> topicSpaces = new LinkedList<String>();
                LinkedList<String> topicSpaceMappings = new LinkedList<String>();
                for (int i = 0; i < this._outputHandler.getTopics().length; ++i) {
                    topicSpaces.add(this._outputHandler.getTopicSpaceUuid().toString());
                    topicSpaceMappings.add(this._outputHandler.getTopicSpaceMapping());
                }
                NeighbourProxyListener listener = this._messageProcessor.getProxyHandler().getProxyListener();
                try {
                    ExternalAutoCommitTransaction tran = this._messageProcessor.getTXManager().createAutoCommitTransaction();
                    listener.deleteProxySubscription(topics, topicSpaces.iterator(), topicSpaceMappings.iterator(), this._outputHandler.getTargetMEUuid(), this._outputHandler.getBusName(), (Transaction)tran);
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteTopicSpaceControl.clearTopics", (String)"1:456:1.34", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.RemoteTopicSpaceControl.clearTopics", "1:461:1.34", SIMPUtils.getStackTrace(e)});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("No Topics to delete for topicspace with id " + this._outputHandler.getDestinationName()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearTopics");
        }
    }

    public SIMPIterator getRemoteSubscriptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteSubscriptions");
        }
        LinkedList<AnycastInputHandler> durableConsumers = new LinkedList<AnycastInputHandler>();
        if (this._anycastInputHandler != null) {
            durableConsumers.add(this._anycastInputHandler);
        }
        AttachedRemoteSubscriberIterator remoteSubscriptionItr = new AttachedRemoteSubscriberIterator(durableConsumers);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteSubscriptions", (Object)remoteSubscriptionItr);
        }
        return remoteSubscriptionItr;
    }

    public PubSubOutputHandler getOutputHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOutputHandler");
            SibTr.exit((TraceComponent)tc, (String)"getOutputHandler", (Object)this._outputHandler);
        }
        return this._outputHandler;
    }
}

