/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1EncodableVector;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERBoolean;
import com.ibm.ws.transport.iiop.asn1.DERInteger;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERSequence;
import java.math.BigInteger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BasicConstraints
extends ASN1Encodable {
    DERBoolean cA = new DERBoolean(false);
    DERInteger pathLenConstraint = null;
    static final long serialVersionUID = 6166007723619586058L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static BasicConstraints getInstance(ASN1TaggedObject obj, boolean explicit) {
        return BasicConstraints.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static BasicConstraints getInstance(Object obj) {
        if (obj == null || obj instanceof BasicConstraints) {
            return (BasicConstraints)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new BasicConstraints((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public BasicConstraints(ASN1Sequence seq) {
        if (seq.size() == 0) {
            this.cA = null;
            this.pathLenConstraint = null;
        } else {
            this.cA = (DERBoolean)seq.getObjectAt(0);
            if (seq.size() > 1) {
                this.pathLenConstraint = (DERInteger)seq.getObjectAt(1);
            }
        }
    }

    @Deprecated
    public BasicConstraints(boolean cA, int pathLenConstraint) {
        if (cA) {
            this.cA = new DERBoolean(cA);
            this.pathLenConstraint = new DERInteger(pathLenConstraint);
        } else {
            this.cA = null;
            this.pathLenConstraint = null;
        }
    }

    public BasicConstraints(boolean cA) {
        this.cA = cA ? new DERBoolean(true) : null;
        this.pathLenConstraint = null;
    }

    public BasicConstraints(int pathLenConstraint) {
        this.cA = new DERBoolean(true);
        this.pathLenConstraint = new DERInteger(pathLenConstraint);
    }

    @Trivial
    public boolean isCA() {
        return this.cA != null && this.cA.isTrue();
    }

    public BigInteger getPathLenConstraint() {
        if (this.pathLenConstraint != null) {
            return this.pathLenConstraint.getValue();
        }
        return null;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.cA != null) {
            v.add(this.cA);
            if (this.pathLenConstraint != null) {
                v.add(this.pathLenConstraint);
            }
        }
        return new DERSequence(v);
    }

    public String toString() {
        if (this.pathLenConstraint == null) {
            if (this.cA == null) {
                return "BasicConstraints: isCa(false)";
            }
            return "BasicConstraints: isCa(" + this.isCA() + ")";
        }
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + this.pathLenConstraint.getValue();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BasicConstraints.class);
    }
}

