/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeProperty;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositePropertyContainer;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositePropertyFactory;
import com.ibm.ws.microprofile.config.archaius.impl.CachedCompositeValue;
import com.ibm.ws.microprofile.config.archaius.impl.PollingDynamicConfig;
import com.ibm.ws.microprofile.config.impl.SortedSources;
import com.ibm.ws.microprofile.config.interfaces.SourcedValue;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.exceptions.ParseException;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CompositeConfig
extends AbstractConfig
implements Closeable,
ConfigListener {
    private static final TraceComponent tc = Tr.register(CompositeConfig.class);
    private final CopyOnWriteArrayList<PollingDynamicConfig> children = new CopyOnWriteArrayList();
    private final CachedCompositePropertyFactory factory;
    static final long serialVersionUID = 6212350695691496315L;

    public CompositeConfig(SortedSources sources, Decoder decoder, ScheduledExecutorService executor, long refreshInterval) {
        this.setDecoder(decoder);
        this.factory = new CachedCompositePropertyFactory(this);
        for (ConfigSource source : sources) {
            this.addConfig(source, executor, refreshInterval);
        }
    }

    public void onConfigAdded(Config config) {
        this.notifyConfigAdded((Config)this);
    }

    public void onConfigRemoved(Config config) {
        this.notifyConfigRemoved((Config)this);
    }

    public void onConfigUpdated(Config config) {
        this.notifyConfigUpdated((Config)this);
    }

    public void onError(Throwable error, Config config) {
        this.notifyError(error, (Config)this);
    }

    private PollingDynamicConfig addConfig(ConfigSource source, ScheduledExecutorService executor, long refreshInterval) {
        PollingDynamicConfig archaiusConfig = new PollingDynamicConfig(source, executor, refreshInterval);
        this.children.add(archaiusConfig);
        archaiusConfig.setStrInterpolator(this.getStrInterpolator());
        archaiusConfig.setDecoder(this.getDecoder());
        this.notifyConfigAdded((Config)archaiusConfig);
        archaiusConfig.addListener(this);
        return archaiusConfig;
    }

    public Object getRawProperty(String key) {
        CachedCompositeValue<String> rawValue = this.getRawCompositeValue(key);
        String raw = rawValue == null ? null : rawValue.getValue();
        return raw;
    }

    public <T> List<T> getList(String key, Class<T> type) {
        for (Config config : this.children) {
            if (!config.containsKey(key)) continue;
            return config.getList(key, type);
        }
        return (List)this.notFound(key);
    }

    public List<?> getList(String key) {
        for (Config config : this.children) {
            if (!config.containsKey(key)) continue;
            return config.getList(key);
        }
        return (List)this.notFound(key);
    }

    public boolean containsKey(String key) {
        for (Config config : this.children) {
            if (!config.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        for (Config config : this.children) {
            if (config.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Iterator<String> getKeys() {
        Set<String> result = this.getKeySet();
        return result.iterator();
    }

    Set<String> getKeySet() {
        HashSet<String> result = new HashSet<String>();
        for (PollingDynamicConfig config : this.children) {
            Iterator<String> iter = config.getKeys();
            while (iter.hasNext()) {
                String key = iter.next();
                boolean added = result.add(key);
                if (!added || !TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"getKeySet", (Object[])new Object[]{"Key={0}, Source={1}", key, config.getSourceID()});
            }
        }
        return result;
    }

    public synchronized <T> T accept(Config.Visitor<T> visitor) {
        Object result = null;
        for (Config config : this.children) {
            result = config.accept(visitor);
        }
        return (T)result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (PollingDynamicConfig child : this.children) {
            sb.append(child).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<String> keyItr = this.getKeys();
        while (keyItr.hasNext()) {
            String key = keyItr.next();
            sb.append(key);
            sb.append("=");
            CachedCompositeValue<String> rawCompositeValue = this.getRawCompositeValue(key);
            if (rawCompositeValue == null) {
                sb.append("null");
            } else {
                sb.append(rawCompositeValue);
            }
            if (!keyItr.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void close() {
        for (PollingDynamicConfig child : this.children) {
            child.close();
        }
    }

    protected <T> T getTypedValue(String propertyName, Class<T> propertyType) {
        CachedCompositePropertyContainer container = this.factory.getProperty(propertyName);
        CachedCompositeProperty<T> property = container.asType(propertyType);
        T value = property.get();
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public <T> CachedCompositeValue<T> getCompositeValue(Class<T> type, String key) {
        CachedCompositeValue<String> rawProp = this.getRawCompositeValue(key);
        if (rawProp == null) {
            return null;
        }
        try {
            Object value = this.getDecoder().decode(type, rawProp.getValue());
            CachedCompositeValue<Object> composite = new CachedCompositeValue<Object>(value, rawProp.getSource());
            return composite;
        }
        catch (NumberFormatException value) {
            void nfe;
            FFDCFilter.processException((Throwable)value, (String)"com.ibm.ws.microprofile.config.archaius.impl.CompositeConfig", (String)"277", (Object)this, (Object[])new Object[]{type, key});
            throw new ParseException("Error parsing value '" + rawProp.getValue() + "' for property '" + key + "'", (Exception)nfe);
        }
    }

    private CachedCompositeValue<String> getRawCompositeValue(String key) {
        for (PollingDynamicConfig child : this.children) {
            if (!child.containsKey(key)) continue;
            String value = (String)child.getRawProperty(key);
            String source = child.getSourceID();
            CachedCompositeValue<String> raw = new CachedCompositeValue<String>(value, source);
            return raw;
        }
        return null;
    }

    public <T> SourcedValue<T> getSourcedValue(String propertyName, Class<T> propertyType) {
        CachedCompositePropertyContainer container = this.factory.getProperty(propertyName);
        CachedCompositeProperty<T> property = container.asType(propertyType);
        CachedCompositeValue<T> value = property.getSourced();
        return value;
    }
}

