/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.archaius.impl.ConfigSourceCallable;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.polling.PollingResponse;
import com.netflix.archaius.util.Futures;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PollingDynamicConfig
extends AbstractConfig
implements Closeable {
    private static final TraceComponent tc = Tr.register(PollingDynamicConfig.class);
    private volatile Map<String, String> current = new HashMap<String, String>();
    private final AtomicBoolean busy = new AtomicBoolean();
    private final AtomicLong updateCounter = new AtomicLong();
    private final AtomicLong errorCounter = new AtomicLong();
    private Future<?> future;
    private final ScheduledExecutorService executor;
    private final long interval;
    private final TimeUnit units;
    private boolean localExecutor = false;
    private final ConfigSourceCallable callable;
    private final String id;
    static final long serialVersionUID = 303481408004620452L;

    public PollingDynamicConfig(ConfigSource source, ScheduledExecutorService executor, long refreshInterval) {
        this.callable = new ConfigSourceCallable(source);
        this.id = source.getName();
        this.interval = refreshInterval;
        this.units = TimeUnit.MILLISECONDS;
        if (executor == null) {
            this.executor = Executors.newScheduledThreadPool(1);
            this.localExecutor = true;
        } else {
            this.executor = executor;
        }
        this.future = this.start();
    }

    /*
     * WARNING - void declaration
     */
    private Future<?> start() {
        ScheduledFuture<?> future = null;
        try {
            this.update();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.config.archaius.impl.PollingDynamicConfig", (String)"94", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"execute", (Object[])new Object[]{"Initial Update failed: " + this, e});
            }
            future = Futures.immediateFailure((Exception)e);
        }
        if (future == null && this.interval > 0L) {
            future = this.executor.scheduleWithFixedDelay(new Runnable(){
                static final long serialVersionUID = 2460431410502131979L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    block4: {
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"execute", (Object[])new Object[]{"Scheduled Update starting: " + this});
                            }
                            PollingDynamicConfig.this.update();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"execute", (Object[])new Object[]{"Scheduled Update completed: " + this});
                            }
                        }
                        catch (Exception exception) {
                            void e;
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.config.archaius.impl.PollingDynamicConfig$1", (String)"114", (Object)this, (Object[])new Object[0]);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)"execute", (Object[])new Object[]{"Scheduled Update failed: " + this, e});
                        }
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            }, this.interval, this.interval, this.units);
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private void update() throws Exception {
        if (this.busy.compareAndSet(false, true)) {
            this.updateCounter.incrementAndGet();
            try {
                PollingResponse response = this.callable.call();
                if (response.hasData()) {
                    this.current = response.getToAdd();
                    this.notifyConfigUpdated((Config)this);
                }
            }
            catch (Exception response) {
                void e;
                block11: {
                    FFDCFilter.processException((Throwable)response, (String)"com.ibm.ws.microprofile.config.archaius.impl.PollingDynamicConfig", (String)"141", (Object)this, (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"update", (Object[])new Object[]{"Exception updating dynamic source: " + e});
                    }
                    this.errorCounter.incrementAndGet();
                    try {
                        this.notifyError((Throwable)e, (Config)this);
                    }
                    catch (Exception exception) {
                        void e2;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.config.archaius.impl.PollingDynamicConfig", (String)"149", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                        Tr.debug((TraceComponent)tc, (String)"update", (Object[])new Object[]{"Exception notifying listener: " + e2});
                    }
                }
                throw e;
            }
            finally {
                this.busy.set(false);
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.future != null) {
                boolean cancelled = this.future.cancel(true);
                if (!cancelled) {
                    throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"future.update.not.cancelled.CWMCG0013E", (Object[])new Object[0]));
                }
                this.future = null;
            }
        }
        finally {
            if (this.localExecutor) {
                this.executor.shutdown();
            }
        }
    }

    public long getUpdateCounter() {
        return this.updateCounter.get();
    }

    public long getErrorCounter() {
        return this.errorCounter.get();
    }

    public boolean containsKey(String key) {
        return this.current.containsKey(key);
    }

    public boolean isEmpty() {
        return this.current.isEmpty();
    }

    public Object getRawProperty(String key) {
        return this.current.get(key);
    }

    public Iterator<String> getKeys() {
        return this.current.keySet().iterator();
    }

    public String toString() {
        return this.id;
    }

    public String getSourceID() {
        return this.id;
    }
}

