/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.impl.ConversionManager;
import com.ibm.ws.microprofile.config.impl.SortedSources;
import com.ibm.ws.microprofile.config.interfaces.ConversionException;
import com.ibm.ws.microprofile.config.interfaces.ConverterNotFoundException;
import com.ibm.ws.microprofile.config.interfaces.WebSphereConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractConfig
implements WebSphereConfig {
    private static final TraceComponent tc = Tr.register(AbstractConfig.class);
    private final SortedSources sources;
    private boolean closed = false;
    private final ConversionManager conversionManager;
    static final long serialVersionUID = -3508865780947953690L;

    public AbstractConfig(SortedSources sources, ConversionManager conversionManager) {
        this.sources = sources;
        this.conversionManager = conversionManager;
    }

    protected abstract <T> T getTypedValue(String var1, Class<T> var2);

    protected abstract Set<String> getKeySet();

    public Iterable<ConfigSource> getConfigSources() {
        return this.sources;
    }

    /*
     * WARNING - void declaration
     */
    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        this.assertNotClosed();
        Optional<T> optional = null;
        try {
            T value = this.getTypedValue(propertyName, propertyType);
            optional = Optional.ofNullable(value);
        }
        catch (ConversionException | ConverterNotFoundException value) {
            void e;
            FFDCFilter.processException((Throwable)value, (String)"com.ibm.ws.microprofile.config.impl.AbstractConfig", (String)"73", (Object)this, (Object[])new Object[]{propertyName, propertyType});
            throw new IllegalArgumentException((Throwable)e);
        }
        return optional;
    }

    public Set<String> getPropertyNames() {
        this.assertNotClosed();
        Set<String> keys = this.getKeySet();
        return keys;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    protected void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"config.closed.CWMCG0001E", (Object[])new Object[0]));
        }
    }

    public String toString() {
        this.assertNotClosed();
        StringBuilder sb = new StringBuilder();
        sb.append("Config ");
        sb.append(this.hashCode());
        sb.append("[");
        sb.append(this.getPropertyNames().size());
        sb.append(" keys from ");
        sb.append(this.sources.size());
        sb.append(" sources] : ");
        sb.append(this.sources);
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public <T> T getValue(String propertyName, Class<T> propertyType) {
        T value = null;
        this.assertNotClosed();
        try {
            value = this.getTypedValue(propertyName, propertyType);
            if (value == null && !this.getKeySet().contains(propertyName)) {
                throw new NoSuchElementException(Tr.formatMessage((TraceComponent)tc, (String)"no.such.element.CWMCG0015E", (Object[])new Object[]{propertyName}));
            }
        }
        catch (ConversionException | ConverterNotFoundException configException) {
            void e;
            FFDCFilter.processException((Throwable)configException, (String)"com.ibm.ws.microprofile.config.impl.AbstractConfig", (String)"132", (Object)this, (Object[])new Object[]{propertyName, propertyType});
            throw new IllegalArgumentException((Throwable)e);
        }
        return value;
    }

    @Override
    public <T> T convertValue(String rawValue, Class<T> type) {
        this.assertNotClosed();
        return (T)this.conversionManager.convert(rawValue, type);
    }
}

