/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.interfaces;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.microprofile.config.sources.EnvConfigSource;
import com.ibm.ws.microprofile.config.sources.PropertiesConfigSource;
import com.ibm.ws.microprofile.config.sources.SystemConfigSource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DefaultSources {
    private static final TraceComponent tc = Tr.register(DefaultSources.class);
    static final long serialVersionUID = 4227290660324993729L;

    /*
     * WARNING - void declaration
     */
    public static ArrayList<ConfigSource> getDefaultSources(ClassLoader classloader) {
        ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
        sources.add(new SystemConfigSource());
        sources.add(new EnvConfigSource());
        try {
            Enumeration<URL> propsResources = classloader.getResources("META-INF/microprofile-config.properties");
            if (propsResources != null) {
                while (propsResources.hasMoreElements()) {
                    URL prop = propsResources.nextElement();
                    PropertiesConfigSource source = new PropertiesConfigSource(prop);
                    sources.add(source);
                }
            }
        }
        catch (IOException propsResources) {
            void e;
            FFDCFilter.processException((Throwable)propsResources, (String)"com.ibm.ws.microprofile.config.interfaces.DefaultSources", (String)"56", null, (Object[])new Object[]{classloader});
            throw new ConfigException("Could not load META-INF/microprofile-config.properties", (Throwable)e);
        }
        return sources;
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayList<ConfigSource> getDiscoveredSources(ClassLoader classloader) {
        ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
        try {
            ServiceLoader<ConfigSource> sl = ServiceLoader.load(ConfigSource.class, classloader);
            for (ConfigSource source : sl) {
                sources.add(source);
            }
        }
        catch (ServiceConfigurationError sl) {
            void e;
            FFDCFilter.processException((Throwable)sl, (String)"com.ibm.ws.microprofile.config.interfaces.DefaultSources", (String)"81", null, (Object[])new Object[]{classloader});
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.discover.config.sources.CWMCG0010E", (Object[])new Object[]{e}), (Throwable)e);
        }
        try {
            ServiceLoader<ConfigSourceProvider> providerSL = ServiceLoader.load(ConfigSourceProvider.class, classloader);
            for (ConfigSourceProvider provider : providerSL) {
                for (ConfigSource source : provider.getConfigSources(classloader)) {
                    sources.add(source);
                }
            }
        }
        catch (ServiceConfigurationError providerSL) {
            void e;
            FFDCFilter.processException((Throwable)providerSL, (String)"com.ibm.ws.microprofile.config.interfaces.DefaultSources", (String)"93", null, (Object[])new Object[]{classloader});
            throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.discover.config.source.providers.CWMCG0011E", (Object[])new Object[]{e}), (Throwable)e);
        }
        return sources;
    }
}

