/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.config.sources.AbstractConfigSource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SystemConfigSource
extends AbstractConfigSource
implements ConfigSource {
    static final long serialVersionUID = -3535552303395059299L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SystemConfigSource() {
        super(SystemConfigSource.getSystemOrdinal(), "System Properties Config Source");
    }

    public ConcurrentMap<String, String> getProperties() {
        ConcurrentHashMap<String, String> props = new ConcurrentHashMap<String, String>();
        Properties sysProps = SystemConfigSource.getSystemProperties();
        Set<String> keys = sysProps.stringPropertyNames();
        for (String key : keys) {
            props.put(key, sysProps.getProperty(key));
        }
        return props;
    }

    public static int getSystemOrdinal() {
        String ordinalProp = SystemConfigSource.getOrdinalSystemProperty();
        int ordinal = 400;
        if (ordinalProp != null) {
            ordinal = Integer.parseInt(ordinalProp);
        }
        return ordinal;
    }

    private static String getOrdinalSystemProperty() {
        String prop = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -1106241989874478469L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("config_ordinal");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return prop;
    }

    private static Properties getSystemProperties() {
        Properties prop = AccessController.doPrivileged(new PrivilegedAction<Properties>(){
            static final long serialVersionUID = -3634975895023872423L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Properties run() {
                return System.getProperties();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        return prop;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SystemConfigSource.class);
    }
}

