/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.j2ee;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class J2EEManagementObjectNameFactory {
    public static final String DOMAIN_NAME = "WebSphere";
    public static final String KEY_TYPE = "j2eeType";
    public static final String KEY_NAME = "name";
    public static final String KEY_SERVER = "server";
    public static final String KEY_JAVA_VMS = "javaVMs";
    public static final String DEPLOYMENT_DESCRIPTOR = "deploymentDescriptor";
    public static final String SERVLETS = "servlets";
    public static final String TYPE_DOMAIN = "J2EEDomain";
    public static final String TYPE_SERVER = "J2EEServer";
    public static final String TYPE_JVM = "JVM";
    public static final String TYPE_APPLICATION = "J2EEApplication";
    public static final String TYPE_EJB_MODULE = "EJBModule";
    public static final String TYPE_WEB_MODULE = "WebModule";
    public static final String TYPE_RESOURCE_ADAPTER_MODULE = "ResourceAdapterModule";
    public static final String TYPE_APP_CLIENT_MODULE = "AppClientModule";
    public static final String TYPE_SERVLET = "Servlet";
    public static final String TYPE_JAVA_MAIL_RESOURCE = "JavaMailResource";
    public static final String TYPE_JNDI_RESOURCE = "JNDIResource";
    public static final String TYPE_ORB_RESOURCE = "RMI_IIOPResource";
    public static final String NAME_JAVA_MAIL_RESOURCE = "JavaMailResourceMBeanImpl";
    public static final String MAIL_SESSION_ID = "mailSessionID";
    public static final String RESOURCE_ID = "resourceID";
    static final long serialVersionUID = 694990471849151274L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    private static ObjectName createObjectName(String type, String name, Hashtable<String, String> props) {
        props.put(KEY_TYPE, type);
        props.put(KEY_NAME, name);
        try {
            return new ObjectName(DOMAIN_NAME, props);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            void e;
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory", (String)"111", null, (Object[])new Object[]{type, name, props});
            throw new IllegalArgumentException((Throwable)e);
        }
    }

    public static ObjectName createJ2EEDomainObjectName() {
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_DOMAIN, DOMAIN_NAME, new Hashtable<String, String>());
    }

    public static ObjectName createJ2EEServerObjectName(String name) {
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_SERVER, name, new Hashtable<String, String>());
    }

    public static ObjectName createJVMObjectName(String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_JVM, TYPE_JVM, props);
    }

    public static ObjectName createApplicationObjectName(String name, String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_APPLICATION, name, props);
    }

    public static ObjectName createModuleObjectName(ModuleType moduleType, String uri, String appName, String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_APPLICATION, appName == null ? "null" : appName);
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(moduleType.name(), uri, props);
    }

    public static ObjectName createEJBModuleObjectName(String uri, String appName, String serverName) {
        return J2EEManagementObjectNameFactory.createModuleObjectName(ModuleType.EJBModule, uri, appName, serverName);
    }

    public static ObjectName createEJBObjectName(EJBType type, String name, String moduleURI, String appName, String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(ModuleType.EJBModule.name(), moduleURI);
        props.put(TYPE_APPLICATION, appName == null ? "null" : appName);
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(type.name(), name, props);
    }

    public static ObjectName createWebModuleObjectName(String moduleURI, String appName, String serverName) {
        return J2EEManagementObjectNameFactory.createModuleObjectName(ModuleType.WebModule, moduleURI, appName, serverName);
    }

    public static ObjectName createServletObjectName(String servletName, String moduleURI, String appName, String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(ModuleType.WebModule.name(), moduleURI);
        props.put(TYPE_APPLICATION, appName == null ? "null" : appName);
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_SERVLET, servletName, props);
    }

    public static ObjectName createJavaMailObjectName(String serverName, String mailSessionID, int resourceCounter) {
        ObjectName objectName;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_SERVER, serverName);
        props.put(MAIL_SESSION_ID, mailSessionID);
        props.put(RESOURCE_ID, "JavaMailResource-" + resourceCounter);
        try {
            objectName = J2EEManagementObjectNameFactory.createObjectName(TYPE_JAVA_MAIL_RESOURCE, NAME_JAVA_MAIL_RESOURCE, props);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory", (String)"185", null, (Object[])new Object[]{serverName, mailSessionID, resourceCounter});
            props.remove(MAIL_SESSION_ID);
            objectName = J2EEManagementObjectNameFactory.createObjectName(TYPE_JAVA_MAIL_RESOURCE, NAME_JAVA_MAIL_RESOURCE, props);
        }
        return objectName;
    }

    public static ObjectName createResourceObjectName(String serverName, String resourceType, String keyName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_SERVER, serverName);
        ObjectName objectName = J2EEManagementObjectNameFactory.createObjectName(resourceType, keyName, props);
        return objectName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(J2EEManagementObjectNameFactory.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class ResourceType
    extends Enum<ResourceType> {
        public static final /* enum */ ResourceType JCAResource;
        public static final /* enum */ ResourceType JTAResource;
        public static final /* enum */ ResourceType JDBCResource;
        public static final /* enum */ ResourceType JMSResource;
        public static final /* enum */ ResourceType JNDIResource;
        public static final /* enum */ ResourceType RMI_IIOPResource;
        public static final /* enum */ ResourceType JavaMailResource;
        public static final /* enum */ ResourceType URLResource;
        private static final /* synthetic */ ResourceType[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static ResourceType[] values() {
            return (ResourceType[])$VALUES.clone();
        }

        public static ResourceType valueOf(String name) {
            return Enum.valueOf(ResourceType.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ResourceType.class);
            JCAResource = new ResourceType();
            JTAResource = new ResourceType();
            JDBCResource = new ResourceType();
            JMSResource = new ResourceType();
            JNDIResource = new ResourceType();
            RMI_IIOPResource = new ResourceType();
            JavaMailResource = new ResourceType();
            URLResource = new ResourceType();
            $VALUES = new ResourceType[]{JCAResource, JTAResource, JDBCResource, JMSResource, JNDIResource, RMI_IIOPResource, JavaMailResource, URLResource};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class EJBType
    extends Enum<EJBType> {
        public static final /* enum */ EJBType StatelessSessionBean;
        public static final /* enum */ EJBType StatefulSessionBean;
        public static final /* enum */ EJBType SingletonSessionBean;
        public static final /* enum */ EJBType EntityBean;
        public static final /* enum */ EJBType MessageDrivenBean;
        private static final /* synthetic */ EJBType[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static EJBType[] values() {
            return (EJBType[])$VALUES.clone();
        }

        public static EJBType valueOf(String name) {
            return Enum.valueOf(EJBType.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EJBType.class);
            StatelessSessionBean = new EJBType();
            StatefulSessionBean = new EJBType();
            SingletonSessionBean = new EJBType();
            EntityBean = new EJBType();
            MessageDrivenBean = new EJBType();
            $VALUES = new EJBType[]{StatelessSessionBean, StatefulSessionBean, SingletonSessionBean, EntityBean, MessageDrivenBean};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class ModuleType
    extends Enum<ModuleType> {
        public static final /* enum */ ModuleType WebModule;
        public static final /* enum */ ModuleType EJBModule;
        public static final /* enum */ ModuleType ResourceAdapterModule;
        public static final /* enum */ ModuleType AppClientModule;
        private static final /* synthetic */ ModuleType[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static ModuleType[] values() {
            return (ModuleType[])$VALUES.clone();
        }

        public static ModuleType valueOf(String name) {
            return Enum.valueOf(ModuleType.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleType.class);
            WebModule = new ModuleType();
            EJBModule = new ModuleType();
            ResourceAdapterModule = new ModuleType();
            AppClientModule = new ModuleType();
            $VALUES = new ModuleType[]{WebModule, EJBModule, ResourceAdapterModule, AppClientModule};
        }
    }
}

