/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedModuleInfo;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threading.FutureMonitor;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class ModuleHandlerBase
implements ModuleHandler {
    private FutureMonitor futureMonitor;
    private MetaDataService metaDataService;
    private StateChangeService stateChangeService;
    private ModuleRuntimeContainer moduleRuntimeContainer;
    private Throwable firstFailure;
    static final long serialVersionUID = -4563697739413190872L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setFutureMonitor(FutureMonitor fm) {
        this.futureMonitor = fm;
    }

    @Reference
    protected void setMetaDataService(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    @Reference
    protected void setStateChangeService(StateChangeService stateChangeService) {
        this.stateChangeService = stateChangeService;
    }

    protected ModuleRuntimeContainer getModuleRuntimeContainer() {
        return this.moduleRuntimeContainer;
    }

    protected void setModuleRuntimeContainer(ModuleRuntimeContainer moduleRuntimeContainer) {
        this.moduleRuntimeContainer = moduleRuntimeContainer;
    }

    @Override
    public ModuleMetaData createModuleMetaData(ExtendedModuleInfo moduleInfo, DeployedAppInfo deployedApp) throws MetaDataException {
        ModuleMetaData mmd = this.moduleRuntimeContainer.createModuleMetaData(moduleInfo);
        deployedApp.moduleMetaDataCreated(moduleInfo, this, mmd);
        return mmd;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<Boolean> deployModule(DeployedModuleInfo deployedMod, DeployedAppInfo deployedApp) {
        Future started;
        this.firstFailure = null;
        ExtendedModuleInfo moduleInfo = deployedMod.getModuleInfo();
        ModuleMetaData mmd = moduleInfo.getMetaData();
        if (mmd == null) {
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult((Object)false);
        }
        try {
            this.metaDataService.fireModuleMetaDataCreated(mmd, moduleInfo.getContainer());
            for (ModuleMetaData nestedMMD : moduleInfo.getNestedMetaData()) {
                this.metaDataService.fireModuleMetaDataCreated(nestedMMD, moduleInfo.getContainer());
            }
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.ModuleHandlerBase", (String)"82", (Object)this, (Object[])new Object[]{deployedMod, deployedApp});
            this.firstFailure = ex;
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult(Boolean.class, (Throwable)ex);
        }
        deployedMod.setIsStarting();
        try {
            this.stateChangeService.fireModuleStarting((ModuleInfo)moduleInfo);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.app.manager.module.internal.ModuleHandlerBase", (String)"91", (Object)this, (Object[])new Object[]{deployedMod, deployedApp});
            this.firstFailure = ex;
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult(Boolean.class, ex);
        }
        try {
            started = this.moduleRuntimeContainer.startModule(moduleInfo);
        }
        catch (Throwable nestedMMD) {
            void ex;
            FFDCFilter.processException((Throwable)nestedMMD, (String)"com.ibm.ws.app.manager.module.internal.ModuleHandlerBase", (String)"100", (Object)this, (Object[])new Object[]{deployedMod, deployedApp});
            this.firstFailure = ex;
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult(Boolean.class, (Throwable)ex);
        }
        deployedMod.setIsStarted();
        try {
            this.stateChangeService.fireModuleStarted((ModuleInfo)moduleInfo);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.app.manager.module.internal.ModuleHandlerBase", (String)"109", (Object)this, (Object[])new Object[]{deployedMod, deployedApp});
            this.firstFailure = ex;
            deployedApp.uninstallApp();
            return this.futureMonitor.createFutureWithResult(Boolean.class, ex);
        }
        return started;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean undeployModule(DeployedModuleInfo deployedModule) {
        block14: {
            ExtendedModuleInfo extendedModuleInfo;
            block13: {
                block12: {
                    this.firstFailure = null;
                    extendedModuleInfo = deployedModule.getModuleInfo();
                    if (deployedModule.isStarted()) {
                        block11: {
                            try {
                                this.stateChangeService.fireModuleStopping((ModuleInfo)extendedModuleInfo);
                            }
                            catch (Throwable throwable) {
                                void t;
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.ModuleHandlerBase", (String)"125", (Object)this, (Object[])new Object[]{deployedModule});
                                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleStopping");
                                if (this.firstFailure != null) break block11;
                                this.firstFailure = t;
                            }
                        }
                        try {
                            this.moduleRuntimeContainer.stopModule(extendedModuleInfo);
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.ModuleHandlerBase", (String)"134", (Object)this, (Object[])new Object[]{deployedModule});
                            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"stopModule");
                            if (this.firstFailure != null) break block12;
                            this.firstFailure = t;
                        }
                    }
                }
                if (deployedModule.isStarting()) {
                    try {
                        this.stateChangeService.fireModuleStopped((ModuleInfo)extendedModuleInfo);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.ModuleHandlerBase", (String)"144", (Object)this, (Object[])new Object[]{deployedModule});
                        FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleStopped");
                        if (this.firstFailure != null) break block13;
                        this.firstFailure = t;
                    }
                }
            }
            try {
                this.metaDataService.fireModuleMetaDataDestroyed(extendedModuleInfo.getMetaData());
                for (ModuleMetaData nestedMMD : extendedModuleInfo.getNestedMetaData()) {
                    this.metaDataService.fireModuleMetaDataDestroyed(nestedMMD);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.ModuleHandlerBase", (String)"156", (Object)this, (Object[])new Object[]{deployedModule});
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireModuleMetaDataDestroyed");
                if (this.firstFailure != null) break block14;
                this.firstFailure = t;
            }
        }
        return this.firstFailure == null;
    }

    protected Throwable getFirstFailure() {
        return this.firstFailure;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ModuleHandlerBase.class);
    }
}

