/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.ws.security.token.TokenService;
import com.ibm.ws.security.token.internal.SingleSignonTokenImpl;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TokenManagerImpl
implements TokenManager {
    private static final TraceComponent tc = Tr.register(TokenManagerImpl.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
    static final String CFG_KEY_SSO_TOKEN_TYPE = "ssoTokenType";
    static final String KEY_TOKEN_SERVICE = "tokenService";
    static final String KEY_TOKEN_TYPE = "tokenType";
    private final ConcurrentServiceReferenceMap<String, TokenService> services = new ConcurrentServiceReferenceMap("tokenService");
    private volatile String ssoTokenType;
    static final long serialVersionUID = -7512923820412908739L;

    protected void setTokenService(ServiceReference<TokenService> tokenServiceReference) {
        String tokenType = (String)tokenServiceReference.getProperty(KEY_TOKEN_TYPE);
        this.services.putReference((Object)tokenType, tokenServiceReference);
    }

    protected void unsetTokenService(ServiceReference<TokenService> tokenServiceReference) {
        String tokenType = (String)tokenServiceReference.getProperty(KEY_TOKEN_TYPE);
        this.services.removeReference((Object)tokenType, tokenServiceReference);
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> props) {
        this.services.activate(componentContext);
        this.ssoTokenType = (String)props.get(CFG_KEY_SSO_TOKEN_TYPE);
    }

    protected void modified(Map<String, Object> props) {
        this.ssoTokenType = (String)props.get(CFG_KEY_SSO_TOKEN_TYPE);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.services.deactivate(componentContext);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Token createToken(String tokenType, Map<String, Object> tokenData) throws TokenCreationFailedException {
        try {
            TokenService tokenService = this.getTokenServiceForType(tokenType);
            return tokenService.createToken(tokenData);
        }
        catch (IllegalArgumentException tokenService) {
            void e;
            FFDCFilter.processException((Throwable)tokenService, (String)"com.ibm.ws.security.token.internal.TokenManagerImpl", (String)"72", (Object)this, (Object[])new Object[]{tokenType, tokenData});
            throw new TokenCreationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SingleSignonToken createSSOToken(Map<String, Object> tokenData) throws TokenCreationFailedException {
        try {
            TokenService tokenService = this.getTokenServiceForType(this.ssoTokenType);
            SingleSignonTokenImpl ssoToken = new SingleSignonTokenImpl(tokenService);
            Token ssoLtpaToken = tokenService.createToken(tokenData);
            ssoToken.initializeToken(ssoLtpaToken);
            return ssoToken;
        }
        catch (IllegalArgumentException tokenService) {
            void e;
            FFDCFilter.processException((Throwable)tokenService, (String)"com.ibm.ws.security.token.internal.TokenManagerImpl", (String)"85", (Object)this, (Object[])new Object[]{tokenData});
            throw new TokenCreationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SingleSignonToken createSSOToken(Token token) throws TokenCreationFailedException {
        try {
            TokenService tokenService = this.getTokenServiceForType(this.ssoTokenType);
            SingleSignonTokenImpl ssoToken = new SingleSignonTokenImpl(tokenService);
            ssoToken.initializeToken(token);
            return ssoToken;
        }
        catch (IllegalArgumentException tokenService) {
            void e;
            FFDCFilter.processException((Throwable)tokenService, (String)"com.ibm.ws.security.token.internal.TokenManagerImpl", (String)"97", (Object)this, (Object[])new Object[]{token});
            throw new TokenCreationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @FFDCIgnore(value={InvalidTokenException.class})
    public Token recreateTokenFromBytes(byte[] tokenBytes) throws InvalidTokenException, TokenExpiredException {
        Token token = null;
        Iterator availableServices = this.services.getServices();
        while (availableServices.hasNext()) {
            TokenService tokenService = (TokenService)availableServices.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Trying to recreate token using token service " + tokenService + ". This will fail if the token was not created by this service and may fail if the configuration of the service which created the token has changed."), (Object[])new Object[0]);
            }
            try {
                token = tokenService.recreateTokenFromBytes(tokenBytes);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("Successfully recreated token using token service " + tokenService + "."), (Object[])new Object[0]);
                break;
            }
            catch (InvalidTokenException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("The token service " + tokenService + " failed to recreate the token."), (Object[])new Object[]{e});
            }
        }
        if (token == null) {
            Tr.info((TraceComponent)tc, (String)"TOKEN_SERVICE_INVALID_TOKEN_INFO", (Object[])new Object[0]);
            String translatedMessage = TraceNLS.getStringFromBundle(this.getClass(), (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"TOKEN_SERVICE_INVALID_TOKEN_INFO", (String)"CWWKS4001I: The security token cannot be validated.");
            throw new InvalidTokenException(translatedMessage);
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Token recreateTokenFromBytes(String tokenType, byte[] tokenBytes) throws InvalidTokenException, TokenExpiredException {
        try {
            TokenService tokenService = this.getTokenServiceForType(tokenType);
            return tokenService.recreateTokenFromBytes(tokenBytes);
        }
        catch (IllegalArgumentException tokenService) {
            void e;
            FFDCFilter.processException((Throwable)tokenService, (String)"com.ibm.ws.security.token.internal.TokenManagerImpl", (String)"147", (Object)this, (Object[])new Object[]{tokenType, tokenBytes});
            Tr.info((TraceComponent)tc, (String)"TOKEN_SERVICE_INVALID_TOKEN_INFO", (Object[])new Object[0]);
            String translatedMessage = TraceNLS.getStringFromBundle(this.getClass(), (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"TOKEN_SERVICE_INVALID_TOKEN_INFO", (String)"CWWKS4001I: The security token cannot be validated.");
            throw new InvalidTokenException(translatedMessage, (Throwable)e);
        }
    }

    private TokenService getTokenServiceForType(String tokenType) {
        TokenService service = (TokenService)this.services.getService((Object)tokenType);
        if (service != null) {
            return service;
        }
        Tr.error((TraceComponent)tc, (String)"TOKEN_SERVICE_CONFIG_ERROR_NO_SUCH_SERVICE_TYPE", (Object[])new Object[]{tokenType});
        String formattedMessage = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"TOKEN_SERVICE_CONFIG_ERROR_NO_SUCH_SERVICE_TYPE", (Object[])new Object[]{tokenType}, (String)"CWWKS4000E: A configuration error has occurred. The requested TokenService instance of type {0} could not be found.");
        throw new IllegalArgumentException(formattedMessage);
    }
}

