/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.token.propagation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.security.common.token.propagation.tokenpropagationhelper"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, name="TokenPropagationHelper", service={TokenPropagationHelper.class}, immediate=true, property={"service.vendor=IBM"})
public class TokenPropagationHelper {
    private static volatile SecurityService securityService;
    public static final TraceComponent tc;
    private static final String KEY_SECURITY_SERVICE = "securityService";
    public static final String JWT_TOKEN = "jwt";
    public static final String ISSUED_JWT_TOKEN = "issuedJwt";
    static final long serialVersionUID = 4762419818274598655L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, Map<String, Object> properties) {
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> properties) {
    }

    @Reference(name="securityService", policy=ReferencePolicy.DYNAMIC)
    protected void setSecurityService(SecurityService securitysvc) {
        securityService = securitysvc;
    }

    protected void unsetSecurityService(SecurityService securitysvc) {
        securityService = null;
    }

    public static String getAccessTokenType() throws Exception {
        return TokenPropagationHelper.getSubjectAttributeString("token_type", true);
    }

    public static String getAccessToken() throws Exception {
        return TokenPropagationHelper.getSubjectAttributeString("access_token", true);
    }

    public static String getJwtToken() throws Exception {
        String jwt = TokenPropagationHelper.getIssuedJwtToken();
        if (jwt == null && !TokenPropagationHelper.isJwt(jwt = TokenPropagationHelper.getAccessToken())) {
            jwt = null;
        }
        return jwt;
    }

    private static boolean isJwt(String jwt) {
        return jwt != null && jwt.indexOf(".") >= 0;
    }

    public static String getIssuedJwtToken() throws Exception {
        return TokenPropagationHelper.getSubjectAttributeString(ISSUED_JWT_TOKEN, true);
    }

    public static String getScopes() throws Exception {
        return TokenPropagationHelper.getSubjectAttributeString("scope", true);
    }

    /*
     * WARNING - void declaration
     */
    public static Subject getRunAsSubject() {
        try {
            return TokenPropagationHelper.getRunAsSubjectInternal();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.token.propagation.TokenPropagationHelper", (String)"125", null, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Received Exception retrieving subject: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static Subject getRunAsSubjectInternal() throws Exception {
        Subject sub = null;
        try {
            sub = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = 5468788588715823967L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    return WSSubject.getRunAsSubject();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.common.token.propagation.TokenPropagationHelper", (String)"144", null, (Object[])new Object[0]);
            throw new Exception(e.getCause());
        }
        return sub;
    }

    public static String getUserName() throws Exception {
        Subject subject = TokenPropagationHelper.getRunAsSubjectInternal();
        if (subject == null) {
            return null;
        }
        Set<Principal> principals = subject.getPrincipals();
        Iterator<Principal> principalsIterator = principals.iterator();
        if (principalsIterator.hasNext()) {
            Principal principal = principalsIterator.next();
            return principal.getName();
        }
        return null;
    }

    static String getSubjectAttributeString(String attribKey, boolean bindWithAccessToken) throws Exception {
        Subject runAsSubject = TokenPropagationHelper.getRunAsSubjectInternal();
        if (runAsSubject != null) {
            return TokenPropagationHelper.getSubjectAttributeObject(runAsSubject, attribKey, bindWithAccessToken);
        }
        return null;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    static String getSubjectAttributeObject(Subject subject, String attribKey, boolean bindWithAccessToken) throws Exception {
        try {
            Set<Object> publicCredentials = subject.getPublicCredentials();
            String result = TokenPropagationHelper.getCredentialAttribute(publicCredentials, attribKey, bindWithAccessToken, "publicCredentials");
            if (result == null || result.isEmpty()) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                result = TokenPropagationHelper.getCredentialAttribute(privateCredentials, attribKey, bindWithAccessToken, "privateCredentials");
            }
            return result;
        }
        catch (PrivilegedActionException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find a value for the attribute (" + attribKey + ")"), (Object[])new Object[0]);
            }
            throw new Exception(e.getCause());
        }
    }

    static String getCredentialAttribute(final Set<Object> credentials, final String attribKey, final boolean bindWithAccessToken, final String msg) throws PrivilegedActionException {
        Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
            static final long serialVersionUID = 4609726558464948832L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() throws Exception {
                int iCnt = 0;
                for (Object credentialObj : credentials) {
                    Object value;
                    Object accessToken;
                    ++iCnt;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(msg + "(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
                    }
                    if (!(credentialObj instanceof Map) || bindWithAccessToken && (accessToken = ((Map)credentialObj).get("access_token")) == null || (value = ((Map)credentialObj).get(attribKey)) == null) continue;
                    return value;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized boolean pushSubject(String username) {
        if (securityService == null || username == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("returning false because user or securityService is null, user= " + username + " secsvc= " + securityService), (Object[])new Object[0]);
            }
            return false;
        }
        AuthenticationService authenticationService = securityService.getAuthenticationService();
        Subject tempSubject = new Subject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (!authenticationService.isAllowHashTableLoginWithIdOnly().booleanValue()) {
            hashtable.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        }
        hashtable.put("com.ibm.wsspi.security.cred.userId", username);
        tempSubject.getPublicCredentials().add(hashtable);
        try {
            Subject new_subject = authenticationService.authenticate("system.WEB_INBOUND", tempSubject);
            return TokenPropagationHelper.setRunAsSubject(new_subject);
        }
        catch (AuthenticationException new_subject) {
            void e;
            FFDCFilter.processException((Throwable)new_subject, (String)"com.ibm.ws.security.common.token.propagation.TokenPropagationHelper", (String)"274", null, (Object[])new Object[]{username});
            FFDCFilter.processException((Throwable)e, (String)TokenPropagationHelper.class.getName(), (String)"pushSubject", (Object[])new Object[]{username});
            Tr.error((TraceComponent)tc, (String)"ERROR_AUTHENTICATE", (Object[])new Object[]{e.getMessage()});
            return false;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.common.token.propagation.TokenPropagationHelper", (String)"280", null, (Object[])new Object[]{username});
            FFDCFilter.processException((Throwable)e, (String)TokenPropagationHelper.class.getName(), (String)"pushSubject", (Object[])new Object[]{username});
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized boolean setRunAsSubject(Subject subj) {
        Subject before = null;
        try {
            before = TokenPropagationHelper.getRunAsSubject();
            final Subject fsubj = subj;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -9185960601214760639L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    WSSubject.setRunAsSubject((Subject)fsubj);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        catch (PrivilegedActionException fsubj) {
            void e;
            FFDCFilter.processException((Throwable)fsubj, (String)"com.ibm.ws.security.common.token.propagation.TokenPropagationHelper", (String)"309", null, (Object[])new Object[]{subj});
            FFDCFilter.processException((Throwable)e, (String)TokenPropagationHelper.class.getName(), (String)"setRunAsSubject", (Object[])new Object[0]);
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setRunAsSubject, runAsSubject before = ", (Object[])new Object[]{before});
            Tr.debug((TraceComponent)tc, (String)"setRunAsSubject, runAsSubject after = ", (Object[])new Object[]{subj});
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        tc = Tr.register(TokenPropagationHelper.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    }
}

