/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.ServerAsyncResult;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.concurrent.Future;
import javax.ejb.Timer;

public class AsyncMethodWrapper
extends EJSWrapperBase
implements Runnable {
    private static final String CLASS_NAME = AsyncMethodWrapper.class.getName();
    private static final TraceComponent tc = Tr.register(AsyncMethodWrapper.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    protected final int ivMethodId;
    private Object[] ivArgs = null;
    private ServerAsyncResult ivServerFuture = null;
    private long ivStartTime;

    public AsyncMethodWrapper(EJSWrapperBase theCallingWrapper, int theMethodId, Object[] theMethodArgs, ServerAsyncResult theServerFuture) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + theCallingWrapper + ", " + theMethodId + ", " + theServerFuture), (Object[])new Object[0]);
        }
        this.container = theCallingWrapper.container;
        this.wrapperManager = theCallingWrapper.wrapperManager;
        this.beanId = theCallingWrapper.beanId;
        this.bmd = theCallingWrapper.bmd;
        this.isolationAttrs = theCallingWrapper.isolationAttrs;
        this.ivCommon = theCallingWrapper.ivCommon;
        this.isManagedWrapper = false;
        this.ivPmiBean = theCallingWrapper.ivPmiBean;
        this.methodInfos = theCallingWrapper.methodInfos;
        this.methodNames = theCallingWrapper.methodNames;
        this.ivInterface = theCallingWrapper.ivInterface;
        this.ivBusinessInterfaceIndex = theCallingWrapper.ivBusinessInterfaceIndex;
        this.ivMethodId = theMethodId;
        this.ivArgs = theMethodArgs;
        this.ivServerFuture = theServerFuture;
        if (this.ivPmiBean != null) {
            this.ivStartTime = this.ivPmiBean.initialTime(39);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isVoidReturnType;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("run : async method " + this.methodInfos[this.ivMethodId].getMethodName() + " : " + this), (Object[])new Object[0]);
        }
        if (this.ivPmiBean != null && this.ivStartTime > 0L) {
            this.ivPmiBean.finalTime(39, this.ivStartTime);
            this.ivPmiBean.asyncQueSizeDecrement();
        }
        Future theResult = null;
        EJBMethodInfoImpl methodInfo = this.methodInfos[this.ivMethodId];
        Method theMethod = methodInfo.ivMethod;
        EJSDeployedSupport s = new EJSDeployedSupport();
        s.ivAsyncResult = this.ivServerFuture;
        s.ivIgnoreApplicationExceptions = isVoidReturnType = theMethod.getReturnType() == Void.TYPE;
        try {
            try {
                Object theBean = this.container.EjbPreInvoke(this, this.ivMethodId, s, this.ivArgs);
                if (methodInfo.getAroundInterceptorProxies() == null) {
                    try {
                        theResult = (Future)theMethod.invoke(theBean, this.ivArgs);
                    }
                    catch (InvocationTargetException ite) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Caught InvocationTargetException, unwrapping : " + ite), (Object[])new Object[0]);
                        }
                        throw ite.getCause();
                    }
                } else {
                    theResult = (Future)this.container.invoke(s, (Timer)null);
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Async method completed successfully", (Object[])new Object[0]);
                }
            }
            catch (Throwable ex) {
                boolean declared = this.isApplicationException(ex, methodInfo);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught Throwable (declared=" + declared + "): " + ex), (Object[])new Object[0]);
                }
                if (declared) {
                    s.setCheckedException((Exception)ex);
                    throw ex;
                }
                s.setUncheckedLocalException(ex);
            }
            finally {
                try {
                    this.container.postInvoke(this, this.ivMethodId, s);
                }
                catch (RemoteException re) {
                    FFDCFilter.processException((Throwable)re, (String)(CLASS_NAME + ".run"), (String)"242", (Object)this);
                    s.setUncheckedLocalException(re);
                }
            }
        }
        catch (Throwable ex) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Async method completed with exception : " + ex), (Object[])new Object[0]);
            }
            if (this.ivServerFuture != null) {
                ex = this.mapSystemExceptionBackToRemoteException(ex);
                this.ivServerFuture.setException(ex);
            }
            if (this.ivPmiBean != null && isVoidReturnType) {
                this.ivPmiBean.asyncFNFFailed();
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("run : " + ex));
            }
            return;
        }
        if (this.ivServerFuture != null) {
            this.ivServerFuture.setResult(theResult);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    private boolean isApplicationException(Throwable ex, EJBMethodInfoImpl methodInfo) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isApplicationException : " + ex.getClass().getName() + ", " + methodInfo), (Object[])new Object[0]);
        }
        if (!(!(ex instanceof Exception) || ContainerProperties.DeclaredUncheckedAreSystemExceptions && ex instanceof RuntimeException)) {
            Object declaredExceptions = null;
            if (this.ivInterface == WrapperInterface.LOCAL || this.ivInterface == WrapperInterface.REMOTE) {
                declaredExceptions = methodInfo.ivDeclaredExceptionsComp;
            } else if (this.ivBusinessInterfaceIndex == -2) {
                for (Class<?> clazz : methodInfo.ivDeclaredExceptions) {
                    if (clazz == null) continue;
                    declaredExceptions = clazz;
                    break;
                }
            } else {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ivBusinessInterfaceIndex=" + this.ivBusinessInterfaceIndex), (Object[])new Object[0]);
                }
                declaredExceptions = methodInfo.ivDeclaredExceptions[this.ivBusinessInterfaceIndex];
            }
            if (declaredExceptions != null) {
                for (Class<?> clazz : declaredExceptions) {
                    if (!clazz.isAssignableFrom(ex.getClass())) continue;
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"isApplicationException : true");
                    }
                    return true;
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isApplicationException : false");
        }
        return false;
    }

    protected Throwable mapSystemExceptionBackToRemoteException(Throwable ex) {
        return ex;
    }
}

