/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanNotReentrantException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.ExceptionMappingStrategy;
import com.ibm.ejs.container.InvalidTransactionLocalException;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIInvalidTransactionException;
import com.ibm.websphere.csi.CSINoSuchObjectException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.ejbcontainer.EJBStoppedException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;

public class BusinessExceptionMappingStrategy
extends ExceptionMappingStrategy {
    private static final String CLASS_NAME = BusinessExceptionMappingStrategy.class.getName();
    private static final TraceComponent tc = Tr.register(BusinessExceptionMappingStrategy.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    static final ExceptionMappingStrategy INSTANCE = new BusinessExceptionMappingStrategy();

    private BusinessExceptionMappingStrategy() {
    }

    private EJBException mapCSIException(CSIException ex, Exception causeEx, Throwable cause) {
        Object ejbex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mapCSIException: " + ex + ", cause = " + cause), (Object[])new Object[0]);
        }
        boolean createdEx = true;
        String message = ExceptionUtil.getBaseMessage(ex);
        if (ex instanceof CSITransactionRolledbackException) {
            ejbex = new EJBTransactionRolledbackException(message, causeEx);
        } else if (ex instanceof CSIAccessException) {
            ejbex = new EJBAccessException(message);
        } else if (ex instanceof CSIInvalidTransactionException) {
            ejbex = new InvalidTransactionLocalException(message, causeEx);
        } else if (ex instanceof CSINoSuchObjectException) {
            ejbex = new NoSuchEJBException(message, causeEx);
        } else if (ex instanceof CSITransactionRequiredException) {
            ejbex = new EJBTransactionRequiredException(message);
        } else {
            ejbex = ExceptionUtil.EJBException(message, causeEx);
            if (causeEx != null) {
                createdEx = false;
            }
        }
        if (createdEx) {
            if (causeEx == null) {
                ejbex.setStackTrace(ex.getStackTrace());
            } else if (ejbex.getCause() == null) {
                ejbex.initCause(cause);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mapCSIException returning: " + ejbex));
        }
        return ejbex;
    }

    private EJBException mapException(Throwable ex) {
        Object ejbex;
        boolean createdEx = true;
        Exception causeEx = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mapException: " + ex), (Object[])new Object[0]);
        }
        String message = ExceptionUtil.getBaseMessage(ex);
        Throwable cause = ExceptionUtil.findCause(ex);
        if (cause != null) {
            causeEx = cause instanceof Exception ? (Exception)cause : new Exception("See nested Throwable", cause);
        }
        if (ex instanceof CSIException) {
            ejbex = this.mapCSIException((CSIException)ex, causeEx, cause);
            createdEx = false;
        } else if (ex instanceof NoSuchObjectException) {
            ejbex = new NoSuchEJBException(message, causeEx);
        } else if (ex instanceof EJBStoppedException) {
            cause = ex;
            causeEx = (Exception)ex;
            ejbex = new NoSuchEJBException((String)null, causeEx);
        } else if (ex instanceof TransactionRequiredException) {
            ejbex = new EJBTransactionRequiredException(message);
        } else if (ex instanceof TransactionRolledbackException) {
            ejbex = new EJBTransactionRolledbackException(message, causeEx);
        } else if (ex instanceof InvalidTransactionException) {
            ejbex = new InvalidTransactionLocalException(message, causeEx);
        } else if (ex instanceof AccessException) {
            ejbex = new EJBAccessException(message);
        } else if (ex instanceof BeanNotReentrantException) {
            BeanNotReentrantException bnre = (BeanNotReentrantException)ex;
            ejbex = bnre.isTimeout() ? new ConcurrentAccessTimeoutException(message) : new ConcurrentAccessException(message, causeEx);
        } else {
            ejbex = ExceptionUtil.EJBException(ex);
            createdEx = false;
        }
        if (createdEx) {
            if (causeEx != null) {
                if (ejbex.getCause() == null) {
                    ejbex.initCause(cause);
                }
            } else {
                ejbex.setStackTrace(ex.getStackTrace());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mapException returning: " + ejbex));
        }
        return ejbex;
    }

    @Override
    public final Throwable setUncheckedException(EJSDeployedSupport s, Throwable ex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setUncheckedException:" + ex), (Object[])new Object[0]);
        }
        if (s.ivException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"setting unchecked exception again", (Object[])new Object[]{ex});
                Tr.event((TraceComponent)tc, (String)"original exception", (Object[])new Object[]{s.ivException});
            }
            return s.ivException;
        }
        Boolean applicationExceptionRollback = null;
        if (ex instanceof Exception && !(ex instanceof RemoteException)) {
            applicationExceptionRollback = s.getApplicationExceptionRollback(ex);
        }
        if (applicationExceptionRollback != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"ApplicationException with rollback set to true, changing to a checked exception", (Object[])new Object[]{ex});
            }
            s.exType = ExceptionType.CHECKED_EXCEPTION;
            s.ivException = ex;
            s.rootEx = ex;
            if (applicationExceptionRollback == Boolean.TRUE) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"ApplicationException with rollback set to true, setting rollback only", (Object[])new Object[]{ex});
                }
                s.currentTx.setRollbackOnly();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("setUncheckedException returning: " + s.ivException));
            }
            return s.ivException;
        }
        if (s.preInvokeException && (ex instanceof NoSuchObjectException || ex instanceof NoSuchEJBException || ex instanceof EJBStoppedException || ex instanceof CSIAccessException || ex instanceof BeanNotReentrantException)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception should not cause rollback, changing to checked exception", (Object[])new Object[0]);
            }
            if (ex instanceof BeanNotReentrantException) {
                s.beanO = null;
            }
            s.exType = ExceptionType.CHECKED_EXCEPTION;
        } else if (EJSContainer.defaultContainer == null) {
            s.exType = ExceptionType.UNCHECKED_EXCEPTION;
            ex = new EJBException("The Enterprise JavaBeans (EJB) features have been deactivated. No further EJB processing is allowed");
            ExceptionUtil.logException(tc, ex, s.getEJBMethodMetaData(), s.getBeanO());
        } else {
            s.exType = ExceptionType.UNCHECKED_EXCEPTION;
            ExceptionUtil.logException(tc, ex, s.getEJBMethodMetaData(), s.getBeanO());
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".setUncheckedException"), (String)"506", (Object)this);
        }
        s.rootEx = this.findRootCause(ex);
        s.ivException = this.mapException(ex);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("setUncheckedException returning: " + s.ivException));
        }
        return s.ivException;
    }

    @Override
    public Exception mapCSITransactionRolledBackException(EJSDeployedSupport s, CSITransactionRolledbackException ex) throws CSIException {
        Throwable cause = null;
        Exception causeEx = null;
        if (s.exType == ExceptionType.UNCHECKED_EXCEPTION) {
            cause = s.ivException;
        } else {
            cause = ExceptionUtil.findCause(ex);
            if (cause == null) {
                cause = s.ivException;
            }
        }
        if (cause != null) {
            causeEx = cause instanceof Exception ? (Exception)cause : new Exception("See nested Throwable", cause);
        }
        EJBException mappedEx = this.mapCSIException(ex, causeEx, cause);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("mapped exception = " + mappedEx), (Object[])new Object[0]);
        }
        return mappedEx;
    }
}

