/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimerNpHandleImpl;
import com.ibm.ejs.container.TimerNpRunnable;
import com.ibm.ejs.container.passivator.PassivatorSerializable;
import com.ibm.ejs.container.passivator.PassivatorSerializableHandle;
import com.ibm.ejs.csi.EJBApplicationMetaData;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.util.ParsedScheduleExpression;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParser;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.util.UUID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.NoMoreTimeoutsException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public final class TimerNpImpl
implements Timer,
PassivatorSerializable {
    private static final TraceComponent tc = Tr.register(TimerNpImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final Map<String, TimerNpImpl> svActiveTimers = new LinkedHashMap<String, TimerNpImpl>();
    protected String ivTaskId = "_NP";
    private static long ivTaskSeqNo = 0L;
    private final EJSContainer ivContainer;
    private final BeanId ivBeanId;
    private final BeanMetaData ivBMD;
    int ivMethodId;
    private Serializable ivInfo;
    private long ivExpiration;
    private long ivInterval;
    private ParsedScheduleExpression ivParsedScheduleExpression;
    private volatile boolean ivDestroyed = false;
    Thread ivTimeoutThread;
    private long ivLastExpiration;
    private TimerNpRunnable ivTaskHandler;

    private TimerNpImpl(EJSContainer container2, BeanMetaData bmd, BeanId beanId, Serializable info) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String infoClassName = info == null ? null : info.getClass().getName();
            Tr.entry((TraceComponent)tc, (String)("TimerNpImpl : " + beanId + ", " + infoClassName), (Object[])new Object[0]);
        }
        this.ivContainer = container2;
        this.ivBMD = bmd;
        this.ivBeanId = beanId;
        this.ivInfo = this.ivContainer.ivObjectCopier.copy(info);
        this.ivTaskId = TimerNpImpl.incrementTaskSeqNo();
    }

    public TimerNpImpl(BeanId beanId, Date expiration, long interval, Serializable info) {
        this(((EJSHome)beanId.home).container, ((EJSHome)beanId.home).beanMetaData, beanId, info);
        this.ivExpiration = expiration.getTime();
        this.ivInterval = interval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)this.toString());
        }
    }

    private TimerNpImpl(BeanId beanId, String taskId) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("TimerNpImpl : " + beanId + ", " + taskId), (Object[])new Object[0]);
        }
        this.ivContainer = ((EJSHome)beanId.home).container;
        this.ivTaskId = taskId;
        this.ivBMD = ((EJSHome)beanId.home).beanMetaData;
        this.ivBeanId = beanId;
        this.ivDestroyed = true;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)this.toString());
        }
    }

    public TimerNpImpl(EJSContainer container2, BeanMetaData bmd, BeanId beanId, int methodId, ParsedScheduleExpression parsedExpr, Serializable info) {
        this(container2, bmd, beanId, info);
        this.ivMethodId = methodId;
        this.ivExpiration = Math.max(0L, parsedExpr.getFirstTimeout());
        this.ivParsedScheduleExpression = parsedExpr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)this.toString());
        }
    }

    public TimerNpImpl(BeanId beanId, ParsedScheduleExpression parsedExpr, Serializable info) {
        this(((EJSHome)beanId.home).container, ((EJSHome)beanId.home).beanMetaData, beanId, 0, parsedExpr, info);
    }

    String getTaskId() {
        return this.ivTaskId;
    }

    private static synchronized String incrementTaskSeqNo() {
        String taskId = ++ivTaskSeqNo + "_NP_" + new UUID();
        return taskId;
    }

    public BeanId getIvBeanId() {
        return this.ivBeanId;
    }

    boolean isIvDestroyed() {
        return this.ivDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("start: " + this), (Object[])new Object[0]);
        }
        EJBModuleMetaDataImpl ejbModuleMetaData = this.ivBMD._moduleMetaData;
        EJBApplicationMetaData ejbAmd = ejbModuleMetaData.getEJBApplicationMetaData();
        TimerNpImpl timerNpImpl = this;
        synchronized (timerNpImpl) {
            if (ejbAmd.isStopping()) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"start: not started - application stop");
                }
                this.ivDestroyed = true;
                return;
            }
            if (this.ivDestroyed || this.ivExpiration == 0L) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("start: not started - destroyed = " + this.ivDestroyed + ", expiration = " + this.ivExpiration));
                }
                return;
            }
            Map<String, TimerNpImpl> map = svActiveTimers;
            synchronized (map) {
                svActiveTimers.put(this.ivTaskId, this);
            }
        }
        boolean queuedOrStarted = ejbAmd.queueOrStartNonPersistentTimerAlarm(this, ejbModuleMetaData);
        if (!queuedOrStarted) {
            this.remove(true);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public synchronized void schedule() {
        if (this.ivTaskHandler == null && !this.ivDestroyed) {
            this.ivTaskHandler = this.ivContainer.getEJBRuntime().createNonPersistentTimerTaskHandler(this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("schedule: scheduling timer for " + this.ivExpiration + " / " + new Date(this.ivExpiration)), (Object[])new Object[0]);
            }
            this.ivTaskHandler.schedule(this.ivExpiration);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("schedule: timer already scheduled or destroyed : destroyed=" + this.ivDestroyed), (Object[])new Object[0]);
        }
    }

    synchronized long calculateNextExpiration() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("calculateNextExpiration: " + this), (Object[])new Object[0]);
        }
        this.ivLastExpiration = this.ivExpiration;
        this.ivExpiration = this.ivParsedScheduleExpression != null ? Math.max(0L, this.ivParsedScheduleExpression.getNextTimeout(this.ivExpiration)) : (this.ivInterval > 0L ? (this.ivExpiration += this.ivInterval) : 0L);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("calculateNextExpiration: " + this.ivExpiration));
        }
        return this.ivExpiration;
    }

    synchronized void scheduleNext() {
        if (!this.ivDestroyed) {
            if (this.ivExpiration != 0L) {
                if (this.ivTaskHandler != null) {
                    this.ivTaskHandler.scheduleNext(this.ivExpiration);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("scheduleNext: not scheduled, timer in cancelled state : " + this.ivTaskId), (Object[])new Object[0]);
                }
            } else {
                this.remove(true);
            }
        }
    }

    synchronized void scheduleRetry(long retryInterval) {
        if (!this.ivDestroyed) {
            if (this.ivTaskHandler != null) {
                this.ivTaskHandler.scheduleRetry(retryInterval);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("scheduleRetry: not scheduled, timer in cancelled state : " + this.ivTaskId), (Object[])new Object[0]);
                }
                this.ivExpiration = this.ivLastExpiration;
            }
        }
    }

    private void checkIfCancelled() {
        if (this.ivDestroyed && this.ivTimeoutThread != Thread.currentThread()) {
            String msg = "Timer with ID " + this.ivTaskId + " has been canceled.";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkIfCancelled: NoSuchObjectLocalException : " + msg), (Object[])new Object[0]);
            }
            throw new NoSuchObjectLocalException(msg);
        }
        ContainerTx tx = this.ivContainer.getCurrentContainerTx();
        if (tx != null && tx.timersCanceled != null && tx.timersCanceled.containsValue(this)) {
            String msg = "Timer with ID " + this.ivTaskId + " has been canceled in the current transaction.";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkIfCancelled: NoSuchObjectLocalException : " + msg), (Object[])new Object[0]);
            }
            throw new NoSuchObjectLocalException(msg);
        }
    }

    void checkLateTimerThreshold() {
        this.ivContainer.getEJBRuntime().checkLateTimerThreshold(new Date(this.ivLastExpiration), this.ivTaskId, this.ivBeanId.j2eeName);
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cancel: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        this.checkIfCancelled();
        ContainerTx tx = this.ivContainer.getCurrentContainerTx();
        if (tx != null) {
            boolean queuedToStart;
            boolean bl = tx.timersQueuedToStart != null ? tx.timersQueuedToStart.remove(this.ivTaskId) != null : (queuedToStart = false);
            if (queuedToStart) {
                this.remove(true);
            } else {
                this.remove(false);
                if (tx.timersCanceled == null) {
                    tx.timersCanceled = new LinkedHashMap<String, TimerNpImpl>();
                }
                tx.timersCanceled.put(this.ivTaskId, this);
            }
        } else {
            this.remove(true);
        }
        if (this.ivTimeoutThread == Thread.currentThread()) {
            this.ivTimeoutThread = null;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancel: successful");
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        Date nextTime = this.getNextTimeout();
        long currentTime = System.currentTimeMillis();
        long remaining = nextTime.getTime() - currentTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTimeRemaining: " + remaining), (Object[])new Object[0]);
        }
        return remaining;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException, NoMoreTimeoutsException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNextTimeout: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        this.checkIfCancelled();
        if (this.ivExpiration == 0L) {
            if (this.ivParsedScheduleExpression != null) {
                if (this.ivTimeoutThread == Thread.currentThread()) {
                    String msg = "Timer with ID " + this.ivTaskId + " has no more timeouts.";
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("getNextTimeout: NoMoreTimeoutsException : " + msg));
                    }
                    throw new NoMoreTimeoutsException(msg);
                }
                String msg = "Timer with ID " + this.ivTaskId + " was created with no scheduled timeouts.";
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getNextTimeout: NoSuchObjectLocalException : no expirations : " + msg));
                }
                throw new NoSuchObjectLocalException(msg);
            }
            Date nextTime = new Date(this.ivLastExpiration);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getNextTimeout: no timeouts : " + nextTime));
            }
            return nextTime;
        }
        if (this.ivTimeoutThread != null && this.ivTimeoutThread != Thread.currentThread()) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getNextTimeout: non firing thread : " + new Date(this.ivLastExpiration)));
            }
            return new Date(this.ivLastExpiration);
        }
        Date nextTime = new Date(this.ivExpiration);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNextTimeout: " + nextTime));
        }
        return nextTime;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInfo: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        this.checkIfCancelled();
        Serializable info = this.ivContainer.ivObjectCopier.copy(this.ivInfo);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInfo: " + Util.identity((Object)info)));
        }
        return info;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        throw new IllegalStateException("getHandle method not allowed on non-persistent timers.");
    }

    public boolean isCalendarTimer() {
        boolean result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isCalendarTimer: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        this.checkIfCancelled();
        boolean bl = result = this.ivParsedScheduleExpression != null;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isCalendarTimer: " + result));
        }
        return result;
    }

    public ScheduleExpression getSchedule() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSchedule: " + this), (Object[])new Object[0]);
        }
        this.checkTimerAccess();
        this.checkIfCancelled();
        if (!this.isCalendarTimer()) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSchedule: IllegalStateException : Timer is not a calendar-based timer");
            }
            throw new IllegalStateException("Timer is not a calendar-based timer");
        }
        ScheduleExpression result = this.ivContainer.ivObjectCopier.copy(this.ivParsedScheduleExpression.getSchedule());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSchedule: " + ScheduleExpressionParser.toString(result)));
        }
        return result;
    }

    public boolean isPersistent() {
        this.checkTimerAccess();
        this.checkIfCancelled();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(boolean destroy) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("remove(destroy=" + destroy + ") : " + this), (Object[])new Object[0]);
        }
        TimerNpImpl timerNpImpl = this;
        synchronized (timerNpImpl) {
            Map<String, TimerNpImpl> map = svActiveTimers;
            synchronized (map) {
                svActiveTimers.remove(this.ivTaskId);
            }
            if (destroy) {
                this.ivDestroyed = true;
            }
            if (this.ivTaskHandler != null) {
                this.ivTaskHandler.cancel();
                this.ivTaskHandler = null;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Timer> findTimersByBeanId(BeanId beanId, ContainerTx tx) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findTimersByBeanId: " + beanId), (Object[])new Object[0]);
        }
        int numActive = 0;
        ArrayList<Timer> timers = new ArrayList<Timer>();
        Map<String, TimerNpImpl> map = svActiveTimers;
        synchronized (map) {
            for (TimerNpImpl npTimer : svActiveTimers.values()) {
                if (!npTimer.ivBeanId.equals(beanId)) continue;
                timers.add(npTimer);
            }
            numActive = svActiveTimers.size();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findTimersByBeanId: " + timers.size() + "(of " + numActive + " active)"));
        }
        return timers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Timer> findTimersByModule(ModuleMetaData mmd) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findTimersByModule: " + mmd), (Object[])new Object[0]);
        }
        int numActive = 0;
        ArrayList<Timer> timers = new ArrayList<Timer>();
        Map<String, TimerNpImpl> map = svActiveTimers;
        synchronized (map) {
            for (TimerNpImpl npTimer : svActiveTimers.values()) {
                if (npTimer.ivBMD.getModuleMetaData() != mmd) continue;
                timers.add(npTimer);
            }
            numActive = svActiveTimers.size();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findTimersByModule: " + timers.size() + "(of " + numActive + " active)"));
        }
        return timers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTimersByJ2EEName(J2EEName j2eeName) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeTimersByJ2EEName: " + j2eeName), (Object[])new Object[0]);
        }
        ArrayList<TimerNpImpl> timersToRemove = null;
        Map<String, TimerNpImpl> map = svActiveTimers;
        synchronized (map) {
            if (svActiveTimers.size() > 0) {
                String appToRemove = j2eeName.getApplication();
                String modToRemove = j2eeName.getModule();
                for (TimerNpImpl timer : svActiveTimers.values()) {
                    J2EEName timerJ2EEName = timer.ivBeanId.j2eeName;
                    if (!appToRemove.equals(timerJ2EEName.getApplication()) || modToRemove != null && !modToRemove.equals(timerJ2EEName.getModule())) continue;
                    if (timersToRemove == null) {
                        timersToRemove = new ArrayList<TimerNpImpl>();
                    }
                    timersToRemove.add(timer);
                }
            }
        }
        if (timersToRemove != null) {
            for (TimerNpImpl timer : timersToRemove) {
                timer.remove(true);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeTimersByJ2EEName: removed " + (timersToRemove != null ? timersToRemove.size() : 0)));
        }
    }

    protected void checkTimerAccess() throws IllegalStateException {
        BeanO beanO = EJSContainer.getCallbackBeanO();
        if (beanO != null) {
            beanO.checkTimerServiceAccess();
        } else if (this.ivContainer.allowTimerAccessOutsideBean) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkTimerAccess: Timer access permitted outside of bean", (Object[])new Object[0]);
            }
        } else {
            IllegalStateException ise = new IllegalStateException("Timer: Timer methods not allowed - no active EJB");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkTimerAccess: " + ise), (Object[])new Object[0]);
            }
            throw ise;
        }
    }

    @Override
    public PassivatorSerializableHandle getSerializableObject() {
        TimerNpHandleImpl timerHandle = new TimerNpHandleImpl(this.ivBeanId, this.ivTaskId);
        return timerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Timer getDeserializedTimer(BeanId beanId, String taskId) {
        Timer timer;
        Map<String, TimerNpImpl> map = svActiveTimers;
        synchronized (map) {
            timer = svActiveTimers.get(taskId);
            if (timer != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getDeserializedTimer: found in active timer map : " + timer), (Object[])new Object[0]);
                }
                return timer;
            }
        }
        EJSHome home = (EJSHome)beanId.home;
        ContainerTx containerTx = home.container.getCurrentContainerTx();
        if (containerTx != null) {
            if (containerTx.timersQueuedToStart != null && (timer = (Timer)containerTx.timersQueuedToStart.get(taskId)) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getDeserializedTimer: found in timersQueuedToStart : " + timer), (Object[])new Object[0]);
                }
                return timer;
            }
            if (containerTx.timersCanceled != null && (timer = (Timer)containerTx.timersCanceled.get(taskId)) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getDeserializedTimer: found in timersCanceled : " + timer), (Object[])new Object[0]);
                }
                return timer;
            }
        }
        timer = new TimerNpImpl(beanId, taskId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getDeserializedTimer: not found - returning destroyed Timer : " + timer), (Object[])new Object[0]);
        }
        return timer;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimerNpImpl) {
            TimerNpImpl timer = (TimerNpImpl)obj;
            return this.ivTaskId.equals(timer.ivTaskId);
        }
        return false;
    }

    public int hashCode() {
        return this.ivTaskId.hashCode();
    }

    public String toString() {
        return "TimerNpImpl(" + this.ivTaskId + ", " + this.ivBeanId + ", " + this.ivExpiration + ", " + this.ivInterval + ", " + this.ivDestroyed + ", " + Util.identity((Object)this.ivInfo) + ")";
    }
}

