/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import java.util.GregorianCalendar;

public final class TimeoutKey {
    private static final int CURRENT_TIME = 0;
    private static final int TIMEOUT_TIME = 1;
    private int ivTimeoutType;
    private final BeanId ivBeanId;
    private long ivTimeout;
    private boolean ivDiscarded;
    private boolean ivExpired;
    private boolean ivInUse;
    private final int ivHashValue;

    TimeoutKey(BeanId beanId) {
        this.ivBeanId = beanId;
        this.ivTimeoutType = 0;
        this.ivTimeout = System.currentTimeMillis();
        this.ivDiscarded = false;
        this.ivExpired = false;
        this.ivInUse = false;
        this.ivHashValue = beanId.hashCode();
    }

    TimeoutKey(BeanId beanId, long timeout) {
        this.ivBeanId = beanId;
        this.ivTimeoutType = 1;
        this.ivTimeout = timeout;
        this.ivDiscarded = false;
        this.ivExpired = false;
        this.ivInUse = true;
        this.ivHashValue = beanId.hashCode();
    }

    public void setTimeoutByInterval(int type, long interval) {
        if (this.ivTimeoutType != 0) {
            if (this.ivExpired && !this.ivDiscarded && !this.ivInUse) {
                this.ivExpired = false;
                this.ivTimeout = System.currentTimeMillis();
            } else {
                throw new IllegalStateException("timeout already set");
            }
        }
        long now = this.ivTimeout;
        this.ivTimeoutType = 1;
        this.ivInUse = true;
        switch (type) {
            case 1: {
                if (interval > 0L) {
                    long currOffset = now % interval;
                    long hashOffset = (long)(this.ivBeanId.hashCode() & Integer.MAX_VALUE) % interval;
                    this.ivTimeout = now + (hashOffset - currOffset);
                    if (this.ivTimeout > now) break;
                    this.ivTimeout += interval;
                    break;
                }
                this.ivTimeout = Long.MAX_VALUE;
                break;
            }
            case 2: {
                GregorianCalendar today = new GregorianCalendar();
                today.set(11, 0);
                today.set(12, 0);
                today.set(13, 0);
                today.set(14, 0);
                long midnight = today.getTime().getTime();
                this.ivTimeout = midnight + interval;
                if (this.ivTimeout > now) break;
                this.ivTimeout += 86400000L;
                break;
            }
            case 3: {
                GregorianCalendar sunday = new GregorianCalendar();
                sunday.set(7, 1);
                sunday.set(11, 0);
                sunday.set(12, 0);
                sunday.set(13, 0);
                sunday.set(14, 0);
                long midnightSunday = sunday.getTime().getTime();
                this.ivTimeout = midnightSunday + interval;
                if (this.ivTimeout > now) break;
                this.ivTimeout += 604800000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Interval LoadPolicy not specified");
            }
        }
    }

    public void setDiscarded() {
        this.ivDiscarded = true;
        this.ivExpired = true;
    }

    public void setInUse(boolean inUse) {
        this.ivInUse = inUse;
    }

    public boolean expirationDetected() {
        return this.ivExpired;
    }

    public final int hashCode() {
        return this.ivHashValue;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TimeoutKey) {
            TimeoutKey key = (TimeoutKey)o;
            if (this.ivBeanId.equals(key.ivBeanId)) {
                if (this.ivTimeoutType == 1 && key.ivTimeoutType == 1) {
                    if (this.ivTimeout == key.ivTimeout) {
                        return true;
                    }
                } else if (key.ivTimeoutType == 0 && this.ivTimeoutType == 1) {
                    if (!this.ivExpired) {
                        if (this.ivTimeout > key.ivTimeout) {
                            return true;
                        }
                        this.ivExpired = true;
                        if (!this.ivInUse && !this.ivDiscarded) {
                            return true;
                        }
                    }
                } else if (this.ivTimeoutType == 0 && key.ivTimeoutType == 1 && !key.ivExpired) {
                    if (key.ivTimeout > this.ivTimeout) {
                        return true;
                    }
                    key.ivExpired = true;
                    if (!key.ivInUse && !key.ivDiscarded) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final boolean equals(TimeoutKey key) {
        if (this == key) {
            return true;
        }
        if (key == null) {
            return false;
        }
        if (this.ivBeanId.equals(key.ivBeanId)) {
            if (this.ivTimeoutType == 1 && key.ivTimeoutType == 1) {
                if (this.ivTimeout == key.ivTimeout) {
                    return true;
                }
            } else if (key.ivTimeoutType == 0 && this.ivTimeoutType == 1) {
                if (!this.ivExpired) {
                    if (this.ivTimeout > key.ivTimeout) {
                        return true;
                    }
                    this.ivExpired = true;
                    if (!this.ivInUse && !this.ivDiscarded) {
                        return true;
                    }
                }
            } else if (this.ivTimeoutType == 0 && key.ivTimeoutType == 1 && !key.ivExpired) {
                if (key.ivTimeout > this.ivTimeout) {
                    return true;
                }
                key.ivExpired = true;
                if (!key.ivInUse && !key.ivDiscarded) {
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("TimeoutKey(");
        result.append(this.ivBeanId);
        if (this.ivTimeoutType == 1) {
            result.append(", Timeout: ");
        } else {
            result.append(", Current: ");
        }
        result.append(this.ivTimeout);
        if (this.ivDiscarded) {
            result.append(", discarded");
        }
        if (this.ivExpired) {
            result.append(", expired");
        }
        if (this.ivInUse) {
            result.append(", inUse");
        }
        result.append(")");
        return result.toString();
    }
}

