/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.injection.processor;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ejbcontainer.AmbiguousEJBReferenceException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejb.injection.annotation.EJBImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.EJBRef;
import com.ibm.ws.javaee.dd.common.InjectionTarget;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.injectionengine.RecursiveInjectionException;
import com.ibm.wsspi.injectionengine.factory.IndirectJndiLookupReferenceFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.rmi.Remote;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.CompositeName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.portable.ObjectImpl;

public class EJBInjectionBinding
extends InjectionBinding<EJB> {
    private static final String CLASS_NAME = EJBInjectionBinding.class.getName();
    private static final TraceComponent tc = Tr.register(EJBInjectionBinding.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    boolean ivBeanInterface;
    String ivBeanName;
    String ivLookup;
    boolean ivBeanNameOrLookupInXml;
    Class<?> ivBeanNameClass;
    int ivBeanType;
    boolean ivHomeInterface;
    boolean ivEjbLocalRef;
    boolean ivEjbRef;
    String ivApplication;
    String ivModule;
    ClassLoader ivClassLoader;
    String ivBindingName;
    String ivBoundToJndiName;
    IndirectJndiLookupReferenceFactory ivIndirectLookupFactory;

    public EJBInjectionBinding(String jndiName, ComponentNameSpaceConfiguration compNSConfig) {
        super(null, compNSConfig);
        this.setJndiName(jndiName);
    }

    public EJBInjectionBinding(EJB ejb, String jndiName, ComponentNameSpaceConfiguration compNSConfig) throws InjectionException {
        super((Annotation)ejb, compNSConfig);
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + ejb), (Object[])new Object[0]);
        }
        this.setJndiName(jndiName);
        this.ivBeanName = ejb.beanName();
        if (this.ivBeanName != null && this.ivBeanName.equals("")) {
            this.ivBeanName = null;
        }
        this.ivLookup = ejb.lookup();
        if (this.ivLookup != null && this.ivLookup.equals("")) {
            this.ivLookup = null;
        }
        this.ivBeanType = -1;
        this.ivApplication = compNSConfig.getApplicationName();
        this.ivModule = compNSConfig.getModuleName();
        this.ivClassLoader = compNSConfig.getClassLoader();
        this.setBindingName();
        if (this.ivBeanName != null && this.ivLookup != null && this.ivBindingName == null) {
            String component = compNSConfig.getDisplayName();
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{component, this.ivModule, this.ivApplication, "beanName/lookup", "@EJB", "name", this.getJndiName(), this.ivBeanName, this.ivLookup});
            String exMsg = "The " + component + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in source code annotations. Conflicting beanName/lookup attribute values exist for multiple @EJB annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting beanName/lookup attribute values are " + this.ivBeanName + " and " + this.ivLookup + ".";
            throw new InjectionConfigurationException(exMsg);
        }
        this.setInjectionClassType(ejb.beanInterface());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + (Object)((Object)this)));
        }
    }

    public EJBInjectionBinding(EJB ejb, EJBRef ejbRef, ComponentNameSpaceConfiguration compNSConfig) throws InjectionException {
        super((Annotation)ejb, compNSConfig);
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + ejbRef), (Object[])new Object[0]);
        }
        this.setJndiName(ejbRef.getName());
        this.ivBeanName = ejbRef.getLink();
        this.ivLookup = ejbRef.getLookupName();
        if (this.ivLookup != null) {
            this.ivLookup = this.ivLookup.trim();
        }
        this.ivBeanNameOrLookupInXml = this.ivBeanName != null || this.ivLookup != null;
        this.ivBeanType = ejbRef.getTypeValue();
        this.ivEjbLocalRef = ejbRef.getKindValue() == 1;
        this.ivEjbRef = ejbRef.getKindValue() == 0;
        this.ivApplication = compNSConfig.getApplicationName();
        this.ivModule = compNSConfig.getModuleName();
        this.ivClassLoader = compNSConfig.getClassLoader();
        this.setBindingName();
        if (this.ivBeanName != null && this.ivLookup != null && this.ivBindingName == null) {
            String component = compNSConfig.getDisplayName();
            String elementType = this.ivEjbRef ? "ejb-ref" : "ejb-local-ref";
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{component, this.ivModule, this.ivApplication, "ejb-link/lookup-name", elementType, "ejb-ref-name", this.getJndiName(), this.ivBeanName, this.ivLookup});
            String exMsg = "The " + component + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting ejb-link/lookup-name element values exist for multiple " + elementType + " elements with the same ejb-ref-name element value : " + this.getJndiName() + ". The conflicting ejb-link/lookup-name element values are \"" + this.ivBeanName + "\" and \"" + this.ivLookup + "\".";
            throw new InjectionConfigurationException(exMsg);
        }
        this.setXMLBeanInterface(ejbRef.getHome(), ejbRef.getInterface());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + (Object)((Object)this)));
        }
    }

    private void setXMLBeanInterface(String homeInterfaceName, String interfaceName) throws InjectionException {
        if (homeInterfaceName != null && homeInterfaceName.length() != 0) {
            this.ivHomeInterface = true;
            this.setInjectionClassTypeName(homeInterfaceName);
            if (this.isValidationLoggable()) {
                this.loadClass(homeInterfaceName, this.isValidationFailable());
                this.loadClass(interfaceName, this.isValidationFailable());
            }
        } else if (interfaceName != null && interfaceName.length() != 0) {
            this.ivBeanInterface = true;
            this.setInjectionClassTypeName(interfaceName);
            if (this.isValidationLoggable()) {
                this.loadClass(interfaceName, this.isValidationFailable());
            }
        }
    }

    private void setBindingName() throws InjectionException {
        Map ejbRefBindings = this.ivNameSpaceConfig.getEJBRefBindings();
        if (ejbRefBindings != null) {
            this.ivBindingName = (String)ejbRefBindings.get(this.getJndiName());
            if (this.ivBindingName != null && this.ivBindingName.equals("")) {
                this.ivBindingName = null;
                Tr.warning((TraceComponent)tc, (String)"EJB_BOUND_TO_EMPTY_STRING_CWNEN0025W", (Object[])new Object[0]);
                if (this.isValidationFailable()) {
                    InjectionConfigurationException icex = new InjectionConfigurationException("The " + this.getJndiName() + " EJB reference in the " + this.ivModule + " module of the " + this.ivApplication + " application has been bound to the empty string in the global Java Naming and Directory Interface (JNDI) namespace.");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("resolve : " + icex));
                    }
                    throw icex;
                }
            }
        }
    }

    public void addInjectionTarget(Member member) throws InjectionException {
        if (this.ivBeanName != null && this.ivBeanNameClass == null) {
            this.ivBeanNameClass = member.getDeclaringClass();
        }
        super.addInjectionTarget(member);
    }

    public void merge(EJB annotation, Class<?> instanceClass, Member member) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge : " + annotation + ", " + member), (Object[])new Object[0]);
        }
        Class beanInterface = annotation.beanInterface();
        this.setInjectionClassType(beanInterface);
        if (!this.ivBeanNameOrLookupInXml) {
            String lookup;
            String beanName = annotation.beanName();
            if (beanName != null && !beanName.equals("")) {
                if (this.ivBeanName == null) {
                    this.ivBeanName = beanName;
                } else {
                    Class beanNameClass;
                    Class clazz = beanNameClass = member != null ? member.getDeclaringClass() : Object.class;
                    if (!(this.ivBeanName.equals(beanName) || this.ivBeanNameClass != null && this.ivBeanNameClass != beanNameClass && beanNameClass.isAssignableFrom(this.ivBeanNameClass))) {
                        String component = this.ivNameSpaceConfig.getDisplayName();
                        Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{component, this.ivModule, this.ivApplication, "beanName", "@EJB", "name", this.getJndiName(), this.ivBeanName, beanName});
                        String exMsg = "The " + component + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in source code annotations. Conflicting beanName attribute values exist for multiple @EJB annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting beanName attribute values are " + this.ivBeanName + " and " + beanName + ".";
                        throw new InjectionConfigurationException(exMsg);
                    }
                }
            }
            if ((lookup = annotation.lookup()) != null && !lookup.equals("")) {
                if (this.ivLookup == null) {
                    this.ivLookup = lookup;
                } else if (!this.ivLookup.equals(lookup)) {
                    String component = this.ivNameSpaceConfig.getDisplayName();
                    Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{component, this.ivModule, this.ivApplication, "lookup", "@EJB", "name", this.getJndiName(), this.ivLookup, lookup});
                    String exMsg = "The " + component + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in source code annotations. Conflicting lookup attribute values exist for multiple @EJB annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting lookup attribute values are " + this.ivLookup + " and " + lookup + ".";
                    throw new InjectionConfigurationException(exMsg);
                }
            }
            if (this.ivBeanName != null && this.ivLookup != null && this.ivBindingName == null) {
                String component = this.ivNameSpaceConfig.getDisplayName();
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_ANNOTATION_VALUES_CWNEN0054E", (Object[])new Object[]{component, this.ivModule, this.ivApplication, "beanName/lookup", "@EJB", "name", this.getJndiName(), this.ivBeanName, this.ivLookup});
                String exMsg = "The " + component + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in source code annotations. Conflicting beanName/lookup attribute values exist for multiple @EJB annotations with the same name attribute value : " + this.getJndiName() + ". The conflicting beanName/lookup attribute values are " + this.ivBeanName + " and " + this.ivLookup + ".";
                throw new InjectionConfigurationException(exMsg);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge", (Object)((Object)this));
        }
    }

    public void merge(EJBRef ejbRef) throws InjectionException {
        String exMsg;
        String elementType;
        String component;
        String exMsg2;
        String elementType2;
        Class mostSpecific;
        boolean ejbLocalRef;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge : " + ejbRef), (Object[])new Object[0]);
        }
        EJBImpl curAnnotation = (EJBImpl)((Object)this.getAnnotation());
        String jndiName = ejbRef.getName();
        String curJndiName = curAnnotation.name();
        int beanType = ejbRef.getTypeValue();
        int curBeanType = this.ivBeanType;
        String homeInterfaceName = ejbRef.getHome();
        String beanInterfaceName = ejbRef.getInterface();
        String beanName = ejbRef.getLink();
        String curBeanName = this.ivBeanName;
        String lookup = ejbRef.getLookupName();
        if (lookup != null) {
            lookup = lookup.trim();
        }
        String mappedName = ejbRef.getMappedName() == null ? "" : ejbRef.getMappedName();
        String curMappedName = curAnnotation.mappedName();
        int kind = ejbRef.getKindValue();
        boolean bl = ejbLocalRef = kind == 1;
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new=" + jndiName + ":" + beanType + ":" + homeInterfaceName + "/" + beanInterfaceName + ":" + beanName + ":" + mappedName + ":" + lookup), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cur=" + curJndiName + ":" + curBeanType + ":" + this.getInjectionClassTypeName() + "," + this.ivHomeInterface + ":" + curBeanName + ":" + curMappedName + ":" + this.ivLookup), (Object[])new Object[0]);
        }
        if (this.ivEjbRef && ejbLocalRef || this.ivEjbLocalRef && kind == 0) {
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_TYPES_CWNEN0051E", (Object[])new Object[]{this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "ejb-ref-name", jndiName, "ejb-ref", "ejb-local-ref"});
            String exMsg3 = "The " + this.ivNameSpaceConfig.getDisplayName() + " bean in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting element types exist with the same ejb-ref-name element value : " + jndiName + ". The conflicting element types are ejb-ref and ejb-local-ref.";
            throw new InjectionConfigurationException(exMsg3);
        }
        if (beanType != -1 && curBeanType != -1) {
            if (beanType != curBeanType) {
                String elementType3 = ejbLocalRef ? "ejb-local-ref" : "ejb-ref";
                String curBeanTypeName = curBeanType == 0 ? "Session" : "Entity";
                String beanTypeName = beanType == 0 ? "Session" : "Entity";
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "ejb-ref-type", elementType3, "ejb-ref-name", jndiName, curBeanTypeName, beanTypeName});
                String exMsg4 = "The " + this.ivNameSpaceConfig.getDisplayName() + " bean in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting ejb-ref-type element values exist for multiple " + elementType3 + " elements with the same ejb-ref-name element value : " + jndiName + ". The conflicting ejb-ref-type element values are " + curBeanTypeName + " and " + beanTypeName + ".";
                throw new InjectionConfigurationException(exMsg4);
            }
        } else if (beanType != -1 && curBeanType == -1) {
            this.ivBeanType = beanType;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ivBeanType = " + this.ivBeanType), (Object[])new Object[0]);
            }
        }
        if (homeInterfaceName != null && homeInterfaceName.length() != 0) {
            if (this.ivClassLoader == null) {
                this.setInjectionClassTypeName(homeInterfaceName);
                this.ivHomeInterface = true;
            } else {
                Class<?> homeInterface = this.loadClass(homeInterfaceName, false);
                if (this.ivHomeInterface) {
                    Class<?> curHomeInterface = this.getInjectionClassType();
                    mostSpecific = EJBInjectionBinding.mostSpecificClass(homeInterface, curHomeInterface);
                    if (mostSpecific == null) {
                        String elementType4 = ejbLocalRef ? "ejb-local-ref" : "ejb-ref";
                        String elementAttr = ejbLocalRef ? "local-home" : "home";
                        Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), elementAttr, elementType4, "ejb-ref-name", jndiName, curHomeInterface.getName(), homeInterface.getName()});
                        String exMsg5 = "The " + this.ivNameSpaceConfig.getDisplayName() + " bean in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting " + elementAttr + " element values exist for multiple " + elementType4 + " elements with the same ejb-ref-name element value : " + jndiName + ". The conflicting " + elementAttr + " element values are " + curHomeInterface.getName() + " and " + homeInterface.getName() + ".";
                        throw new InjectionConfigurationException(exMsg5);
                    }
                    this.setInjectionClassType(mostSpecific);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ivHomeInterface = " + this.ivHomeInterface), (Object[])new Object[0]);
                    }
                } else {
                    this.setInjectionClassType(homeInterface);
                    this.ivHomeInterface = true;
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ivHomeInterface = " + this.ivHomeInterface), (Object[])new Object[0]);
                    }
                }
            }
        } else if (beanInterfaceName != null && beanInterfaceName.length() != 0) {
            this.ivBeanInterface = true;
            if (this.ivClassLoader == null) {
                this.setInjectionClassTypeName(beanInterfaceName);
            } else if (!this.ivHomeInterface) {
                Class<?> curBeanInterface;
                Class<?> beanInterface = this.loadClass(beanInterfaceName, false);
                mostSpecific = EJBInjectionBinding.mostSpecificClass(beanInterface, curBeanInterface = this.getInjectionClassType());
                if (mostSpecific == null) {
                    String elementType5 = ejbLocalRef ? "ejb-local-ref" : "ejb-ref";
                    String elementAttr = ejbLocalRef ? "local" : "remote";
                    Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), elementAttr, elementType5, "ejb-ref-name", jndiName, curBeanInterface.getName(), beanInterface.getName()});
                    String exMsg6 = "The " + this.ivNameSpaceConfig.getDisplayName() + " bean in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting " + elementAttr + " element values exist for multiple " + elementType5 + " elements with the same ejb-ref-name element value : " + jndiName + ". The conflicting " + elementAttr + " element values are " + curBeanInterface.getName() + " and " + beanInterface.getName() + ".";
                    throw new InjectionConfigurationException(exMsg6);
                }
                this.setInjectionClassType(beanInterface);
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ivBeanInterface = " + beanInterface), (Object[])new Object[0]);
                }
            }
        }
        if (curAnnotation.ivIsSetMappedName && mappedName != null) {
            if (!curMappedName.equals(mappedName)) {
                elementType2 = ejbLocalRef ? "ejb-local-ref" : "ejb-ref";
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "mapped-name", elementType2, "ejb-ref-name", jndiName, curMappedName, mappedName});
                exMsg2 = "The " + this.ivNameSpaceConfig.getDisplayName() + " bean in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting mapped-name element values exist for multiple " + elementType2 + " elements with the same ejb-ref-name element value : " + jndiName + ". The conflicting mapped-name element values are " + curMappedName + " and " + mappedName + ".";
                throw new InjectionConfigurationException(exMsg2);
            }
        } else if (mappedName != null && !curAnnotation.ivIsSetMappedName) {
            curAnnotation.ivMappedName = mappedName;
            curAnnotation.ivIsSetMappedName = true;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ivMappedName = " + mappedName), (Object[])new Object[0]);
            }
        }
        if (beanName != null && curAnnotation.ivIsSetBeanName) {
            if (!curBeanName.equals(beanName)) {
                elementType2 = ejbLocalRef ? "ejb-local-ref" : "ejb-ref";
                Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{this.ivNameSpaceConfig.getDisplayName(), this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), "ejb-link", elementType2, "ejb-ref-name", jndiName, curBeanName, beanName});
                exMsg2 = "The " + this.ivNameSpaceConfig.getDisplayName() + " bean in the " + this.ivNameSpaceConfig.getModuleName() + " module of the " + this.ivNameSpaceConfig.getApplicationName() + " application has conflicting configuration data in the XML deployment descriptor. Conflicting ejb-link element values exist for multiple " + elementType2 + " elements with the same ejb-ref-name element value : " + jndiName + ". The conflicting ejb-link element values are " + curBeanName + " and " + beanName + ".";
                throw new InjectionConfigurationException(exMsg2);
            }
        } else if (beanName != null && curBeanName == null) {
            curAnnotation.ivBeanName = beanName;
            curAnnotation.ivIsSetBeanName = true;
            this.ivBeanName = beanName;
            this.ivBeanNameOrLookupInXml = true;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ivBeanName = " + this.ivBeanName), (Object[])new Object[0]);
            }
        }
        if (lookup != null) {
            if (this.ivLookup != null) {
                if (!lookup.equals(this.ivLookup)) {
                    component = this.ivNameSpaceConfig.getDisplayName();
                    elementType = ejbLocalRef ? "ejb-local-ref" : "ejb-ref";
                    Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{component, this.ivModule, this.ivApplication, "lookup-name", elementType, "ejb-ref-name", jndiName, this.ivLookup, lookup});
                    exMsg = "The " + component + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting lookup-name element values exist for multiple " + elementType + " elements with the same ejb-ref-name element value : " + jndiName + ". The conflicting lookup-name element values are \"" + this.ivLookup + "\" and \"" + lookup + "\".";
                    throw new InjectionConfigurationException(exMsg);
                }
            } else {
                this.ivLookup = lookup;
                this.ivBeanNameOrLookupInXml = true;
                curAnnotation.ivLookup = lookup;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ivLookup = " + this.ivLookup), (Object[])new Object[0]);
                }
            }
        }
        if (this.ivBeanName != null && this.ivLookup != null) {
            component = this.ivNameSpaceConfig.getDisplayName();
            elementType = ejbLocalRef ? "ejb-local-ref" : "ejb-ref";
            Tr.error((TraceComponent)tc, (String)"CONFLICTING_XML_VALUES_CWNEN0052E", (Object[])new Object[]{component, this.ivModule, this.ivApplication, "ejb-link/lookup-name", elementType, "ejb-ref-name", this.getJndiName(), this.ivBeanName, this.ivLookup});
            exMsg = "The " + component + " bean in the " + this.ivModule + " module of the " + this.ivApplication + " application has conflicting configuration data in the XML deployment descriptor. Conflicting ejb-link/lookup-name element values exist for multiple " + elementType + " elements with the same ejb-ref-name element value : " + this.getJndiName() + ". The conflicting ejb-link/lookup-name element values are \"" + this.ivBeanName + "\" and \"" + this.ivLookup + "\".";
            throw new InjectionConfigurationException(exMsg);
        }
        List targets = ejbRef.getInjectionTargets();
        if (!targets.isEmpty()) {
            for (InjectionTarget target : targets) {
                Class<?> injectionType = this.getInjectionClassType();
                String injectionName = target.getInjectionTargetName();
                String injectionClassName = target.getInjectionTargetClassName();
                this.addInjectionTarget(injectionType, injectionName, injectionClassName);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge", (Object)((Object)this));
        }
    }

    public void mergeSaved(InjectionBinding<EJB> injectionBinding) throws InjectionException {
        EJBInjectionBinding ejbBinding = (EJBInjectionBinding)injectionBinding;
        this.mergeSavedValue(this.getInjectionClassType(), ejbBinding.getInjectionClassType(), "bean-interface");
        this.mergeSavedValue(this.ivBeanName, ejbBinding.ivBeanName, "ejb-link");
        this.mergeSavedValue(this.ivLookup, ejbBinding.ivLookup, "lookup");
        this.mergeSavedValue(this.ivBindingName, ejbBinding.ivBindingName, "binding-name");
    }

    public void setInjectionClassType(Class<?> injectionClassType) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setInjectionClassType : " + injectionClassType), (Object[])new Object[0]);
        }
        super.setInjectionClassType(injectionClassType);
        if (!this.ivHomeInterface) {
            if (EJBHome.class.isAssignableFrom(injectionClassType)) {
                this.ivHomeInterface = true;
                this.ivEjbLocalRef = false;
                this.ivEjbRef = true;
            } else if (EJBLocalHome.class.isAssignableFrom(injectionClassType)) {
                this.ivHomeInterface = true;
                this.ivEjbLocalRef = true;
                this.ivEjbRef = false;
            } else {
                this.ivBeanInterface = true;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("setInjectionClassType : " + (Object)((Object)this)));
        }
    }

    public Class<?> getInjectionClassType() {
        try {
            return this.getInjectionClassTypeWithException();
        }
        catch (InjectionException injectionException) {
            return null;
        }
    }

    public Class<?> getInjectionClassTypeWithException() throws InjectionException {
        String typeName;
        Class<?> type = super.getInjectionClassType();
        if (type == null && this.ivClassLoader != null && (typeName = this.getInjectionClassTypeName()) != null) {
            type = this.loadClass(typeName, !this.ivHomeInterface);
            this.setInjectionClassType(type);
        }
        return type;
    }

    public Object getInjectionObject(Object targetObject, InjectionTargetContext targetContext) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInjectionObject : " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        Object ejb = null;
        try {
            ejb = super.getInjectionObject(targetObject, targetContext);
        }
        catch (Throwable ex) {
            RecursiveInjectionException.RecursionDetection rd;
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getInjectionObject"), (String)"516", (Object)((Object)this), (Object[])new Object[]{ejb, this.getBindingObject()});
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getInjectionObject : " + this.getBindingObject()), (Object[])new Object[0]);
                Tr.exit((TraceComponent)tc, (String)("getInjectionObject : " + ex));
            }
            if ((rd = RecursiveInjectionException.detectRecursiveInjection((Throwable)ex)) == RecursiveInjectionException.RecursionDetection.NotRecursive) {
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof InjectionException) {
                    throw (InjectionException)ex;
                }
                throw new InjectionException(ex.toString(), ex);
            }
            if (rd != RecursiveInjectionException.RecursionDetection.RecursiveAlreadyLogged) {
                Tr.error((TraceComponent)tc, (String)"RECURSIVE_INJECTION_FAILURE_CWNEN0059E", (Object[])new Object[]{this.getJndiName(), this.ivBeanType, this.ivBeanName});
            }
            RecursiveInjectionException riex = new RecursiveInjectionException("The Injection Engine failed to inject the " + this.getJndiName() + " binding object into the " + this.ivBeanType + ":" + this.ivBeanName + " Enterprise JavaBeans (EJB) file because the attempted injection is recursive or cyclic.");
            riex.ivLogged = true;
            throw riex;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInjectionObject : " + Util.identity((Object)ejb)));
        }
        return ejb;
    }

    protected Object getInjectionObjectInstance(Object targetObject, InjectionTargetContext targetContext) throws Exception {
        Object ejb;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInjectionObjectInstance : " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        try {
            ejb = super.getInjectionObjectInstance(targetObject, targetContext);
        }
        catch (NamingException cioex) {
            String beanInterfaceName;
            Throwable cause = cioex.getCause();
            Class<?> injectionType = this.getInjectionClassType();
            String string = beanInterfaceName = injectionType == null ? null : injectionType.getName();
            if (cause instanceof AmbiguousEJBReferenceException && this.ivIndirectLookupFactory != null && beanInterfaceName != null) {
                String boundToJndiName = this.ivBoundToJndiName + "#" + beanInterfaceName;
                Reference ref = this.ivIndirectLookupFactory.createIndirectJndiLookup(this.getJndiName(), boundToJndiName, beanInterfaceName);
                try {
                    ejb = this.ivObjectFactory.getObjectInstance(ref, null, null, null);
                }
                catch (Throwable ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getInjectionObject"), (String)"489", (Object)((Object)this), (Object[])new Object[]{ref});
                    throw cioex;
                }
                this.setObjects(null, ref);
                this.ivBoundToJndiName = boundToJndiName;
            }
            throw cioex;
        }
        Class<?> injectType = this.getInjectionClassType();
        if (injectType != null && ejb instanceof ObjectImpl && !injectType.isAssignableFrom(ejb.getClass())) {
            ejb = PortableRemoteObject.narrow((Object)ejb, injectType);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInjectionObjectInstance : " + Util.identity((Object)ejb)));
        }
        return ejb;
    }

    public Object getRemoteObject() throws NamingException {
        try {
            Object bean = this.getInjectionObject();
            if (bean instanceof Remote) {
                return bean;
            }
            NamingException nex = new NamingException("The " + this.getInjectionClassTypeName() + " EJB interface bound to " + this.getJndiName() + " is not a remote interface.");
            nex.setResolvedName(new CompositeName(this.getJndiName()));
            throw nex;
        }
        catch (InjectionException iex) {
            NamingException nex = new NamingException("Failed to create instance of EJB bound to " + this.getJndiName() + " : " + (Object)((Object)iex));
            nex.setResolvedName(new CompositeName(this.getJndiName()));
            throw nex;
        }
    }

    private Class<?> loadClass(String className, boolean required) throws InjectionConfigurationException {
        Class<?> loadedClass;
        boolean isTraceOn;
        block8: {
            if (className == null || className.equals("") || this.ivClassLoader == null) {
                return null;
            }
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("loadClass : " + className), (Object[])new Object[0]);
            }
            loadedClass = null;
            try {
                loadedClass = this.ivClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".loadClass"), (String)"575", (Object)((Object)this), (Object[])new Object[]{className});
                if (required) {
                    InjectionConfigurationException icex = new InjectionConfigurationException("The " + className + " interface specified for <ejb-ref> or <ejb-local-ref> could not be found", (Throwable)ex);
                    Tr.error((TraceComponent)tc, (String)"EJB_INTERFACE_IS_NOT_SPECIFIED_CORRECTLY_CWNEN0039E", (Object[])new Object[]{className});
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("loadClass : " + icex));
                    }
                    throw icex;
                }
                Tr.warning((TraceComponent)tc, (String)"EJB_INTERFACE_IS_NOT_SPECIFIED_CORRECTLY_CWNEN0033W", (Object[])new Object[]{className});
                if (!this.isValidationFailable()) break block8;
                InjectionConfigurationException icex = new InjectionConfigurationException("The " + className + " interface specified for <ejb-ref> or <ejb-local-ref> could not be found", (Throwable)ex);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("loadClass : " + icex));
                }
                throw icex;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("loadClass : " + loadedClass));
        }
        return loadedClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(Util.identity((Object)((Object)this)));
        sb.append("[name=").append(this.getJndiName());
        if (this.ivEjbLocalRef) {
            sb.append(", local");
        }
        if (this.ivEjbRef) {
            sb.append(", remote");
        }
        if (this.ivHomeInterface) {
            sb.append(", home");
        } else if (this.ivBeanInterface) {
            sb.append(", beanInterface");
        }
        sb.append(", type=").append(this.getInjectionClassTypeName());
        if (this.ivBeanName != null) {
            sb.append(", beanName=").append(this.ivBeanName);
        }
        if (this.ivLookup != null) {
            sb.append(", lookup=").append(this.ivLookup);
        }
        if (this.ivBindingName != null) {
            sb.append(", binding=").append(this.ivBindingName);
        }
        return sb.append(']').toString();
    }
}

