/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import com.ibm.ws.kernel.boot.cmdline.UtilityMain;
import com.ibm.ws.staticvalue.StaticValue;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.zip.ZipFile;

public class Utils {
    private static StaticValue<File> installDir = StaticValue.createStaticValue(null);
    private static StaticValue<File> userDir = StaticValue.createStaticValue(null);
    private static StaticValue<File> outputDir = StaticValue.createStaticValue(null);
    private static StaticValue<File> logDir = StaticValue.createStaticValue(null);
    private static ResourceBundle cmdlineResourceBundle;

    public static File getInstallDir() {
        if (installDir.get() == null) {
            URL url = UtilityMain.class.getProtectionDomain().getCodeSource().getLocation();
            File file = Utils.getFile(url).getParentFile().getParentFile();
            installDir = StaticValue.mutateStaticValue(installDir, new FileInitializer(file));
        }
        return installDir.get();
    }

    public static File getUserDir() {
        String userDirLoc = null;
        if (userDir.get() == null) {
            File resultDir = null;
            userDirLoc = System.getenv("WLP_USER_DIR");
            if (userDirLoc != null) {
                resultDir = new File(userDirLoc);
            } else {
                userDirLoc = System.getProperty("WLP_USER_DIR");
                if (userDirLoc != null) {
                    resultDir = new File(userDirLoc);
                } else {
                    File installDir = Utils.getInstallDir();
                    if (installDir != null) {
                        resultDir = new File(installDir, "usr");
                    }
                }
            }
            userDir = StaticValue.mutateStaticValue(userDir, new FileInitializer(resultDir));
        }
        return userDir.get();
    }

    public static File getOutputDir() {
        return Utils.getOutputDir(false);
    }

    public static File getLogDir() {
        String logDirLoc = null;
        if (logDir.get() == null) {
            File resultDir = null;
            try {
                logDirLoc = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return System.getenv("LOG_DIR");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (logDirLoc != null) {
                resultDir = new File(logDirLoc);
            } else {
                logDirLoc = System.getProperty("LOG_DIR");
                if (logDirLoc != null) {
                    resultDir = new File(logDirLoc);
                }
            }
            logDir = StaticValue.mutateStaticValue(logDir, new FileInitializer(resultDir));
        }
        return logDir.get();
    }

    public static File getOutputDir(boolean isClient) {
        String outputDirLoc = null;
        if (outputDir.get() == null) {
            try {
                outputDirLoc = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return System.getenv("WLP_OUTPUT_DIR");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            File resultDir = null;
            if (outputDirLoc != null) {
                resultDir = new File(outputDirLoc);
            } else {
                outputDirLoc = System.getProperty("WLP_OUTPUT_DIR");
                if (outputDirLoc != null) {
                    resultDir = new File(outputDirLoc);
                } else {
                    File userDir = Utils.getUserDir();
                    if (userDir != null) {
                        resultDir = isClient ? new File(userDir, "clients") : new File(userDir, "servers");
                    }
                }
            }
            outputDir = StaticValue.mutateStaticValue(outputDir, new FileInitializer(resultDir));
        }
        return outputDir.get();
    }

    public static File getServerOutputDir(String serverName) {
        return Utils.getServerOutputDir(serverName, false);
    }

    public static File getServerOutputDir(String serverName, boolean isClient) {
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName can not be 'null'");
        }
        File outputDir = Utils.getOutputDir(isClient);
        if (outputDir != null) {
            return new File(outputDir, serverName);
        }
        return Utils.getServerConfigDir(serverName);
    }

    public static File getServerConfigDir(String serverName) {
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName can not be 'null'");
        }
        File userDir = Utils.getUserDir();
        if (userDir != null) {
            return new File(new File(userDir, "servers"), serverName);
        }
        return null;
    }

    public static File getJavaTools() throws MalformedURLException {
        File javaHomeFile;
        File javaToolsFile = null;
        String javaHome = System.getProperty("java.home");
        if (null != javaHome && !javaHome.isEmpty() && null == (javaToolsFile = Utils.buildJavaToolsFile(javaHomeFile = new File(javaHome)))) {
            javaToolsFile = Utils.buildJavaToolsFile(javaHomeFile.getParentFile());
        }
        return javaToolsFile;
    }

    private static File buildJavaToolsFile(File javaHomeFile) {
        File javaLibFile = new File(javaHomeFile, "lib");
        File javaToolsFile = new File(javaLibFile, "tools.jar");
        return javaToolsFile.exists() && javaToolsFile.isFile() ? javaToolsFile : null;
    }

    public static boolean hasToolsByDefault() {
        try {
            Class.forName("com.sun.mirror.apt.AnnotationProcessorFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static ResourceBundle getResourceBundle() {
        if (cmdlineResourceBundle == null) {
            cmdlineResourceBundle = ResourceBundle.getBundle("com.ibm.ws.kernel.boot.cmdline.resources.CommandLineMessages");
        }
        return cmdlineResourceBundle;
    }

    static String getResourceBundleString(String key) {
        ResourceBundle bundle = Utils.getResourceBundle();
        return bundle == null ? null : bundle.getString(key);
    }

    public static boolean tryToClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean tryToClose(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setInstallDir(File installDir) {
        Utils.installDir = StaticValue.mutateStaticValue(Utils.installDir, new FileInitializer(installDir));
    }

    public static void setUserDir(File userDir) {
        Utils.userDir = StaticValue.mutateStaticValue(Utils.userDir, new FileInitializer(userDir));
    }

    private static File getFile(URL url) {
        String path;
        try {
            if (url.getAuthority() != null) {
                url = new URL("file://" + url.toString().substring("file:".length()));
            }
            path = new File(url.toURI()).getPath();
        }
        catch (MalformedURLException e) {
            path = null;
        }
        catch (URISyntaxException e) {
            path = null;
        }
        catch (IllegalArgumentException e) {
            path = null;
        }
        if (path == null) {
            path = url.getPath();
        }
        return new File(Utils.normalizePathDrive(path));
    }

    private static String normalizePathDrive(String path) {
        if (File.separatorChar == '\\' && path.length() > 1 && path.charAt(1) == ':' && path.charAt(0) >= 'a' && path.charAt(0) <= 'z') {
            path = Character.toUpperCase(path.charAt(0)) + path.substring(1);
        }
        return path;
    }

    public static class FileInitializer
    implements Callable<File> {
        final File file;

        public FileInitializer(File file) {
            this.file = file;
        }

        @Override
        public File call() throws Exception {
            return this.file;
        }
    }
}

