/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.BootstrapManifest;
import com.ibm.ws.kernel.boot.internal.KernelResolver;
import com.ibm.ws.kernel.boot.internal.KernelUtils;
import com.ibm.ws.kernel.boot.internal.LauncherDelegate;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import com.ibm.ws.kernel.boot.security.WLPDynamicPolicy;
import com.ibm.ws.kernel.internal.classloader.BootstrapChildFirstJarClassloader;
import com.ibm.ws.kernel.internal.classloader.BootstrapChildFirstURLClassloader;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.kernel.provisioning.NameBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.ServiceFingerprint;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class KernelBootstrap {
    protected final BootstrapConfig bootProps;
    protected final ServerLock serverLock;
    protected final CountDownLatch delegateCreated = new CountDownLatch(1);
    protected LauncherDelegate launcherDelegate;
    protected File serverRunning = null;
    protected final boolean libertyBoot;

    public KernelBootstrap(BootstrapConfig bootProps) {
        this.bootProps = bootProps;
        this.libertyBoot = Boolean.parseBoolean(bootProps.get("wlp.liberty.boot"));
        this.serverLock = ServerLock.createServerLock(bootProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnCode go() {
        try {
            List<String> cmdArgs;
            this.serverLock.obtainServerLock();
            this.clearServerStateDir();
            this.setupJMXOverride();
            this.setHttpRetryPost();
            this.setLoggerProperties();
            ServerLock.createServerRunningMarkerFile(this.bootProps);
            this.cleanStart();
            BootstrapManifest bootManifest = null;
            try {
                bootManifest = BootstrapManifest.readBootstrapManifest(this.libertyBoot);
            }
            catch (IOException e) {
                throw new LaunchException("Could not read the jar manifest", BootstrapConstants.messages.getString("error.unknown.kernel.version"), e);
            }
            bootManifest.prepSystemPackages(this.bootProps);
            String kernelVersion = "wlp-" + bootManifest.getBundleVersion();
            String productInfo = KernelBootstrap.getProductInfoDisplayName();
            KernelResolver resolver = new KernelResolver(this.bootProps.getInstallRoot(), this.bootProps.getWorkareaFile("platform/kernel.cache"), bootManifest.getKernelDefinition(this.bootProps), bootManifest.getLogProviderDefinition(this.bootProps), bootManifest.getOSExtensionDefinition(this.bootProps), this.libertyBoot);
            String logLevel = this.bootProps.get("com.ibm.ws.logging.console.log.level");
            boolean logVersionInfo = logLevel == null || !logLevel.equalsIgnoreCase("off");
            KernelBootstrap.processVersion(this.bootProps, "info.serverLaunch", kernelVersion, productInfo, logVersionInfo);
            if (logVersionInfo && (cmdArgs = this.bootProps.getCmdArgs()) != null && !cmdArgs.isEmpty()) {
                System.out.println("\t" + MessageFormat.format(BootstrapConstants.messages.getString("info.cmdArgs"), cmdArgs));
            }
            if (resolver.getForceCleanStart()) {
                KernelUtils.cleanStart(this.bootProps.getWorkareaFile(null));
            }
            ServiceFingerprint.putInstallDir(null, this.bootProps.getInstallRoot());
            String packages = this.bootProps.get("org.osgi.framework.system.packages.extra");
            packages = resolver.appendExtraSystemPackages(packages);
            if (packages != null) {
                this.bootProps.put("org.osgi.framework.system.packages.extra", packages);
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            if (!this.libertyBoot) {
                this.bootProps.addBootstrapJarURLs(urlList);
                resolver.addBootJars(urlList);
            }
            ClassLoader loader = this.buildClassLoader(urlList, this.bootProps.get("verifyJarSignature"));
            try {
                Class<? extends LauncherDelegate> clazz = this.getLauncherDelegateClass(loader);
                this.launcherDelegate = clazz.getConstructor(BootstrapConfig.class).newInstance(this.bootProps);
            }
            catch (Exception e) {
                this.rethrowException("Unable to create OSGi framework due to " + e, e);
            }
            this.delegateCreated.countDown();
            this.bootProps.setFrameworkClassloader(loader);
            this.bootProps.setKernelResolver(resolver);
            this.bootProps.setInstrumentation(this.getInstrumentation());
            if (!Boolean.parseBoolean(this.bootProps.get("server.no.start"))) {
                this.launcherDelegate.launchFramework();
            }
        }
        catch (LaunchException le) {
            throw le;
        }
        catch (Throwable e) {
            this.rethrowException("Caught unexpected exception " + e, e);
        }
        finally {
            this.delegateCreated.countDown();
            if (this.serverLock != null) {
                this.serverLock.releaseServerLock();
            }
        }
        return ReturnCode.OK;
    }

    private void clearServerStateDir() {
        File stateDir = this.bootProps.getOutputFile("logs/state");
        KernelUtils.cleanDirectory(stateDir, "state");
    }

    public Set<String> getServerContent(String osRequest) throws FileNotFoundException, IOException, InterruptedException {
        this.delegateCreated.await();
        if (this.launcherDelegate != null) {
            return this.launcherDelegate.queryFeatureInformation(osRequest);
        }
        return Collections.emptySet();
    }

    public Set<String> getServerFeatures() throws InterruptedException {
        this.delegateCreated.await();
        if (this.launcherDelegate != null) {
            return this.launcherDelegate.queryFeatureNames();
        }
        return Collections.emptySet();
    }

    public boolean waitForStarted() throws InterruptedException {
        this.delegateCreated.await();
        if (this.launcherDelegate != null) {
            return this.launcherDelegate.waitForReady();
        }
        return false;
    }

    public ReturnCode shutdown() throws InterruptedException {
        this.delegateCreated.await();
        if (this.launcherDelegate != null && this.launcherDelegate.shutdown()) {
            return this.serverLock.waitForStop();
        }
        return ReturnCode.OK;
    }

    protected void setupJMXOverride() {
        System.setProperty("javax.management.builder.initial", "com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServerBuilder");
    }

    private void setLoggerProperties() {
        String logManager = this.bootProps.get("java.util.logging.manager");
        if (logManager == null) {
            logManager = "com.ibm.ws.kernel.boot.logging.WsLogManager";
        }
        System.setProperty("java.util.logging.manager", logManager);
    }

    private void setHttpRetryPost() {
        String httpRetryPost = this.bootProps.get("sun.net.http.retryPost");
        if (httpRetryPost == null) {
            httpRetryPost = "false";
        }
        System.setProperty("sun.net.http.retryPost", httpRetryPost);
    }

    protected void cleanStart() {
        File workareaFile = this.bootProps.getWorkareaFile(null);
        if (ServiceFingerprint.hasServiceBeenApplied(this.bootProps.getInstallRoot(), workareaFile) || this.bootProps.checkCleanStart()) {
            ServiceFingerprint.clear();
            KernelUtils.cleanStart(workareaFile);
            this.bootProps.remove("org.osgi.framework.storage.clean");
            this.bootProps.remove("osgi.clean");
        }
    }

    protected Class<? extends LauncherDelegate> getLauncherDelegateClass(ClassLoader loader) throws ClassNotFoundException {
        String className = "com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl";
        Class<?> clazz = loader.loadClass(className);
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        return clazz.asSubclass(LauncherDelegate.class);
    }

    protected ClassLoader buildClassLoader(final List<URL> urlList, String verifyJarProperty) {
        if (this.libertyBoot) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return this.getClass().getClassLoader();
                }
            });
        }
        final boolean verifyJar = System.getSecurityManager() == null ? "true".equalsIgnoreCase(verifyJarProperty) : true;
        KernelBootstrap.enableJava2SecurityIfSet(this.bootProps, urlList);
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader parent = this.getClass().getClassLoader();
                URL[] urls = urlList.toArray(new URL[urlList.size()]);
                if (verifyJar) {
                    return new BootstrapChildFirstURLClassloader(urls, parent);
                }
                try {
                    return new BootstrapChildFirstJarClassloader(urls, parent);
                }
                catch (RuntimeException e) {
                    return new BootstrapChildFirstURLClassloader(urls, parent);
                }
            }
        });
        return loader;
    }

    public static void enableJava2SecurityIfSet(BootstrapConfig bootProps, List<URL> urlList) {
        if (bootProps.get("websphere.java.security") != null) {
            NameBasedLocalBundleRepository repo = new NameBasedLocalBundleRepository(bootProps.getInstallRoot());
            File bestMatchFile = repo.selectBundle("com.ibm.ws.org.eclipse.equinox.region", VersionUtility.stringToVersionRange("[1.0,1.0.100)"));
            if (bestMatchFile == null) {
                throw new LaunchException("Could not find bundle for com.ibm.ws.org.eclipse.equinox.region.", BootstrapConstants.messages.getString("error.missingBundleException"));
            }
            try {
                urlList.add(bestMatchFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new LaunchException("Failure to set the default Security Manager due to exception ", BootstrapConstants.messages.getString("error.set.securitymanager"), e);
            }
            WLPDynamicPolicy wlpPolicy = new WLPDynamicPolicy(Policy.getPolicy(), urlList);
            Policy.setPolicy(wlpPolicy);
        }
    }

    public static void showVersion(BootstrapConfig bootProps) {
        try {
            BootstrapManifest bootManifest = BootstrapManifest.readBootstrapManifest(Boolean.parseBoolean(bootProps.get("wlp.liberty.boot")));
            String kernelVersion = bootManifest.getBundleVersion();
            String productInfo = KernelBootstrap.getProductInfoDisplayName();
            KernelBootstrap.processVersion(bootProps, "info.serverVersion", kernelVersion, productInfo, true);
        }
        catch (IOException e) {
            throw new LaunchException("Could not read the jar manifest", BootstrapConstants.messages.getString("error.unknown.kernel.version"), e);
        }
    }

    private static void processVersion(BootstrapConfig bootProps, String msgKey, String kernelVersion, String productInfo, boolean printVersion) {
        String versionString;
        String launchString;
        if (productInfo == null) {
            launchString = "WebSphere Application Server/" + kernelVersion;
            versionString = "WebSphere Application Server (" + kernelVersion + ")";
        } else {
            launchString = productInfo + "/" + kernelVersion;
            versionString = productInfo + " (" + kernelVersion + ")";
        }
        if (printVersion) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString(msgKey), "info.serverLaunch".equals(msgKey) ? launchString : versionString, System.getProperty("java.vm.name"), System.getProperty("java.runtime.version") + " (" + Locale.getDefault() + ")", bootProps.getProcessName()));
        }
        bootProps.put("websphere.product.info", versionString);
    }

    protected static String getProductInfoDisplayName() {
        String result = null;
        try {
            Map<String, ProductInfo> products = ProductInfo.getAllProductInfo();
            StringBuilder builder = new StringBuilder();
            for (ProductInfo productInfo : products.values()) {
                if (builder.length() != 0) {
                    builder.append(", ");
                }
                builder.append(productInfo.getDisplayName());
            }
            result = builder.toString();
        }
        catch (ProductInfoParseException productInfoParseException) {
        }
        catch (DuplicateProductInfoException duplicateProductInfoException) {
        }
        catch (ProductInfoReplaceException productInfoReplaceException) {
            // empty catch block
        }
        return result;
    }

    private void rethrowException(String untranslatedMsg, Throwable ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            cause = ex;
        }
        throw new LaunchException(untranslatedMsg, MessageFormat.format(BootstrapConstants.messages.getString("error.unknownException"), cause.toString()), cause);
    }

    protected Instrumentation getInstrumentation() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        try {
            Class<?> agentClass = cl.loadClass("com.ibm.ws.kernel.instrument.BootstrapAgent");
            Field instField = agentClass.getDeclaredField("instrumentation");
            instField.setAccessible(true);
            return (Instrumentation)instField.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

