/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.launch.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.boot.internal.ServerCommand;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.launch.internal.FrameworkManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServerCommandListener
extends ServerCommand {
    private static final TraceComponent tc = Tr.register(ServerCommandListener.class);
    private final FrameworkManager frameworkManager;
    private int nextCommandAuthID;
    private boolean closed;
    private ServerSocketChannel serverSocketChannel;
    private final Object responseLock;
    private final AtomicReference<Thread> responseThread;
    private volatile boolean listenForCommands;
    private volatile Thread listeningThread;
    private final String serverName;
    private static final char DELIM = '#';
    static final long serialVersionUID = -3873162804303002245L;

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public ServerCommandListener(BootstrapConfig bootProps, String uuid, FrameworkManager frameworkManager) {
        super(bootProps);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{bootProps, uuid, frameworkManager});
        }
        this.responseLock = new Object(){
            static final long serialVersionUID = -3582384678172189332L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{ServerCommandListener.this});
                }
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        this.responseThread = new AtomicReference();
        this.listenForCommands = false;
        this.frameworkManager = frameworkManager;
        this.serverUUID = uuid;
        this.serverName = bootProps.getProcessName();
        File serverDir = bootProps.getConfigFile(null);
        File serverWorkArea = bootProps.getWorkareaFile(null);
        if (!serverDir.exists()) {
            throw new LaunchException("Can not initialize server command listener - Invalid server directory", MessageFormat.format(BootstrapConstants.messages.getString("error.invalid.directory"), serverDir));
        }
        boolean writable = true;
        if (!serverWorkArea.exists()) {
            writable = serverWorkArea.mkdirs();
        }
        if (!writable || !serverWorkArea.canWrite()) {
            throw this.securityError(serverWorkArea, null);
        }
        writable = true;
        if (!this.commandFile.delete() && this.commandFile.exists()) {
            throw this.securityError(serverWorkArea, null);
        }
        File commandFileTmp = new File(this.commandFile.getParentFile(), this.commandFile.getName() + ".tmp");
        if (!commandFileTmp.delete() && commandFileTmp.exists()) {
            throw this.securityError(serverWorkArea, null);
        }
        try {
            writable = commandFileTmp.createNewFile();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener", (String)"123", (Object)this, (Object[])new Object[]{bootProps, uuid, frameworkManager});
            writable = false;
        }
        if (writable) {
            if (!commandFileTmp.setWritable(false)) {
                writable = false;
            }
            if (!commandFileTmp.setWritable(true, true)) {
                writable = false;
            }
        }
        if (!writable || !commandFileTmp.canWrite()) {
            throw this.securityError(serverWorkArea, null);
        }
        commandFileTmp.setReadable(false);
        commandFileTmp.setReadable(true, true);
        if (!FileUtils.recursiveClean(this.commandAuthDir) || !this.commandAuthDir.mkdir()) {
            throw this.securityError(serverWorkArea, null);
        }
        int commandPort = Boolean.parseBoolean(bootProps.get("com.ibm.ws.kernel.default.command.port.disabled")) ? -1 : 0;
        String commandPortString = bootProps.get("command.port");
        if (commandPortString != null) {
            try {
                commandPort = Integer.parseInt(commandPortString);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener", (String)"157", (Object)this, (Object[])new Object[]{bootProps, uuid, frameworkManager});
            }
        }
        try {
            this.init(commandPort, commandFileTmp);
        }
        catch (IOException iOException) {
            void ex;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener", (String)"163", (Object)this, (Object[])new Object[]{bootProps, uuid, frameworkManager});
            throw new LaunchException("Failed to initialize server command listener", MessageFormat.format(BootstrapConstants.messages.getString("error.serverCommand.init"), ex));
        }
        if (!commandFileTmp.renameTo(this.commandFile)) {
            throw this.securityError(serverWorkArea, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private LaunchException securityError(File file, Throwable cause) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"securityError", (Object[])new Object[]{file, cause});
        }
        LaunchException launchException = new LaunchException("Can not create or write to command directory, check server directory permissions", MessageFormat.format(BootstrapConstants.messages.getString("error.serverDirPermission"), file.getAbsolutePath()), cause);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            launchException = launchException;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"securityError", (Object)launchException);
        }
        return launchException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void init(int port, File commandFileTmp) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"init", (Object[])new Object[]{port, commandFileTmp});
        }
        if (port != -1) {
            this.serverSocketChannel = SelectorProvider.provider().openServerSocketChannel();
            InetSocketAddress address = new InetSocketAddress(InetAddress.getByName(null), port);
            Object bindError = null;
            boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
            try {
                this.serverSocketChannel.socket().setReuseAddress(false);
                this.serverSocketChannel.socket().bind(address);
                if (!isWindows) {
                    this.serverSocketChannel.socket().setReuseAddress(true);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ServerSocket reuse set to true to allow for later override", (Object[])new Object[0]);
                    }
                }
            }
            catch (IOException iOException) {
                void ioe;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener", (String)"210", (Object)this, (Object[])new Object[]{port, commandFileTmp});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ServerSocket bind failed on first attempt with IOException: " + ioe.getMessage()), (Object[])new Object[0]);
                }
                bindError = ioe;
                try {
                    InetSocketAddress testAddr = new InetSocketAddress(InetAddress.getByName(null), port);
                    if (!testAddr.isUnresolved()) {
                        SocketChannel testChannel = SocketChannel.open(testAddr);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"attempt to connect to command port to check listen status worked, someone else is using the port!", (Object[])new Object[0]);
                        }
                        testChannel.close();
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Test connection addr is unresolvable; " + testAddr), (Object[])new Object[0]);
                    }
                }
                catch (IOException testAddr) {
                    FFDCFilter.processException((Throwable)testAddr, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener", (String)"233", (Object)this, (Object[])new Object[]{port, commandFileTmp});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void testioe;
                        Tr.debug((TraceComponent)tc, (String)("attempt to connect to command port to check listen status failed with IOException: " + testioe.getMessage()), (Object[])new Object[0]);
                    }
                    try {
                        this.serverSocketChannel.socket().setReuseAddress(true);
                        this.serverSocketChannel.socket().bind(address);
                        bindError = null;
                    }
                    catch (IOException testChannel) {
                        void newioe;
                        FFDCFilter.processException((Throwable)testChannel, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener", (String)"243", (Object)this, (Object[])new Object[]{port, commandFileTmp});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("ServerSocket bind failed on second attempt with IOException: " + newioe.getMessage()), (Object[])new Object[0]);
                        }
                        bindError = newioe;
                    }
                }
            }
            if (bindError == null) {
                if (port == 0) {
                    port = this.serverSocketChannel.socket().getLocalPort();
                }
                this.listenForCommands = true;
            } else {
                throw bindError;
            }
        }
        ServerCommand.ServerCommandID sci = (ServerCommand)this.new ServerCommand.ServerCommandID(port, this.serverUUID);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(commandFileTmp);
            fos.write(sci.getIDString().getBytes());
            fos.close();
        }
        catch (Throwable throwable) {
            Utils.tryToClose(fos);
            throw throwable;
        }
        Utils.tryToClose(fos);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object[])new Object[0]);
        }
        Thread responseThread = null;
        ServerCommandListener serverCommandListener = this;
        synchronized (serverCommandListener) {
            if (!this.closed) {
                this.closed = true;
                this.notifyAll();
                if (this.listenForCommands) {
                    this.listenForCommands = false;
                    if (this.listeningThread != null) {
                        this.listeningThread.interrupt();
                    }
                }
                Utils.tryToClose(this.serverSocketChannel);
                this.commandFile.delete();
                responseThread = this.responseThread.getAndSet(null);
            }
        }
        if (responseThread != null) {
            try {
                responseThread.join();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener", (String)"303", (Object)this, (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public void startListening() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"startListening", (Object[])new Object[0]);
        }
        if (this.listenForCommands) {
            this.listeningThread = new Thread("kernel-command-listener"){
                static final long serialVersionUID = -5466213988271870365L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;
                {
                    if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                        Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{ServerCommandListener.this, x0});
                    }
                    if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                    }
                }

                @Override
                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                public void run() {
                    if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                        Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
                    }
                    while (ServerCommandListener.this.listenForCommands && ServerCommandListener.this.acceptAndExecuteCommand()) {
                    }
                    if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run");
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            };
            this.listeningThread.start();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"startListening");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    @FFDCIgnore(value={IOException.class})
    private boolean acceptAndExecuteCommand() {
        boolean socketValid;
        block19: {
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"acceptAndExecuteCommand", (Object[])new Object[0]);
            }
            socketValid = false;
            try {
                SocketChannel sc = this.serverSocketChannel.accept();
                socketValid = true;
                if (sc == null) break block19;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"accepted socket", (Object[])new Object[]{sc});
                }
                try {
                    String uuidAndCommand = this.read(sc);
                    ServerCommand.ServerCommandID commandID = new ServerCommand.ServerCommandID(uuidAndCommand);
                    String command = commandID.getOperation();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"read UUID and command", (Object[])new Object[]{command});
                    }
                    if (!commandID.validate()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"invalid UUID", (Object[])new Object[]{uuidAndCommand});
                        }
                    } else {
                        String authIDResponse;
                        String authID;
                        File authFile;
                        while ((authFile = new File(this.commandAuthDir, authID = Integer.toString(this.nextCommandAuthID++))).exists()) {
                        }
                        authFile.createNewFile();
                        this.write(sc, authID);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"wrote authorization challenge", (Object[])new Object[]{authID, authFile});
                        }
                        if (!(authIDResponse = this.read(sc)).equals(authID) || authFile.exists()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"authorization failed", (Object[])new Object[0]);
                            }
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"authorization succeeded", (Object[])new Object[0]);
                            }
                            sc = this.executeCommand(sc, command);
                        }
                    }
                }
                finally {
                    Utils.tryToClose(sc);
                }
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener", (String)"404", (Object)this, (Object[])new Object[0]);
            }
        }
        boolean bl = socketValid;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"acceptAndExecuteCommand", (Object)bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private SocketChannel executeCommand(SocketChannel sc, String command) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"executeCommand", (Object[])new Object[]{sc, command});
        }
        if ("status:start".equals(command)) {
            this.asyncResponse(command, sc);
            sc = null;
        } else if ("stop".equals(command) || "forceStop".equals(command)) {
            Tr.audit((TraceComponent)tc, (String)"info.stop.request.received", (Object[])new Object[]{new Date(), this.serverName});
            this.asyncResponse(command, sc);
            sc = null;
            this.frameworkManager.shutdownCommand("forceStop".equals(command));
        } else if (command.startsWith("introspect")) {
            Set<JavaDumpAction> javaDumpActions;
            String timestamp;
            String arg = command.substring(command.indexOf(35) + 1);
            if (command.startsWith("introspectJavadump")) {
                String[] args = arg.split(",");
                timestamp = args[0];
                javaDumpActions = this.parseJavaDumpActions(args, 1);
            } else {
                timestamp = arg;
                javaDumpActions = null;
            }
            this.frameworkManager.introspectFramework(timestamp, javaDumpActions);
            this.writeResponse(sc);
        } else if (command.startsWith("javadump")) {
            int index = command.indexOf(35);
            Set<JavaDumpAction> javaDumpActions = index == -1 ? null : this.parseJavaDumpActions(command.substring(index + 1).split(","), 0);
            this.frameworkManager.dumpJava(javaDumpActions);
            this.writeResponse(sc);
        } else if (command.startsWith("pause")) {
            String args = null;
            int index = command.indexOf("#");
            if (index > 0 && command.length() > index + 1) {
                args = command.substring(index + 1);
            }
            ReturnCode rc = this.frameworkManager.pauseListeners(args);
            this.writeResponse(sc, rc.getValue());
        } else if (command.startsWith("resume")) {
            String args = null;
            int index = command.indexOf("#");
            if (index > 0 && command.length() > index + 1) {
                args = command.substring(index + 1);
            }
            ReturnCode rc = this.frameworkManager.resumeListeners(args);
            this.writeResponse(sc, rc.getValue());
        } else if (tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"warning.unrecognized.command", (Object[])new Object[]{command});
        }
        SocketChannel socketChannel = sc;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            socketChannel = socketChannel;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"executeCommand", (Object)socketChannel);
        }
        return socketChannel;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private synchronized void asyncResponse(String command, SocketChannel sc) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"asyncResponse", (Object[])new Object[]{command, sc});
        }
        if (this.closed) {
            Utils.tryToClose(sc);
        } else {
            Thread thread = new Thread((Runnable)new ResponseThread(command, sc), "kernel-" + command + "-command-response");
            Thread oldThread = this.responseThread.getAndSet(thread);
            if (oldThread != null) {
                oldThread.interrupt();
            }
            thread.start();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"asyncResponse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void writeResponse(SocketChannel sc) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"writeResponse", (Object[])new Object[]{sc});
        }
        Object object = this.responseLock;
        synchronized (object) {
            this.write(sc, this.serverUUID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"writeResponse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private void writeResponse(SocketChannel sc, int rc) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"writeResponse", (Object[])new Object[]{sc, rc});
        }
        Object object = this.responseLock;
        synchronized (object) {
            this.write(sc, this.serverUUID + '#' + rc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"writeResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    private Set<JavaDumpAction> parseJavaDumpActions(String[] args, int index) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"parseJavaDumpActions", (Object[])new Object[]{args, index});
        }
        if (index == args.length) {
            Set<JavaDumpAction> set = null;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                set = set;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"parseJavaDumpActions", set);
            }
            return set;
        }
        LinkedHashSet<JavaDumpAction> javaDumpActions = new LinkedHashSet<JavaDumpAction>();
        while (index < args.length) {
            javaDumpActions.add(JavaDumpAction.valueOf(args[index]));
            ++index;
        }
        LinkedHashSet<JavaDumpAction> linkedHashSet = javaDumpActions;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            linkedHashSet = linkedHashSet;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"parseJavaDumpActions", linkedHashSet);
        }
        return linkedHashSet;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class ResponseThread
    implements Runnable {
        private final SocketChannel sc;
        private final String command;
        static final long serialVersionUID = 8691069529991784127L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        ResponseThread(String command, SocketChannel sc) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{command, sc});
            }
            this.command = command;
            this.sc = sc;
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
            }
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
            }
            try {
                boolean success = true;
                if ("status:start".equals(this.command)) {
                    success = ServerCommandListener.this.frameworkManager.waitForReady();
                } else if ("stop".equals(this.command) || "forceStop".equals(this.command)) {
                    ServerCommandListener.this.frameworkManager.waitForFrameworkStop();
                } else if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"warning.unrecognized.command", (Object[])new Object[]{this.command});
                }
                if (success) {
                    ServerCommandListener.this.writeResponse(this.sc);
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener$ResponseThread", (String)"551", (Object)this, (Object[])new Object[0]);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.launch.internal.ServerCommandListener$ResponseThread", (String)"553", (Object)this, (Object[])new Object[0]);
            }
            finally {
                Utils.tryToClose(this.sc);
                ServerCommandListener.this.responseThread.compareAndSet(Thread.currentThread(), null);
            }
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run");
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ResponseThread.class);
        }
    }
}

