/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.provisioning;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.AbstractResourceRepository;
import com.ibm.ws.kernel.provisioning.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class ContentBasedLocalBundleRepository
extends AbstractResourceRepository {
    private final File _installDir;
    private final File _cacheFile;
    private final String _defaultLocation;
    private final ConcurrentMap<String, List<AbstractResourceRepository.Resource>> _cacheBySymbolicName = new ConcurrentHashMap<String, List<AbstractResourceRepository.Resource>>();
    private final Set<File> _bundleLocations = new HashSet<File>();
    private final Set<String> _locations = new HashSet<String>();
    private boolean _dirty;
    private final Messages _msgs;
    private boolean _cacheRead;

    public ContentBasedLocalBundleRepository(File installDir, File cacheFile, boolean msgs) {
        this._installDir = installDir.getAbsoluteFile();
        this._msgs = msgs ? new TrMessages() : new NullMessages();
        this._cacheFile = cacheFile;
        this._defaultLocation = "lib/";
        this.includeBaseLocation(this._defaultLocation);
    }

    @Override
    protected File getRootDirectory() {
        return this._installDir;
    }

    @Override
    protected String getDefaultBaseLocation() {
        return this._defaultLocation;
    }

    @Override
    protected List<AbstractResourceRepository.Resource> getResourcesBySymbolicName(String symbolicName) {
        return (List)this._cacheBySymbolicName.get(symbolicName);
    }

    @Override
    protected boolean isBaseLocationIncluded(String baseLocation) {
        return this._locations.contains(baseLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._cacheFile != null && this._dirty) {
            PrintStream out = null;
            try {
                File parent = this._cacheFile.getParentFile();
                if (parent.isDirectory() || parent.mkdirs()) {
                    out = new PrintStream(this._cacheFile);
                    for (List bundleInfoList : this._cacheBySymbolicName.values()) {
                        for (AbstractResourceRepository.Resource bundleInfo : bundleInfoList) {
                            out.println(bundleInfo);
                        }
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                Utils.tryToClose(out);
            }
        }
        this._bundleLocations.clear();
        this._cacheBySymbolicName.clear();
    }

    public File selectBundle(String baseLocation, String symbolicName, VersionRange versionRange) {
        this.readCache();
        return this.selectResource(baseLocation, symbolicName, versionRange);
    }

    public File selectBaseBundle(String baseLocation, String symbolicName, VersionRange versionRange) {
        this.readCache();
        return this.selectResource(baseLocation, symbolicName, versionRange, true, true);
    }

    @Override
    protected synchronized void includeBaseLocation(String baseLocation) {
        File[] files;
        this._locations.add(baseLocation);
        if (this._cacheRead && (files = new File(this._installDir, baseLocation).listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().endsWith(".jar") && !ContentBasedLocalBundleRepository.this._bundleLocations.contains(arg0);
            }
        })) != null) {
            for (File f : files) {
                try {
                    BundleInfo bInfo = new BundleInfo(f, baseLocation);
                    if (bInfo.symbolicName == null) continue;
                    this._dirty = true;
                    this.addToCache(bInfo);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    private synchronized void readCache() {
        if (!this._cacheRead) {
            BufferedReader reader = null;
            try {
                if (this._cacheFile != null && this._cacheFile.exists() && this._cacheFile.isFile()) {
                    String line;
                    reader = new BufferedReader(new FileReader(this._cacheFile));
                    while ((line = reader.readLine()) != null) {
                        try {
                            BundleInfo bInfo = new BundleInfo(line);
                            if (!bInfo.file.exists() || bInfo.symbolicName == null) continue;
                            this.addToCache(bInfo);
                        }
                        catch (IOException bInfo) {}
                    }
                }
            }
            catch (IOException e) {
                this._bundleLocations.clear();
                this._cacheBySymbolicName.clear();
            }
            finally {
                Utils.tryToClose(reader);
            }
            this._cacheRead = true;
            for (String loc : new HashSet<String>(this._locations)) {
                this.includeBaseLocation(loc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(BundleInfo bInfo) {
        List<BundleInfo> info = (ArrayList<BundleInfo>)this._cacheBySymbolicName.get(bInfo.symbolicName);
        if (info == null) {
            info = new ArrayList<BundleInfo>();
            info.add(bInfo);
        }
        if ((info = (List)this._cacheBySymbolicName.putIfAbsent(bInfo.symbolicName, info)) != null) {
            List<BundleInfo> list = info;
            synchronized (list) {
                info.add(bInfo);
            }
        }
        this._bundleLocations.add(bInfo.file);
    }

    @Override
    protected void warnThatAnIFixWasIgnored(String fileName, String symbolicName, int majorVersion, int minorVersion, int microVersion) {
        this._msgs.warning("warn.ifix.ignored", fileName, symbolicName + '_' + majorVersion + '.' + minorVersion + '.' + microVersion + ".jar");
    }

    public static class TrMessages
    implements Messages {
        private static final TraceComponent _tc = Tr.register(TrMessages.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");

        @Override
        public void warning(String key, Object ... inserts) {
            Tr.warning((TraceComponent)_tc, (String)key, (Object[])inserts);
        }
    }

    private static final class NullMessages
    implements Messages {
        private NullMessages() {
        }

        @Override
        public void warning(String key, Object ... inserts) {
        }
    }

    private final class BundleInfo
    extends AbstractResourceRepository.Resource {
        private final File file;
        private final Version version;
        private final String symbolicName;
        private final long lastUpdated;
        private final long size;
        private final String baseLocation;
        private final boolean isFix;

        @Override
        protected File getFile() {
            return this.file;
        }

        @Override
        protected Version getVersion() {
            return this.version;
        }

        @Override
        protected String getBaseLocation() {
            return this.baseLocation;
        }

        @Override
        protected boolean isFix() {
            return this.isFix;
        }

        @Override
        protected String getSymbolicName() {
            return this.symbolicName;
        }

        public BundleInfo(File f, String baseLoc) throws IOException {
            this.file = f;
            this.baseLocation = baseLoc;
            this.size = this.file.length();
            this.lastUpdated = this.file.lastModified();
            JarFile jar = new JarFile(this.file);
            Manifest man = jar.getManifest();
            Attributes a = man.getMainAttributes();
            String bsn = this.getSymbolicName(a);
            this.symbolicName = bsn == null ? null : bsn.trim();
            try {
                this.version = Version.parseVersion(a.getValue("Bundle-Version"));
                String iFixHeader = a.getValue("IBM-Interim-Fixes");
                String tFixHeader = a.getValue("IBM-Test-Fixes");
                this.isFix = iFixHeader != null || tFixHeader != null;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid Bundle-Version in " + f + ": " + e.getMessage(), e);
            }
            finally {
                Utils.tryToClose(jar);
            }
        }

        public BundleInfo(String cacheLine) throws IOException {
            int beginIndex = cacheLine.lastIndexOf(59);
            this.file = new File(cacheLine.substring(beginIndex + 1));
            int endIndex = beginIndex;
            beginIndex = cacheLine.lastIndexOf(59, endIndex - 1);
            this.baseLocation = cacheLine.substring(beginIndex + 1, endIndex);
            endIndex = beginIndex;
            beginIndex = cacheLine.lastIndexOf(59, endIndex - 1);
            long size = Long.parseLong(cacheLine.substring(beginIndex + 1, endIndex));
            endIndex = beginIndex;
            beginIndex = cacheLine.lastIndexOf(59, endIndex - 1);
            long lastUpdated = Long.parseLong(cacheLine.substring(beginIndex + 1, endIndex));
            this.size = this.file.length();
            this.lastUpdated = this.file.lastModified();
            if (this.size == size && this.lastUpdated == lastUpdated) {
                endIndex = beginIndex;
                beginIndex = cacheLine.lastIndexOf(59, endIndex - 1);
                this.isFix = Boolean.parseBoolean(cacheLine.substring(beginIndex + 1, endIndex));
                endIndex = beginIndex;
                beginIndex = cacheLine.lastIndexOf(59, endIndex - 1);
                this.version = Version.parseVersion(cacheLine.substring(beginIndex + 1, endIndex));
                endIndex = beginIndex;
                beginIndex = cacheLine.lastIndexOf(59, endIndex - 1);
                this.symbolicName = cacheLine.substring(beginIndex + 1, endIndex);
            } else {
                JarFile jar = new JarFile(this.file);
                Manifest man = jar.getManifest();
                Attributes a = man.getMainAttributes();
                this.symbolicName = this.getSymbolicName(a);
                this.version = Version.parseVersion(a.getValue("Bundle-Version"));
                Object iFixHeader = a.get("IBM-Interim-Fixes");
                Object tFixHeader = a.get("IBM-Test-Fixes");
                this.isFix = iFixHeader != null || tFixHeader != null;
            }
        }

        private String getSymbolicName(Attributes attributes) {
            String value = attributes.getValue("Bundle-SymbolicName");
            int index = value != null ? value.indexOf(59) : -1;
            return index > 0 ? value.substring(0, index).trim() : value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.symbolicName);
            builder.append(';');
            builder.append(this.version);
            builder.append(';');
            builder.append(this.isFix);
            builder.append(';');
            builder.append(this.lastUpdated);
            builder.append(';');
            builder.append(this.size);
            builder.append(';');
            builder.append(this.baseLocation);
            builder.append(';');
            builder.append(this.file.getAbsolutePath());
            return builder.toString();
        }
    }
}

