/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.TraceComponentChangeListener;
import com.ibm.ws.kernel.boot.logging.WsLogManager;
import com.ibm.ws.kernel.provisioning.packages.PackageIndex;
import com.ibm.ws.logging.WsTraceRouter;
import com.ibm.ws.logging.internal.DisabledTraceService;
import com.ibm.ws.logging.internal.SafeTraceLevelIndexFactory;
import com.ibm.ws.logging.internal.TraceSpecification;
import com.ibm.ws.logging.internal.WsLogger;
import com.ibm.ws.staticvalue.StaticValue;
import com.ibm.wsspi.logging.MessageRouter;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import com.ibm.wsspi.logprovider.LogProviderConfig;
import com.ibm.wsspi.logprovider.TrService;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public class TrConfigurator {
    static final StaticValue<AtomicReference<LogProviderConfig>> loggingConfig = StaticValue.createStaticValue(new Callable<AtomicReference<LogProviderConfig>>(){

        @Override
        public AtomicReference<LogProviderConfig> call() throws Exception {
            return new AtomicReference<Object>(null);
        }
    });
    static StaticValue<TrService> delegate = StaticValue.createStaticValue(null);
    static final StaticValue<Set<TraceComponentChangeListener>> registeredListeners = StaticValue.createStaticValue(new Callable<Set<TraceComponentChangeListener>>(){

        @Override
        public Set<TraceComponentChangeListener> call() throws Exception {
            return new CopyOnWriteArraySet<TraceComponentChangeListener>();
        }
    });
    private static boolean instrumentationAvailable;
    static String traceString;
    private static PackageIndex<Integer> safeLevelsIndex;
    private static String sensitiveTraceListResourceName;
    private static boolean suppressSensitiveTrace;
    private static boolean defaultUpdated;

    public static synchronized void init(LogProviderConfig config) {
        if (config == null) {
            throw new NullPointerException("LogProviderConfig must not be null");
        }
        if (loggingConfig.get().compareAndSet(null, config)) {
            final TrService tr = config.getTrDelegate();
            if (tr == null) {
                throw new NullPointerException("LogProviderConfig must provide a TrService delegate");
            }
            Callable<TrService> result = new Callable<TrService>(){

                @Override
                public TrService call() throws Exception {
                    return tr;
                }
            };
            delegate = StaticValue.mutateStaticValue(delegate, result);
            delegate.get().init(config);
            TrConfigurator.setTraceSpec(config.getTraceString());
            WsLogManager.setWsLogger(WsLogger.class);
        }
    }

    public static synchronized void update(Map<String, Object> newConfig) {
        if (newConfig == null) {
            throw new NullPointerException("Updated config must not be null");
        }
        boolean traceWasDisabled = !TraceComponent.isAnyTracingEnabled();
        LogProviderConfig config = loggingConfig.get().get();
        if (config != null) {
            config.update(newConfig);
            Object o = newConfig.get("suppressSensitiveTrace");
            if (o != null) {
                if (o instanceof String) {
                    suppressSensitiveTrace = Boolean.parseBoolean((String)o);
                } else if (o instanceof Boolean) {
                    suppressSensitiveTrace = (Boolean)o;
                }
                if (suppressSensitiveTrace && safeLevelsIndex == null) {
                    TrConfigurator.setupSafeLevelsIndex();
                }
            }
            TraceSpecification newTs = TrConfigurator.setTraceSpec(config.getTraceString());
            if (defaultUpdated && newTs != null) {
                newTs.warnUnmatchedSpecs();
            }
            defaultUpdated = true;
            TrConfigurator.getDelegate().update(config);
        }
        if (!instrumentationAvailable && traceWasDisabled && TraceComponent.isAnyTracingEnabled()) {
            Tr.warning(TraceSpecification.getTc(), "INSTRUMENTATION_SERVICE_UNAVAILABLE", new Object[0]);
        }
    }

    protected static void setSensitiveTraceListResourceName(String resourceName) {
        sensitiveTraceListResourceName = resourceName;
    }

    private static synchronized void setupSafeLevelsIndex() {
        if (safeLevelsIndex != null) {
            return;
        }
        if (sensitiveTraceListResourceName == null) {
            sensitiveTraceListResourceName = "META-INF/logging/liberty.ras.rawtracelist.properties";
        }
        safeLevelsIndex = SafeTraceLevelIndexFactory.createPackageIndex(sensitiveTraceListResourceName);
    }

    static TrService getDelegate() {
        TrService tr;
        TrService result = delegate.get();
        if (result != null) {
            return result;
        }
        LogProviderConfig config = loggingConfig.get().get();
        if (config != null && (tr = config.getTrDelegate()) != null) {
            Callable<TrService> initializer = new Callable<TrService>(){

                @Override
                public TrService call() throws Exception {
                    return tr;
                }
            };
            delegate = StaticValue.mutateStaticValue(delegate, initializer);
            delegate.get().init(config);
            return delegate.get();
        }
        return DisabledDelegateSingleton.instance;
    }

    static void traceComponentRegistered(TraceComponent tc) {
        for (TraceComponentChangeListener listener : registeredListeners.get()) {
            listener.traceComponentRegistered(tc);
        }
    }

    static void traceComponentUpdated(TraceComponent tc) {
        for (TraceComponentChangeListener listener : registeredListeners.get()) {
            listener.traceComponentUpdated(tc);
        }
    }

    public static void addTraceComponentListener(TraceComponentChangeListener tcl) {
        registeredListeners.get().add(tcl);
    }

    public static void removeTraceComponentListener(TraceComponentChangeListener tcl) {
        registeredListeners.get().remove(tcl);
    }

    static synchronized TraceSpecification setTraceSpec(String spec) {
        if (WsLogManager.isConfiguredByLoggingProperties()) {
            return null;
        }
        if ((spec == null || spec.equals(traceString)) && Tr.activeTraceSpec.isSensitiveTraceSuppressed() == suppressSensitiveTrace) {
            return null;
        }
        traceString = spec;
        TraceSpecification newTs = new TraceSpecification(spec, safeLevelsIndex, suppressSensitiveTrace);
        TraceSpecification.TraceSpecificationException tex = newTs.getExceptions();
        if (tex != null) {
            do {
                tex.warning(loggingConfig.get() != null);
            } while ((tex = tex.getPreviousException()) != null);
        }
        Tr.setTraceSpec(newTs);
        return newTs;
    }

    static TraceSpecification getTraceSpec() {
        return Tr.activeTraceSpec;
    }

    public static String getEffectiveTraceSpec() {
        return Tr.activeTraceSpec.toDisplayString();
    }

    public static String getLogLocation() {
        LogProviderConfig cfg = loggingConfig.get().get();
        if (cfg == null) {
            throw new IllegalStateException("Tr not initialized");
        }
        return cfg.getLogDirectory().getAbsolutePath();
    }

    public static synchronized void stop() {
        TrService service = TrConfigurator.getDelegate();
        if (service != null) {
            service.stop();
        }
    }

    public static void setInstrumentation(boolean instrumentation) {
        instrumentationAvailable = instrumentation;
    }

    public static void setMessageRouter(MessageRouter msgRouter) {
        TrConfigurator.getDelegate().setMessageRouter(msgRouter);
    }

    public static void unsetMessageRouter(MessageRouter msgRouter) {
        TrConfigurator.getDelegate().unsetMessageRouter(msgRouter);
    }

    public static void setTraceRouter(WsTraceRouter msgRouter) {
        TrConfigurator.getDelegate().setTraceRouter(msgRouter);
    }

    public static void unsetTraceRouter(WsTraceRouter msgRouter) {
        TrConfigurator.getDelegate().unsetTraceRouter(msgRouter);
    }

    public static void registerTraceComponent(TraceComponent tc) {
        Tr.registerTraceComponent(tc);
    }

    public static TextFileOutputStreamFactory getFileOutputStreamFactory() {
        LogProviderConfig cfg = loggingConfig.get().get();
        if (cfg == null) {
            throw new IllegalStateException("Tr not initialized");
        }
        return cfg.getTextFileOutputStreamFactory();
    }

    static {
        traceString = "";
        safeLevelsIndex = null;
        suppressSensitiveTrace = false;
        defaultUpdated = false;
    }

    static class DisabledDelegateSingleton {
        static DisabledTraceService instance = new DisabledTraceService();

        DisabledDelegateSingleton() {
        }
    }
}

