/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.javaee.common.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javaee.dd.common.ParamValue;
import com.ibm.ws.javaee.dd.common.wsclient.Handler;
import com.ibm.ws.javaee.dd.common.wsclient.HandlerChain;
import com.ibm.ws.javaee.dd.ws.PortComponent;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.HandlerChainInfo;
import com.ibm.ws.jaxws.metadata.HandlerChainsInfo;
import com.ibm.ws.jaxws.metadata.HandlerInfo;
import com.ibm.ws.jaxws.metadata.ParamValueInfo;
import com.ibm.ws.jaxws.metadata.XsdQNameInfo;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import javax.xml.namespace.QName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxWsHandlerInfoMergingHelper {
    private static final TraceComponent tc = Tr.register(JaxWsHandlerInfoMergingHelper.class);
    static final long serialVersionUID = -6876054120875231080L;

    public static void mergeHandlerChains(PortComponent portComp, EndpointInfo endpointInfo) {
        if (endpointInfo == null || portComp == null) {
            return;
        }
        HandlerChainsInfo hChainsInfo = new HandlerChainsInfo();
        List handlerChains = portComp.getHandlerChains();
        if (handlerChains == null || handlerChains.size() == 0) {
            return;
        }
        for (HandlerChain hChain : handlerChains) {
            HandlerChainInfo chainInfo = new HandlerChainInfo();
            QName qName = JaxWsHandlerInfoMergingHelper.convertDDQNameToQName(hChain.getPortNamePattern());
            if (qName != null) {
                if (!JaxWsUtils.matchesQName((QName)qName, (QName)endpointInfo.getWsdlPort(), (boolean)true)) continue;
                chainInfo.setPortNamePattern(qName);
            }
            if ((qName = JaxWsHandlerInfoMergingHelper.convertDDQNameToQName(hChain.getServiceNamePattern())) != null) {
                if (!JaxWsUtils.matchesQName((QName)qName, (QName)endpointInfo.getWsdlService(), (boolean)true)) continue;
                chainInfo.setServiceNamePattern(qName);
            }
            List bindings = hChain.getProtocolBindings();
            boolean include = false;
            if (bindings != null) {
                for (String binding : bindings) {
                    if (JaxWsUtils.singleProtocolMatches((String)binding, (String)endpointInfo.getProtocolBinding())) {
                        include |= true;
                    }
                    chainInfo.addProtocolBinding(JaxWsUtils.getProtocolByToken((String)binding));
                }
                if (!include && !bindings.isEmpty()) continue;
            }
            for (Handler handler : hChain.getHandlers()) {
                Object portName2;
                HandlerInfo hInfo = new HandlerInfo();
                String handlerClass = handler.getHandlerClassName();
                if (handlerClass == null || "".equals(handlerClass)) {
                    Tr.warning((TraceComponent)tc, (String)"warn.dd.invalid.handler", (Object[])new Object[]{"<handler-class>", endpointInfo.getPortComponentName()});
                    continue;
                }
                String handlerName = handler.getHandlerName();
                if (handlerName == null || "".equals(handlerName)) {
                    Tr.warning((TraceComponent)tc, (String)"warn.dd.invalid.handler", (Object[])new Object[]{"<handler-name>", endpointInfo.getPortComponentName()});
                    continue;
                }
                hInfo.setHandlerClass(handlerClass);
                hInfo.setHandlerName(handlerName);
                List portNames = handler.getPortNames();
                for (Object portName2 : portNames) {
                    hInfo.addPortName((String)portName2);
                }
                List soapRoles = handler.getSoapRoles();
                portName2 = soapRoles.iterator();
                while (portName2.hasNext()) {
                    String soapRole = (String)portName2.next();
                    hInfo.addSoapRole(soapRole);
                }
                List soapHeaders = handler.getSoapHeaders();
                for (com.ibm.ws.javaee.dd.common.QName soapHeader : soapHeaders) {
                    hInfo.addSoapHeader(new XsdQNameInfo(new QName(soapHeader.getNamespaceURI(), soapHeader.getLocalPart()), ""));
                }
                List initParams = handler.getInitParams();
                for (ParamValue pv : initParams) {
                    hInfo.addInitParam(new ParamValueInfo(pv.getName(), pv.getValue()));
                }
                chainInfo.addHandlerInfo(hInfo);
            }
            hChainsInfo.addHandlerChainInfo(chainInfo);
        }
        if (!hChainsInfo.getHandlerChainInfos().isEmpty()) {
            endpointInfo.setHandlerChainsInfo(hChainsInfo);
        }
    }

    private static QName convertDDQNameToQName(com.ibm.ws.javaee.dd.common.QName dQName) {
        if (dQName == null) {
            return null;
        }
        String ns = dQName.getNamespaceURI();
        String localPart = dQName.getLocalPart();
        int index = localPart.indexOf(":");
        if (index > -1) {
            String prefix = localPart.substring(0, index);
            String localName = index < localPart.length() - 1 ? localPart.substring(index + 1) : "";
            return new QName(ns, localName, prefix);
        }
        return new QName(ns, localPart);
    }
}

